/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.CrtToken;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.KeyLabelKeySpec;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKeySpec;
import com.ibm.crypto.hdwrCCA.provider.RSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public class RSAKeyFactory
extends KeyFactorySpi {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.RSAKeyFactory";
    private KeyPairUtils.KeyPairAlgorithm keyPairAlgorithm;
    private AlgorithmId rsaPssAlgId;
    private String externalKeyFactoryProvider = "IBMJCE";
    private String externalKeyFactoryAlg;

    public RSAKeyFactory() {
        this(RSAUtil.KeyType.RSA);
    }

    public RSAKeyFactory(RSAUtil.KeyType type) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "RSAKeyFactory");
        }
        if (type == RSAUtil.KeyType.PSS) {
            this.keyPairAlgorithm = KeyPairUtils.KeyPairAlgorithm.RSAPSS;
            this.rsaPssAlgId = RSAUtil.createAlgorithmId((RSAUtil.KeyType)RSAUtil.KeyType.PSS, null);
            this.externalKeyFactoryAlg = "RSASSA-PSS";
        } else {
            this.keyPairAlgorithm = KeyPairUtils.KeyPairAlgorithm.RSA;
            this.rsaPssAlgId = new AlgIdRSA();
            this.externalKeyFactoryAlg = "RSA";
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "RSAKeyFactory");
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGeneratePublic", keySpec);
        }
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rsaPubKeySpec = (RSAPublicKeySpec)keySpec;
                RSAPublicKey result = new RSAPublicKey(this.rsaPssAlgId, rsaPubKeySpec.getModulus(), rsaPubKeySpec.getPublicExponent());
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePublic", result);
                }
                return result;
            }
            if (keySpec instanceof KeyLabelKeySpec) {
                KeyPairUtils util = new KeyPairUtils();
                RSAKeyHWAttributes keyAttribs = new RSAKeyHWAttributes(0, 4);
                byte[] tmp = ((KeyLabelKeySpec)keySpec).getLabelString().getBytes(PlatformUtilities.CHARSET_ISO_8859_1);
                byte[] pkdsLabel = new byte[64];
                Arrays.fill(pkdsLabel, (byte)32);
                System.arraycopy(tmp, 0, pkdsLabel, 0, tmp.length);
                util.initializeRSA(0, null, keyAttribs, pkdsLabel, this.keyPairAlgorithm);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", "Creating key pair for label: " + new String(pkdsLabel, PlatformUtilities.CHARSET_ISO_8859_1));
                }
                KeyPair result = util.generateKeyPairFromInternalToken(pkdsLabel);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePublic", result.getPublic());
                }
                return result.getPublic();
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                RSAPublicKey result = new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePublic", result);
                }
                return result;
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", "Inappropriate key specification ");
                debug.exit(Debug.TYPE_FINE, className, "engineGeneratePublic");
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", e);
                debug.exit(Debug.TYPE_FINE, className, "engineGeneratePublic");
            }
            throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGeneratePrivate", keySpec);
        }
        if (keySpec instanceof RSAPrivateCrtKeySpec || keySpec instanceof RSAPrivateKeySpec) {
            try {
                BigInteger modulus = null;
                PublicKey rsaPublicKey = null;
                PrivateKey rsaPrivateKey = null;
                if (keySpec instanceof RSAPrivateCrtKeySpec) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", "Using RSAPrivateCrtKeySpec");
                    }
                    modulus = ((RSAPrivateCrtKeySpec)keySpec).getModulus();
                    KeyFactory keyFactory = KeyFactory.getInstance(this.externalKeyFactoryAlg, this.externalKeyFactoryProvider);
                    RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(((RSAPrivateCrtKeySpec)keySpec).getModulus(), ((RSAPrivateCrtKeySpec)keySpec).getPublicExponent());
                    rsaPublicKey = keyFactory.generatePublic(pubKeySpec);
                    rsaPrivateKey = keyFactory.generatePrivate(keySpec);
                } else {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", "Using RSAPrivateKeySpec");
                    }
                    modulus = ((RSAPrivateKeySpec)keySpec).getModulus();
                    BigInteger publicExponent = BigInteger.valueOf(65537L);
                    KeyFactory keyFactory = KeyFactory.getInstance(this.externalKeyFactoryAlg, this.externalKeyFactoryProvider);
                    RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(((RSAPrivateKeySpec)keySpec).getModulus(), publicExponent);
                    rsaPublicKey = keyFactory.generatePublic(pubKeySpec);
                    rsaPrivateKey = keyFactory.generatePrivate(keySpec);
                }
                KeyPairUtils kpu = new KeyPairUtils();
                byte[] modulusByteArray = modulus.toByteArray();
                int modulusBitLength = modulusByteArray[0] > 127 ? modulusByteArray.length * 8 : modulus.bitLength();
                RSAKeyHWAttributes keyAttrs = new RSAKeyHWAttributes(2, 4);
                kpu.initializeRSA(modulusBitLength, null, keyAttrs, null, this.keyPairAlgorithm);
                RSAPrivateHWKey migKey = (RSAPrivateHWKey)kpu.generatePrivateHWKey(rsaPublicKey, rsaPrivateKey);
                return migKey;
            }
            catch (NoSuchAlgorithmException e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", e);
                }
                throw new InvalidKeySpecException("Hardware error, Inappropriate key specification: " + e.getMessage());
            }
            catch (NoSuchProviderException e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", e);
                }
                throw new InvalidKeySpecException("Hardware error, Inappropriate key specification: " + e.getMessage());
            }
        }
        if (keySpec instanceof RSAPrivateHWKeySpec) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", "Using RSAPrivateHWKeySpec");
            }
            try {
                RSAPrivateHWKey tmpKey = new RSAPrivateHWKey(this.rsaPssAlgId, ((RSAPrivateHWKeySpec)keySpec).getToken(), ((RSAPrivateHWKeySpec)keySpec).getAttributes());
                return tmpKey;
            }
            catch (InvalidKeyException e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", e);
                }
                throw new InvalidKeySpecException("Hardware error, Inappropriate key specification: " + e.getMessage());
            }
        }
        if (keySpec instanceof KeyLabelKeySpec) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", "Using KeyLabelKeySpec");
            }
            KeyPairUtils util = new KeyPairUtils();
            RSAKeyHWAttributes keyAttribs = new RSAKeyHWAttributes(0, 4);
            byte[] pkdsLabel = PlatformUtilities.convertBytesETOA(((KeyLabelKeySpec)keySpec).getLabelBytes());
            util.initializeRSA(0, null, keyAttribs, pkdsLabel, this.keyPairAlgorithm);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePublic", "Creating key pair for label: " + new String(pkdsLabel, PlatformUtilities.CHARSET_ISO_8859_1));
            }
            KeyPair result = util.generateKeyPairFromInternalToken(pkdsLabel);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGeneratePrivate", result.getPrivate());
            }
            return result.getPrivate();
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(this.externalKeyFactoryAlg, this.externalKeyFactoryProvider);
                PrivateKey rsaPrivateKey = keyFactory.generatePrivate((PKCS8EncodedKeySpec)keySpec);
                BigInteger modulus = ((RSAPrivateKey)rsaPrivateKey).getModulus();
                BigInteger publicExponent = BigInteger.valueOf(65537L);
                RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
                PublicKey rsaPublicKey = keyFactory.generatePublic(pubKeySpec);
                KeyPairUtils kpu = new KeyPairUtils();
                RSAKeyHWAttributes keyAttrs = new RSAKeyHWAttributes(2, 4);
                kpu.initializeRSA(((RSAPrivateKey)rsaPrivateKey).getPrivateExponent().bitLength(), null, keyAttrs, null, this.keyPairAlgorithm);
                RSAPrivateHWKey theKey = (RSAPrivateHWKey)kpu.generatePrivateHWKey(rsaPublicKey, rsaPrivateKey);
                return theKey;
            }
            catch (NoSuchAlgorithmException nsae) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", "Hardware error, inappropriate key specification(1)");
                    debug.exit(Debug.TYPE_FINE, className, "engineGeneratePrivate");
                }
                throw new InvalidKeySpecException("Hardware error, Inappropriate key specification(1)");
            }
            catch (NoSuchProviderException nsae) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", "Hardware error, inappropriate key specification(2)");
                    debug.exit(Debug.TYPE_FINE, className, "engineGeneratePrivate");
                }
                throw new InvalidKeySpecException("Hardware error, Inappropriate key specification(2)");
            }
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineGeneratePrivate", "Hardware error, inappropriate key specification");
            debug.exit(Debug.TYPE_FINE, className, "engineGeneratePrivate");
        }
        throw new InvalidKeySpecException("Hardware error, Inappropriate key specification");
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            Object[] parms = new Object[]{key, keySpec};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec", parms);
        }
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            if (keySpec.isAssignableFrom(RSAPublicKeySpec.class)) {
                java.security.interfaces.RSAPublicKey rsaPubKey = (java.security.interfaces.RSAPublicKey)key;
                RSAPublicKeySpec result = new RSAPublicKeySpec(rsaPubKey.getModulus(), rsaPubKey.getPublicExponent());
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec", result);
                }
                return (T)((KeySpec)keySpec.cast(result));
            }
            if (keySpec.isAssignableFrom(X509EncodedKeySpec.class)) {
                X509EncodedKeySpec result = new X509EncodedKeySpec(key.getEncoded());
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec", result);
                }
                return (T)((KeySpec)keySpec.cast(result));
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        if (key instanceof RSAPrivateHWKey) {
            if (keySpec.isAssignableFrom(RSAPrivateHWKeySpec.class)) {
                RSAPrivateHWKey rsaPrivHWKey = (RSAPrivateHWKey)key;
                RSAPrivateHWKeySpec result = new RSAPrivateHWKeySpec(rsaPrivHWKey.getToken(), rsaPrivHWKey.getType(), rsaPrivHWKey.getUsage());
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec", result);
                }
                return (T)((KeySpec)keySpec.cast(result));
            }
            if (keySpec.isAssignableFrom(RSAPrivateCrtKeySpec.class)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "keySpec is assignable from RSAPrivateCrtKeySpec");
                }
                RSAPrivateCrtKeySpec privateCrtKeySpec = this.getPrivateCrtKeySpec((RSAPrivateHWKey)key);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec", privateCrtKeySpec);
                }
                return (T)((KeySpec)keySpec.cast(privateCrtKeySpec));
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Hardware error, inappropriate key specification");
        }
        throw new InvalidKeySpecException("Hardware error, Inappropriate key specification");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", key);
        }
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                if (key instanceof RSAPublicKey) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", key);
                    }
                    return key;
                }
                RSAPublicKeySpec rsaPubKeySpec = this.engineGetKeySpec(key, RSAPublicKeySpec.class);
                PublicKey result = this.engineGeneratePublic(rsaPubKeySpec);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", result);
                }
                return result;
            }
            if (key instanceof RSAPrivateCrtKey) {
                if (key instanceof RSAPrivateHWKey) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", key);
                    }
                    return key;
                }
                if (key instanceof PKCS11PrivateKey && Boolean.TRUE.equals(((PKCS11PrivateKey)key).getSensitive())) {
                    InvalidKeyException ike = new InvalidKeyException("Private key value is sensitive and is not exportable");
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineTranslateKey");
                    }
                    throw ike;
                }
                RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)key;
                RSAPrivateCrtKeySpec rsaPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(rsaPrivateCrtKey.getModulus(), rsaPrivateCrtKey.getPublicExponent(), rsaPrivateCrtKey.getPrivateExponent(), rsaPrivateCrtKey.getPrimeP(), rsaPrivateCrtKey.getPrimeQ(), rsaPrivateCrtKey.getPrimeExponentP(), rsaPrivateCrtKey.getPrimeExponentQ(), rsaPrivateCrtKey.getCrtCoefficient());
                PrivateKey result = this.engineGeneratePrivate(rsaPrivateCrtKeySpec);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", result);
                }
                return result;
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineTranslateKey", "Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeySpecException e) {
            InvalidKeyException ike = new InvalidKeyException("Hardware error, cannot translate key: " + e.getMessage(), e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineTranslateKey");
            }
            throw ike;
        }
    }

    private RSAPrivateCrtKeySpec getPrivateCrtKeySpec(RSAPrivateHWKey key) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "getPrivateCrtKeySpec", key);
        }
        if (key.getType() != 2) {
            InvalidKeySpecException ikse = new InvalidKeySpecException("Inappropriate key specification. Key must be CLEAR key type");
            if (debug != null) {
                debug.exception(8192L, className, "getPrivateCrtKeySpec", ikse);
                debug.exit(Debug.TYPE_FINE, className, "getPrivateCrtKeySpec");
            }
            throw ikse;
        }
        byte[] rsaExternalCrtToken = key.getExternalKeyToken();
        if (rsaExternalCrtToken == null) {
            InvalidKeySpecException ikse = new InvalidKeySpecException("Cannot get private key spec. CLEAR RSA private key must have an external private key token");
            if (debug != null) {
                debug.exception(8192L, className, "getPrivateCrtKeySpec", ikse);
                debug.exit(Debug.TYPE_FINE, className, "getPrivateCrtKeySpec");
            }
            throw ikse;
        }
        if (rsaExternalCrtToken[8] != 8) {
            InvalidKeySpecException ikse = new InvalidKeySpecException("Cannot get private key spec. The external private key token is not in CRT format");
            if (debug != null) {
                debug.exception(8192L, className, "getPrivateCrtKeySpec", ikse);
                debug.exit(Debug.TYPE_FINE, className, "getPrivateCrtKeySpec");
            }
            throw ikse;
        }
        CrtToken crtToken = new CrtToken(rsaExternalCrtToken, null);
        RSAPrivateCrtKeySpec privateCrtKeySpec = null;
        try {
            privateCrtKeySpec = crtToken.generatePrivateCrtKeySpec();
        }
        catch (IOException ioe) {
            InvalidKeySpecException ikse = new InvalidKeySpecException("Cannot generate private key spec", ioe);
            if (debug != null) {
                debug.exception(8192L, className, "getPrivateCrtKeySpec", ioe);
                debug.exception(8192L, className, "getPrivateCrtKeySpec", ikse);
                debug.exit(Debug.TYPE_FINE, className, "getPrivateCrtKeySpec");
            }
            throw ikse;
        }
        if (privateCrtKeySpec == null) {
            InvalidKeySpecException ikse = new InvalidKeySpecException("Cannot generate private key spec");
            if (debug != null) {
                debug.exception(8192L, className, "getPrivateCrtKeySpec", ikse);
                debug.exit(Debug.TYPE_FINE, className, "getPrivateCrtKeySpec");
            }
            throw ikse;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "getPrivateCrtKeySpec", privateCrtKeySpec);
        }
        return privateCrtKeySpec;
    }

    public static final class PSS
    extends RSAKeyFactory {
        public PSS() {
            super(RSAUtil.KeyType.PSS);
        }
    }
}

