/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.AESKey;
import com.ibm.crypto.hdwrCCA.provider.CCAAlgorithmParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.DESKey;
import com.ibm.crypto.hdwrCCA.provider.DESedeKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.PKCS11Utils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.RSAPublicKey;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyUtils;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPrivateKey;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;

public final class RSA
extends CipherSpi {
    private byte[] buffer = null;
    private ByteArrayOutputStream bArray;
    private boolean decrypting = false;
    private byte[] token = null;
    private byte[] externalToken = null;
    private hikmNativeInteger returnCode = new hikmNativeInteger(0);
    private hikmNativeInteger reasonCode = new hikmNativeInteger(0);
    private HIKM hikm = null;
    private byte[] exitData = new byte[0];
    private byte[] pkaEncipheredkey;
    private int paddingIndicator = 0;
    private hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
    private hikmNativeInteger pkaEncipheredKeyBitLength = new hikmNativeInteger(0);
    private hikmNativeInteger pkaEncipheredKeyLength = new hikmNativeInteger(0);
    private boolean longBuffers = false;
    private int maxEncipheredKeyLength = 256;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.RSA";
    private PublicKey pubKey = null;
    private PrivateKey privKey = null;
    private boolean genAESHWkeyToken = false;
    private boolean genDESHWkeyToken = false;
    private boolean canBeStored = true;
    private boolean storeInCKDS = false;
    private String CKDSLabel = null;
    private byte keyTokenWrapMode = (byte)10;
    private String oaepHash = null;
    private String maskGenAlg = null;
    private OAEPParameterSpec oaepSpec = null;
    private CCAAlgorithmParameterSpec ccaSpec = null;
    private AlgorithmParameterSpec mgfSpec = null;
    private boolean oaepPadding = false;
    private static final String[] HASH_ALGORITHMS = new String[]{"SHA1", "SHA-1", "SHA224", "SHA-224", "SHA256", "SHA-256", "SHA384", "SHA-384", "SHA512", "SHA-512"};
    private static final MGF1ParameterSpec[] MGF_ALGORITHMS = new MGF1ParameterSpec[]{MGF1ParameterSpec.SHA1, MGF1ParameterSpec.SHA224, MGF1ParameterSpec.SHA256, MGF1ParameterSpec.SHA384, MGF1ParameterSpec.SHA512};

    public RSA() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "RSA");
        }
        this.hikm = new HIKM();
        this.longBuffers = HardwareProfile.getIs4096RNGLSupported();
        if (this.longBuffers) {
            this.maxEncipheredKeyLength = 512;
        }
        this.pkaEncipheredkey = new byte[this.maxEncipheredKeyLength];
        if (debug != null) {
            String info = new String(HardwareProfile.getICSFlevel() + ": 4096RNGLSupported = " + this.longBuffers);
            debug.exit(Debug.TYPE_FINE, (Object)className, "RSA", info);
        }
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetMode", mode);
        }
        if (mode != null && mode.equals(" ")) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
            }
            return;
        }
        if (mode != null && !mode.equals("ECB")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Mode: " + mode + " not implemented");
                debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
            }
            throw new NoSuchAlgorithmException("Mode: " + mode + " not implemented");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
        }
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetPadding", paddingScheme);
        }
        if (paddingScheme == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetPadding", "null padding");
                debug.exit(Debug.TYPE_FINE, className, "engineSetPadding");
            }
            throw new NoSuchPaddingException("null padding");
        }
        if (paddingScheme.equalsIgnoreCase("PKCS1Padding")) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "engineSetPadding1");
            }
            this.paddingIndicator = 0;
            return;
        }
        if (paddingScheme.equalsIgnoreCase("ZeroPadding")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetPadding", "null padding");
                debug.exit(Debug.TYPE_FINE, className, "engineSetPadding2");
            }
            this.paddingIndicator = 1;
            return;
        }
        if (paddingScheme.toUpperCase().contains("OAEP")) {
            int i;
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, paddingScheme);
            }
            if (paddingScheme.equalsIgnoreCase("OAEPPadding")) {
                this.oaepHash = "SHA-1";
            } else {
                this.oaepHash = "SHA";
                int hashIndex = paddingScheme.indexOf("SHA") + "SHA".length();
                if (paddingScheme.charAt(hashIndex) != '-') {
                    this.oaepHash = this.oaepHash + "-";
                }
                for (i = hashIndex; i < paddingScheme.length() && !Character.isLetter(paddingScheme.charAt(i)); ++i) {
                    this.oaepHash = this.oaepHash + paddingScheme.charAt(i);
                }
            }
            if (paddingScheme.toUpperCase().contains("MGF")) {
                int mgfIndex;
                this.maskGenAlg = "MGF";
                this.paddingIndicator = 2;
                for (i = mgfIndex = paddingScheme.indexOf("MGF") + "MGF".length(); i < paddingScheme.length() && !Character.isLetter(paddingScheme.charAt(i)); ++i) {
                    this.maskGenAlg = this.maskGenAlg + paddingScheme.charAt(i);
                }
            } else if (paddingScheme.equalsIgnoreCase("OAEPPadding")) {
                this.maskGenAlg = "MGF1";
                this.paddingIndicator = 2;
            } else {
                this.maskGenAlg = "MGF1";
                this.oaepPadding = true;
            }
            if (this.oaepHash.equals("SHA-1")) {
                this.oaepSpec = new OAEPParameterSpec(this.oaepHash, this.maskGenAlg, MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
            } else if (this.oaepHash.equals("SHA-224")) {
                this.oaepSpec = new OAEPParameterSpec(this.oaepHash, this.maskGenAlg, MGF1ParameterSpec.SHA224, PSource.PSpecified.DEFAULT);
            } else if (this.oaepHash.equals("SHA-256")) {
                this.oaepSpec = new OAEPParameterSpec(this.oaepHash, this.maskGenAlg, MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            } else if (this.oaepHash.equals("SHA-384")) {
                this.oaepSpec = new OAEPParameterSpec(this.oaepHash, this.maskGenAlg, MGF1ParameterSpec.SHA384, PSource.PSpecified.DEFAULT);
            } else if (this.oaepHash.equals("SHA-512")) {
                this.oaepSpec = new OAEPParameterSpec(this.oaepHash, this.maskGenAlg, MGF1ParameterSpec.SHA512, PSource.PSpecified.DEFAULT);
            } else {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineSetPadding", "Padding: " + paddingScheme + " not implemented with " + this.oaepHash);
                    debug.exit(Debug.TYPE_FINE, className, "engineSetPadding");
                }
                throw new NoSuchPaddingException("Padding: " + paddingScheme + " not implemented");
            }
            return;
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineSetPadding", "Padding: " + paddingScheme + " not implemented");
            debug.exit(Debug.TYPE_FINE, className, "engineSetPadding");
        }
        throw new NoSuchPaddingException("Padding: " + paddingScheme + " not implemented");
    }

    @Override
    protected int engineGetBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetBlockSize");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetBlockSize", 0);
        }
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetOutputSize");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize", 256);
        }
        return 256;
    }

    @Override
    protected byte[] engineGetIV() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetIV");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetIV", null);
        }
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetParameters");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameters", null);
        }
        return null;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(opmode), key, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        this.keyTokenWrapMode = (byte)10;
        this.commonInit(opmode, key, random);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commonInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        block34: {
            InvalidKeyException ike;
            block35: {
                Key migKey;
                block37: {
                    block36: {
                        if (debug != null) {
                            Object[] parms = new Object[]{new Integer(opmode), key, random};
                            debug.entry(Debug.TYPE_FINE, (Object)className, "commonInit", parms);
                        }
                        this.buffer = null;
                        this.bArray = new ByteArrayOutputStream();
                        this.externalToken = null;
                        this.token = null;
                        if (key == null) {
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "commonInit", "No key given");
                                debug.exit(Debug.TYPE_FINE, className, "commonInit");
                            }
                            throw new InvalidKeyException("No key given");
                        }
                        if (this.oaepSpec != null && !HardwareProfile.getIsHCR7790OrLaterPresent()) {
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "commonInit", "System Error: OAEP is only supported on HCR7790 or later version.");
                                debug.exit(Debug.TYPE_FINE, className, "commonInit");
                            }
                            throw new InvalidParameterException("System Error: OAEP is only supported on HCR7790 or later version.");
                        }
                        this.decrypting = opmode == 2 || opmode == 4;
                        if (!(key instanceof RSAKey)) {
                            String pszkey = key.getAlgorithm();
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "commonInit", "Not a RSA key.  Key algorithm is " + pszkey + ".");
                                debug.exit(Debug.TYPE_FINE, className, "commonInit");
                            }
                            throw new InvalidKeyException("Not a RSA key.  Key algorithm is " + pszkey + ".");
                        }
                        if (key instanceof PublicKey) {
                            if (this.decrypting) {
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "commonInit", "Public Key cannot be used to decrypt.");
                                    debug.exit(Debug.TYPE_FINE, className, "commonInit");
                                }
                                throw new InvalidKeyException("Public Key cannot be used to decrypt.");
                            }
                            if (key instanceof RSAPublicKey) {
                                this.pubKey = (PublicKey)key;
                                try {
                                    this.token = ((RSAPublicKey)key).getToken();
                                }
                                catch (Exception ex) {
                                    if (debug != null) {
                                        debug.exception(Debug.TYPE_PUBLIC, className, "commonInit", ex);
                                        debug.text(Debug.TYPE_PUBLIC, className, "commonInit", "Bad key encoding.");
                                        debug.exit(Debug.TYPE_FINE, className, "commonInit");
                                    }
                                    throw new InvalidKeyException("Bad key encoding.");
                                }
                            }
                            if (key instanceof java.security.interfaces.RSAPublicKey) {
                                this.pubKey = (PublicKey)key;
                                migKey = new RSAPublicKey(key.getEncoded());
                                this.token = ((RSAPublicKey)migKey).getToken();
                                break block34;
                            } else {
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "commonInit", "Bad key encoding.");
                                    debug.exit(Debug.TYPE_FINE, className, "commonInit");
                                }
                                throw new InvalidKeyException("Bad key encoding");
                            }
                        }
                        if (!(key instanceof PrivateKey)) break block35;
                        if (!this.decrypting) {
                            ike = new InvalidKeyException("Private key cannot be used to encrypt.");
                            if (debug != null) {
                                debug.exception(Debug.TYPE_PUBLIC, className, "commonInit", ike);
                                debug.exit(Debug.TYPE_FINE, className, "commonInit");
                            }
                            throw ike;
                        }
                        if (!(key instanceof RSAPrivateHWKey)) break block36;
                        this.privKey = (PrivateKey)key;
                        RSAPrivateHWKey priv = (RSAPrivateHWKey)key;
                        this.token = priv.getToken();
                        this.externalToken = priv.getExternalKeyToken();
                        break block34;
                    }
                    if (!(key instanceof PKCS11RSAPrivateKey) || !Boolean.TRUE.equals(((PKCS11RSAPrivateKey)key).getSensitive())) break block37;
                    if (!PKCS11Utils.isSecureKey((PKCS11Key)((PKCS11RSAPrivateKey)key))) {
                        ike = new InvalidKeyException("Private key is a sensitive key, but not a secure key");
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "commonInit", ike);
                            debug.exit(Debug.TYPE_FINE, className, "commonInit");
                        }
                        throw ike;
                    }
                    String p11Label = PKCS11Utils.getSecureKeyLabel((PKCS11Key)((PKCS11RSAPrivateKey)key));
                    if (p11Label == null) {
                        InvalidKeyException ike2 = new InvalidKeyException("Bad RSA private key, unable to retrieve secure key label");
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "commonInit", ike2);
                            debug.exit(Debug.TYPE_FINE, className, "commonInit");
                        }
                        throw ike2;
                    }
                    this.privKey = (PrivateKey)key;
                    this.token = p11Label.getBytes(StandardCharsets.ISO_8859_1);
                    this.externalToken = null;
                    break block34;
                }
                if (key instanceof RSAPrivateKey) {
                    this.privKey = (PrivateKey)key;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "commonInit", "Do automatic migration of IBMJCE private key to IBMJCECCA");
                    }
                    try {
                        migKey = new RSAPrivateHWKey(key.getEncoded());
                        this.token = ((RSAPrivateHWKey)migKey).getToken();
                        this.externalToken = ((RSAPrivateHWKey)migKey).getExternalKeyToken();
                    }
                    catch (Exception ex) {
                        InvalidKeyException ike3 = new InvalidKeyException(ex.getMessage());
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "commonInit", ex);
                            debug.exception(Debug.TYPE_PUBLIC, className, "commonInit", ike3);
                            debug.exit(Debug.TYPE_FINE, className, "commonInit");
                        }
                        throw ike3;
                    }
                } else {
                    ike = new InvalidKeyException("Bad RSA private key encoding");
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "commonInit", ike);
                        debug.exit(Debug.TYPE_FINE, className, "commonInit");
                    }
                    throw ike;
                }
            }
            ike = new InvalidKeyException("Must be either public key or private key.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "commonInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "commonInit");
            }
            throw ike;
        }
        if (key instanceof RSAPrivateHWKey && ((RSAPrivateHWKey)key).getUsage() != 3 && this.paddingIndicator == 1) {
            InvalidParameterException ipe = new InvalidParameterException("Key usage must be SIGNATURE when using zero-padding");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "commonInit", ipe);
                debug.exit(Debug.TYPE_FINE, className, "commonInit");
            }
            throw ipe;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "commonInit");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.keyTokenWrapMode = (byte)10;
        if (params instanceof OAEPParameterSpec) {
            if (this.oaepPadding) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "OAEP has already been defined");
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw new InvalidAlgorithmParameterException("OAEP has already been defined");
            }
            this.oaepSpec = (OAEPParameterSpec)params;
        } else if (params instanceof CCAAlgorithmParameterSpec) {
            byte mode;
            this.ccaSpec = (CCAAlgorithmParameterSpec)params;
            if (this.oaepPadding) {
                if (this.ccaSpec.getOAEPParameterSpec() != null) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "OAEP has already been defined");
                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                    }
                    throw new InvalidAlgorithmParameterException("OAEP has already been defined");
                }
            } else {
                this.oaepSpec = this.ccaSpec.getOAEPParameterSpec();
            }
            byte keyType = this.ccaSpec.getHwType();
            if (this.ccaSpec.isSecureInternalToken()) {
                this.genAESHWkeyToken = true;
                this.genDESHWkeyToken = true;
                this.storeInCKDS = false;
                this.CKDSLabel = null;
                mode = ((CCAAlgorithmParameterSpec)params).getTokenWrappingMode();
                if (!(mode != 11 && mode != 12 || HardwareProfile.getIsEnhancedWrappingPresent())) {
                    RuntimeException e = new RuntimeException("WRAPPING_MODE_ECB and WRAPPING_MODE_CBC wrapping modes not supported on this combination of ICSF and/or hardware.");
                    if (null != debug) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                    }
                    throw e;
                }
                if (mode == 11) {
                    this.keyTokenWrapMode = (byte)11;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is SECURE_INTERNAL_TOKEN and wrapping mode is ECB. Any keys unwrapped will now be protected as a secret hardware key using the ECB token wrapping mode.");
                    }
                } else if (mode == 12) {
                    this.keyTokenWrapMode = (byte)12;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is SECURE_INTERNAL_TOKEN and wrapping mode is CBC. Any keys unwrapped will now be protected as a secret hardware key using the CBC token wrapping mode.");
                    }
                } else {
                    this.keyTokenWrapMode = (byte)10;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is SECURE_INTERNAL_TOKEN. Any keys unwrapped will now be protected as a secret hardware key using the default token wrapping mode.");
                    }
                }
            } else if (keyType == 0) {
                this.genAESHWkeyToken = true;
                this.genDESHWkeyToken = true;
                this.storeInCKDS = true;
                this.CKDSLabel = ((CCAAlgorithmParameterSpec)params).getLabel();
                mode = ((CCAAlgorithmParameterSpec)params).getTokenWrappingMode();
                if (!(mode != 11 && mode != 12 || HardwareProfile.getIsEnhancedWrappingPresent())) {
                    RuntimeException e = new RuntimeException("WRAPPING_MODE_ECB and WRAPPING_MODE_CBC wrapping modes not supported on this combination of ICSF and/or hardware.");
                    if (null != debug) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                    }
                    throw e;
                }
                if (mode == 11) {
                    this.keyTokenWrapMode = (byte)11;
                    if (debug != null) {
                        String labelInfo = "A CKDS label will be generated for the new entry.";
                        if (null != this.CKDSLabel && !"".equals(this.CKDSLabel)) {
                            labelInfo = "The following user-specified CKDS label will be used: " + this.CKDSLabel;
                        }
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is CKDS. Any keys unwrapped will now be protected as a secret hardware key using the ECB token wrapping mode and stored in the CKDS. " + labelInfo);
                    }
                } else if (mode == 12) {
                    this.keyTokenWrapMode = (byte)12;
                    if (debug != null) {
                        String labelInfo = "A CKDS label will be generated for the new entry.";
                        if (null != this.CKDSLabel && !"".equals(this.CKDSLabel)) {
                            labelInfo = "The following user-specified CKDS label will be used: " + this.CKDSLabel;
                        }
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is CKDS. Any keys unwrapped will now be protected as a secret hardware key using the CBC token wrapping mode and stored in the CKDS. " + labelInfo);
                    }
                } else {
                    this.keyTokenWrapMode = (byte)10;
                    if (debug != null) {
                        String labelInfo = "A CKDS label will be generated for the new entry.";
                        if (null != this.CKDSLabel && !"".equals(this.CKDSLabel)) {
                            labelInfo = "The following user-specified CKDS label will be used: " + this.CKDSLabel;
                        }
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is CKDS. Any keys unwrapped will now be protected as a secret hardware key using the default token wrapping mode and stored in the CKDS. " + labelInfo);
                    }
                }
            } else {
                this.genAESHWkeyToken = false;
                this.genDESHWkeyToken = false;
                this.storeInCKDS = false;
                this.CKDSLabel = null;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is CLEAR. \nAny keys unwrapped will be a clear key value.");
                }
            }
        }
        if (this.oaepSpec != null) {
            if (!HardwareProfile.getIsHCR7790OrLaterPresent()) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "System Error: OAEP is only supported on HCR7790 or later version.");
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw new InvalidParameterException("System Error: OAEP is only supported on HCR7790 or later version.");
            }
            this.oaepHash = this.oaepSpec.getDigestAlgorithm().toUpperCase();
            String mgfName = this.oaepSpec.getMGFAlgorithm();
            this.mgfSpec = this.oaepSpec.getMGFParameters();
            PSource pSource = this.oaepSpec.getPSource();
            if (Arrays.asList(HASH_ALGORITHMS).contains(this.oaepHash)) {
                if (!mgfName.equalsIgnoreCase("MGF1")) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Unsupported mgf " + mgfName + "; MGF1 only.");
                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                    }
                    throw new InvalidAlgorithmParameterException("Unsupported mgf " + mgfName + "; MGF1 only.");
                }
                if (this.mgfSpec instanceof MGF1ParameterSpec) {
                    if (!Arrays.asList(MGF_ALGORITHMS).contains(this.mgfSpec)) {
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Invalid MGF1ParameterSpec. " + this.mgfSpec.toString() + " is not valid.");
                            debug.exit(Debug.TYPE_FINE, className, "engineInit");
                        }
                        throw new InvalidAlgorithmParameterException("Invalid MGF1ParameterSpec. " + this.mgfSpec.toString() + " is not valid.");
                    }
                } else {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Inappropriate mgf parameters; non-null MGFParameterSpec only.");
                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                    }
                    throw new InvalidAlgorithmParameterException("Inappropriate mgf parameters; non-null MGFParameterSpec only.");
                }
                if (!pSource.getAlgorithm().equals("PSpecified")) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Unsupported pSource " + pSource.getAlgorithm() + "; pSpecified only.");
                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                    }
                    throw new InvalidAlgorithmParameterException("Unsupported pSource " + pSource.getAlgorithm() + "; pSpecified only.");
                }
            } else {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Padding: " + this.oaepHash + " not implemented.");
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw new InvalidAlgorithmParameterException("Padding: " + this.oaepHash + " not implemented.");
            }
        }
        this.commonInit(opmode, key, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.oaepSpec != null && !HardwareProfile.getIsHCR7790OrLaterPresent()) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "System Error: OAEP is only supported on HCR7790 or later version.");
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw new InvalidParameterException("System Error: OAEP is only supported on HCR7790 or later version.");
        }
        this.engineInit(opmode, key, random);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
        }
        if (input != null) {
            this.bArray.write(input, inputOffset, inputLen);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineUpdate", new byte[0]);
        }
        return new byte[0];
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
        }
        if (input != null) {
            this.bArray.write(input, inputOffset, inputLen);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineUpdate", 0);
        }
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineDoFinal", parms);
        }
        if (input != null) {
            this.bArray.write(input, inputOffset, inputLen);
        }
        this.buffer = this.bArray.toByteArray();
        byte[] result = this.rsa(this.buffer, this.buffer.length);
        if (result == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Unknown padding specified");
                debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
            }
            throw new BadPaddingException("Unknown padding specified");
        }
        this.buffer = null;
        this.bArray = new ByteArrayOutputStream();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDoFinal", result);
        }
        return result;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineDoFinal", parms);
        }
        if (input != null) {
            this.bArray.write(input, inputOffset, inputLen);
        }
        this.buffer = this.bArray.toByteArray();
        byte[] result = this.rsa(this.buffer, this.buffer.length);
        if (result == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Unknown padding specified");
                debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
            }
            throw new BadPaddingException("Unknown padding specified");
        }
        if (result.length > output.length - outputOffset) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Output buffer too short: " + (output.length - outputOffset) + " bytes given, " + result.length + " bytes needed");
                debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
            }
            throw new ShortBufferException("Output buffer too short: " + (output.length - outputOffset) + " bytes given, " + result.length + " bytes needed");
        }
        System.arraycopy(result, 0, output, outputOffset, result.length);
        this.buffer = null;
        this.bArray = new ByteArrayOutputStream();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDoFinal", result.length);
        }
        return result.length;
    }

    private byte[] rsa(byte[] data, int len) throws RuntimeException {
        hikmNativeInteger ruleArrayCount = null;
        hikmNativeInteger dataLength = new hikmNativeInteger(len);
        hikmNativeInteger tokenLength = null;
        hikmNativeInteger internalTokenLength = null;
        hikmNativeInteger dataStructureLength = new hikmNativeInteger(0);
        int offset = -1;
        byte[] dataStructure = new byte[]{};
        byte[] tokenData = null;
        byte[] internalTokenData = null;
        String ruleText = null;
        HexDumpEncoder encoder = null;
        if (this.externalToken != null && this.externalToken.length > 0) {
            tokenLength = new hikmNativeInteger(this.externalToken.length);
            tokenData = (byte[])this.externalToken.clone();
            internalTokenLength = new hikmNativeInteger(this.token.length);
            internalTokenData = (byte[])this.token.clone();
        } else {
            tokenLength = new hikmNativeInteger(this.token.length);
            tokenData = (byte[])this.token.clone();
            internalTokenLength = tokenLength;
            internalTokenData = tokenData;
        }
        if (PlatformUtilities.isZOS()) {
            tokenData = PlatformUtilities.convertBytesIfKeyLabelATOE(tokenData);
            internalTokenData = PlatformUtilities.convertBytesIfKeyLabelATOE(internalTokenData);
        }
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "rsa", data, new Integer(len));
            encoder = new HexDumpEncoder();
        }
        this.pkaEncipheredKeyBitLength.setValue(0);
        if (this.oaepSpec != null) {
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "rsa: this.oaepHash = ", this.oaepHash);
            }
            if (this.oaepHash.equals("SHA1") || this.oaepHash.equals("SHA-1")) {
                ruleText = new String("PKCSOAEPSHA-1   ");
            } else if (this.oaepHash.equals("SHA224") || this.oaepHash.equals("SHA-224")) {
                ruleText = new String("PKOAEP2 SHA-224 ");
            } else if (this.oaepHash.equals("SHA256") || this.oaepHash.equals("SHA-256")) {
                ruleText = new String("PKCSOAEPSHA-256 ");
            } else if (this.oaepHash.equals("SHA384") || this.oaepHash.equals("SHA-384")) {
                ruleText = new String("PKOAEP2 SHA-384 ");
            } else if (this.oaepHash.equals("SHA512") || this.oaepHash.equals("SHA-512")) {
                ruleText = new String("PKOAEP2 SHA-512 ");
            } else {
                RuntimeException re = new RuntimeException("Invalid Padding: " + this.oaepHash);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "wrapKey", re);
                    debug.exit(Debug.TYPE_FINE, className, "wrapKey");
                }
                throw re;
            }
            ruleArrayCount = new hikmNativeInteger(2);
        } else if (this.paddingIndicator == 0) {
            ruleText = new String("PKCS-1.2");
            ruleArrayCount = new hikmNativeInteger(1);
        } else if (this.paddingIndicator == 1) {
            ruleText = new String("ZERO-PAD");
            ruleArrayCount = new hikmNativeInteger(1);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "rsa", "Padding set to an unknown value = " + this.paddingIndicator + ".");
                debug.exit(Debug.TYPE_FINE, className, "rsa_1");
            }
            throw new RuntimeException("Padding set to an unknown value = " + this.paddingIndicator + ".");
        }
        byte[] ruleArray = PlatformUtilities.getBytesPlatform(ruleText);
        this.pkaEncipheredKeyLength.setValue(this.pkaEncipheredkey.length);
        this.pkaEncipheredKeyBitLength.setValue(this.pkaEncipheredkey.length * 8);
        if (this.paddingIndicator == 0 || this.paddingIndicator == 2) {
            String exitDataString;
            if (!this.decrypting) {
                String exitDataString2;
                if (debug != null) {
                    exitDataString2 = encoder.encodeBuffer(this.exitData);
                    String ruleArrayString = encoder.encodeBuffer(ruleArray);
                    String tokenDataString = encoder.encodeBuffer(tokenData);
                    String parmsReport = "\nRSA: CSNDPKE INPUT PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    exitDataLen   : " + this.exitDataLength.getValue() + "\n    exitData      : \n" + exitDataString2 + "\n    ruleArrayCount: " + ruleArrayCount.getValue() + "\n    ruleArray     : \n" + ruleArrayString + "\n    dataLength  : " + dataLength.getValue() + "\n    data     : \n\n    dataStructureLength: " + dataStructureLength.getValue() + "\n    tokenLength  : " + tokenLength.getValue() + "\n    tokenData     : \n" + tokenDataString + "\n    pkaEncipheredKeyLength  : " + this.pkaEncipheredKeyLength.getValue() + "\n";
                    debug.text(Debug.TYPE_FINEST, className, "rsa", parmsReport);
                }
                try {
                    this.hikm.CSNDPKEJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, dataLength, data, dataStructureLength, dataStructure, tokenLength, tokenData, this.pkaEncipheredKeyLength, this.pkaEncipheredkey);
                }
                catch (IllegalArgumentException e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "rsa", e);
                        debug.text(Debug.TYPE_PUBLIC, className, "rsa", "Hardware error from call CSNDPKE " + e);
                        debug.exit(Debug.TYPE_FINE, className, "rsa_3");
                    }
                    throw new RuntimeException("Hardware error from call CSNDPKE " + e);
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "rsa", "CSNDPKE: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
                }
                if (debug != null) {
                    debug.text(8192L, className, "rsa", "CSNDPKE Rtn = " + this.returnCode.getValue() + " reason " + this.reasonCode.getValue());
                    exitDataString2 = encoder.encodeBuffer(this.exitData);
                    String pkaEncipheredkeyString = encoder.encodeBuffer(this.pkaEncipheredkey);
                    String parmsReport = "\nRSA: CSNDPKE RETURN PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    exitDataLen   : " + this.exitDataLength.getValue() + "\n    exitData      : \n" + exitDataString2 + "\n    pkaEncipheredKeyLength  : " + this.pkaEncipheredKeyLength.getValue() + "\n    pkaEncipheredkey     : \n" + pkaEncipheredkeyString + "\n";
                    debug.text(Debug.TYPE_FINEST, className, "rsa", parmsReport);
                }
                if (this.returnCode.getValue() != 0) {
                    if (debug != null) {
                        debug.text(8192L, className, "rsa", "Hardware error from call CSNDPKE returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue());
                        debug.exit(Debug.TYPE_FINE, className, "rsa_4");
                    }
                    throw new JCECCARuntimeException(1, "CSNDPKE", "Hardware error from call CSNDPKE returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                }
                byte[] result = new byte[this.pkaEncipheredKeyLength.getValue()];
                System.arraycopy(this.pkaEncipheredkey, 0, result, 0, this.pkaEncipheredKeyLength.getValue());
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "rsa_5", result);
                }
                return result;
            }
            if (debug != null) {
                exitDataString = encoder.encodeBuffer(this.exitData);
                String ruleArrayString = encoder.encodeBuffer(ruleArray);
                String dataString = encoder.encodeBuffer(data);
                String tokenDataString = encoder.encodeBuffer(tokenData);
                String parmsReport = "\nRSA: CSNDPKD INPUT PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    exitDataLen   : " + this.exitDataLength.getValue() + "\n    exitData      : \n" + exitDataString + "\n    ruleArrayCount: " + ruleArrayCount.getValue() + "\n    ruleArray     : \n" + ruleArrayString + "\n    dataLength  : " + dataLength.getValue() + "\n    data     : \n" + dataString + "\n    dataStructureLength: " + dataStructureLength.getValue() + "\n    tokenLength  : " + tokenLength.getValue() + "\n    tokenData     : \n" + tokenDataString + "\n    pkaDecipheredKeyLength  : " + this.pkaEncipheredKeyLength.getValue() + "\n";
                debug.text(Debug.TYPE_FINEST, className, "rsa", parmsReport);
            }
            try {
                this.hikm.CSNDPKDJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, dataLength, data, dataStructureLength, dataStructure, tokenLength, tokenData, this.pkaEncipheredKeyLength, this.pkaEncipheredkey);
            }
            catch (IllegalArgumentException e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "rsa", e);
                    debug.text(Debug.TYPE_PUBLIC, className, "rsa", "Hardware error from call CSNDPKD " + e);
                    debug.exit(Debug.TYPE_FINE, className, "rsa_6");
                }
                throw new RuntimeException("Hardware error from call CSNDPKD " + e);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "rsa", "CSNDPKD: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
            }
            if (debug != null) {
                debug.text(8192L, className, "rsa", "CSNDPKD Rtn = " + this.returnCode.getValue() + " reason " + this.reasonCode.getValue());
                exitDataString = encoder.encodeBuffer(this.exitData);
                String pkaEncipheredkeyString = encoder.encodeBuffer(this.pkaEncipheredkey);
                String parmsReport = "\nRSA: CSNDPKD RETURN PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    exitDataLen   : " + this.exitDataLength.getValue() + "\n    exitData      : \n" + exitDataString + "\n    pkaDecipheredKeyLength  : " + this.pkaEncipheredKeyLength.getValue() + "\n    pkaDecipheredkey     : \n" + pkaEncipheredkeyString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "rsa", parmsReport);
            }
            if (this.returnCode.getValue() != 0) {
                if (debug != null) {
                    debug.text(8192L, className, "rsa", "Hardware error from call CSNDPKD returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue());
                    debug.exit(Debug.TYPE_FINE, className, "rsa_7");
                }
                throw new JCECCARuntimeException(1, "CSNDPKD", "Hardware error from call CSNDPKD returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
            }
            byte[] result = new byte[this.pkaEncipheredKeyLength.getValue()];
            System.arraycopy(this.pkaEncipheredkey, 0, result, 0, this.pkaEncipheredKeyLength.getValue());
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "rsa_8", result);
            }
            return result;
        }
        if (this.paddingIndicator == 1) {
            String exitDataString;
            if (!this.decrypting) {
                String exitDataString3;
                if (debug != null) {
                    exitDataString3 = encoder.encodeBuffer(this.exitData);
                    String ruleArrayString = encoder.encodeBuffer(ruleArray);
                    String dataString = encoder.encodeBuffer(data);
                    String tokenDataString = encoder.encodeBuffer(tokenData);
                    String parmsReport = "\nRSA: CSNDPKE INPUT PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    exitDataLen   : " + this.exitDataLength.getValue() + "\n    exitData      : \n" + exitDataString3 + "\n    ruleArrayCount: " + ruleArrayCount.getValue() + "\n    ruleArray     : \n" + ruleArrayString + "\n    dataLength  : " + dataLength.getValue() + "\n    data     : \n" + dataString + "\n    dataStructureLength: " + dataStructureLength.getValue() + "\n    tokenLength  : " + tokenLength.getValue() + "\n    tokenData     : \n" + tokenDataString + "\n    pkaEncipheredKeyLength  : " + this.pkaEncipheredKeyLength.getValue() + "\n";
                    debug.text(Debug.TYPE_FINEST, className, "rsa", parmsReport);
                }
                try {
                    this.hikm.CSNDPKEJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, dataLength, data, dataStructureLength, dataStructure, tokenLength, tokenData, this.pkaEncipheredKeyLength, this.pkaEncipheredkey);
                }
                catch (IllegalArgumentException e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "rsa", e);
                        debug.text(Debug.TYPE_PUBLIC, className, "rsa", "Hardware error from call CSNDPKE " + e);
                        debug.exit(Debug.TYPE_FINE, className, "rsa_9");
                    }
                    throw new RuntimeException("Hardware error from call CSNDPKE " + e);
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "rsa", "CSNDPKE: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
                }
                if (debug != null) {
                    debug.text(8192L, className, "rsa", "CSNDPKE Rtn = " + this.returnCode.getValue() + " reason " + this.reasonCode.getValue());
                    exitDataString3 = encoder.encodeBuffer(this.exitData);
                    String parmsReport = "\nRSA: CSNDPKE RETURN PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    exitDataLen   : " + this.exitDataLength.getValue() + "\n    exitData      : \n" + exitDataString3 + "\n    pkaEncipheredKeyLength  : " + this.pkaEncipheredKeyLength.getValue() + "\n    pkaEncipheredkey     : \n\n";
                    debug.text(Debug.TYPE_FINEST, className, "rsa", parmsReport);
                }
                if (this.returnCode.getValue() == 8 && this.reasonCode.getValue() == 11008) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, className, "rsa_10");
                    }
                    throw new JCECCARuntimeException(1, "CSNDPKE", "Hardware error from call CSNDPKE. The data to be encrypted is too long. The data must be the size of the modulus or smaller in bytes.", this.returnCode.getValue(), this.reasonCode.getValue());
                }
                if (this.returnCode.getValue() != 0) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, className, "rsa_11");
                    }
                    throw new JCECCARuntimeException(1, "CSNDPKE", "Hardware error from call CSNDPKE returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                }
                byte[] result = new byte[this.pkaEncipheredKeyLength.getValue()];
                System.arraycopy(this.pkaEncipheredkey, 0, result, 0, this.pkaEncipheredKeyLength.getValue());
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "rsa_12", result);
                }
                return result;
            }
            byte[] ruleArrayZeroPad = (byte[])ruleArray.clone();
            if (debug != null) {
                exitDataString = encoder.encodeBuffer(this.exitData);
                String ruleArrayString = encoder.encodeBuffer(ruleArray);
                String dataString = encoder.encodeBuffer(data);
                String tokenDataString = encoder.encodeBuffer(internalTokenData);
                String parmsReport = "\nRSA: CSNDDSG INPUT PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    exitDataLen   : " + this.exitDataLength.getValue() + "\n    exitData      : \n" + exitDataString + "\n    ruleArrayCount: " + ruleArrayCount.getValue() + "\n    ruleArray     : \n" + ruleArrayString + "\n    keyLength     : " + internalTokenLength.getValue() + "\n    key           : \n" + tokenDataString + "\n    hashLength    : " + dataLength.getValue() + "\n    hash          : \n" + dataString + "\n    sigFieldLength: " + this.pkaEncipheredKeyLength.getValue() + "\n";
                debug.text(Debug.TYPE_FINEST, className, "rsa", parmsReport);
            }
            try {
                this.hikm.CSNDDSGJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, internalTokenLength, internalTokenData, dataLength, data, this.pkaEncipheredKeyLength, this.pkaEncipheredKeyBitLength, this.pkaEncipheredkey);
            }
            catch (IllegalArgumentException e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "rsa", e);
                    debug.text(Debug.TYPE_PUBLIC, className, "rsa", "Hardware error from call CSNDDSG " + e);
                    debug.exit(Debug.TYPE_FINE, className, "rsa_13");
                }
                throw new RuntimeException("Hardware error from call CSNDDSG " + e);
            }
            if (debug != null) {
                exitDataString = encoder.encodeBuffer(this.exitData);
                String pkaEncipheredkeyString = encoder.encodeBuffer(this.pkaEncipheredkey);
                String parmsReport = "\nRSA: CSNDDSG RETURN PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    exitDataLen   : " + this.exitDataLength.getValue() + "\n    exitData      : \n" + exitDataString + "\n    sigFieldLength: " + this.pkaEncipheredKeyLength.getValue() + "\n    sigBitLength  : " + this.pkaEncipheredKeyBitLength.getValue() + "\n    signature     : \n" + pkaEncipheredkeyString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "rsa", parmsReport);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "rsa", "CSNDDSG Rtn = " + this.returnCode.getValue() + " reason " + this.reasonCode.getValue());
            }
            if (this.returnCode.getValue() != 0) {
                if (this.returnCode.getValue() == 8 && this.reasonCode.getValue() == 48 && internalTokenData.length > 64) {
                    String exitDataString4;
                    if (debug != null) {
                        debug.text(Debug.TYPE_FINE, className, "rsa", "One or more keys has a master key verification pattern that is not valid");
                        debug.text(Debug.TYPE_FINE, className, "rsa", "Refreshing internal token representation of CLEAR key and trying sign again");
                    }
                    KeyPairUtils util = new KeyPairUtils();
                    internalTokenData = util.importExternalToken(tokenData, KeyPairUtils.KeyPairAlgorithm.RSA);
                    internalTokenLength = new hikmNativeInteger(internalTokenData.length);
                    ruleArray = (byte[])ruleArrayZeroPad.clone();
                    if (debug != null) {
                        exitDataString4 = encoder.encodeBuffer(this.exitData);
                        String ruleArrayString = encoder.encodeBuffer(ruleArray);
                        String dataString = encoder.encodeBuffer(data);
                        String tokenDataString = encoder.encodeBuffer(internalTokenData);
                        String parmsReport = "\nRSA: CSNDDSG INPUT PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    exitDataLen   : " + this.exitDataLength.getValue() + "\n    exitData      : \n" + exitDataString4 + "\n    ruleArrayCount: " + ruleArrayCount.getValue() + "\n    ruleArray     : \n" + ruleArrayString + "\n    keyLength     : " + internalTokenLength.getValue() + "\n    key           : \n" + tokenDataString + "\n    hashLength    : " + dataLength.getValue() + "\n    hash          : \n" + dataString + "\n    sigFieldLength: " + this.pkaEncipheredKeyLength.getValue() + "\n";
                        debug.text(Debug.TYPE_FINEST, className, "rsa", parmsReport);
                    }
                    try {
                        this.hikm.CSNDDSGJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, internalTokenLength, internalTokenData, dataLength, data, this.pkaEncipheredKeyLength, this.pkaEncipheredKeyBitLength, this.pkaEncipheredkey);
                    }
                    catch (IllegalArgumentException e) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "rsa", e);
                            debug.text(Debug.TYPE_PUBLIC, className, "rsa", "Hardware error from call CSNDDSG " + e);
                            debug.exit(Debug.TYPE_FINE, className, "rsa_13");
                        }
                        throw new RuntimeException("Hardware error from call CSNDDSG " + e);
                    }
                    if (debug != null) {
                        exitDataString4 = encoder.encodeBuffer(this.exitData);
                        String pkaEncipheredkeyString = encoder.encodeBuffer(this.pkaEncipheredkey);
                        String parmsReport = "\nRSA: CSNDDSG RETURN PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    exitDataLen   : " + this.exitDataLength.getValue() + "\n    exitData      : \n" + exitDataString4 + "\n    sigFieldLength: " + this.pkaEncipheredKeyLength.getValue() + "\n    sigBitLength  : " + this.pkaEncipheredKeyBitLength.getValue() + "\n    signature     : \n" + pkaEncipheredkeyString + "\n";
                        debug.text(Debug.TYPE_FINEST, className, "rsa", parmsReport);
                    }
                    if (debug != null) {
                        debug.text(Debug.TYPE_FINE, className, "rsa", "CSNDDSG Rtn = " + this.returnCode.getValue() + " reason " + this.reasonCode.getValue());
                    }
                    if (this.returnCode.getValue() != 0) {
                        if (debug != null) {
                            debug.exit(Debug.TYPE_FINE, className, "rsa_17");
                        }
                        throw new JCECCARuntimeException(1, "CSNDDSG", "Hardware error from call CSNDDSG returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                    }
                } else {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, className, "rsa_14");
                    }
                    throw new JCECCARuntimeException(1, "CSNDDSG", "Hardware error from call CSNDDSG returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                }
            }
            for (int i = 0; i < this.pkaEncipheredKeyLength.getValue() && offset == -1; ++i) {
                if (this.pkaEncipheredkey[i] == 0) continue;
                offset = i;
            }
            byte[] result = new byte[this.pkaEncipheredKeyLength.getValue() - offset];
            System.arraycopy(this.pkaEncipheredkey, offset, result, 0, this.pkaEncipheredKeyLength.getValue() - offset);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "rsa_15", result);
            }
            return result;
        }
        if (debug != null) {
            debug.text(8192L, className, "rsa", "Padding set to an unknown value = " + this.paddingIndicator + ".");
            debug.exit(Debug.TYPE_FINE, className, "rsa_16");
        }
        throw new RuntimeException("Padding set to an unknown value = " + this.paddingIndicator + ".");
    }

    @Override
    protected int engineGetKeySize(Key key) {
        int keySize;
        block4: {
            keySize = 1024;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetKeySize", key);
            }
            try {
                keySize = Cipher.getMaxAllowedKeyLength("RSA");
            }
            catch (NoSuchAlgorithmException e) {
                if (debug == null) break block4;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySize", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySize", keySize);
        }
        return keySize;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        String form;
        byte[] keyToken = null;
        byte[] keyLabel = null;
        String algorithm = "";
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineWrap", key);
        }
        if (key instanceof DESKey) {
            form = ((DESKey)key).getFormat();
            algorithm = "DES";
            if ("ICSFToken".equals(form)) {
                keyToken = ((DESKey)key).getToken();
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Wrapping DES ICSFToken key type");
                }
            } else if ("CKDSLabel".equals(form)) {
                byte[] tmp = ((DESKey)key).getLabelString().getBytes(PlatformUtilities.CHARSET_IBM_1047);
                keyLabel = new byte[64];
                Arrays.fill(keyLabel, (byte)64);
                System.arraycopy(tmp, 0, keyLabel, 0, tmp.length);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Wrapping DES CKDSLabel key type");
                }
            } else if ("RAW".equals(form)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Wrapping DES RAW key");
                }
                if (this.oaepSpec != null) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "(1)OAEP padding is not supported for CLEAR keys.");
                        debug.exit(Debug.TYPE_FINE, className, "engineWrap");
                    }
                    throw new RuntimeException(new InvalidAlgorithmParameterException("(1)OAEP padding is not supported for CLEAR keys."));
                }
                try {
                    String provider = null;
                    provider = Security.getProvider("IBMJCECCA") == null ? "IBMJCE4758" : "IBMJCECCA";
                    Cipher ci = Cipher.getInstance("RSA/ /PKCS1Padding", provider);
                    ci.init(1, this.pubKey);
                    byte[] encodedKey = key.getEncoded();
                    if (encodedKey == null || encodedKey.length == 0) {
                        throw new InvalidKeyException("Cannot get encoding of the DESKey being wrapped.");
                    }
                    ci.update(encodedKey);
                    byte[] encrypted_key = ci.doFinal();
                    return encrypted_key;
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Error wrapping DES key.", e);
                }
            }
        } else if (key instanceof DESedeKey) {
            form = ((DESedeKey)key).getFormat();
            algorithm = "DESede";
            if ("ICSFToken".equals(form)) {
                keyToken = ((DESedeKey)key).getToken();
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Wrapping DESede ICSFToken key type");
                }
            } else if ("CKDSLabel".equals(form)) {
                byte[] tmp = ((DESedeKey)key).getLabelString().getBytes(PlatformUtilities.CHARSET_IBM_1047);
                keyLabel = new byte[64];
                Arrays.fill(keyLabel, (byte)64);
                System.arraycopy(tmp, 0, keyLabel, 0, tmp.length);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Wrapping DESede CKDSLabel key type");
                }
            } else if ("RAW".equals(form)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Wrapping DESede RAW key");
                }
                if (this.oaepSpec != null) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "(2)OAEP padding is not supported for CLEAR keys.");
                        debug.exit(Debug.TYPE_FINE, className, "engineWrap");
                    }
                    throw new RuntimeException(new InvalidAlgorithmParameterException("(2)OAEP padding is not supported for CLEAR keys."));
                }
                try {
                    String provider = null;
                    provider = Security.getProvider("IBMJCECCA") == null ? "IBMJCE4758" : "IBMJCECCA";
                    Cipher ci = Cipher.getInstance("RSA/ /PKCS1Padding", provider);
                    ci.init(1, this.pubKey);
                    byte[] encodedKey = key.getEncoded();
                    if (encodedKey == null || encodedKey.length == 0) {
                        throw new InvalidKeyException("Cannot get encoding of the DESedeKey being wrapped.");
                    }
                    ci.update(encodedKey);
                    byte[] encrypted_key = ci.doFinal();
                    return encrypted_key;
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Error wrapping DESede key.", e);
                }
            }
        } else if (key instanceof AESKey) {
            form = ((AESKey)key).getFormat();
            algorithm = "AES";
            if ("ICSFToken".equals(form)) {
                keyToken = ((AESKey)key).getToken();
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Wrapping AES ICSFToken key type");
                }
            } else if ("CKDSLabel".equals(form)) {
                byte[] tmp = ((AESKey)key).getLabelString().getBytes(PlatformUtilities.CHARSET_IBM_1047);
                keyLabel = new byte[64];
                Arrays.fill(keyLabel, (byte)64);
                System.arraycopy(tmp, 0, keyLabel, 0, tmp.length);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Wrapping AES CKDSLabel key type");
                }
            } else if ("RAW".equals(form)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Wrapping AES RAW key");
                }
                if (this.oaepSpec != null) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "(3)OAEP padding is not supported for CLEAR keys.");
                        debug.exit(Debug.TYPE_FINE, className, "engineWrap");
                    }
                    throw new RuntimeException(new InvalidAlgorithmParameterException("(3)OAEP padding is not supported for CLEAR keys."));
                }
                try {
                    String provider = null;
                    provider = Security.getProvider("IBMJCECCA") == null ? "IBMJCE4758" : "IBMJCECCA";
                    Cipher ci = Cipher.getInstance("RSA/ /PKCS1Padding", provider);
                    ci.init(1, this.pubKey);
                    byte[] encodedKey = key.getEncoded();
                    if (encodedKey == null || encodedKey.length == 0) {
                        throw new InvalidKeyException("Cannot get encoding of the AESKey being wrapped.");
                    }
                    ci.update(encodedKey);
                    byte[] encrypted_key = ci.doFinal();
                    return encrypted_key;
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Error wrapping AES key.", e);
                }
            }
        } else if (key instanceof Key) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Wrapping Software Key");
            }
            if (this.oaepSpec != null) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "(4)OAEP padding is not supported for CLEAR keys.");
                    debug.exit(Debug.TYPE_FINE, className, "engineWrap");
                }
                throw new RuntimeException(new InvalidAlgorithmParameterException("(4)OAEP padding is not supported for CLEAR keys."));
            }
            try {
                String provider = null;
                provider = Security.getProvider("IBMJCECCA") == null ? "IBMJCE4758" : "IBMJCECCA";
                Cipher ci = Cipher.getInstance("RSA/ /PKCS1Padding", provider);
                ci.init(1, this.pubKey);
                byte[] encodedKey = key.getEncoded();
                if (encodedKey == null || encodedKey.length == 0) {
                    throw new InvalidKeyException("Cannot get an encoding of the the Key being wrapped.");
                }
                ci.update(encodedKey);
                byte[] encrypted_key = ci.doFinal();
                return encrypted_key;
            }
            catch (Exception e) {
                throw new InvalidKeyException("Error wrapping software key.", e);
            }
        }
        if (null == keyToken && null == keyLabel) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Key wrapping is not supported for the given key algorithm or format.");
                debug.exit(Debug.TYPE_FINE, className, "engineWrap");
            }
            throw new InvalidKeyException("Key wrapping is not supported for the given key algorithm or format.");
        }
        byte[] wrappedKey = this.wrapKey(keyToken, keyLabel, algorithm);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineWrap", wrappedKey);
        }
        return wrappedKey;
    }

    private byte[] wrapKey(byte[] keyToken, byte[] keyLabel, String algorithm) {
        byte[] returnValue;
        byte[] keyTokenOrLabel;
        boolean isKeyToken;
        HexDumpEncoder encoder = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "wrapKey");
            encoder = new HexDumpEncoder();
        }
        boolean allAES_supported = false;
        if ("AES".equalsIgnoreCase(algorithm) && HardwareProfile.getIsAES128CryptoAssistPresent() && HardwareProfile.getIsAES192CryptoAssistPresent() && HardwareProfile.getIsAES256CryptoAssistPresent()) {
            allAES_supported = true;
        }
        if (keyToken != null) {
            isKeyToken = true;
            keyTokenOrLabel = keyToken;
        } else {
            isKeyToken = false;
            keyTokenOrLabel = keyLabel;
        }
        this.returnCode = new hikmNativeInteger(0);
        this.reasonCode = new hikmNativeInteger(0);
        this.exitDataLength = new hikmNativeInteger(0);
        this.exitData = new byte[0];
        hikmNativeInteger ruleArrayCount = null;
        byte[] rsaPublicId = (byte[])this.token.clone();
        hikmNativeInteger rsaPublicIdLength = new hikmNativeInteger(rsaPublicId.length);
        String ruleText = null;
        if (this.oaepSpec != null) {
            ruleText = "DES".equals(algorithm) || "DESede".equals(algorithm) ? "DES     PKCSOAEP" : (!isKeyToken || SymmetricKeyUtils.isAESInternalDataKeyToken(keyTokenOrLabel) ? "AES     PKCSOAEP" : "AES     PKOAEP2 ");
            if (this.oaepHash.equals("SHA-1")) {
                ruleText = ruleText + "SHA-1   ";
            } else if (this.oaepHash.equals("SHA-256")) {
                ruleText = ruleText + "SHA-256 ";
            } else {
                RuntimeException re = new RuntimeException("Invalid Padding: " + this.oaepHash);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "wrapKey", re);
                    debug.exit(Debug.TYPE_FINE, className, "wrapKey");
                }
                throw re;
            }
            ruleArrayCount = new hikmNativeInteger(3);
        } else if ("DES".equals(algorithm) || "DESede".equals(algorithm)) {
            ruleText = "PKCS-1.2";
            ruleArrayCount = new hikmNativeInteger(1);
        } else {
            ruleText = "AES     PKCS-1.2";
            ruleArrayCount = new hikmNativeInteger(2);
        }
        byte[] ruleArray = PlatformUtilities.getBytesPlatform(ruleText);
        if (PlatformUtilities.isZOS()) {
            rsaPublicId = PlatformUtilities.convertBytesIfKeyLabelATOE(rsaPublicId);
        }
        hikmNativeInteger dataKeyIdLength = new hikmNativeInteger(keyTokenOrLabel.length);
        byte[] dataKeyId = (byte[])keyTokenOrLabel.clone();
        if (PlatformUtilities.isLinux()) {
            dataKeyId = PlatformUtilities.convertBytesIfKeyLabelETOA(dataKeyId);
        }
        hikmNativeInteger encipheredKeyLength = new hikmNativeInteger(this.maxEncipheredKeyLength);
        byte[] encipheredKey = new byte[this.maxEncipheredKeyLength];
        boolean z31Bit = false;
        boolean z64Bit = false;
        if (HardwareProfile.getIs64Bit()) {
            z64Bit = true;
        } else {
            z31Bit = true;
        }
        if (debug != null) {
            String osReport = "\n    64 Bit        : " + HardwareProfile.getIs64Bit() + "\n    HCR7770 plus  : " + HardwareProfile.getIsHCR7770OrLaterPresent() + "\n";
            debug.text(Debug.TYPE_PUBLIC, className, "wrapKey", osReport);
        }
        if (z31Bit || z64Bit && HardwareProfile.getIsHCR7770OrLaterPresent()) {
            String exitDataString;
            if (debug != null) {
                exitDataString = encoder.encodeBuffer(this.exitData);
                String ruleArrayString = encoder.encodeBuffer(ruleArray);
                String dataKeyIdString = encoder.encodeBuffer(dataKeyId);
                String rsaPublicIdString = encoder.encodeBuffer(rsaPublicId);
                String parmsReport = "\nRSA: CSNDSYX INPUT PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    exitDataLen   : " + this.exitDataLength.getValue() + "\n    exitData      : " + exitDataString + "\n    ruleArrayCount: " + ruleArrayCount.getValue() + "\n    ruleArray     : " + ruleArrayString + "\n    dataKeyIdLen  : " + dataKeyIdLength.getValue() + "\n    dataKeyId     : \n" + dataKeyIdString + "\n    rsaPublicIdLen: " + rsaPublicIdLength.getValue() + "\n    rsaPublicId   : \n" + rsaPublicIdString + "\n    enciphKeyLen  : " + encipheredKeyLength.getValue() + "\n";
                debug.text(Debug.TYPE_FINEST, className, "wrapKey", parmsReport);
            }
            try {
                this.hikm.CSNDSYXJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, dataKeyIdLength, dataKeyId, rsaPublicIdLength, rsaPublicId, encipheredKeyLength, encipheredKey);
            }
            catch (IllegalArgumentException e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "wrapKey", e);
                    debug.text(Debug.TYPE_PUBLIC, className, "wrapKey", "Hardware error from call CSNDSYX " + e);
                    debug.exit(Debug.TYPE_FINE, className, "wrapKey");
                }
                throw new RuntimeException("Hardware error from call CSNDSYX " + e);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "wrapKey", "CSNDSYX: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
            }
            if (debug != null) {
                exitDataString = encoder.encodeBuffer(this.exitData);
                String dataKeyIdString = encoder.encodeBuffer(dataKeyId);
                String encipheredKeyString = encoder.encodeBuffer(encipheredKey);
                if (encipheredKeyString == null) {
                    encipheredKeyString = "";
                }
                String parmsReport = "\nRSA: CSNDSYX RETURN PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    exitDataLen   : " + this.exitDataLength.getValue() + "\n    exitData      : " + exitDataString + "\n    dataKeyIdLen  : " + dataKeyIdLength.getValue() + "\n    dataKeyId     : \n" + dataKeyIdString + "\n    enciphKeyLen  : " + encipheredKeyLength.getValue() + "\n    enciphKey     : \n" + encipheredKeyString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "wrapKey", parmsReport);
            }
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "wrapKey", "Hardware call to CSNDSYX not supported");
            }
            throw new IllegalArgumentException("System Error: Key wrapping is not supported in AMODE(64).");
        }
        int currentRetCode = this.returnCode.getValue();
        switch (currentRetCode) {
            case 0: {
                if (debug == null) break;
                debug.text(Debug.TYPE_PUBLIC, className, "wrapKey", "Good return code from CSNDSYX. Key wrapped.");
                break;
            }
            case 8: {
                if (this.reasonCode.getValue() == 2093 && !HardwareProfile.getIsHCR7770OrLaterPresent()) {
                    if (debug == null) break;
                    debug.text(Debug.TYPE_PUBLIC, className, "wrapKey", "CSNDSYXJ return/reason code 8/2093 is an expected result");
                    break;
                }
                if ((this.reasonCode.getValue() == 3052 || this.reasonCode.getValue() == 10068) && HardwareProfile.getIsHCR7770OrLaterPresent()) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "wrapKey", "CSNDSYXJ return/reason code 8/3052 or 10068");
                    }
                    encipheredKey = this.wrapCKDSLabelClearKey(keyTokenOrLabel);
                    encipheredKeyLength.setValue(encipheredKey.length);
                    break;
                }
                if ((this.reasonCode.getValue() == 2016 || this.reasonCode.getValue() == 34) && this.oaepSpec != null && algorithm.equals("AES") && !isKeyToken) {
                    String retryRuleArray;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "wrapKey", "CSNDSYX return/reason code 8/" + this.reasonCode.getValue() + ". Retry RSA OAEP with PKOAEP2 formatting method");
                    }
                    switch (this.oaepHash) {
                        case "SHA-256": {
                            retryRuleArray = "AES     PKOAEP2 SHA-256 ";
                            break;
                        }
                        default: {
                            retryRuleArray = "AES     PKOAEP2 SHA-1   ";
                        }
                    }
                    encipheredKey = SymmetricKeyUtils.symmetricKeyExport(3, retryRuleArray, dataKeyId, rsaPublicId);
                    encipheredKeyLength.setValue(encipheredKey.length);
                    break;
                }
                if (this.reasonCode.getValue() == 39 && (algorithm.equals("DES") || algorithm.equals("DESede"))) {
                    JCECCARuntimeException jre = new JCECCARuntimeException(1, "CSNDSYX", "Hardware error from call CSNDSYX returnCode 8 reasonCode 39, this DES or DESede key cannot be wrapped using a RSA cipher", this.returnCode.getValue(), this.reasonCode.getValue());
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "wrapKey", jre);
                        debug.exit(Debug.TYPE_PUBLIC, className, "wrapKey");
                    }
                    throw jre;
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "wrapKey", "Hardware call to CSNDSYX not supported");
                }
                throw new JCECCARuntimeException(1, "CSNDSYX", "Hardware error from call CSNDSYX returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
            }
            case 12: {
                if (this.reasonCode.getValue() == 0 && "AES".equalsIgnoreCase(algorithm) && !allAES_supported) {
                    String ex_msg = "Hardware error from call CSNDSYX returnCode=" + this.returnCode.getValue() + " reasonCode=" + this.reasonCode.getValue() + ".\nThe current environment does not support AES  keys of this size and type SECURE_INTERNAL_TOKEN or CKDS.";
                    JCECCARuntimeException ike = new JCECCARuntimeException(1, "CSNDSYX", ex_msg, this.returnCode.getValue(), this.reasonCode.getValue());
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "wrapKey", ike);
                        debug.exit(Debug.TYPE_FINE, className, "wrapKey");
                    }
                    throw ike;
                }
                JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNDSYX", "Hardware error from call CSNDSYX returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "wrapKey", re);
                    debug.exit(Debug.TYPE_FINE, className, "wrapKey");
                }
                throw re;
            }
            default: {
                String Msg = "Hardware error from call CSNDSYX returnCode=" + this.returnCode.getValue() + " reasonCode=" + this.reasonCode.getValue() + ".";
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "wrapKey", Msg);
                }
                throw new JCECCARuntimeException(1, "CSNDSYX", Msg, this.returnCode.getValue(), this.reasonCode.getValue());
            }
        }
        if (encipheredKeyLength.getValue() == encipheredKey.length) {
            returnValue = encipheredKey;
        } else {
            returnValue = new byte[encipheredKeyLength.getValue()];
            System.arraycopy(encipheredKey, 0, returnValue, 0, encipheredKeyLength.getValue());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "wrapKey", returnValue);
        }
        return returnValue;
    }

    private byte[] wrapCKDSLabelClearKey(byte[] keyTokenOrLabel) {
        String exitDataString;
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(2);
        byte[] KeyTokenData = null;
        HexDumpEncoder encoder = null;
        this.returnCode = new hikmNativeInteger(0);
        this.reasonCode = new hikmNativeInteger(0);
        this.exitDataLength = new hikmNativeInteger(0);
        this.exitData = new byte[0];
        byte[] ruleArray = PlatformUtilities.getBytesPlatform("PKCS-1.2KEYIDENT");
        hikmNativeInteger KeyTokenLength = new hikmNativeInteger(keyTokenOrLabel.length);
        KeyTokenData = (byte[])keyTokenOrLabel.clone();
        byte[] pkaKeyId = (byte[])this.token.clone();
        hikmNativeInteger pkaKeyIdLength = new hikmNativeInteger(pkaKeyId.length);
        hikmNativeInteger dataStructureLength = new hikmNativeInteger(0);
        byte[] dataStructure = new byte[]{};
        this.pkaEncipheredKeyLength.setValue(this.pkaEncipheredkey.length);
        this.pkaEncipheredKeyBitLength.setValue(0);
        this.pkaEncipheredKeyBitLength.setValue(this.pkaEncipheredkey.length * 8);
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "wrapCKDSLabelClearKey");
            encoder = new HexDumpEncoder();
        }
        if (debug != null) {
            exitDataString = encoder.encodeBuffer(this.exitData);
            String ruleArrayString = encoder.encodeBuffer(ruleArray);
            String data = encoder.encodeBuffer(KeyTokenData);
            String tokenDataString = encoder.encodeBuffer(pkaKeyId);
            String parmsReport = "\nRSA: CSNDPKE INPUT PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    exitDataLen   : " + this.exitDataLength.getValue() + "\n    exitData      : \n" + exitDataString + "\n    ruleArrayCount: " + ruleArrayCount.getValue() + "\n    ruleArray     : \n" + ruleArrayString + "\n    dataLength    : " + KeyTokenLength.getValue() + "\n    data          : \n" + data + "\n    tokenLength  : " + pkaKeyIdLength.getValue() + "\n    tokenData     : \n" + tokenDataString + "\n    pkaEncipheredKeyLength  : " + this.pkaEncipheredKeyLength.getValue() + "\n";
            debug.text(Debug.TYPE_FINEST, className, "wrapCKDSLabelClearKey", parmsReport);
        }
        try {
            this.hikm.CSNDPKEJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, KeyTokenLength, KeyTokenData, dataStructureLength, dataStructure, pkaKeyIdLength, pkaKeyId, this.pkaEncipheredKeyLength, this.pkaEncipheredkey);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "wrapCKDSLabelClearKey", e);
                debug.text(Debug.TYPE_PUBLIC, className, "wrapCKDSLabelClearKey", "Hardware error from call CSNDPKE " + e);
                debug.exit(Debug.TYPE_FINE, className, "wrapCKDSLabelClearKey_2");
            }
            throw new RuntimeException("Hardware error from call CSNDPKE " + e);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "wrapCKDSLabelClearKey", "CSNDPKE Rtn = " + this.returnCode.getValue() + " reason " + this.reasonCode.getValue());
            exitDataString = encoder.encodeBuffer(this.exitData);
            String pkaEncipheredkeyString = encoder.encodeBuffer(this.pkaEncipheredkey);
            if (pkaEncipheredkeyString == null) {
                pkaEncipheredkeyString = "";
            }
            String parmsReport = "\nRSA: CSNDPKE RETURN PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    exitDataLen   : " + this.exitDataLength.getValue() + "\n    exitData      : \n" + exitDataString + "\n    pkaEncipheredKeyLength  : " + this.pkaEncipheredKeyLength.getValue() + "\n    pkaEncipheredkey     : \n" + pkaEncipheredkeyString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "wrapCKDSLabelClearKey", parmsReport);
        }
        if (this.returnCode.getValue() != 0) {
            if (debug != null) {
                debug.text(8192L, className, "wrapCKDSLabelClearKey", "Hardware error from call CSNDPKE returnCode " + this.returnCode.getValue() + " reasonCode" + this.reasonCode.getValue());
                debug.exit(Debug.TYPE_FINE, className, "wrapCKDSLabelClearKey_3");
            }
            throw new JCECCARuntimeException(1, "CSNKPKE", "Hardware error from call CSNDPKE returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
        }
        byte[] returnValue = new byte[this.pkaEncipheredKeyLength.getValue()];
        System.arraycopy(this.pkaEncipheredkey, 0, returnValue, 0, this.pkaEncipheredKeyLength.getValue());
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "wrapCKDSLabelClearKey_4", returnValue);
        }
        return returnValue;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        void var6_33;
        byte[] keyToken;
        String algorithm;
        block70: {
            algorithm = "";
            keyToken = null;
            if (debug != null) {
                Object[] objectArray = new Object[]{wrappedKey, wrappedKeyAlgorithm, new Integer(wrappedKeyType)};
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineUnwrap", objectArray);
            }
            if (3 != wrappedKeyType) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "Key unwrapping is not supported for the given key type.");
                    debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
                }
                throw new InvalidKeyException("Key unwrapping is not supported for the given key type.");
            }
            if ("DESede".equalsIgnoreCase(wrappedKeyAlgorithm) || "TripleDES".equalsIgnoreCase(wrappedKeyAlgorithm)) {
                if (this.genDESHWkeyToken) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "Unwrapping DESede ICSFToken key type");
                    }
                    algorithm = "DESede";
                    break block70;
                } else {
                    if (this.oaepSpec != null) {
                        if (this.ccaSpec == null) {
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "(1)The default type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys.");
                                debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
                            }
                            throw new RuntimeException(new InvalidAlgorithmParameterException("(1)The default type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys."));
                        }
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "(1)The requested returned type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys.");
                            debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
                        }
                        throw new RuntimeException(new InvalidAlgorithmParameterException("(1)The requested returned type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys."));
                    }
                    try {
                        void var6_10;
                        Object var6_7 = null;
                        if (Security.getProvider("IBMJCECCA") == null) {
                            String string = "IBMJCE4758";
                        } else {
                            String string = "IBMJCECCA";
                        }
                        Cipher ci = Cipher.getInstance("RSA/ /PKCS1Padding", (String)var6_10);
                        ci.init(2, this.privKey);
                        byte[] keybytes = ci.doFinal(wrappedKey);
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "Unwrapping DESede RAW key");
                        }
                        return new DESedeKey("RAW", keybytes);
                    }
                    catch (Exception exception) {
                        throw new InvalidKeyException("Error unwrapping DESede key.", exception);
                    }
                }
            }
            if ("DES".equalsIgnoreCase(wrappedKeyAlgorithm)) {
                if (this.genDESHWkeyToken) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "Unwrapping DES ICSFToken key type");
                    }
                    algorithm = "DES";
                    break block70;
                } else {
                    if (this.oaepSpec != null) {
                        if (this.ccaSpec == null) {
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "(2)The default type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys.");
                                debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
                            }
                            throw new RuntimeException(new InvalidAlgorithmParameterException("(2)The default type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys."));
                        }
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "(2)The requested returned type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys.");
                            debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
                        }
                        throw new RuntimeException(new InvalidAlgorithmParameterException("(2)The requested returned type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys."));
                    }
                    try {
                        void var6_15;
                        Object var6_12 = null;
                        if (Security.getProvider("IBMJCECCA") == null) {
                            String string = "IBMJCE4758";
                        } else {
                            String string = "IBMJCECCA";
                        }
                        Cipher ci = Cipher.getInstance("RSA/ /PKCS1Padding", (String)var6_15);
                        ci.init(2, this.privKey);
                        byte[] keybytes = ci.doFinal(wrappedKey);
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "Unwrapping DES RAW key");
                        }
                        return new DESKey("RAW", keybytes);
                    }
                    catch (Exception exception) {
                        throw new InvalidKeyException("Error unwrapping DES key.", exception);
                    }
                }
            }
            if ("AES".equalsIgnoreCase(wrappedKeyAlgorithm)) {
                if (this.genAESHWkeyToken) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "Unwrapping AES ICSFToken key type");
                    }
                    algorithm = "AES";
                    break block70;
                } else {
                    if (this.oaepSpec != null) {
                        if (this.ccaSpec == null) {
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "(3)The default type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys.");
                                debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
                            }
                            throw new RuntimeException(new InvalidAlgorithmParameterException("(3)The default type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys."));
                        }
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "(3)The requested returned type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys.");
                            debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
                        }
                        throw new RuntimeException(new InvalidAlgorithmParameterException("(3)The requested returned type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys."));
                    }
                    try {
                        void var6_20;
                        Object var6_17 = null;
                        if (Security.getProvider("IBMJCECCA") == null) {
                            String string = "IBMJCE4758";
                        } else {
                            String string = "IBMJCECCA";
                        }
                        Cipher ci = Cipher.getInstance("RSA/ /PKCS1Padding", (String)var6_20);
                        ci.init(2, this.privKey);
                        byte[] keybytes = ci.doFinal(wrappedKey);
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "Unwrapping AES RAW key");
                        }
                        return new AESKey(keybytes);
                    }
                    catch (Exception exception) {
                        throw new InvalidKeyException("Error unwrapping AES key.", exception);
                    }
                }
            }
            if ("TlsRsaPremasterSecret".equalsIgnoreCase(wrappedKeyAlgorithm)) {
                if (this.oaepSpec != null) {
                    if (this.ccaSpec == null) {
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "(4)The default type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys.");
                            debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
                        }
                        throw new RuntimeException(new InvalidAlgorithmParameterException("(4)The default type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys."));
                    }
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "(4)The requested returned type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys.");
                        debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
                    }
                    throw new RuntimeException(new InvalidAlgorithmParameterException("(4)The requested returned type for an unwrapped key is CLEAR. OAEP padding is not supported for CLEAR keys."));
                }
                try {
                    void var6_25;
                    Object var6_22 = null;
                    if (Security.getProvider("IBMJCECCA") == null) {
                        String string = "IBMJCE4758";
                    } else {
                        String string = "IBMJCECCA";
                    }
                    Cipher ci = Cipher.getInstance("RSA/ /PKCS1Padding", (String)var6_25);
                    ci.init(2, this.privKey);
                    byte[] keybytes = ci.doFinal(wrappedKey);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "Unwrapping TlsRsaPremasterSecret key type");
                    }
                    return new SecretKeySpec(keybytes, "TlsRsaPremasterSecret");
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Error unwrapping TlsRsaPremasterSecret key.", exception);
                }
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", "Key unwrapping is not supported for the given key algorithm.");
                debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
            }
            throw new InvalidKeyException("Key unwrapping is not supported for the given key algorithm.");
        }
        keyToken = this.unwrapKey(wrappedKey, algorithm);
        if ("DES".equals(algorithm)) {
            DESKey dESKey = new DESKey("ICSFToken", keyToken);
            if (this.storeInCKDS) {
                try {
                    String actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(dESKey, this.CKDSLabel);
                    DESKey dESKey2 = DESKey.newLabelKey(actualLabel);
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ex);
                        debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
                    }
                    throw new RuntimeException("Error storing DES key " + this.CKDSLabel + " in the CKDS. " + ex.getMessage(), ex);
                }
            }
        } else if ("DESede".equals(algorithm)) {
            DESedeKey dESedeKey = new DESedeKey("ICSFToken", keyToken);
            if (this.storeInCKDS) {
                try {
                    String actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(dESedeKey, this.CKDSLabel);
                    DESedeKey dESedeKey2 = DESedeKey.newLabelKey(actualLabel);
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ex);
                        debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
                    }
                    throw new RuntimeException("Error storing DESede key " + this.CKDSLabel + " in the CKDS. " + ex.getMessage(), ex);
                }
            }
        } else {
            AESKey aESKey = new AESKey("ICSFToken", keyToken);
            aESKey.setCanBeStored(this.canBeStored);
            this.canBeStored = true;
            if (this.storeInCKDS) {
                try {
                    String actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(aESKey, this.CKDSLabel);
                    AESKey aESKey2 = AESKey.newLabelKey(actualLabel);
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ex);
                        debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
                    }
                    throw new RuntimeException("Error storing AES key " + this.CKDSLabel + " in the CKDS. " + ex.getMessage(), ex);
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineUnwrap", var6_33);
        }
        return var6_33;
    }

    private byte[] unwrapKey(byte[] keyToken, String algorithm) {
        byte[] rsaPrivateId;
        hikmNativeInteger rsaPrivateIdLen;
        HexDumpEncoder encoder = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "unwrapKey", (Object)keyToken);
            encoder = new HexDumpEncoder();
        }
        boolean allAES_supported = false;
        if ("AES".equalsIgnoreCase(algorithm)) {
            if (HardwareProfile.getIsAES128CryptoAssistPresent() && HardwareProfile.getIsAES192CryptoAssistPresent() && HardwareProfile.getIsAES256CryptoAssistPresent()) {
                allAES_supported = true;
            }
            if (this.keyTokenWrapMode != 10) {
                RuntimeException e = new RuntimeException("Only the WRAPPING_MODE_DEFAULT wrapping mode can be used when unwrapping an AES key.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "unwrapKey", e);
                    debug.exit(Debug.TYPE_FINE, className, "unwrapKey");
                }
                throw e;
            }
        }
        this.returnCode = new hikmNativeInteger(0);
        this.reasonCode = new hikmNativeInteger(0);
        this.exitDataLength = new hikmNativeInteger(0);
        this.exitData = new byte[0];
        String ruleText = null;
        int ruleArrayNum = 0;
        if (this.oaepSpec != null) {
            ruleText = "DES".equals(algorithm) || "DESede".equals(algorithm) ? "DES     " : "AES     ";
            if (this.oaepHash.equals("SHA-1")) {
                ruleText = ruleText + "PKCSOAEPSHA-1   ";
            } else if (this.oaepHash.equals("SHA-256")) {
                ruleText = ruleText + "PKCSOAEPSHA-256 ";
            } else {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "unwrapKey", "Invalid Padding: " + this.oaepHash);
                    debug.exit(Debug.TYPE_FINE, className, "unwrapKey");
                }
                throw new RuntimeException("Invalid Padding: " + this.oaepHash);
            }
            ruleArrayNum = 3;
        } else if ("DES".equals(algorithm) || "DESede".equals(algorithm)) {
            ruleText = "PKCS-1.2";
            ruleArrayNum = 1;
        } else {
            ruleText = "AES     PKCS-1.2";
            ruleArrayNum = 2;
        }
        if (this.keyTokenWrapMode != 10) {
            if (this.keyTokenWrapMode == 12) {
                ruleText = ruleText + "WRAP-ENH";
                ++ruleArrayNum;
            } else if (this.keyTokenWrapMode == 11) {
                ruleText = ruleText + "WRAP-ECB";
                ++ruleArrayNum;
            } else {
                RuntimeException e = new RuntimeException("Unrecognized token wrapping mode.");
                if (null != debug) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "unwrapKey", e);
                    debug.exit(Debug.TYPE_FINE, className, "unwrapKey");
                }
                throw e;
            }
        }
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(ruleArrayNum);
        byte[] ruleArray = PlatformUtilities.getBytesPlatform(ruleText);
        if (null != this.token && 0 < this.token.length) {
            rsaPrivateIdLen = new hikmNativeInteger(this.token.length);
            rsaPrivateId = (byte[])this.token.clone();
            if (PlatformUtilities.isZOS()) {
                rsaPrivateId = PlatformUtilities.convertBytesIfKeyLabelATOE(rsaPrivateId);
            }
        } else {
            rsaPrivateIdLen = new hikmNativeInteger(this.externalToken.length);
            rsaPrivateId = (byte[])this.externalToken.clone();
            if (PlatformUtilities.isZOS()) {
                rsaPrivateId = PlatformUtilities.convertBytesIfKeyLabelATOE(rsaPrivateId);
            }
        }
        hikmNativeInteger encryptedKeyLen = new hikmNativeInteger(keyToken.length);
        byte[] encryptedKey = (byte[])keyToken.clone();
        hikmNativeInteger targetKeyIdLength = new hikmNativeInteger(64);
        byte[] targetKeyId = new byte[64];
        boolean z31Bit = false;
        boolean z64Bit = false;
        if (HardwareProfile.getIs64Bit()) {
            z64Bit = true;
        } else {
            z31Bit = true;
        }
        if (debug != null) {
            String osReport = "\n    64 Bit        : " + HardwareProfile.getIs64Bit() + "\n    HCR7770 plus  : " + HardwareProfile.getIsHCR7770OrLaterPresent() + "\n";
            debug.text(Debug.TYPE_FINE, className, "unwrapKey", osReport);
        }
        if (z31Bit || z64Bit && HardwareProfile.getIsHCR7770OrLaterPresent()) {
            String exitDataString;
            if (debug != null) {
                exitDataString = encoder.encodeBuffer(this.exitData);
                String ruleArrayString = encoder.encodeBuffer(ruleArray);
                String encryptedKeyString = encoder.encodeBuffer(encryptedKey);
                String rsaPrivateIdString = encoder.encodeBuffer(rsaPrivateId);
                String parmsReport = "\nRSA: CSNDSYI INPUT PARAMETERS: \n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    ruleArrayCount : " + ruleArrayCount.getValue() + "\n    ruleArray      : " + ruleArrayString + "\n    encryptedKeyLen: " + encryptedKeyLen.getValue() + "\n    encryptedKey   : \n" + encryptedKeyString + "\n    rsaPrivateIdLen: " + rsaPrivateIdLen.getValue() + "\n    rsaPrivateId   : \n" + rsaPrivateIdString + "\n    targetKeyIdLen : " + targetKeyIdLength.getValue() + "\n";
                debug.text(Debug.TYPE_FINEST, className, "unwrapKey", parmsReport);
            }
            try {
                this.hikm.CSNDSYIJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, encryptedKeyLen, encryptedKey, rsaPrivateIdLen, rsaPrivateId, targetKeyIdLength, targetKeyId);
            }
            catch (IllegalArgumentException e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "unwrapKey", e);
                    debug.text(Debug.TYPE_PUBLIC, className, "unwrapKey", "Hardware error from call CSNDSYI " + e);
                    debug.exit(Debug.TYPE_FINE, className, "unwrapKey");
                }
                throw new RuntimeException("Hardware error from call CSNDSYI " + e);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "unwrapKey", "CSNDSYI: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
            }
            if (debug != null) {
                exitDataString = encoder.encodeBuffer(this.exitData);
                String targetKeyIdString = encoder.encodeBuffer(targetKeyId);
                String parmsReport = "\nRSA: CSNDSYI RETURN PARAMETERS: \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    targetKeyIdLen : " + targetKeyIdLength.getValue() + "\n    targetKeyId    : \n" + targetKeyIdString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "unwrapKey", parmsReport);
            }
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "wrapKey", "Hardware call to CSNDSYI not supported");
            }
            throw new IllegalArgumentException("System Error: Key unwrapping is not supported in AMODE(64).");
        }
        int current_retCode = this.returnCode.getValue();
        switch (current_retCode) {
            case 0: {
                if (debug == null) break;
                debug.text(Debug.TYPE_PUBLIC, className, "unwrapKey", "Good return code from CSNDSYI. Key unwrapped.");
                break;
            }
            case 8: {
                if (this.reasonCode.getValue() == 2093) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "unwrapKey", "Expected error from ICSF key unwrapping call using CSNDSYI returnCode=" + this.returnCode.getValue() + " reasonCode=" + this.reasonCode.getValue());
                    }
                    this.canBeStored = false;
                    break;
                }
                if (this.reasonCode.getValue() == 72 && this.oaepSpec != null && algorithm.equals("AES")) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "unwrapKey", "CSNDSYI return/reason code 8/72. Retry RSA OAEP with PKOAEP2 formatting method");
                    }
                    targetKeyId = SymmetricKeyUtils.symmetricKeyImport2(2, "AES     PKOAEP2 ", keyToken, rsaPrivateId);
                    targetKeyIdLength.setValue(targetKeyId.length);
                    break;
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "unwrapKey", "Hardware call to CSNDSYI not supported");
                }
                throw new JCECCARuntimeException(1, "CSNDSYI", "Hardware error from call CSNDSYI returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
            }
            case 12: {
                if (this.reasonCode.getValue() == 0 && "AES".equalsIgnoreCase(algorithm) && !allAES_supported) {
                    String ex_msg = "Hardware error from call CSNDSYI returnCode=" + this.returnCode.getValue() + " reasonCode=" + this.reasonCode.getValue() + ".\nThe current environment does not support  AES keys of this size and type SECURE_INTERNAL_TOKEN or CKDS.";
                    JCECCARuntimeException ike = new JCECCARuntimeException(1, "CSNDSYI", ex_msg, this.returnCode.getValue(), this.reasonCode.getValue());
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "unwrapKey", ike);
                        debug.exit(Debug.TYPE_FINE, className, "unwrapKey");
                    }
                    throw ike;
                }
                JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNDSYI", "Hardware error from call CSNDSYI returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "unwrapKey", re);
                    debug.exit(Debug.TYPE_FINE, className, "unwrapKey");
                }
                throw re;
            }
            default: {
                String Msg = "Hardware error from call CSNDSYI returnCode=" + this.returnCode.getValue() + " reasonCode=" + this.reasonCode.getValue() + ".";
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "wrapKey", Msg);
                }
                throw new JCECCARuntimeException(1, "CSNDSYI", Msg, this.returnCode.getValue(), this.reasonCode.getValue());
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "unwrapKey", targetKeyId);
        }
        return targetKeyId;
    }
}

