/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class RACFResults {
    private byte[] resultsBytes = null;
    private byte[] useridBytes = null;
    private byte[] aliasBytes = null;
    private static final int functionNewRing = 7;
    private static final int functionDataPut = 8;
    private static final int functionDataRemove = 9;
    private static final int functionDataRefresh = 11;
    private static Debug debug = Debug.getInstance("ibmjceracf");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.RACFResults";

    public RACFResults() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "RACFResults");
            debug.exit(Debug.TYPE_PUBLIC, className, "RACFResults");
        }
    }

    public void checkResults() throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "checkResults");
        }
        if (this.resultsBytes == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "checkResults", "results bytes == null");
                debug.exit(Debug.TYPE_PUBLIC, className, "checkResults");
            }
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.resultsBytes);
        DataInputStream dos = new DataInputStream(bais);
        int functionCode = 0;
        int safReturnCode = 0;
        int racfReturnCode = 0;
        int racfReasonCode = 0;
        try {
            functionCode = dos.readInt();
            safReturnCode = dos.readInt();
            racfReturnCode = dos.readInt();
            racfReasonCode = dos.readInt();
            dos.close();
        }
        catch (IOException ioe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "checkResults", ioe);
            }
            throw new IOException("Exception caught while parsing RACF results: " + ioe.getMessage());
        }
        if (safReturnCode == 0 && racfReturnCode == 0 && racfReasonCode == 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "checkResults", "All Return codes = 0");
                debug.exit(Debug.TYPE_PUBLIC, className, "checkResults");
            }
            return;
        }
        String rcs = "(" + safReturnCode + ", " + racfReturnCode + ", " + racfReasonCode + ")";
        String userid = RACFResults.zByteArrayToString(this.useridBytes);
        String alias = RACFResults.zByteArrayToString(this.aliasBytes);
        String useridtext = userid == null ? "" : " Userid: (" + userid + ")";
        String aliastext = alias == null ? "" : " Alias: (" + alias + ")";
        String message = null;
        String update_message = new String("One or more updates could not be completed. ");
        if (safReturnCode == 4 && racfReturnCode == 0 && racfReasonCode == 0) {
            message = new String("RACF is not installed.");
        } else if (safReturnCode == 8 && racfReturnCode == 8) {
            switch (racfReasonCode) {
                case 4: {
                    message = new String("Parameter list error occurred.");
                    break;
                }
                case 8: {
                    message = new String("Not RACF authorized to use the requested service.");
                    break;
                }
                case 12: {
                    message = new String("Internal error caused recovery to get control.");
                    break;
                }
                case 16: {
                    message = new String("Unable to establish a recovery environment.");
                    break;
                }
                case 20: {
                    message = new String("Requested Function_code not defined.");
                    break;
                }
                case 24: {
                    message = new String("Parm_list version number not supported.");
                    break;
                }
                case 28: {
                    message = new String("Error in Ring_name length or RACF_userid length.");
                    break;
                }
                case 72: {
                    message = new String("Caller not in task mode.");
                }
            }
        }
        block11 : switch (functionCode) {
            case 7: {
                if (safReturnCode != 8 || racfReturnCode != 8) break;
                switch (racfReasonCode) {
                    case 32: {
                        message = new String("Profile for Ring_name not found for REUSE.");
                        break;
                    }
                    case 36: {
                        message = new String("Profile for Ring_name already exists and REUSE was not specified.");
                        break;
                    }
                    case 40: {
                        message = new String("Invalid Ring_name.");
                        break;
                    }
                    case 44: {
                        message = new String("RACF_userid invalid or not found.");
                    }
                }
                break;
            }
            case 8: {
                if (safReturnCode == 4 && racfReturnCode == 4) {
                    switch (racfReasonCode) {
                        case 0: {
                            message = new String("Success but Certificate status is NOTRUST.");
                            break;
                        }
                        case 4: {
                            message = new String("Success but DIGTCERT class needs SETROPTS RACLIST REFRESH.");
                            break;
                        }
                        case 8: {
                            message = new String("Success but the Label information is ignored since the certificate already exists in RACF.");
                            break;
                        }
                        case 12: {
                            message = new String("Success but the Label information is ignored since the certificate already exists in RACF. The certificate is added NOTRUST.");
                            break;
                        }
                        case 16: {
                            message = new String("Success but the Label information is ignored since the certificate already exists in RACF. The DIGTCERT class needs to refresh to reflect the update.");
                        }
                    }
                    break;
                }
                if (safReturnCode != 8 || racfReturnCode != 8) break;
                switch (racfReasonCode) {
                    case 32: {
                        message = new String("Parameter error.");
                        break;
                    }
                    case 36: {
                        message = new String("Unable to decode certificate.");
                        break;
                    }
                    case 40: {
                        message = new String("Private key is neither of a DER encoded format nor a key label format.");
                        break;
                    }
                    case 44: {
                        message = new String("Bad encoding of private key or unsupported algorithm or key size invalid.");
                        break;
                    }
                    case 48: {
                        message = new String("Specified private key does not match the existing one.");
                        break;
                    }
                    case 52: {
                        message = new String("Can not find the ICSF key label.");
                        break;
                    }
                    case 56: {
                        message = new String("ICSF error when trying to locate the key label.");
                        break;
                    }
                    case 60: {
                        message = new String("Not authorized to access ICSF key entry.");
                        break;
                    }
                    case 64: {
                        message = new String("Certificate label specified already exists in RACF.");
                        break;
                    }
                    case 68: {
                        message = new String("User ID specified does not exist in RACF.");
                        break;
                    }
                    case 76: {
                        message = new String("Certificate uninstallable.");
                        break;
                    }
                    case 80: {
                        message = new String("Certificate exists under a different user.");
                        break;
                    }
                    case 84: {
                        message = new String("Profile for Ring_name not found.");
                        break;
                    }
                    case 92: {
                        message = new String("Internal Error.");
                    }
                }
                break;
            }
            case 11: {
                update_message = new String("Updates were successful but REFRESH of the DIGTCERT class failed. RACLISTed profiles will not reflect the updates until SETROPTS RACLIST(DIGTCERT) REFRESH is issued. ");
                if (safReturnCode != 4 || racfReturnCode != 4 || racfReturnCode != 0) break;
                message = new String("Refresh not needed.");
                break;
            }
            case 9: {
                if (safReturnCode == 4 && racfReturnCode == 4) {
                    switch (racfReasonCode) {
                        case 0: {
                            message = new String("Success but cannot delete certificate from RACF since it is connected to other rings.");
                            break;
                        }
                        case 4: {
                            message = new String("Success but cannot delete certificate from RACF due to unexpected error.");
                            break;
                        }
                        case 8: {
                            message = new String("Success but cannot delete certificate from RACF due to insufficient authority.");
                            break;
                        }
                        case 12: {
                            message = new String("Success but DIGTCERT class needs to refresh to reflect the update.");
                        }
                    }
                    break;
                }
                if (safReturnCode != 8 || racfReturnCode != 8) break;
                switch (racfReasonCode) {
                    case 32: {
                        message = new String("Parameter error.");
                        break block11;
                    }
                    case 36: {
                        message = new String("Can not find the certificate with the specified label and owner ID.");
                        break block11;
                    }
                    case 40: {
                        message = new String("Profile for Ring_name not found.");
                    }
                }
            }
        }
        if (message == null) {
            message = new String("Unknown error.");
        }
        String exceptionText = new String("R_datalib (IRRSDL00) error: " + update_message + message + " Function code: (" + functionCode + ")" + aliastext + useridtext + " Return Codes: " + rcs);
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "checkResults", exceptionText);
            debug.exit(Debug.TYPE_PUBLIC, className, "checkResults");
        }
        throw new IOException(exceptionText);
    }

    public static String zByteArrayToString(byte[] inBytes) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "zByteArrayToString");
        }
        String outString = null;
        if (inBytes == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "zByteArrayToString", "inBytes is null");
                debug.exit(Debug.TYPE_PUBLIC, className, "zByteArrayToString");
            }
            return null;
        }
        outString = new String(inBytes, PlatformUtilities.CHARSET_IBM_1047);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "zByteArrayToString", outString);
        }
        return outString;
    }
}

