/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.LabelUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

class PlatformUtilities {
    private static boolean isLinux = System.getProperty("os.name").equals("Linux");
    private static boolean isZOS = System.getProperty("os.name").equals("z/OS");
    protected static final Charset CHARSET_ISO_8859_1 = StandardCharsets.ISO_8859_1;
    protected static final Charset CHARSET_IBM_1047 = Charset.forName("IBM-1047");
    protected static final Charset CHARSET_UTF8 = StandardCharsets.UTF_8;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PlatformUtilities";

    PlatformUtilities() {
    }

    protected static boolean isLinux() {
        return isLinux;
    }

    protected static boolean isZOS() {
        return isZOS;
    }

    protected static byte[] getBytesPlatform(String str) {
        byte[] bytesPlatform;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getBytesPlatform", str);
        }
        if (isZOS) {
            bytesPlatform = str.getBytes(CHARSET_IBM_1047);
        } else if (isLinux) {
            bytesPlatform = str.getBytes(CHARSET_ISO_8859_1);
        } else {
            RuntimeException rte = new RuntimeException("Unable to convert string to platform bytes. Execution platform is not linux or zos.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getBytesPlatform", rte);
                debug.exit(Debug.TYPE_PUBLIC, className, "getBytesPlatform");
            }
            throw rte;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getBytesPlatform", bytesPlatform);
        }
        return bytesPlatform;
    }

    protected static String getString(byte[] bytesPlatform) {
        String str;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getString", (Object)bytesPlatform);
        }
        if (isZOS) {
            str = new String(bytesPlatform, CHARSET_IBM_1047);
        } else if (isLinux) {
            str = new String(bytesPlatform, CHARSET_ISO_8859_1);
        } else {
            RuntimeException rte = new RuntimeException("Unable to convert platform bytes to string. Execution platform is not linux or zos.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getString", rte);
                debug.exit(Debug.TYPE_PUBLIC, className, "getString");
            }
            throw rte;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getString", str);
        }
        return str;
    }

    protected static byte[] convertBytesATOE(byte[] bytes) {
        return PlatformUtilities.convertBytes(bytes, CHARSET_ISO_8859_1, CHARSET_IBM_1047);
    }

    protected static byte[] convertBytesETOA(byte[] bytes) {
        return PlatformUtilities.convertBytes(bytes, CHARSET_IBM_1047, CHARSET_ISO_8859_1);
    }

    private static byte[] convertBytes(byte[] sourceBytes, Charset sourceEncoding, Charset destinationEncoding) {
        if (debug != null) {
            Object[] parms = new Object[]{sourceBytes, sourceEncoding.displayName(), destinationEncoding.displayName()};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "convertBytes", parms);
        }
        if (sourceBytes == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "convertBytes", "sourceBytes is null, returning null.");
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "convertBytes", sourceBytes);
            }
            return sourceBytes;
        }
        String stringRepresentation = new String(sourceBytes, sourceEncoding);
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "convertBytes", "string representation=[" + stringRepresentation + "]");
        }
        byte[] destinationBytes = stringRepresentation.getBytes(destinationEncoding);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "convertBytes", destinationBytes);
        }
        return destinationBytes;
    }

    protected static byte[] convertBytesIfKeyLabelETOA(byte[] bytes) {
        return PlatformUtilities.convertBytesIfKeyLabel(bytes, CHARSET_IBM_1047, CHARSET_ISO_8859_1);
    }

    protected static byte[] convertBytesIfKeyLabelATOE(byte[] bytes) {
        return PlatformUtilities.convertBytesIfKeyLabel(bytes, CHARSET_ISO_8859_1, CHARSET_IBM_1047);
    }

    private static byte[] convertBytesIfKeyLabel(byte[] sourceBytes, Charset sourceEncoding, Charset destinationEncoding) {
        if (debug != null) {
            Object[] parms = new Object[]{sourceBytes, sourceEncoding.displayName(), destinationEncoding.displayName()};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getBytesKeyLabel", parms);
        }
        if (!LabelUtils.isLabel(sourceBytes, sourceEncoding)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getBytesKeyLabel", "This is not a label.");
            }
            return sourceBytes;
        }
        byte[] destinationBytes = PlatformUtilities.convertBytes(sourceBytes, sourceEncoding, destinationEncoding);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getBytesKeyLabel", destinationBytes);
        }
        return destinationBytes;
    }
}

