/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public final class PSSParameters
extends AlgorithmParametersSpi {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.RSAPSSSignature";
    protected AlgorithmId hashAlgorithm;
    protected AlgorithmId maskGenAlgorithm;
    protected AlgorithmParameterSpec mgfParameterSpec;
    protected int saltLength;
    protected int trailerField;
    private PSSParameterSpec spec;
    byte TAG0 = DerValue.createTag((byte)-128, (boolean)true, (byte)0);
    byte TAG1 = DerValue.createTag((byte)-128, (boolean)true, (byte)1);
    byte TAG2 = DerValue.createTag((byte)-128, (boolean)true, (byte)2);
    byte TAG3 = DerValue.createTag((byte)-128, (boolean)true, (byte)3);

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", paramSpec);
        }
        if (!(paramSpec instanceof PSSParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        PSSParameterSpec spec = (PSSParameterSpec)paramSpec;
        String mgfName = spec.getMGFAlgorithm();
        if (!spec.getMGFAlgorithm().equalsIgnoreCase("MGF1")) {
            throw new InvalidParameterSpecException("Unsupported mgf " + mgfName + "; MGF1 only");
        }
        AlgorithmParameterSpec mgfSpec = spec.getMGFParameters();
        if (!(mgfSpec instanceof MGF1ParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate mgf parameters; non-null MGF1ParameterSpec only");
        }
        try {
            this.hashAlgorithm = AlgorithmId.get((String)spec.getDigestAlgorithm());
            this.maskGenAlgorithm = AlgorithmId.get((String)spec.getMGFAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidParameterSpecException(e.toString());
        }
        this.mgfParameterSpec = ((PSSParameterSpec)paramSpec).getMGFParameters();
        this.saltLength = ((PSSParameterSpec)paramSpec).getSaltLength();
        this.trailerField = ((PSSParameterSpec)paramSpec).getTrailerField();
        this.spec = spec;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", (Object)params);
        }
        this.spec = this.decodePSSParameters(params);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{params, format};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        if (format != null && !format.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        this.engineInit(params);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetEncoded");
        }
        DerOutputStream out = new DerOutputStream();
        String hashAlgName = this.hashAlgorithm.getName();
        String defaultHashAlgName = null;
        try {
            defaultHashAlgName = AlgorithmId.get((String)PSSParameterSpec.DEFAULT.getDigestAlgorithm()).getName();
        }
        catch (NoSuchAlgorithmException nsae) {
            defaultHashAlgName = null;
        }
        if (!hashAlgName.equalsIgnoreCase(defaultHashAlgName)) {
            DerValue derValueHash = this.encodeHashAlg(this.hashAlgorithm);
            out.putDerValue(derValueHash);
        }
        if (!this.maskGenAlgorithm.getName().equalsIgnoreCase(PSSParameterSpec.DEFAULT.getMGFAlgorithm())) {
            DerValue derValueMaskGen = this.encodeMaskGenAlg(this.maskGenAlgorithm, this.mgfParameterSpec);
            out.putDerValue(derValueMaskGen);
        } else if (this.mgfParameterSpec != null) {
            String mgf1DigestAlgName = ((MGF1ParameterSpec)this.mgfParameterSpec).getDigestAlgorithm();
            String normDigestAlgName = null;
            AlgorithmParameterSpec defaultAlgParamSpec = PSSParameterSpec.DEFAULT.getMGFParameters();
            String defaultMGFDigest = null;
            try {
                normDigestAlgName = AlgorithmId.get((String)mgf1DigestAlgName).getName();
                defaultMGFDigest = AlgorithmId.get((String)((MGF1ParameterSpec)defaultAlgParamSpec).getDigestAlgorithm()).getName();
            }
            catch (NoSuchAlgorithmException e) {
                out.close();
                throw new IOException("NoSuchAlgorithmException during encoding operations.");
            }
            if (normDigestAlgName != null && !normDigestAlgName.equalsIgnoreCase(defaultMGFDigest)) {
                DerValue derValueMaskGen = this.encodeMaskGenAlg(this.maskGenAlgorithm, this.mgfParameterSpec);
                out.putDerValue(derValueMaskGen);
            }
        }
        if (this.saltLength != PSSParameterSpec.DEFAULT.getSaltLength()) {
            DerValue derValueSalt = this.encodeSalt(this.saltLength);
            out.putDerValue(derValueSalt);
        }
        if (this.trailerField != PSSParameterSpec.DEFAULT.getTrailerField()) {
            DerValue derValueTrailerField = this.encodeTrailerField(this.trailerField);
            out.putDerValue(derValueTrailerField);
        }
        DerValue val = new DerValue(48, out.toByteArray());
        byte[] encodedPSSParameters = val.toByteArray();
        out.close();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", encodedPSSParameters);
        }
        return encodedPSSParameters;
    }

    protected DerValue encodeSalt(int salt) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "encodeSalt", salt);
        }
        try {
            DerOutputStream out = new DerOutputStream();
            byte tag = DerValue.createTag((byte)-128, (boolean)true, (byte)2);
            out.putInteger(this.saltLength);
            DerValue val = new DerValue(tag, out.toByteArray());
            out.close();
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "encodeSalt", val);
            }
            return val;
        }
        catch (IOException e) {
            throw new IOException("Exception in hashAlgorithm(): " + e);
        }
    }

    protected DerValue encodeTrailerField(int trailerField) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "encodeTrailerField", trailerField);
        }
        try {
            DerOutputStream out = new DerOutputStream();
            byte tag = DerValue.createTag((byte)-128, (boolean)true, (byte)3);
            out.putInteger(trailerField);
            DerValue val = new DerValue(tag, out.toByteArray());
            out.close();
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "encodeTrailerField", val);
            }
            return val;
        }
        catch (IOException e) {
            throw new IOException("Exception in hashAlgorithm(): " + e);
        }
    }

    protected DerValue encodeHashAlg(AlgorithmId hashAlgorithm) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "encodeHashAlg", hashAlgorithm);
        }
        try {
            DerOutputStream out = new DerOutputStream();
            out.putOID(hashAlgorithm.getOID());
            out.putNull();
            DerValue val1 = new DerValue(48, out.toByteArray());
            out.close();
            DerOutputStream out1 = new DerOutputStream();
            out1.putDerValue(val1);
            byte tag = DerValue.createTag((byte)-128, (boolean)true, (byte)0);
            DerValue val = new DerValue(tag, out1.toByteArray());
            out1.close();
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "encodeHashAlg", val);
            }
            return val;
        }
        catch (IOException e) {
            throw new IOException("Exception in hashAlgorithm(): " + e);
        }
    }

    private AlgorithmId decodeHashAlgorithm(DerValue encodedHashAlg) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "decodeHashAlgorithm", encodedHashAlg);
        }
        try {
            if (encodedHashAlg.getTag() != this.TAG0) {
                throw new IOException("Not a TAG0 encoding");
            }
            DerInputStream data1 = encodedHashAlg.getData();
            DerValue derValue1 = data1.getDerValue();
            DerInputStream data = derValue1.getData();
            ObjectIdentifier hashOID = data.getOID();
            AlgorithmId hashAlgID = new AlgorithmId(hashOID);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "decodeHashAlgorithm", hashAlgID);
            }
            return hashAlgID;
        }
        catch (IOException e) {
            throw new IOException("Exception in decodeHashAlgorithm (): " + e);
        }
    }

    private int decodeSaltLength(DerValue encodedSaltLength) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "decodeSaltLength", encodedSaltLength);
        }
        try {
            if (encodedSaltLength.getTag() != this.TAG2) {
                throw new IOException("Not a TAG2 encoding");
            }
            DerInputStream data = encodedSaltLength.getData();
            int saltLength = data.getInteger().intValue();
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "decodeSaltLength", (Object)saltLength);
            }
            return saltLength;
        }
        catch (IOException e) {
            throw new IOException("Exception in decodeSaltLength (): " + e);
        }
    }

    private int decodeTrailerField(DerValue encodedTrailerField) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "decodeTrailerField", encodedTrailerField);
        }
        try {
            if (encodedTrailerField.getTag() != this.TAG3) {
                throw new IOException("Not a TAG3 encoding for trailerField");
            }
            DerInputStream data = encodedTrailerField.getData();
            int trailerField = data.getInteger().intValue();
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "decodeTrailerField", (Object)trailerField);
            }
            return trailerField;
        }
        catch (IOException e) {
            throw new IOException("Exception in decodeTrailerField (): " + e);
        }
    }

    protected DerValue encodeMaskGenAlg(AlgorithmId maskGenAlgorithm, AlgorithmParameterSpec mgf1ParameterSpec) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{maskGenAlgorithm, mgf1ParameterSpec};
            debug.entry(Debug.TYPE_FINE, (Object)className, "encodeMaskGenAlg", parms);
        }
        try {
            DerOutputStream out = new DerOutputStream();
            out.putOID(maskGenAlgorithm.getOID());
            if (this.mgfParameterSpec != null) {
                DerValue mgfDigest = this.encodeMgfParameterSpec(this.mgfParameterSpec);
                out.putDerValue(mgfDigest);
            }
            out.close();
            DerValue val1 = new DerValue(48, out.toByteArray());
            DerOutputStream out1 = new DerOutputStream();
            out1.putDerValue(val1);
            byte tag = DerValue.createTag((byte)-128, (boolean)true, (byte)1);
            DerValue val = new DerValue(tag, out1.toByteArray());
            out1.close();
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "encodeMaskGenAlg", val);
            }
            return val;
        }
        catch (IOException e) {
            throw new IOException("Exception in MGF1Parameters: " + e);
        }
    }

    protected DerValue encodeMgfParameterSpec(AlgorithmParameterSpec mgfParameterSpec) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "encodeMgfParameterSpec", mgfParameterSpec);
        }
        try {
            DerOutputStream out = new DerOutputStream();
            String mgfDigestName = ((MGF1ParameterSpec)mgfParameterSpec).getDigestAlgorithm();
            out.putOID(AlgorithmId.get((String)mgfDigestName).getOID());
            out.putNull();
            DerValue val = new DerValue(48, out.toByteArray());
            out.close();
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "encodeMgfParameterSpec", val);
            }
            return val;
        }
        catch (IOException e) {
            throw new IOException("Exception in encodeMGfParameterSpec(): " + e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Exception in encodeMGfParameterSpec(): " + e);
        }
    }

    private PSSParameterSpec decodePSSParameters(byte[] encodedPSSParameters) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "decodePSSParameters", (Object)encodedPSSParameters);
        }
        try {
            DerInputStream derInputStreamParams = new DerInputStream(encodedPSSParameters);
            DerValue[] values = derInputStreamParams.getSequence(0);
            if (values == null) {
                return null;
            }
            try {
                this.hashAlgorithm = AlgorithmId.get((String)PSSParameterSpec.DEFAULT.getDigestAlgorithm());
            }
            catch (NoSuchAlgorithmException e1) {
                throw new IOException("NoSuchAlgorithmException during decoding operations.");
            }
            try {
                this.maskGenAlgorithm = AlgorithmId.get((String)PSSParameterSpec.DEFAULT.getMGFAlgorithm());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("NoSuchAlgorithmException during decoding operations.");
            }
            this.mgfParameterSpec = PSSParameterSpec.DEFAULT.getMGFParameters();
            this.saltLength = PSSParameterSpec.DEFAULT.getSaltLength();
            this.trailerField = PSSParameterSpec.DEFAULT.getTrailerField();
            for (int i = 0; i < values.length; ++i) {
                byte tag = values[i].getTag();
                if (tag == this.TAG0) {
                    this.hashAlgorithm = this.decodeHashAlgorithm(values[i]);
                    continue;
                }
                if (tag == this.TAG1) {
                    this.maskGenAlgorithm = this.decodeMaskGenAlgorithm(values[i]);
                    continue;
                }
                if (tag == this.TAG2) {
                    this.saltLength = this.decodeSaltLength(values[i]);
                    continue;
                }
                if (tag == this.TAG3) {
                    this.trailerField = this.decodeTrailerField(values[i]);
                    continue;
                }
                throw new IOException("Unknown tag in the asn.1 encoding" + tag);
            }
            PSSParameterSpec pssParameterSpec = new PSSParameterSpec(this.hashAlgorithm.getName(), this.maskGenAlgorithm.getName(), this.mgfParameterSpec, this.saltLength, this.trailerField);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "decodePSSParameters", pssParameterSpec);
            }
            return pssParameterSpec;
        }
        catch (IOException e) {
            throw new IOException("Exception in decodePSSParameters(): " + e);
        }
    }

    private AlgorithmId decodeMaskGenAlgorithm(DerValue encodedMaskGenAlg) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "decodeMaskGenAlgorithm", encodedMaskGenAlg);
        }
        try {
            DerInputStream data1 = encodedMaskGenAlg.getData();
            DerValue derValue1 = data1.getDerValue();
            if (derValue1.getTag() != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = derValue1.getData();
            ObjectIdentifier maskGenOID = data.getOID();
            AlgorithmId maskGenAlgID = new AlgorithmId(maskGenOID);
            if (data.available() <= 0) {
                throw new IOException("Missing MGF1 parameters");
            }
            DerValue encodedMGF1Parameters = data.getDerValue();
            this.mgfParameterSpec = this.decodeMGF1ParameterSpec(encodedMGF1Parameters);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "decodeMaskGenAlgorithm", maskGenAlgID);
            }
            return maskGenAlgID;
        }
        catch (IOException e) {
            throw new IOException("Exception in decodeMaskGenAlgorithm (): " + e);
        }
    }

    private AlgorithmParameterSpec decodeMGF1ParameterSpec(DerValue encodedMGF1Parameters) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "decodeMGF1ParameterSpec", encodedMGF1Parameters);
        }
        try {
            if (encodedMGF1Parameters.getTag() != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = encodedMGF1Parameters.getData();
            ObjectIdentifier mgf1DigestOID = data.getOID();
            String mgf1DigestName = new AlgorithmId(mgf1DigestOID).getName();
            MGF1ParameterSpec mgf1ParameterSpec = new MGF1ParameterSpec(mgf1DigestName);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "decodeMGF1ParameterSpec", mgf1ParameterSpec);
            }
            return mgf1ParameterSpec;
        }
        catch (IOException e) {
            throw new IOException("Exception in decodeMGF1ParameterSpec(): " + e);
        }
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", encodingMethod);
        }
        if (encodingMethod != null && !encodingMethod.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        byte[] encodedBytes = this.engineGetEncoded();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", encodedBytes);
        }
        return encodedBytes;
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetParameterSpec", paramSpec);
        }
        try {
            Class<?> pssParamSpec = Class.forName("java.security.spec.PSSParameterSpec");
            if (pssParamSpec.isAssignableFrom(paramSpec)) {
                PSSParameterSpec pssParameterSpec = new PSSParameterSpec(this.hashAlgorithm.getName(), this.maskGenAlgorithm.getName(), this.mgfParameterSpec, this.saltLength, this.trailerField);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameterSpec", pssParameterSpec);
                }
                return pssParameterSpec;
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    @Override
    protected String engineToString() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineToString");
        }
        String mdName = this.mgfParameterSpec == null ? this.hashAlgorithm.getName() : ((MGF1ParameterSpec)this.mgfParameterSpec).getDigestAlgorithm();
        String str = "\n\thashAlgorithm: " + this.hashAlgorithm + "\n\tmaskGenAlgorithm: " + this.maskGenAlgorithm + "\n\tmgf1ParameterSpec: " + mdName + "\n\tsaltLength: " + Integer.toString(this.saltLength) + "\n\ttrailerField: " + Integer.toString(this.trailerField) + "\n";
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineToString", str);
        }
        return str;
    }

    protected static AlgorithmParameters getAlgorithmParameters(PSSParameterSpec spec) throws InvalidKeyException, InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "getAlgorithmParameters", spec);
        }
        try {
            AlgorithmParameters params = AlgorithmParameters.getInstance("RSASSA-PSS", "IBMJCECCA");
            params.init(spec);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "getAlgorithmParameters", params);
            }
            return params;
        }
        catch (GeneralSecurityException e) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e);
        }
    }
}

