/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.Padding;
import javax.crypto.ShortBufferException;

class PKCS5Padding
implements Padding {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PKCS5Padding";
    private int blockSize = 8;

    public PKCS5Padding() {
    }

    public PKCS5Padding(int _blockSize) {
        this.blockSize = _blockSize;
    }

    @Override
    public int pad(byte[] in, int off, int len) throws ShortBufferException {
        if (debug != null) {
            Object[] parms = new Object[]{in, new Integer(off), new Integer(len)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "pad", parms);
        }
        if (in == null) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "pad1", 0);
            }
            return 0;
        }
        int paddingOctet = this.blockSize - len % this.blockSize;
        if (off + len + paddingOctet > in.length) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "pad", "Buffer too small to hold padding");
            }
            throw new ShortBufferException("Buffer too small to hold padding");
        }
        for (int i = 0; i < paddingOctet; ++i) {
            in[i + off + len] = paddingOctet;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "pad2", 0);
        }
        return paddingOctet;
    }

    @Override
    public void padWithLen(byte[] in, int off, int len) throws ShortBufferException {
        if (debug != null) {
            Object[] parms = new Object[]{in, new Integer(off), new Integer(len)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "padWithLen", parms);
        }
        if (in == null) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, "padWithLen1");
            }
            return;
        }
        if (off + len > in.length) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "padWithLen", "Buffer too small to hold padding");
            }
            throw new ShortBufferException("Buffer too small to hold padding");
        }
        byte paddingOctet = (byte)(len & 0xFF);
        for (int i = 0; i < len; ++i) {
            in[i + off] = paddingOctet;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "padWithLen2");
        }
    }

    @Override
    public int unpad(byte[] in, int off, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{in, new Integer(off), new Integer(len)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "unpad", parms);
        }
        if (in == null || len == 0) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "unpad1", 0);
            }
            return 0;
        }
        byte lastByte = in[off + len - 1];
        if ((lastByte & 0xFF) < 1 || (lastByte & 0xFF) > this.blockSize) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "unpad2", -1);
            }
            return -1;
        }
        int start = off + len - (lastByte & 0xFF);
        if (start < off) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "unpad3", -1);
            }
            return -1;
        }
        for (int i = 0; i < (lastByte & 0xFF); ++i) {
            if (in[start + i] == lastByte) continue;
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "unpad4", -1);
            }
            return -1;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "unpad5", start);
        }
        return start;
    }

    @Override
    public int padLength(int len) {
        int paddingOctet = this.blockSize - len % this.blockSize;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "padLength", new Integer(len));
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "padLength", paddingOctet);
        }
        return paddingOctet;
    }
}

