/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import java.security.spec.KeySpec;
import java.util.Arrays;

public class PKCS5KeySpec
implements KeySpec {
    private char[] password;
    private String algorithm;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PKCS5KeySpec";

    public PKCS5KeySpec(char[] password, String alg) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "PKCS5KeySpec", password, alg);
        }
        if (password == null || password.length == 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5KeySpec", "Empty password");
            }
            throw new IllegalArgumentException("Empty password");
        }
        this.password = (char[])password.clone();
        if (alg == null || alg.length() == 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5KeySpec", "Empty algorithm");
            }
            throw new IllegalArgumentException("Empty algorithm");
        }
        this.algorithm = new String(alg);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "PKCS5KeySpec");
        }
    }

    public final char[] getPassword() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getPassword");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getPassword", (char[])this.password.clone());
        }
        return (char[])this.password.clone();
    }

    public final String getAlgorithm() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getPassword");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getPassword", new String(this.algorithm));
        }
        return new String(this.algorithm);
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "finalize");
            debug.exit(Debug.TYPE_PUBLIC, className, "finalize");
        }
        if (this.password != null) {
            Arrays.fill(this.password, ' ');
            this.password = null;
        }
    }
}

