/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.PKCS5Key;
import com.ibm.crypto.hdwrCCA.provider.PKCS5KeySpec;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;

public final class PKCS5KeyFactory
extends SecretKeyFactorySpi {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PKCS5KeyFactory";

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", keySpec);
        }
        if (keySpec == null || !(keySpec instanceof PKCS5KeySpec)) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", "Invalid key spec");
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", new PKCS5Key((PKCS5KeySpec)keySpec));
        }
        return new PKCS5Key((PKCS5KeySpec)keySpec);
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpecCl) throws InvalidKeySpecException {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, className, "engineGetKeySpec", key, keySpecCl);
            }
            if (key != null && key instanceof SecretKey && (key.getAlgorithm().equalsIgnoreCase("PBE") || key.getAlgorithm().equalsIgnoreCase("PBEWithMD2AndDES") || key.getAlgorithm().equalsIgnoreCase("PBEWithMD5AndDES") || key.getAlgorithm().equalsIgnoreCase("PBEWithSHA1AndDES") || key.getAlgorithm().equalsIgnoreCase("PBEWithMD2AndTripleDES") || key.getAlgorithm().equalsIgnoreCase("PBEWithMD5AndTripleDES") || key.getAlgorithm().equalsIgnoreCase("PBEWithSHA1AndTripleDES") || key.getAlgorithm().equalsIgnoreCase("PBEWithMD2AndRC2") || key.getAlgorithm().equalsIgnoreCase("PBEWithMD5AndRC2") || key.getAlgorithm().equalsIgnoreCase("PBEWithSHA1AndRC2")) && key.getFormat().equalsIgnoreCase("PKCS5_KEY")) {
                Class<?> pbeKeySpecCl = Class.forName("com.ibm.crypto.hdwrCCA.provider.PKCS5KeySpec");
                if (keySpecCl != null && pbeKeySpecCl.isAssignableFrom(keySpecCl)) {
                    String alg;
                    byte[] passwdBytes;
                    DerInputStream derIn;
                    try {
                        byte[] keyEncoding = key.getEncoded();
                        derIn = new DerInputStream(keyEncoding);
                    }
                    catch (IOException e) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
                        }
                        throw new InvalidKeySpecException("Invalid key: bad encoding");
                    }
                    try {
                        passwdBytes = derIn.getOctetString();
                    }
                    catch (IOException e) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
                        }
                        throw new InvalidKeySpecException("Invalid key: bad encoding");
                    }
                    char[] passwdChars = new char[passwdBytes.length];
                    for (int i = 0; i < passwdChars.length; ++i) {
                        passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
                    }
                    try {
                        DerValue derAlg = derIn.getDerValue();
                        alg = derAlg.getPrintableString();
                    }
                    catch (IOException e) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
                            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec_1", null);
                        }
                        return null;
                    }
                    PKCS5KeySpec ret = new PKCS5KeySpec(passwdChars, alg);
                    Arrays.fill(passwdChars, ' ');
                    Arrays.fill(passwdBytes, (byte)0);
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec_2", ret);
                    }
                    return ret;
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Invalid key spec");
                }
                throw new InvalidKeySpecException("Invalid key spec");
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Invalid key format/algorithm");
            }
            throw new InvalidKeySpecException("Invalid key format/algorithm");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
            }
            throw new InvalidKeySpecException("Unsupported key spec: " + e.getMessage());
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", key);
            }
            if (key != null && (key.getAlgorithm().equalsIgnoreCase("PBE") || key.getAlgorithm().equalsIgnoreCase("PBEWithMD2AndDES") || key.getAlgorithm().equalsIgnoreCase("PBEWithMD5AndDES") || key.getAlgorithm().equalsIgnoreCase("PBEWithSHA1AndDES") || key.getAlgorithm().equalsIgnoreCase("PBEWithMD2AndTripleDES") || key.getAlgorithm().equalsIgnoreCase("PBEWithMD5AndTripleDES") || key.getAlgorithm().equalsIgnoreCase("PBEWithSHA1AndTripleDES") || key.getAlgorithm().equalsIgnoreCase("PBEWithMD2AndRC2") || key.getAlgorithm().equalsIgnoreCase("PBEWithMD5AndRC2") || key.getAlgorithm().equalsIgnoreCase("PBEWithSHA1AndRC2")) && key.getFormat().equalsIgnoreCase("PKCS5_KEY")) {
                if (key instanceof PKCS5Key) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", key);
                    }
                    return key;
                }
                PKCS5KeySpec pbeKeySpec = (PKCS5KeySpec)this.engineGetKeySpec(key, (Class)PKCS5KeySpec.class);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", this.engineGenerateSecret(pbeKeySpec));
                }
                return this.engineGenerateSecret(pbeKeySpec);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineTranslateKey", "Invalid key format/algorithm");
            }
            throw new InvalidKeyException("Invalid key format/algorithm");
        }
        catch (InvalidKeySpecException ikse) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey", ikse);
            }
            throw new InvalidKeyException("Cannot translate key: " + ikse.getMessage());
        }
    }
}

