/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.PKCS5KeySpec;
import com.ibm.security.util.DerOutputStream;
import java.io.IOException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;

class PKCS5Key
implements SecretKey {
    static final long serialVersionUID = -3471069256160399636L;
    private byte[] key;
    private String algorithm;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PKCS5Key";

    public PKCS5Key(PKCS5KeySpec keySpec) throws InvalidKeySpecException {
        int i;
        char[] passwd;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "PKCS5Key", keySpec);
        }
        if ((passwd = keySpec.getPassword()) == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5Key", "Empty password");
            }
            throw new InvalidKeySpecException("Empty password");
        }
        for (i = 0; i < passwd.length; ++i) {
            if (passwd[i] >= ' ' && passwd[i] <= '~') continue;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5Key", "Password is not ASCII");
            }
            throw new InvalidKeySpecException("Password is not ASCII");
        }
        this.key = new byte[passwd.length];
        for (i = 0; i < passwd.length; ++i) {
            this.key[i] = (byte)(passwd[i] & 0x7F);
        }
        Arrays.fill(passwd, ' ');
        String alg = keySpec.getAlgorithm();
        if (alg == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5Key", "Empty algorithm");
            }
            throw new InvalidKeySpecException("Empty algorithm");
        }
        this.algorithm = alg;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "PKCS5Key");
        }
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "finalize");
        }
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            this.key = null;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "finalize");
        }
    }

    @Override
    public byte[] getEncoded() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getEncoded");
        }
        DerOutputStream out = new DerOutputStream();
        try {
            out.putOctetString(this.key);
            out.putPrintableString(this.algorithm);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getEncoded", e);
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded1", null);
            }
            return null;
        }
        byte[] result = out.toByteArray();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded2", result);
        }
        return result;
    }

    @Override
    public String getAlgorithm() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getAlgorithm");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getAlgorithm", new String(this.algorithm));
        }
        return new String(this.algorithm);
    }

    @Override
    public String getFormat() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getFormat");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getFormat", "PKCS5_KEY");
        }
        return "PKCS5_KEY";
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "hashCode");
        }
        int retval = 0;
        for (int i = 1; i < this.key.length; ++i) {
            retval += this.key[i] * i;
        }
        retval ^= this.getAlgorithm().toLowerCase().hashCode();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "hashCode", retval);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "equals", obj);
        }
        if (obj == this) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals1", true);
            }
            return true;
        }
        if (!(obj instanceof SecretKey)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals2", false);
            }
            return false;
        }
        SecretKey that = (SecretKey)obj;
        if (!that.getAlgorithm().equalsIgnoreCase(this.algorithm)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals3", false);
            }
            return false;
        }
        byte[] thatEncoded = that.getEncoded();
        boolean ret = Arrays.equals(this.getEncoded(), thatEncoded);
        Arrays.fill(thatEncoded, (byte)0);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals4", ret);
        }
        return ret;
    }
}

