/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import java.security.spec.KeySpec;
import java.util.Arrays;

public class PKCS5DerivedKeySpec
implements KeySpec {
    private char[] password;
    private byte[] salt;
    private int iCount;
    private int keyLen;
    private String encrFunc;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PKCSDeriveKeySpec";

    public PKCS5DerivedKeySpec(char[] pwd, byte[] salt, int iterations, int keyLength, String function) {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, salt, new Integer(iterations), new Integer(keyLength), function};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "PKCS5DeriveKeySpec", parms);
        }
        if (pwd == null || pwd.length == 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5DeriveKeySpec", "Empty password");
            }
            throw new IllegalArgumentException("Empty password");
        }
        this.password = (char[])pwd.clone();
        if (function == null || function.length() == 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5DeriveKeySpec", "Empty encryption function");
            }
            throw new IllegalArgumentException("Empty encryption function");
        }
        this.encrFunc = new String(function);
        if (salt == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5DeriveKeySpec", "Empty salt");
            }
            throw new IllegalArgumentException("Empty salt");
        }
        if (this.encrFunc.equals("MD2") || this.encrFunc.equals("MD5") || this.encrFunc.equals("SHA1")) {
            if (salt.length != 8) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "PKCS5DeriveKeySpec", "Salt must be 8 bytes long.");
                }
                throw new IllegalArgumentException("Salt must be 8 bytes long.");
            }
        } else if (salt.length < 8) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5DeriveKeySpec", "Salt must be at least 8 bytes long.");
            }
            throw new IllegalArgumentException("Salt must be at least 8 bytes long.");
        }
        this.salt = salt;
        if (iterations < 1) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5DeriveKeySpec", "Iteration count must be greater than 0");
            }
            throw new IllegalArgumentException("Iteration count must be greater than 0");
        }
        this.iCount = iterations;
        if (keyLength > 16 && (this.encrFunc.equals("MD2") || this.encrFunc.equals("MD5"))) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5DeriveKeySpec", "Derived key too long.  Key length of " + keyLength + " is not valid for " + this.encrFunc + ".");
            }
            throw new IllegalArgumentException("Derived key too long.  Key length of " + keyLength + " is not valid for " + this.encrFunc + ".");
        }
        if (keyLength > 20 && this.encrFunc.equals("SHA1")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5DeriveKeySpec", "Derived key too long.  Key length of " + keyLength + " is not valid for " + this.encrFunc + ".");
            }
            throw new IllegalArgumentException("Derived key too long.  Key length of " + keyLength + " is not valid for " + this.encrFunc + ".");
        }
        if (keyLength > 29) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PKCS5DeriveKeySpec", "Derived key too long.  Key length of " + keyLength + " is not valid for " + this.encrFunc + ".");
            }
            throw new IllegalArgumentException("Derived key too long.  Key length of " + keyLength + " is not valid for " + this.encrFunc + ".");
        }
        this.keyLen = keyLength;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "PKCS5DeriveKeySpec");
        }
    }

    public final char[] getPassword() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getPassword");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getPassword", (char[])this.password.clone());
        }
        return (char[])this.password.clone();
    }

    public final byte[] getSalt() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getSalt");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getSalt", (byte[])this.salt.clone());
        }
        return (byte[])this.salt.clone();
    }

    public final int getIterationCount() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getSalt");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getSalt", this.iCount);
        }
        return this.iCount;
    }

    public final int getKeyLength() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getKeyLength");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKeyLength", this.keyLen);
        }
        return this.keyLen;
    }

    public final String getAlgorithm() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getAlgorithm");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getAlgorithm", null);
        }
        return null;
    }

    public final String getEncryptionFunction() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getEncryptionFunction");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncryptionFunction", new String(this.encrFunc));
        }
        return new String(this.encrFunc);
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "finalize");
            debug.exit(Debug.TYPE_PUBLIC, className, "finalize");
        }
        if (this.password != null) {
            Arrays.fill(this.password, ' ');
            this.password = null;
        }
    }
}

