/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.util.Arrays;

class PKCS12GenKey {
    static final String IBM_PROVIDER = "IBMJCECCA";
    static final byte KEY_ID = 1;
    static final byte IV_ID = 2;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PKCS12GenKey";

    PKCS12GenKey() {
    }

    protected static byte[] genKey(byte id, String digestAlg, char[] pwd, byte[] salt, int iterations, int keysize) throws NoSuchAlgorithmException {
        MessageDigest md;
        int v;
        int u;
        if (debug != null) {
            Object[] parms = new Object[]{new Byte(id), digestAlg, pwd, salt, new Integer(iterations), new Integer(keysize)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "genKey", parms);
        }
        if (id != 1 && id != 2 && id != 3) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "genKey", "Illegal identifier byte: " + id + ". Must be one of 1, 2 or 3.");
            }
            throw new IllegalArgumentException("Illegal identifier byte: " + id + ". Must be one of 1, 2 or 3.");
        }
        if (digestAlg == null || digestAlg.length() == 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "genKey", "No digest algorithm specified.");
            }
            throw new IllegalArgumentException("No digest algorithm specified.");
        }
        if (iterations <= 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "genKey", "Iterations must be greater than zero.");
            }
            throw new IllegalArgumentException("Iterations must be greater than zero.");
        }
        if (keysize <= 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "genKey", "Keybits must be greater than zero.");
            }
            throw new IllegalArgumentException("Keybits must be greater than zero.");
        }
        if (digestAlg.equalsIgnoreCase("SHA") || digestAlg.equalsIgnoreCase("SHA1") || digestAlg.equalsIgnoreCase("SHA-1")) {
            u = 20;
            v = 64;
        } else if (digestAlg.equalsIgnoreCase("MD2") || digestAlg.equalsIgnoreCase("MD5")) {
            u = 16;
            v = 64;
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "genKey", "Unsupported digest algorithm: " + digestAlg + ".  Must be one of SHA, MD2 or MD5.");
            }
            throw new IllegalArgumentException("Unsupported digest algorithm: " + digestAlg + ".  Must be one of SHA, MD2 or MD5.");
        }
        byte[] passwd = PKCS12GenKey.ascii2bmp(pwd);
        try {
            md = Security.getProvider(IBM_PROVIDER) == null ? MessageDigest.getInstance(digestAlg, "IBMJCE4758") : MessageDigest.getInstance(digestAlg, IBM_PROVIDER);
        }
        catch (NoSuchProviderException nspe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "genKey", nspe);
            }
            throw new RuntimeException("IBMJCECCA called, but not configured");
        }
        int c = PKCS12GenKey.roundup(keysize, u) / u;
        byte[] D = new byte[v];
        int s = PKCS12GenKey.roundup(salt.length, v);
        int p = PKCS12GenKey.roundup(passwd.length, v);
        byte[] I = new byte[s + p];
        byte[] key = new byte[keysize];
        Arrays.fill(D, id);
        PKCS12GenKey.concat(salt, I, 0, s);
        PKCS12GenKey.concat(passwd, I, s, p);
        byte[] B = new byte[v];
        byte[] tmp = new byte[v];
        int i = 0;
        while (true) {
            md.update(D);
            md.update(I);
            byte[] Ai = md.digest();
            for (int r = 1; r < iterations; ++r) {
                Ai = md.digest(Ai);
            }
            System.arraycopy(Ai, 0, key, u * i, Math.min(keysize, u));
            if (i + 1 == c) break;
            PKCS12GenKey.concat(Ai, B, 0, B.length);
            BigInteger B1 = new BigInteger(1, B).add(BigInteger.ONE);
            for (int j = 0; j < I.length; j += v) {
                if (tmp.length != v) {
                    tmp = new byte[v];
                }
                System.arraycopy(I, j, tmp, 0, v);
                BigInteger Ij = new BigInteger(1, tmp);
                Ij = Ij.add(B1);
                tmp = Ij.toByteArray();
                int trunc = tmp.length - v;
                if (trunc >= 0) {
                    System.arraycopy(tmp, trunc, I, j, v);
                    continue;
                }
                if (trunc >= 0) continue;
                Arrays.fill(I, j, j + -trunc, (byte)0);
                System.arraycopy(tmp, 0, I, j + -trunc, tmp.length);
            }
            ++i;
            keysize -= u;
        }
        Arrays.fill(passwd, (byte)0);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "genKey", key);
        }
        return key;
    }

    private static int roundup(int x, int y) {
        if (debug != null) {
            debug.entry(40960L, className, "roundup", new Integer(x), new Integer(y));
            debug.exit(40960L, (Object)className, "roundup", (x + (y - 1)) / y * y);
        }
        return (x + (y - 1)) / y * y;
    }

    private static void concat(byte[] src, byte[] dst, int start, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{src, dst, new Integer(start), new Integer(len)};
            debug.entry(40960L, (Object)className, "concat", parms);
        }
        int loop = len / src.length;
        int i = 0;
        int off = 0;
        while (i < loop) {
            System.arraycopy(src, 0, dst, off + start, src.length);
            ++i;
            off += src.length;
        }
        System.arraycopy(src, 0, dst, off + start, len - off);
        if (debug != null) {
            debug.exit(40960L, className, "concat");
        }
    }

    private static byte[] ascii2bmp(char[] chars) {
        byte[] bmpStr = new byte[]{};
        if (debug != null) {
            debug.entry(40960L, (Object)className, "ascii2bmp", (Object)chars);
        }
        if (chars == null) {
            if (debug != null) {
                debug.exit(40960L, (Object)className, "ascii2bmp_1", bmpStr);
            }
            return bmpStr;
        }
        if (chars.length > 0) {
            bmpStr = new byte[(chars.length + 1) * 2];
        }
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            bmpStr[j] = (byte)(chars[i] >>> 8 & 0xFF);
            bmpStr[j + 1] = (byte)(chars[i] & 0xFF);
            ++i;
            j += 2;
        }
        if (debug != null) {
            debug.exit(40960L, (Object)className, "ascii2bmp_2", bmpStr);
        }
        return bmpStr;
    }
}

