/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;

final class PKCS11Utils {
    static final int CKA_IBM_SECURE = -2147483642;
    static final int CKA_IBM_ICSF_HANDLE = -2147483639;
    private static final String NINETEEN_BLANKS = "                   ";
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PKCS11Utils";

    private PKCS11Utils() {
    }

    static boolean isSecureKey(PKCS11Key key) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "isSecureKey", key);
        }
        Boolean secure = false;
        PKCS11Object pkcs11Object = key.getObject();
        if (pkcs11Object != null) {
            try {
                secure = (Boolean)pkcs11Object.getAttributeValue(-2147483642);
            }
            catch (PKCS11Exception e) {
                secure = false;
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "isSecureKey", secure);
        }
        return secure;
    }

    static String getSecureKeyLabel(PKCS11Key key) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getSecureKeyLabel", key);
        }
        String label = null;
        PKCS11Object pkcs11Object = key.getObject();
        if (pkcs11Object != null) {
            try {
                String handle = (String)pkcs11Object.getAttributeValue(-2147483639);
                label = "=" + handle + NINETEEN_BLANKS;
            }
            catch (PKCS11Exception e) {
                label = null;
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getSecureKeyLabel", label);
        }
        return label;
    }
}

