/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.FeedbackCipher;
import com.ibm.crypto.hdwrCCA.provider.SymmetricCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;

class PCBC
extends SymmetricCipher
implements FeedbackCipher {
    private static final String MODE_NAME = "PCBC";
    private byte[] iv = null;
    private byte[] k;
    private SymmetricCipher embeddedCipher;
    private int blockSize = -1;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PCBC";

    PCBC() {
    }

    @Override
    public String getFeedback() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getFeedback");
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getFeedback", MODE_NAME);
        }
        return MODE_NAME;
    }

    void setEmbeddedCipher(SymmetricCipher embeddedCipher) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setEmbeddedCipher", embeddedCipher);
        }
        if (embeddedCipher == null || (this.blockSize = embeddedCipher.getBlockSize()) <= 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "setEmbeddedCipher", "Incompatible algorithm type and mode");
            }
            throw new NoSuchAlgorithmException("Incompatible algorithm type and mode");
        }
        this.embeddedCipher = embeddedCipher;
        this.k = new byte[this.blockSize];
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "setEmbeddedCipher");
        }
    }

    @Override
    int getBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getBlockSize");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getBlockSize", this.blockSize);
        }
        return this.blockSize;
    }

    @Override
    public byte[] getIV() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getIV");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getIV", this.iv);
        }
        return this.iv;
    }

    @Override
    void init(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "init", key);
        }
        this.embeddedCipher.init(key);
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("IBMSecureRandom");
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "init", e);
            }
            random = new SecureRandom();
        }
        this.iv = new byte[this.blockSize];
        random.nextBytes(this.iv);
        System.arraycopy(this.iv, 0, this.k, 0, this.blockSize);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "init", key, params);
        }
        this.embeddedCipher.init(key);
        if (params != null && params instanceof IvParameterSpec) {
            IvParameterSpec ivSpec = (IvParameterSpec)params;
            this.iv = ivSpec.getIV();
            if (this.iv == null || this.iv.length != 8) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong IV length: must be 8 bytes long");
                }
                throw new InvalidAlgorithmParameterException("Wrong IV length: must be 8 bytes long");
            }
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong parameter type: IV expected");
            }
            throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
        }
        System.arraycopy(this.iv, 0, this.k, 0, this.blockSize);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    public void reset() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "reset");
        }
        System.arraycopy(this.iv, 0, this.k, 0, this.blockSize);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "reset");
        }
    }

    @Override
    void encrypt(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) throws IllegalBlockSizeException {
        int endIndex = plainOffset + plainLen;
        if (debug != null) {
            Object[] parms = new Object[]{plain, new Integer(plainOffset), new Integer(plainLen), cipher, new Integer(cipherOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "encrypt", parms);
        }
        while (plainOffset < endIndex) {
            int i;
            for (i = 0; i < this.blockSize; ++i) {
                int n = i;
                this.k[n] = (byte)(this.k[n] ^ plain[i + plainOffset]);
            }
            this.embeddedCipher.encrypt(this.k, 0, this.blockSize, cipher, cipherOffset);
            for (i = 0; i < this.blockSize; ++i) {
                this.k[i] = (byte)(plain[i + plainOffset] ^ cipher[i + cipherOffset]);
            }
            plainOffset += this.blockSize;
            cipherOffset += this.blockSize;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
        }
    }

    @Override
    void decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) throws IllegalBlockSizeException {
        int endIndex = cipherOffset + cipherLen;
        if (debug != null) {
            Object[] parms = new Object[]{cipher, new Integer(cipherOffset), new Integer(cipherLen), plain, new Integer(plainOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "decrypt", parms);
        }
        while (cipherOffset < endIndex) {
            int i;
            this.embeddedCipher.decrypt(cipher, cipherOffset, this.blockSize, plain, plainOffset);
            for (i = 0; i < this.blockSize; ++i) {
                int n = i + plainOffset;
                plain[n] = (byte)(plain[n] ^ this.k[i]);
            }
            for (i = 0; i < this.blockSize; ++i) {
                this.k[i] = (byte)(plain[i + plainOffset] ^ cipher[i + cipherOffset]);
            }
            plainOffset += this.blockSize;
            cipherOffset += this.blockSize;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
        }
    }
}

