/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.PBMParameterSpec;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class PBMParameters
extends AlgorithmParametersSpi {
    private byte[] salt;
    private AlgorithmId owf;
    private int iCount;
    private AlgorithmId mac;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.RSA";

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineInit", paramSpec);
        }
        if (!(paramSpec instanceof PBMParameterSpec)) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Inappropriate parameter specification");
            }
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.salt = (byte[])((PBMParameterSpec)paramSpec).getSalt().clone();
        this.owf = ((PBMParameterSpec)paramSpec).getOwf();
        this.iCount = ((PBMParameterSpec)paramSpec).getIterationCount();
        this.mac = ((PBMParameterSpec)paramSpec).getMac();
        this.checkParams();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "engineInit");
        }
    }

    private void checkParams() throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(8192L, className, "checkParams");
        }
        if (this.salt == null || this.salt.length == 0) {
            if (debug != null) {
                debug.text(8192L, className, "checkParams", "Salt not specified");
            }
            throw new InvalidParameterSpecException("Salt not specified");
        }
        if (this.owf == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkParams", "Owf not specified");
            }
            throw new InvalidParameterSpecException("Owf not specified");
        }
        String name = this.owf.getName();
        if (!(name.equalsIgnoreCase("SHA") || name.equalsIgnoreCase("SHA1") || name.equalsIgnoreCase("SHA-1"))) {
            if (debug != null) {
                debug.text(8192L, className, "checkParams", "Owf algorithm " + name + " not supported");
            }
            throw new InvalidParameterSpecException("Owf algorithm " + name + " not supported");
        }
        if (this.iCount < 1) {
            if (debug != null) {
                debug.text(8192L, className, "checkParams", "Invalid iteration count : " + this.iCount + ".");
            }
            throw new InvalidParameterSpecException("Invalid iteration count : " + this.iCount + ".");
        }
        if (this.mac == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkParams", "Mac not specified");
            }
            throw new InvalidParameterSpecException("Mac not specified");
        }
        name = this.mac.getName();
        if (!name.equalsIgnoreCase("HmacSHA1")) {
            if (debug != null) {
                debug.text(8192L, className, "checkParams", "Mac algorithm " + name + " not supported");
            }
            throw new InvalidParameterSpecException("Mac algorithm " + name + " not supported");
        }
        if (debug != null) {
            debug.exit(8192L, className, "checkParams");
        }
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineInit", (Object)encoded);
        }
        try {
            DerValue val = new DerValue(encoded);
            if (val.getTag() != 48) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "PBM parameter parsing error: not a sequence");
                }
                throw new IOException("PBM parameter parsing error: not a sequence");
            }
            val.getData().reset();
            if (val.getData().available() == 0) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "PBM parameter parsing error : not enough data");
                }
                throw new IOException("PBM parameter parsing error : not enough data");
            }
            this.salt = val.getData().getOctetString();
            if (val.getData().available() == 0) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "PBM parameter parsing error 1: not enough data");
                }
                throw new IOException("PBM parameter parsing error : not enough data");
            }
            this.owf = AlgorithmId.parse((DerValue)val.getData().getDerValue());
            if (val.getData().available() == 0) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "PBM parameter parsing error 2: not enough data");
                }
                throw new IOException("PBM parameter parsing error : not enough data");
            }
            this.iCount = val.getData().getInteger().intValue();
            if (val.getData().available() == 0) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "PBM parameter parsing error 3: not enough data");
                }
                throw new IOException("PBM parameter parsing error : not enough data");
            }
            this.mac = AlgorithmId.parse((DerValue)val.getData().getDerValue());
            if (val.getData().available() != 0) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "PBM parameter parsing error: extra data");
                }
                throw new IOException("PBM parameter parsing error: extra data");
            }
            try {
                this.checkParams();
            }
            catch (InvalidParameterSpecException ee) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ee);
                }
                throw new IOException("PBM parameter parsing error : " + ee);
            }
        }
        catch (NumberFormatException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
            }
            throw new IOException("iteration count too big");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        this.engineInit(encoded);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineGetParameterSpec", paramSpec);
        }
        try {
            Class<?> PBMParamSpec = Class.forName("com.ibm.crypto.provider.PBMParameterSpec");
            if (PBMParamSpec.isAssignableFrom(paramSpec)) {
                PBMParameterSpec pbmParamSpec = new PBMParameterSpec(this.salt, this.owf, this.iCount, this.mac);
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineGetParameterSpec", pbmParamSpec);
                }
                return pbmParamSpec;
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetParameterSpec", "Inappropriate parameter specification");
            }
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameterSpec", e);
            }
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "engineGetEncoded");
        }
        bytes.putOctetString(this.salt);
        this.owf.encode(bytes);
        bytes.putInteger(BigInteger.valueOf(this.iCount));
        this.mac.encode(bytes);
        out.write((byte)48, bytes);
        byte[] result = out.toByteArray();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineGetEncoded", result);
        }
        return result;
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "engineToString");
        }
        String saltString = "\n    salt:\n[";
        HexDumpEncoder encoder = new HexDumpEncoder();
        saltString = saltString + encoder.encodeBuffer(this.salt);
        saltString = saltString + "]";
        String owfString = "\n    owf:\n[";
        owfString = owfString + this.owf.toString();
        owfString = owfString + "]";
        String iCString = "\n    iterationCount:\n" + this.iCount + "\n";
        String macString = "\n    mac:\n[";
        macString = macString + this.mac.toString();
        macString = macString + "]";
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineToString", saltString + owfString + iCString + macString);
        }
        return saltString + owfString + iCString + macString;
    }
}

