/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.security.x509.AlgorithmId;
import java.security.spec.AlgorithmParameterSpec;

public class PBMParameterSpec
implements AlgorithmParameterSpec {
    private byte[] salt;
    private AlgorithmId owf;
    private int iterationCount;
    private AlgorithmId mac;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PBMParameterSpec";

    public PBMParameterSpec(byte[] salt, AlgorithmId owf, int iterationCount, AlgorithmId mac) {
        if (debug != null) {
            Object[] parms = new Object[]{salt, owf, new Integer(iterationCount), mac};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "PBMParameterSpec", parms);
        }
        if (salt == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PBMParameterSpec", "salt not specified");
            }
            throw new IllegalArgumentException("salt not specifided");
        }
        if (owf == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PBMParameterSpec", "owf not specified");
            }
            throw new IllegalArgumentException("owf not specifided");
        }
        if (iterationCount < 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PBMParameterSpec", "invalid iteration count");
            }
            throw new IllegalArgumentException("invalid iteration count");
        }
        if (mac == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PBMParameterSpec", "mac not specified");
            }
            throw new IllegalArgumentException("mac not specified");
        }
        this.salt = (byte[])salt.clone();
        this.owf = owf;
        this.iterationCount = iterationCount;
        this.mac = mac;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "PBMParameterSpec", "salt not specified");
        }
    }

    public byte[] getSalt() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getSalt");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getSalt", (byte[])this.salt.clone());
        }
        return (byte[])this.salt.clone();
    }

    public AlgorithmId getOwf() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getOwf");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getOwf", this.owf);
        }
        return this.owf;
    }

    public int getIterationCount() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getIterationCount");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getIterationCount", this.iterationCount);
        }
        return this.iterationCount;
    }

    public AlgorithmId getMac() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getMac");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getMac", this.mac);
        }
        return this.mac;
    }
}

