/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.PBMParameterSpec;
import com.ibm.security.x509.AlgorithmId;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class PBM
extends MacSpi
implements Cloneable {
    private static final int SHA1_LENGTH = 20;
    private static final int SHA1_BLOCK_LENGTH = 64;
    private static final String IBMJCECCA_PROVIDER = "IBMJCECCA";
    private Mac mac;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PBM";

    public PBM() throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "PBM");
        }
        IBMJCECCA.verifyJceJar();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "PBM");
        }
    }

    @Override
    protected int engineGetMacLength() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetMacLength");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetMacLength", 20);
        }
        return 20;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int i;
        MessageDigest owf;
        int iterationCount;
        byte[] salt;
        byte[] secret;
        block38: {
            String name;
            AlgorithmId algid;
            block37: {
                if (debug != null) {
                    debug.entry(Debug.TYPE_FINE, className, "engineInit", key, params);
                }
                if (key == null || !(key instanceof SecretKey)) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Secret key expected");
                    }
                    throw new InvalidKeyException("Secret key expected");
                }
                secret = key.getEncoded();
                if (secret == null || secret.length == 0) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Missing key data");
                    }
                    throw new InvalidKeyException("Missing key data");
                }
                if (!(params instanceof PBMParameterSpec)) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "PBMParameter expected");
                    }
                    throw new InvalidAlgorithmParameterException("PBMParameter expected");
                }
                salt = ((PBMParameterSpec)params).getSalt();
                if (salt == null || salt.length == 0) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Invalid salt value");
                    }
                    throw new InvalidAlgorithmParameterException("Invalid salt value");
                }
                iterationCount = ((PBMParameterSpec)params).getIterationCount();
                if (iterationCount < 1) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Invalid iteration count");
                    }
                    throw new InvalidAlgorithmParameterException("Invalid iteration count");
                }
                algid = ((PBMParameterSpec)params).getOwf();
                if (algid == null) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Owf not specified");
                    }
                    throw new InvalidAlgorithmParameterException("Owf not specified");
                }
                name = algid.getName();
                if (!name.equalsIgnoreCase("SHA1") && !name.equalsIgnoreCase("SHA")) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Owf algorithm " + name + " not supperted");
                    }
                    throw new InvalidAlgorithmParameterException("Owf algorithm " + name + " not supported");
                }
                try {
                    try {
                        if (Security.getProvider(IBMJCECCA_PROVIDER) == null) {
                            owf = MessageDigest.getInstance(name, "IBMJCE4758");
                            break block37;
                        }
                        owf = MessageDigest.getInstance(name, IBMJCECCA_PROVIDER);
                    }
                    catch (NoSuchProviderException e) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                        }
                        owf = MessageDigest.getInstance(name);
                    }
                }
                catch (NoSuchAlgorithmException ee) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ee);
                    }
                    throw new InvalidAlgorithmParameterException("Owf algorithm " + name + " not supported");
                }
            }
            algid = ((PBMParameterSpec)params).getMac();
            if (algid == null) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Mac not specified");
                }
                throw new InvalidAlgorithmParameterException("Mac not specified");
            }
            name = algid.getName();
            if (!name.equalsIgnoreCase("HmacSHA") && !name.equalsIgnoreCase("HmacSHA1")) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Mac algorithm " + name + " not supported");
                }
                throw new InvalidAlgorithmParameterException("Mac algorithm " + name + " not supported");
            }
            try {
                try {
                    if (Security.getProvider(IBMJCECCA_PROVIDER) == null) {
                        this.mac = Mac.getInstance(name, "IBMJCE4758");
                        break block38;
                    }
                    this.mac = Mac.getInstance(name, IBMJCECCA_PROVIDER);
                }
                catch (NoSuchProviderException e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                    }
                    this.mac = Mac.getInstance(name);
                }
            }
            catch (NoSuchAlgorithmException ee) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ee);
                }
                throw new InvalidAlgorithmParameterException("Mac algorithm " + name + " not supported");
            }
        }
        byte[] input = new byte[secret.length + salt.length];
        System.arraycopy(secret, 0, input, 0, secret.length);
        System.arraycopy(salt, 0, input, secret.length, salt.length);
        do {
            input = owf.digest(input);
        } while (--iterationCount > 0);
        SecretKeySpec pbmKey = new SecretKeySpec(input, "PBM");
        this.mac.init(pbmKey);
        for (i = 0; i < secret.length; ++i) {
            secret[i] = 0;
        }
        for (i = 0; i < salt.length; ++i) {
            salt[i] = 0;
        }
        secret = null;
        salt = null;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineUpdate(byte input) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", new Byte(input));
        }
        this.mac.update(input);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(offset), new Integer(len)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
        }
        this.mac.update(input, offset, len);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected byte[] engineDoFinal() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineDoFinal");
        }
        byte[] result = this.mac.doFinal();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDoFinal", result);
        }
        return result;
    }

    @Override
    protected void engineReset() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineReset");
        }
        this.mac.reset();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineReset");
        }
    }
}

