/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.PBKDF2KeyImpl;
import com.ibm.misc.Debug;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;

abstract class PBKDF2Core
extends SecretKeyFactorySpi {
    private static Debug aDebug = Debug.getInstance((String)"ibmjcecca");
    private static String aClassName = "com.ibm.crypto.hdwrCCA.provider.PBKDF2Core";
    private final String prfAlgo;

    protected PBKDF2Core(String prfAlgo) {
        if (aDebug != null) {
            aDebug.entry(16384L, (Object)aClassName, "PBKDF2Core", (Object)prfAlgo);
        }
        this.prfAlgo = prfAlgo;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (aDebug != null) {
            aDebug.entry(16384L, (Object)aClassName, "engineGenerateSecret", (Object)keySpec);
        }
        if (!(keySpec instanceof PBEKeySpec)) {
            InvalidKeySpecException ikse = new InvalidKeySpecException("Invalid key spec");
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "engineGenerateSecret", "Invalid key spec");
                aDebug.exception(16384L, (Object)aClassName, "engineGenerateSecret", (Throwable)ikse);
            }
            throw ikse;
        }
        PBEKeySpec ks = (PBEKeySpec)keySpec;
        PBKDF2KeyImpl sKey = new PBKDF2KeyImpl(ks, this.prfAlgo);
        if (aDebug != null) {
            aDebug.exit(16384L, (Object)aClassName, "engineGenerateSecret", (Object)sKey);
        }
        return sKey;
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpecCl) throws InvalidKeySpecException {
        InvalidKeySpecException ikse;
        if (aDebug != null) {
            String clName = null;
            if (keySpecCl != null) {
                clName = keySpecCl.getName();
            }
            aDebug.entry(16384L, (Object)aClassName, "engineGetKeySpec", (Object)key, (Object)clName);
        }
        if (key instanceof PBEKey) {
            if (keySpecCl != null && PBEKeySpec.class.isAssignableFrom(keySpecCl)) {
                PBEKey pKey = (PBEKey)key;
                if (aDebug != null) {
                    aDebug.exit(16384L, (Object)aClassName, "engineGetKeySpec");
                }
                return new PBEKeySpec(pKey.getPassword(), pKey.getSalt(), pKey.getIterationCount(), pKey.getEncoded().length * 8);
            }
            ikse = new InvalidKeySpecException("Invalid key spec");
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "engineGetKeySpec", "Invalid key spec");
                aDebug.exception(16384L, (Object)aClassName, "engineGetKeySpec", (Throwable)ikse);
            }
            throw ikse;
        }
        ikse = new InvalidKeySpecException("Invalid key format/algorithm");
        if (aDebug != null) {
            aDebug.text(16384L, (Object)aClassName, "engineGetKeySpec", "Invalid key format/algorithm");
            aDebug.exception(16384L, (Object)aClassName, "engineGetKeySpec", (Throwable)ikse);
        }
        throw ikse;
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (aDebug != null) {
            aDebug.entry(16384L, (Object)aClassName, "engineTranslateKey");
        }
        if (key != null && key.getAlgorithm().equalsIgnoreCase("PBKDF2With" + this.prfAlgo) && key.getFormat().equalsIgnoreCase("RAW")) {
            if (key instanceof PBKDF2KeyImpl) {
                if (aDebug != null) {
                    aDebug.exit(16384L, (Object)aClassName, "engineTranslateKey (1)");
                }
                return key;
            }
            if (key instanceof PBEKey) {
                PBEKey pKey = (PBEKey)key;
                try {
                    PBEKeySpec spec = new PBEKeySpec(pKey.getPassword(), pKey.getSalt(), pKey.getIterationCount(), pKey.getEncoded().length * 8);
                    if (aDebug != null) {
                        aDebug.exit(16384L, (Object)aClassName, "engineTranslateKey (1)");
                    }
                    return new PBKDF2KeyImpl(spec, this.prfAlgo);
                }
                catch (InvalidKeySpecException re) {
                    InvalidKeyException ike = new InvalidKeyException("Invalid key component(s)");
                    ike.initCause(re);
                    if (aDebug != null) {
                        aDebug.text(16384L, (Object)aClassName, "engineTranslateKey", "Invalid key component(s)");
                        aDebug.exception(16384L, (Object)aClassName, "engineTranslateKey", (Throwable)ike);
                    }
                    throw ike;
                }
            }
        }
        InvalidKeyException ike = new InvalidKeyException("Invalid key format/algorithm");
        if (aDebug != null) {
            aDebug.text(16384L, (Object)aClassName, "engineTranslateKey", "Invalid key format/algorithm");
            aDebug.exception(16384L, (Object)aClassName, "engineTranslateKey", (Throwable)ike);
        }
        throw ike;
    }

    protected static final class HmacSHA1
    extends PBKDF2Core {
        public HmacSHA1() {
            super("HmacSHA1");
            if (aDebug != null) {
                aDebug.exit(16384L, (Object)(aClassName + "$HmacSHA1"), "HmacSHA1");
            }
        }
    }
}

