/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

abstract class PBES2Parameters
extends AlgorithmParametersSpi {
    private static Debug aDebug = Debug.getInstance((String)"ibmjcecca");
    private static String aClassName = "com.ibm.crypto.hdwrCCA.provider.PBES2Parameters";
    private static final int[] pkcs5PBKDF2 = new int[]{1, 2, 840, 113549, 1, 5, 12};
    private static final int[] pkcs5PBES2 = new int[]{1, 2, 840, 113549, 1, 5, 13};
    private static final int[] hmacWithSHA1 = new int[]{1, 2, 840, 113549, 2, 7};
    private static final int[] hmacWithSHA224 = new int[]{1, 2, 840, 113549, 2, 8};
    private static final int[] hmacWithSHA256 = new int[]{1, 2, 840, 113549, 2, 9};
    private static final int[] hmacWithSHA384 = new int[]{1, 2, 840, 113549, 2, 10};
    private static final int[] hmacWithSHA512 = new int[]{1, 2, 840, 113549, 2, 11};
    private static final int[] aes128CBC = new int[]{2, 16, 840, 1, 101, 3, 4, 1, 2};
    private static ObjectIdentifier pkcs5PBKDF2_OID;
    private static ObjectIdentifier pkcs5PBES2_OID;
    private static ObjectIdentifier hmacWithSHA1_OID;
    private static ObjectIdentifier hmacWithSHA224_OID;
    private static ObjectIdentifier hmacWithSHA256_OID;
    private static ObjectIdentifier hmacWithSHA384_OID;
    private static ObjectIdentifier hmacWithSHA512_OID;
    private static ObjectIdentifier aes128CBC_OID;
    private String pbes2AlgorithmName = null;
    private byte[] salt = null;
    private int iCount = 0;
    private AlgorithmParameterSpec cipherParam = null;
    private ObjectIdentifier kdfAlgo_OID = hmacWithSHA1_OID;
    private ObjectIdentifier cipherAlgo_OID = null;
    private int keysize = -1;

    PBES2Parameters() {
    }

    protected PBES2Parameters(String pbes2AlgorithmName) throws NoSuchAlgorithmException {
        Object nsae2;
        int and;
        if (aDebug != null) {
            aDebug.entry(16384L, (Object)aClassName, "PBES2Parameters", (Object)pbes2AlgorithmName);
        }
        String kdfAlgo = null;
        String cipherAlgo = null;
        this.pbes2AlgorithmName = pbes2AlgorithmName;
        if (pbes2AlgorithmName.startsWith("PBEWith") && (and = pbes2AlgorithmName.indexOf("And", 8)) > 0) {
            kdfAlgo = pbes2AlgorithmName.substring(7, and);
            cipherAlgo = pbes2AlgorithmName.substring(and + 3);
            int bitIndex = cipherAlgo.indexOf("Bit");
            if (bitIndex > 0) {
                this.keysize = Integer.parseInt(cipherAlgo.substring(0, bitIndex));
                cipherAlgo = cipherAlgo.substring(bitIndex + 3);
            } else {
                int underscore = cipherAlgo.indexOf(95);
                if (underscore > 0) {
                    int slash = cipherAlgo.indexOf(47, underscore + 1);
                    this.keysize = slash > 0 ? Integer.parseInt(cipherAlgo.substring(underscore + 1, slash)) : Integer.parseInt(cipherAlgo.substring(underscore + 1));
                    cipherAlgo = cipherAlgo.substring(0, underscore);
                }
            }
        } else {
            NoSuchAlgorithmException nsae2 = new NoSuchAlgorithmException("No crypto implementation for " + pbes2AlgorithmName);
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "PBES2Parameters", "No crypto implementation for " + pbes2AlgorithmName);
                aDebug.exception(16384L, (Object)aClassName, "PBES2Parameters", (Throwable)nsae2);
            }
            throw nsae2;
        }
        switch (kdfAlgo) {
            case "HmacSHA1": {
                this.kdfAlgo_OID = hmacWithSHA1_OID;
                break;
            }
            case "HmacSHA224": {
                this.kdfAlgo_OID = hmacWithSHA224_OID;
                break;
            }
            case "HmacSHA256": {
                this.kdfAlgo_OID = hmacWithSHA256_OID;
                break;
            }
            case "HmacSHA384": {
                this.kdfAlgo_OID = hmacWithSHA384_OID;
                break;
            }
            case "HmacSHA512": {
                this.kdfAlgo_OID = hmacWithSHA512_OID;
                break;
            }
            default: {
                NoSuchAlgorithmException nsae3 = new NoSuchAlgorithmException("No crypto implementation for " + kdfAlgo);
                if (aDebug != null) {
                    aDebug.text(16384L, (Object)aClassName, "PBES2Parameters", "No crypto implementation for " + kdfAlgo);
                    aDebug.exception(16384L, (Object)aClassName, "PBES2Parameters", (Throwable)nsae3);
                }
                throw nsae3;
            }
        }
        if (cipherAlgo.equals("AES")) {
            this.keysize = this.keysize;
            switch (this.keysize) {
                case 128: {
                    this.cipherAlgo_OID = aes128CBC_OID;
                    break;
                }
                default: {
                    nsae2 = new NoSuchAlgorithmException("No Cipher implementation for " + this.keysize + "-bit " + cipherAlgo);
                    if (aDebug != null) {
                        aDebug.text(16384L, (Object)aClassName, "PBES2Parameters", "No Cipher implementation for " + this.keysize + "-bit " + cipherAlgo);
                        aDebug.exception(16384L, (Object)aClassName, "PBES2Parameters", (Throwable)nsae2);
                    }
                    throw nsae2;
                }
            }
        } else {
            nsae2 = new NoSuchAlgorithmException("No Cipher implementation for " + cipherAlgo);
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "PBES2Parameters", "No Cipher implementation for " + cipherAlgo);
                aDebug.exception(16384L, (Object)aClassName, "PBES2Parameters", (Throwable)nsae2);
            }
            throw nsae2;
        }
        if (aDebug != null) {
            aDebug.exit(16384L, (Object)aClassName, "PBES2Parameters");
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (aDebug != null) {
            aDebug.entry(16384L, (Object)aClassName, "engineInit", (Object)paramSpec);
        }
        if (!(paramSpec instanceof PBEParameterSpec)) {
            InvalidParameterSpecException ipse = new InvalidParameterSpecException("Inappropriate parameter specification");
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "engineInit", "Inappropriate parameter specification");
                aDebug.exception(16384L, (Object)aClassName, "engineInit", (Throwable)ipse);
            }
            throw ipse;
        }
        this.salt = (byte[])((PBEParameterSpec)paramSpec).getSalt().clone();
        this.iCount = ((PBEParameterSpec)paramSpec).getIterationCount();
        this.cipherParam = ((PBEParameterSpec)paramSpec).getParameterSpec();
        if (aDebug != null) {
            aDebug.exit(16384L, (Object)aClassName, "engineInit");
        }
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        if (aDebug != null) {
            aDebug.entry(16384L, (Object)aClassName, "engineInit");
        }
        String kdfAlgo = null;
        String cipherAlgo = null;
        DerValue pBES2Algorithms = new DerValue(encoded);
        if (pBES2Algorithms.getTag() != 48) {
            IOException ioe = new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "engineInit", "PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
                aDebug.exception(16384L, (Object)aClassName, "engineInit", (Throwable)ioe);
            }
            throw ioe;
        }
        if (!pkcs5PBES2_OID.equals(pBES2Algorithms.getData().getOID())) {
            IOException ioe = new IOException("PBE parameter parsing error: expecting the object identifier for PBES2");
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "engineInit", "PBE parameter parsing error: expecting the object identifier for PBES2");
                aDebug.exception(16384L, (Object)aClassName, "engineInit", (Throwable)ioe);
            }
            throw ioe;
        }
        if (pBES2Algorithms.getTag() != 48) {
            IOException ioe = new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "engineInit", "PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
                aDebug.exception(16384L, (Object)aClassName, "engineInit", (Throwable)ioe);
            }
            throw ioe;
        }
        DerValue pBES2_params = pBES2Algorithms.getData().getDerValue();
        if (pBES2_params.getTag() != 48) {
            IOException ioe = new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "engineInit", "PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
                aDebug.exception(16384L, (Object)aClassName, "engineInit", (Throwable)ioe);
            }
            throw ioe;
        }
        kdfAlgo = this.parseKDF(pBES2_params.getData().getDerValue());
        if (pBES2_params.getTag() != 48) {
            IOException ioe = new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "engineInit", "PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
                aDebug.exception(16384L, (Object)aClassName, "engineInit", (Throwable)ioe);
            }
            throw ioe;
        }
        cipherAlgo = this.parseES(pBES2_params.getData().getDerValue());
        this.pbes2AlgorithmName = "PBEWith" + kdfAlgo + "And" + cipherAlgo;
        if (aDebug != null) {
            aDebug.exit(16384L, (Object)aClassName, "engineInit");
        }
    }

    private String parseKDF(DerValue keyDerivationFunc) throws IOException {
        if (aDebug != null) {
            aDebug.entry(16384L, (Object)aClassName, "parseKDF");
        }
        String kdfAlgo = null;
        if (!pkcs5PBKDF2_OID.equals(keyDerivationFunc.getData().getOID())) {
            IOException ioe = new IOException("PBE parameter parsing error: expecting the object identifier for PBKDF2");
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "parseKDF", "PBE parameter parsing error: expecting the object identifier for PBKDF2");
                aDebug.exception(16384L, (Object)aClassName, "parseKDF", (Throwable)ioe);
            }
            throw ioe;
        }
        if (keyDerivationFunc.getTag() != 48) {
            IOException ioe = new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "parseKDF", "PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
                aDebug.exception(16384L, (Object)aClassName, "parseKDF", (Throwable)ioe);
            }
            throw ioe;
        }
        DerValue pBKDF2_params = keyDerivationFunc.getData().getDerValue();
        if (pBKDF2_params.getTag() != 48) {
            IOException ioe = new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "parseKDF", "PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
                aDebug.exception(16384L, (Object)aClassName, "parseKDF", (Throwable)ioe);
            }
            throw ioe;
        }
        DerValue specified = pBKDF2_params.getData().getDerValue();
        if (specified.getTag() != 4) {
            IOException ioe = new IOException("PBE parameter parsing error: not an ASN.1 OCTET STRING tag");
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "parseKDF", "PBE parameter parsing error: not an ASN.1 OCTET STRING tag");
                aDebug.exception(16384L, (Object)aClassName, "parseKDF", (Throwable)ioe);
            }
            throw ioe;
        }
        this.salt = specified.getOctetString();
        this.iCount = pBKDF2_params.getData().getInteger().intValue();
        DerValue keyLength = pBKDF2_params.getData().getDerValue();
        if (keyLength.getTag() == 2) {
            this.keysize = keyLength.getInteger().intValue() * 8;
        }
        if (pBKDF2_params.getTag() == 48) {
            DerValue parameter;
            DerValue prf = pBKDF2_params.getData().getDerValue();
            this.kdfAlgo_OID = prf.getData().getOID();
            if (hmacWithSHA1_OID.equals(this.kdfAlgo_OID)) {
                kdfAlgo = "HmacSHA1";
            } else if (hmacWithSHA224_OID.equals(this.kdfAlgo_OID)) {
                kdfAlgo = "HmacSHA224";
            } else if (hmacWithSHA256_OID.equals(this.kdfAlgo_OID)) {
                kdfAlgo = "HmacSHA256";
            } else if (hmacWithSHA384_OID.equals(this.kdfAlgo_OID)) {
                kdfAlgo = "HmacSHA384";
            } else if (hmacWithSHA512_OID.equals(this.kdfAlgo_OID)) {
                kdfAlgo = "HmacSHA512";
            } else {
                IOException ioe = new IOException("PBE parameter parsing error: expecting the object identifier for a HmacSHA key derivation function");
                if (aDebug != null) {
                    aDebug.text(16384L, (Object)aClassName, "parseKDF", "PBE parameter parsing error: expecting the object identifier for a HmacSHA key derivation function");
                    aDebug.exception(16384L, (Object)aClassName, "parseKDF", (Throwable)ioe);
                }
                throw ioe;
            }
            if (prf.getData().available() != 0 && (parameter = prf.getData().getDerValue()).getTag() != 5) {
                IOException ioe = new IOException("PBE parameter parsing error: not an ASN.1 NULL tag");
                if (aDebug != null) {
                    aDebug.text(16384L, (Object)aClassName, "parseKDF", "PBE parameter parsing error: not an ASN.1 NULL tag");
                    aDebug.exception(16384L, (Object)aClassName, "parseKDF", (Throwable)ioe);
                }
                throw ioe;
            }
        }
        if (aDebug != null) {
            aDebug.exit(16384L, (Object)aClassName, "parseKDF", kdfAlgo);
        }
        return kdfAlgo;
    }

    private String parseES(DerValue encryptionScheme) throws IOException {
        if (aDebug != null) {
            aDebug.entry(16384L, (Object)aClassName, "parseES");
        }
        String cipherAlgo = null;
        this.cipherAlgo_OID = encryptionScheme.getData().getOID();
        if (!aes128CBC_OID.equals(this.cipherAlgo_OID)) {
            IOException ioe = new IOException("PBE parameter parsing error: expecting the object identifier for AES cipher");
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "parseES", "PBE parameter parsing error: expecting the object identifier for AES cipher");
                aDebug.exception(16384L, (Object)aClassName, "parseES", (Throwable)ioe);
            }
            throw ioe;
        }
        cipherAlgo = "AES_128";
        this.cipherParam = new IvParameterSpec(encryptionScheme.getData().getOctetString());
        this.keysize = 128;
        if (aDebug != null) {
            aDebug.exit(16384L, (Object)aClassName, "parseES", (Object)cipherAlgo);
        }
        return cipherAlgo;
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        this.engineInit(encoded);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (PBEParameterSpec.class.isAssignableFrom(paramSpec)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(new PBEParameterSpec(this.salt, this.iCount, this.cipherParam)));
        }
        InvalidParameterSpecException ipse = new InvalidParameterSpecException("Inappropriate parameter specification");
        if (aDebug != null) {
            aDebug.text(16384L, (Object)aClassName, "engineGetParameterSpec", "Inappropriate parameter specification");
            aDebug.exception(16384L, (Object)aClassName, "engineGetParameterSpec", (Throwable)ipse);
        }
        throw ipse;
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        if (aDebug != null) {
            aDebug.entry(16384L, (Object)aClassName, "engineGetEncoded");
        }
        DerOutputStream out = new DerOutputStream();
        DerOutputStream pBES2Algorithms = new DerOutputStream();
        pBES2Algorithms.putOID(pkcs5PBES2_OID);
        DerOutputStream pBES2_params = new DerOutputStream();
        DerOutputStream keyDerivationFunc = new DerOutputStream();
        keyDerivationFunc.putOID(pkcs5PBKDF2_OID);
        DerOutputStream pBKDF2_params = new DerOutputStream();
        pBKDF2_params.putOctetString(this.salt);
        pBKDF2_params.putInteger(this.iCount);
        pBKDF2_params.putInteger(this.keysize / 8);
        DerOutputStream prf = new DerOutputStream();
        prf.putOID(this.kdfAlgo_OID);
        prf.putNull();
        pBKDF2_params.write((byte)48, prf);
        keyDerivationFunc.write((byte)48, pBKDF2_params);
        pBES2_params.write((byte)48, keyDerivationFunc);
        DerOutputStream encryptionScheme = new DerOutputStream();
        encryptionScheme.putOID(this.cipherAlgo_OID);
        if (this.cipherParam == null || !(this.cipherParam instanceof IvParameterSpec)) {
            IOException ioe = new IOException("Wrong parameter type: IV expected");
            if (aDebug != null) {
                aDebug.text(16384L, (Object)aClassName, "engineGetParameterSpec", "Wrong parameter type: IV expected");
                aDebug.exception(16384L, (Object)aClassName, "engineGetParameterSpec", (Throwable)ioe);
            }
            throw ioe;
        }
        encryptionScheme.putOctetString(((IvParameterSpec)this.cipherParam).getIV());
        pBES2_params.write((byte)48, encryptionScheme);
        pBES2Algorithms.write((byte)48, pBES2_params);
        out.write((byte)48, pBES2Algorithms);
        if (aDebug != null) {
            aDebug.exit(16384L, (Object)aClassName, "engineGetEncoded");
        }
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        if (aDebug != null) {
            aDebug.exit(16384L, (Object)aClassName, "engineToString", (Object)this.pbes2AlgorithmName);
        }
        return this.pbes2AlgorithmName;
    }

    static {
        try {
            pkcs5PBKDF2_OID = new ObjectIdentifier(pkcs5PBKDF2);
            pkcs5PBES2_OID = new ObjectIdentifier(pkcs5PBES2);
            hmacWithSHA1_OID = new ObjectIdentifier(hmacWithSHA1);
            hmacWithSHA224_OID = new ObjectIdentifier(hmacWithSHA224);
            hmacWithSHA256_OID = new ObjectIdentifier(hmacWithSHA256);
            hmacWithSHA384_OID = new ObjectIdentifier(hmacWithSHA384);
            hmacWithSHA512_OID = new ObjectIdentifier(hmacWithSHA512);
            aes128CBC_OID = new ObjectIdentifier(aes128CBC);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static final class HmacSHA1AndAES_128
    extends PBES2Parameters {
        public HmacSHA1AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA1And128BitAES");
            if (aDebug != null) {
                aDebug.exit(16384L, (Object)(aClassName + "$HmacSHA1AndAES_128"), "HmacSHA1AndAES_128");
            }
        }
    }

    protected static final class General
    extends PBES2Parameters {
        public General() throws NoSuchAlgorithmException {
            if (aDebug != null) {
                aDebug.exit(16384L, (Object)(aClassName + "$General"), "General");
            }
        }
    }
}

