/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.PBES2Parameters;
import com.ibm.crypto.hdwrCCA.provider.PBKDF2Core;
import com.ibm.crypto.hdwrCCA.provider.ParametersForPBES2Core;
import com.ibm.misc.Debug;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class PBES2Core
extends CipherSpi {
    private static Debug debug = Debug.getInstance((String)"ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PBES2Core";
    private static final int DEFAULT_SALT_LENGTH = 20;
    private static final int DEFAULT_COUNT = 4096;
    private final Cipher cipher;
    private final int keyLength;
    private final int blkSize;
    private final PBKDF2Core kdf;
    private final String pbeAlgo;
    private final String cipherAlgo;
    private int iCount = 4096;
    private byte[] salt = null;
    private IvParameterSpec ivSpec = null;
    private SecureRandom random;
    private static Provider prod = Security.getProvider("IBMJCECCA");

    protected PBES2Core(String kdfAlgo, String cipherAlgo, int keySize) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (debug != null) {
            Object[] parms = new Object[]{kdfAlgo, cipherAlgo, keySize};
            debug.entry(16384L, (Object)className, "PBES2Core", parms);
        }
        this.cipherAlgo = cipherAlgo;
        this.keyLength = keySize * 8;
        this.pbeAlgo = "PBEWith" + kdfAlgo + "And" + this.keyLength + "Bit" + cipherAlgo;
        if (cipherAlgo.equals("AES")) {
            this.blkSize = 16;
            try {
                this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding", "IBMJCECCA");
                if (this.cipher == null) {
                    throw new NoSuchAlgorithmException("No Cipher implementation for " + this.pbeAlgo);
                }
            }
            catch (NoSuchProviderException nsp) {
                throw new RuntimeException("IBMJCECCA called, but not configured");
            }
            switch (kdfAlgo) {
                case "HmacSHA1": {
                    this.kdf = new PBKDF2Core.HmacSHA1();
                    break;
                }
                default: {
                    throw new NoSuchAlgorithmException("No Cipher implementation for " + kdfAlgo);
                }
            }
        } else {
            throw new NoSuchAlgorithmException("No Cipher implementation for " + this.pbeAlgo);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "PBES2Core");
        }
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (mode != null && !mode.equalsIgnoreCase("CBC")) {
            throw new NoSuchAlgorithmException("Invalid cipher mode: " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (paddingScheme != null && !paddingScheme.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Invalid padding scheme: " + paddingScheme);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blkSize;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.cipher.getOutputSize(inputLen);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.cipher.getIV();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetParameters");
        }
        ParametersForPBES2Core params = null;
        if (this.salt == null) {
            this.salt = new byte[20];
            this.getRandom().nextBytes(this.salt);
            this.iCount = 4096;
        }
        if (this.ivSpec == null) {
            byte[] ivBytes = new byte[this.blkSize];
            this.getRandom().nextBytes(ivBytes);
            this.ivSpec = new IvParameterSpec(ivBytes);
        }
        PBEParameterSpec pbeSpec = new PBEParameterSpec(this.salt, this.iCount, this.ivSpec);
        try {
            PBES2Parameters.HmacSHA1AndAES_128 paramsSpi = new PBES2Parameters.HmacSHA1AndAES_128();
            params = new ParametersForPBES2Core(paramsSpi, prod, this.pbeAlgo);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("PBES2Parameters.HmacSHA1AndAES_128 not supported");
        }
        try {
            params.init(pbeSpec);
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException("PBEParameterSpec not supported");
        }
        if (debug != null) {
            HexDumpEncoder encoder = new HexDumpEncoder();
            String saltString = new String("salt:   " + encoder.encodeBuffer(this.salt));
            String ivString = new String("iv:     " + encoder.encodeBuffer(this.ivSpec.getIV()));
            String iterString = new String("icount: " + this.iCount);
            String retValueString = new String("\n" + saltString + "\n" + iterString + "\n" + ivString);
            debug.exit(16384L, (Object)className, "engineGetParameters", (Object)retValueString);
        }
        return params;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException ie) {
            InvalidKeyException ike = new InvalidKeyException("requires PBE parameters");
            ike.initCause(ie);
            throw ike;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        block25: {
            if (debug != null) {
                Object[] parms = new Object[]{opmode, key, params, random};
                debug.entry(16384L, (Object)className, "engineInit", parms);
            }
            this.random = random;
            if (key == null) throw new InvalidKeyException("Missing password");
            if (key.getEncoded() == null) throw new InvalidKeyException("Missing password");
            if (!key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) {
                throw new InvalidKeyException("Missing password");
            }
            if (key instanceof PBEKey) {
                this.salt = ((PBEKey)key).getSalt();
                if (this.salt != null && this.salt.length < 8) {
                    throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
                }
                this.iCount = ((PBEKey)key).getIterationCount();
                if (this.iCount == 0) {
                    this.iCount = 4096;
                } else if (this.iCount < 0) {
                    throw new InvalidAlgorithmParameterException("Iteration count must be a positive number");
                }
            }
            if (params == null) {
                if (this.salt == null) {
                    this.salt = new byte[20];
                    this.getRandom().nextBytes(this.salt);
                    this.iCount = 4096;
                }
                if (opmode == 1 || opmode == 3) {
                    byte[] ivBytes = new byte[this.blkSize];
                    this.getRandom().nextBytes(ivBytes);
                    this.ivSpec = new IvParameterSpec(ivBytes);
                }
            } else {
                if (!(params instanceof PBEParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
                }
                byte[] specSalt = ((PBEParameterSpec)params).getSalt();
                if (specSalt != null && specSalt.length < 8) {
                    throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
                }
                this.salt = specSalt;
                int specICount = ((PBEParameterSpec)params).getIterationCount();
                if (specICount == 0) {
                    specICount = 4096;
                } else if (specICount < 0) {
                    throw new InvalidAlgorithmParameterException("Iteration count must be a positive number");
                }
                this.iCount = specICount;
                AlgorithmParameterSpec specParams = ((PBEParameterSpec)params).getParameterSpec();
                if (specParams != null) {
                    if (specParams instanceof IvParameterSpec) {
                        this.ivSpec = (IvParameterSpec)specParams;
                        break block25;
                    } else {
                        String msg = "unknown";
                        try {
                            msg = specParams.getClass().getName();
                            throw new InvalidAlgorithmParameterException("Wrong parameter type: IvParameterSpec expected, given object is " + msg);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new InvalidAlgorithmParameterException("Wrong parameter type: IvParameterSpec expected, given object is " + msg);
                    }
                }
                if (opmode != 1) {
                    if (opmode != 3) throw new InvalidAlgorithmParameterException("Missing parameter type: IV expected");
                }
                byte[] ivBytes = new byte[this.blkSize];
                this.getRandom().nextBytes(ivBytes);
                this.ivSpec = new IvParameterSpec(ivBytes);
            }
        }
        SecretKeySpec cipherKey = null;
        byte[] derivedKey = null;
        byte[] passwdBytes = key.getEncoded();
        char[] passwdChars = new char[passwdBytes.length];
        for (int i = 0; i < passwdChars.length; ++i) {
            passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
        }
        PBEKeySpec pbeSpec = new PBEKeySpec(passwdChars, this.salt, this.iCount, this.blkSize * 8);
        Arrays.fill(passwdChars, ' ');
        Arrays.fill(passwdBytes, (byte)0);
        SecretKey s = null;
        try {
            s = this.kdf.engineGenerateSecret(pbeSpec);
        }
        catch (InvalidKeySpecException ikse) {
            InvalidKeyException ike = new InvalidKeyException("Cannot construct PBE key");
            ike.initCause(ikse);
            throw ike;
        }
        derivedKey = s.getEncoded();
        cipherKey = new SecretKeySpec(derivedKey, this.cipherAlgo);
        this.cipher.init(opmode, (Key)cipherKey, this.ivSpec, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEParameterSpec pbeSpec = null;
        if (params != null) {
            try {
                pbeSpec = params.getParameterSpec(PBEParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                String msg = "unknown";
                try {
                    msg = null == pbeSpec ? "null" : pbeSpec.getClass().getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new InvalidAlgorithmParameterException("Wrong parameter type: PBEParameterSpec expected, given object is " + msg);
            }
        }
        this.engineInit(opmode, key, pbeSpec, random);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return this.cipher.update(input, inputOffset, inputLen);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.cipher.update(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(input, inputOffset, inputLen);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return this.keyLength;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.cipher.wrap(key);
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.cipher.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    private SecureRandom getRandom() {
        if (this.random == null) {
            try {
                this.random = SecureRandom.getInstance("IBMSecureRandom");
            }
            catch (NoSuchAlgorithmException e) {
                this.random = new SecureRandom();
            }
        }
        return this.random;
    }

    protected static final class HmacSHA1AndAES_128
    extends PBES2Core {
        public HmacSHA1AndAES_128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA1", "AES", 16);
        }
    }
}

