/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.PBEKey;
import com.ibm.crypto.hdwrCCA.provider.PKCS5KeySpec;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.HashSet;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

abstract class PBEKeyFactory
extends SecretKeyFactorySpi {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory";
    private String type;
    private static HashSet<String> validTypes = new HashSet(16);

    public PBEKeyFactory(String keytype) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "PBEKeyFactory", keytype);
        }
        IBMJCECCA.verifyJceJar();
        this.type = keytype;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "PBEKeyFactory");
        }
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", keySpec);
        }
        if (keySpec == null || !(keySpec instanceof PBEKeySpec) && !(keySpec instanceof PKCS5KeySpec) && !(keySpec instanceof SecretKeySpec)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", "Invalid key spec");
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        PBEKey returnKey = new PBEKey(keySpec, this.type);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", returnKey);
        }
        return returnKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpecCl) throws InvalidKeySpecException {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, className, "engineGetKeySpec", key, keySpecCl);
            }
            if (key != null && key instanceof SecretKey && validTypes.contains(key.getAlgorithm().toUpperCase()) && key.getFormat().equalsIgnoreCase("RAW")) {
                Class<?> pbeKeySpecCl = Class.forName("javax.crypto.spec.PBEKeySpec");
                if (keySpecCl != null && pbeKeySpecCl.isAssignableFrom(keySpecCl)) {
                    byte[] passwdBytes = key.getEncoded();
                    char[] passwdChars = new char[passwdBytes.length];
                    for (int i = 0; i < passwdChars.length; ++i) {
                        passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
                    }
                    PBEKeySpec ret = new PBEKeySpec(passwdChars);
                    Arrays.fill(passwdChars, ' ');
                    Arrays.fill(passwdBytes, (byte)0);
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySpec", ret);
                    }
                    return ret;
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Invalid key spec");
                }
                throw new InvalidKeySpecException("Invalid key spec");
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Invalid key format/algorithm");
            }
            throw new InvalidKeySpecException("Invalid key format/algorithm");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
            }
            throw new InvalidKeySpecException("Unsupported key spec: " + e.getMessage());
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", key);
            }
            if (key != null && validTypes.contains(key.getAlgorithm().toUpperCase()) && key.getFormat().equalsIgnoreCase("RAW")) {
                if (key instanceof PBEKey) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey1", key);
                    }
                    return key;
                }
                PBEKeySpec pbeKeySpec = (PBEKeySpec)this.engineGetKeySpec(key, (Class)PBEKeySpec.class);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey2", this.engineGenerateSecret(pbeKeySpec));
                }
                return this.engineGenerateSecret(pbeKeySpec);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineTranslateKey", "Invalid key format/algorithm");
            }
            throw new InvalidKeyException("Invalid key format/algorithm");
        }
        catch (InvalidKeySpecException ikse) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey", ikse);
            }
            throw new InvalidKeyException("Cannot translate key: " + ikse.getMessage());
        }
    }

    static {
        validTypes.add("PBEWithMD2AndDES".toUpperCase());
        validTypes.add("PBEWithMD5AndDES".toUpperCase());
        validTypes.add("PBEWithSHAAndDES".toUpperCase());
        validTypes.add("PBEWithSHAAndTripleDES".toUpperCase());
        validTypes.add("PBEWithSHAAnd40BitRC2".toUpperCase());
        validTypes.add("PBEWithSHAAnd128BitRC2".toUpperCase());
        validTypes.add("PBEWithSHAAnd40BitRC4".toUpperCase());
        validTypes.add("PBEWithSHAAnd128BitRC4".toUpperCase());
        validTypes.add("PBEWithSHAAnd2KeyTripleDES".toUpperCase());
        validTypes.add("PBEWithSHAAnd3KeyTripleDES".toUpperCase());
        validTypes.add("PBEWithMD2AndTripleDES".toUpperCase());
        validTypes.add("PBEWithMD5AndTripleDES".toUpperCase());
        validTypes.add("PBEWithMD2AndRC2".toUpperCase());
        validTypes.add("PBEWithMD5AndRC2".toUpperCase());
        validTypes.add("PBEWithSHA1AndRC2".toUpperCase());
        validTypes.add("PBE".toUpperCase());
    }

    public static final class PBE
    extends PBEKeyFactory {
        public PBE() {
            super("PBE");
        }
    }

    public static final class PBEWithSHA1AndRC2
    extends PBEKeyFactory {
        public PBEWithSHA1AndRC2() {
            super("PBEWithSHA1AndRC2");
        }
    }

    public static final class PBEWithMD5AndRC2
    extends PBEKeyFactory {
        public PBEWithMD5AndRC2() {
            super("PBEWithMD5AndRC2");
        }
    }

    public static final class PBEWithMD2AndRC2
    extends PBEKeyFactory {
        public PBEWithMD2AndRC2() {
            super("PBEWithMD2AndRC2");
        }
    }

    public static final class PBEWithMD5AndTripleDES
    extends PBEKeyFactory {
        public PBEWithMD5AndTripleDES() {
            super("PBEWithMD5AndTripleDES");
        }
    }

    public static final class PBEWithMD2AndTripleDES
    extends PBEKeyFactory {
        public PBEWithMD2AndTripleDES() {
            super("PBEWithMD2AndTripleDES");
        }
    }

    public static final class PBEWithSHAAnd3KeyTripleDES
    extends PBEKeyFactory {
        public PBEWithSHAAnd3KeyTripleDES() {
            super("PBEWithSHAAnd3KeyTripleDES");
        }
    }

    public static final class PBEWithSHAAnd2KeyTripleDES
    extends PBEKeyFactory {
        public PBEWithSHAAnd2KeyTripleDES() {
            super("PBEWithSHAAnd2KeyTripleDES");
        }
    }

    public static final class PBEWithSHAAnd128BitRC4
    extends PBEKeyFactory {
        public PBEWithSHAAnd128BitRC4() {
            super("PBEWithSHAAnd128BitRC4");
        }
    }

    public static final class PBEWithSHAAnd40BitRC4
    extends PBEKeyFactory {
        public PBEWithSHAAnd40BitRC4() {
            super("PBEWithSHAAnd40BitRC4");
        }
    }

    public static final class PBEWithSHAAnd128BitRC2
    extends PBEKeyFactory {
        public PBEWithSHAAnd128BitRC2() {
            super("PBEWithSHAAnd128BitRC2");
        }
    }

    public static final class PBEWithSHAAnd40BitRC2
    extends PBEKeyFactory {
        public PBEWithSHAAnd40BitRC2() {
            super("PBEWithSHAAnd40BitRC2");
        }
    }

    public static final class PBEWithSHAAndTripleDES
    extends PBEKeyFactory {
        public PBEWithSHAAndTripleDES() {
            super("PBEWithSHAAndTripleDES");
        }
    }

    public static final class PBEWithSHAAndDES
    extends PBEKeyFactory {
        public PBEWithSHAAndDES() {
            super("PBEWithSHAAndDES");
        }
    }

    public static final class PBEWithMD5AndDES
    extends PBEKeyFactory {
        public PBEWithMD5AndDES() {
            super("PBEWithMD5AndDES");
        }
    }

    public static final class PBEWithMD2AndDES
    extends PBEKeyFactory {
        public PBEWithMD2AndDES() {
            super("PBEWithMD2AndDES");
        }
    }
}

