/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.PKCS5KeySpec;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

class PBEKey
implements SecretKey {
    static final long serialVersionUID = 6550714301310581595L;
    private byte[] key;
    private String type;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.PBEKey";

    public PBEKey(KeySpec keySpec, String keytype) throws InvalidKeySpecException {
        int i;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "PBEKey", keySpec, keytype);
        }
        if (!(keySpec instanceof PBEKeySpec || keySpec instanceof PKCS5KeySpec || keySpec instanceof SecretKeySpec)) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PBEKey", "Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        char[] passwd = null;
        if (keySpec instanceof PBEKeySpec) {
            PBEKeySpec pbeKeySpec = (PBEKeySpec)keySpec;
            passwd = pbeKeySpec.getPassword();
        }
        if (keySpec instanceof PKCS5KeySpec) {
            PKCS5KeySpec pkcs5KeySpec = (PKCS5KeySpec)keySpec;
            passwd = pkcs5KeySpec.getPassword();
        }
        if (keySpec instanceof SecretKeySpec) {
            SecretKeySpec secretKeySpec = (SecretKeySpec)keySpec;
            byte[] pwdBytes = secretKeySpec.getEncoded();
            String pwdString = new String(pwdBytes, PlatformUtilities.CHARSET_ISO_8859_1);
            passwd = pwdString.toCharArray();
        }
        if (passwd == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PBEKey", "Empty password");
            }
            throw new InvalidKeySpecException("Empty password");
        }
        for (i = 0; i < passwd.length; ++i) {
            if (passwd[i] >= ' ' && passwd[i] <= '~') continue;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "PBEKey", "Password is not ASCII");
            }
            throw new InvalidKeySpecException("Password is not ASCII");
        }
        this.key = new byte[passwd.length];
        for (i = 0; i < passwd.length; ++i) {
            this.key[i] = (byte)(passwd[i] & 0x7F);
        }
        Arrays.fill(passwd, ' ');
        this.type = keytype;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "PBEKey");
        }
    }

    @Override
    public byte[] getEncoded() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getEncoded");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", (byte[])this.key.clone());
        }
        return (byte[])this.key.clone();
    }

    @Override
    public String getAlgorithm() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getAlgorithm");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getAlgorithm", this.type);
        }
        return this.type;
    }

    @Override
    public String getFormat() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getFormat");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getFormat", "RAW");
        }
        return "RAW";
    }

    public int hashCode() {
        int retval = 0;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "hashCode");
        }
        for (int i = 1; i < this.key.length; ++i) {
            retval += this.key[i] * i;
        }
        retval ^= this.getAlgorithm().toLowerCase().hashCode();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "hashCode", retval);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "equals");
        }
        if (obj == this) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals1", true);
            }
            return true;
        }
        if (!(obj instanceof SecretKey)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals2", false);
            }
            return false;
        }
        SecretKey that = (SecretKey)obj;
        if (!(that.getAlgorithm().equalsIgnoreCase(this.type) || that.getAlgorithm().toUpperCase().equals("PBE") || this.type.equals("PBE") && that.getAlgorithm().toUpperCase().startsWith("PBE"))) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals3", false);
            }
            return false;
        }
        byte[] thatEncoded = that.getEncoded();
        boolean ret = Arrays.equals(this.key, thatEncoded);
        Arrays.fill(thatEncoded, (byte)0);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals4", ret);
        }
        return ret;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "readObject", s);
        }
        ObjectInputStream.GetField fields = s.readFields();
        this.key = (byte[])fields.get("key", null);
        this.key = (byte[])this.key.clone();
        this.type = (String)fields.get("type", null);
        if (this.type == null) {
            this.type = "PBE";
        }
        if (debug != null) {
            debug.exit(8192L, className, "readObject");
        }
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "finalize");
        }
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            this.key = null;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "finalize");
        }
    }
}

