/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public final class OAEPParameters
extends AlgorithmParametersSpi {
    private String mdName = "SHA-1";
    private String mgfName = "MGF1";
    private MGF1ParameterSpec mgfSpec;
    private byte[] p;
    private static ObjectIdentifier OID_MGF1;
    private static ObjectIdentifier OID_PSpecified;
    private static Debug debug;
    private static String className;
    private static final String[] MGF_ALGORITHMS;

    public OAEPParameters() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "OAEPParameters");
            debug.exit(Debug.TYPE_FINE, className, "OAEPParameters");
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit 1", paramSpec);
        }
        if (!(paramSpec instanceof OAEPParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        OAEPParameterSpec spec = (OAEPParameterSpec)paramSpec;
        this.mdName = spec.getDigestAlgorithm();
        this.mgfName = spec.getMGFAlgorithm();
        if (!Arrays.asList(MGF_ALGORITHMS).contains(this.mgfName)) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit 1", "Inappropriate parameter specification: Unsupported mgf.");
            }
            throw new InvalidParameterSpecException("Unsupported mgf " + this.mgfName + "; only " + Arrays.toString(MGF_ALGORITHMS));
        }
        AlgorithmParameterSpec mgfSpec = spec.getMGFParameters();
        if (!(mgfSpec instanceof MGF1ParameterSpec)) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit 1", "Inappropriate parameter specification: Inappropriate mgf.");
            }
            throw new InvalidParameterSpecException("Inappropriate mgf parameters; non-null MGF1ParameterSpec only");
        }
        this.mgfSpec = (MGF1ParameterSpec)mgfSpec;
        PSource pSrc = spec.getPSource();
        if (!pSrc.getAlgorithm().equals("PSpecified")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit 1", "Inappropriate parameter specification: Unsupported pSource.");
            }
            throw new InvalidParameterSpecException("Unsupported pSource " + pSrc.getAlgorithm() + "; PSpecified only");
        }
        this.p = ((PSource.PSpecified)pSrc).getValue();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit 1");
        }
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit 2", (Object)encoded);
        }
        DerInputStream der = new DerInputStream(encoded);
        this.mdName = "SHA-1";
        this.mgfSpec = MGF1ParameterSpec.SHA1;
        this.p = new byte[0];
        DerValue[] datum = der.getSequence(3);
        for (int i = 0; i < datum.length; ++i) {
            AlgorithmId val;
            DerValue data = datum[i];
            if (data.isContextSpecific((byte)0)) {
                this.mdName = AlgorithmId.parse((DerValue)data.getData().getDerValue()).getName();
                continue;
            }
            if (data.isContextSpecific((byte)1)) {
                val = AlgorithmId.parse((DerValue)data.getData().getDerValue());
                if (!val.getOID().equals((Object)OID_MGF1)) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit 2", "Invalid mgf: Only " + Arrays.toString(MGF_ALGORITHMS) + " mgf is supported");
                    }
                    throw new IOException("Only " + Arrays.toString(MGF_ALGORITHMS) + " mgf is supported");
                }
                AlgorithmId params = AlgorithmId.parse((DerValue)new DerValue(val.getEncodedParams()));
                String mgfDigestName = params.getName();
                if (mgfDigestName.equals("SHA-1")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA1;
                    continue;
                }
                if (mgfDigestName.equals("SHA-224")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA224;
                    continue;
                }
                if (mgfDigestName.equals("SHA-256")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA256;
                    continue;
                }
                if (mgfDigestName.equals("SHA-384")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA384;
                    continue;
                }
                if (mgfDigestName.equals("SHA-512")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA512;
                    continue;
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit 2", "Unrecognized message digest algorithm");
                }
                throw new IOException("Unrecognized message digest algorithm");
            }
            if (data.isContextSpecific((byte)2)) {
                val = AlgorithmId.parse((DerValue)data.getData().getDerValue());
                if (!val.getOID().equals((Object)OID_PSpecified)) {
                    throw new IOException("Wrong OID for pSpecified");
                }
                DerInputStream dis = new DerInputStream(val.getEncodedParams());
                this.p = dis.getOctetString();
                if (dis.available() == 0) continue;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit 2", "Extra data for pSpecified");
                }
                throw new IOException("Extra data for pSpecified");
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit 2", "Invalid encoded OAEPParameters");
            }
            throw new IOException("Invalid encoded OAEPParameters");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit 2");
        }
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit 3");
        }
        if (decodingMethod != null && !decodingMethod.equalsIgnoreCase("ASN.1")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit 3", "Only support ASN.1 format");
            }
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        this.engineInit(encoded);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit 3");
        }
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetParameterSpec");
        }
        if (OAEPParameterSpec.class.isAssignableFrom(paramSpec)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "engineGetParameterSpec");
            }
            return (T)((AlgorithmParameterSpec)paramSpec.cast(new OAEPParameterSpec(this.mdName, this.mgfName, this.mgfSpec, new PSource.PSpecified(this.p))));
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineGetParameterSpec", "Inappropriate parameter specification");
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        AlgorithmId mgfDigestId;
        AlgorithmId mdAlgId;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetEncoded 1");
        }
        DerOutputStream tmp = new DerOutputStream();
        try {
            mdAlgId = AlgorithmId.get((String)this.mdName);
        }
        catch (NoSuchAlgorithmException nsae) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetEncoded", "AlgorithmId impl not found");
            }
            throw new IOException("AlgorithmId " + this.mdName + " impl not found");
        }
        DerOutputStream tmp2 = new DerOutputStream();
        mdAlgId.derEncode((OutputStream)tmp2);
        tmp.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), tmp2);
        tmp2 = new DerOutputStream();
        tmp2.putOID(OID_MGF1);
        try {
            mgfDigestId = AlgorithmId.get((String)this.mgfSpec.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException nase) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetEncoded", "AlgorithmId impl not found");
            }
            throw new IOException("AlgorithmId " + this.mgfSpec.getDigestAlgorithm() + " impl not found");
        }
        mgfDigestId.encode(tmp2);
        DerOutputStream tmp3 = new DerOutputStream();
        tmp3.write((byte)48, tmp2);
        tmp.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), tmp3);
        tmp2 = new DerOutputStream();
        tmp2.putOID(OID_PSpecified);
        tmp2.putOctetString(this.p);
        tmp3 = new DerOutputStream();
        tmp3.write((byte)48, tmp2);
        tmp.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), tmp3);
        DerOutputStream out = new DerOutputStream();
        out.write((byte)48, tmp);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineGetEncoded 1");
        }
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetEncoded 2");
        }
        if (encodingMethod != null && !encodingMethod.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineGetEncoded 2");
        }
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineToString");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("MD: " + this.mdName + "\n");
        sb.append("MGF: " + this.mgfSpec.getDigestAlgorithm() + "\n");
        sb.append("PSource: PSpecified " + (this.p.length == 0 ? "" : Debug.toHexString(new BigInteger(this.p))) + "\n");
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineToString", "\n: " + sb.toString() + "\n");
        }
        return sb.toString();
    }

    static {
        debug = Debug.getInstance("ibmjcecca");
        className = "com.ibm.crypto.hdwrCCA.provider.OAEPParameters";
        MGF_ALGORITHMS = new String[]{"MGF1"};
        try {
            OID_MGF1 = new ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 1, 8});
        }
        catch (IOException ioe) {
            OID_MGF1 = null;
        }
        try {
            OID_PSpecified = new ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 1, 9});
        }
        catch (IOException ioe) {
            OID_PSpecified = null;
        }
    }
}

