/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.util.Arrays;

public final class MD5
extends MessageDigestSpi
implements Cloneable {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.MD5";
    private static final int MD5_LENGTH = 16;
    private static final int BLOCK_LENGTH = 2048;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferLeft;
    private boolean first = true;
    private byte[] chainVector;
    private byte[] hash;

    public MD5() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "MD5");
        }
        this.init();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "MD5");
        }
    }

    private MD5(MD5 md5) {
        this();
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "MD5", md5);
        }
        this.buffer = (byte[])md5.buffer.clone();
        this.bufferIndex = md5.bufferIndex;
        this.bufferLeft = md5.bufferLeft;
        this.chainVector = (byte[])md5.chainVector.clone();
        this.hash = (byte[])md5.hash.clone();
        this.first = md5.first;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "MD5");
        }
    }

    public void init() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "init");
        }
        this.buffer = new byte[2048];
        this.bufferIndex = 0;
        this.bufferLeft = 2048;
        this.chainVector = new byte[128];
        this.hash = new byte[16];
        this.first = true;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "init");
        }
    }

    @Override
    protected void engineReset() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineReset");
        }
        this.bufferIndex = 0;
        this.bufferLeft = 2048;
        Arrays.fill(this.chainVector, (byte)0);
        Arrays.fill(this.hash, (byte)0);
        this.first = true;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineReset");
        }
    }

    @Override
    protected int engineGetDigestLength() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetDigestLength");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetDigestLength", 16);
        }
        return 16;
    }

    @Override
    protected synchronized void engineUpdate(byte b) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", new Byte(b));
        }
        byte[] input = new byte[]{b};
        this.engineUpdate(input, 0, 1);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected synchronized void engineUpdate(byte[] input, int offset, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(offset), new Integer(len)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
        }
        this.bufferLeft = 2048 - this.bufferIndex;
        for (int inputUsed = 0; inputUsed < len; inputUsed += this.bufferLeft) {
            if (this.bufferLeft <= len - inputUsed) {
                System.arraycopy(input, inputUsed + offset, this.buffer, this.bufferIndex, this.bufferLeft);
                this.processBuffer(this.buffer, 0, this.buffer.length, null);
                this.bufferIndex = 0;
                this.bufferLeft = 2048;
                continue;
            }
            System.arraycopy(input, inputUsed + offset, this.buffer, this.bufferIndex, len - inputUsed);
            this.bufferIndex += len - inputUsed;
            this.bufferLeft = 2048 - this.bufferIndex;
            inputUsed = len;
            break;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected byte[] engineDigest() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineDigest");
        }
        byte[] result = new byte[16];
        this.processBuffer(this.buffer, 0, this.bufferIndex, result);
        this.engineReset();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDigest", result);
        }
        return result;
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (debug != null) {
            Object[] parms = new Object[]{buf, new Integer(offset), new Integer(len)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineDigest", parms);
        }
        byte[] result = new byte[16];
        this.processBuffer(this.buffer, 0, this.bufferIndex, result);
        if (len < 16) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDigest", "Partial digests not returned");
            }
            throw new DigestException("partial digests not returned");
        }
        if (buf.length - offset < 16) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDigest", "Insufficent space in the digest buffer to store the digest");
            }
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        System.arraycopy(result, 0, buf, offset, 16);
        this.engineReset();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDigest", 16);
        }
        return 16;
    }

    @Override
    public Object clone() {
        MD5 that = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "clone");
        }
        try {
            that = (MD5)super.clone();
            that.buffer = (byte[])this.buffer.clone();
            that.bufferIndex = this.bufferIndex;
            that.bufferLeft = this.bufferLeft;
            that.chainVector = (byte[])this.chainVector.clone();
            that.hash = (byte[])this.hash.clone();
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "clone", that);
            }
            return that;
        }
        catch (CloneNotSupportedException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "clone", e);
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "clone", that);
            }
            return that;
        }
    }

    void processBuffer(byte[] data, int off, int len, byte[] buf) throws RuntimeException {
        String exitDataString;
        String ruleText;
        HexDumpEncoder encoder = null;
        if (debug != null) {
            Object[] parms = new Object[]{data, new Integer(off), new Integer(len), buf};
            debug.entry(Debug.TYPE_FINE, (Object)className, "processBuffer", parms);
            encoder = new HexDumpEncoder();
        }
        HIKM hikm = new HIKM();
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        byte[] exitData = new byte[4];
        hikmNativeInteger exitDataLen = new hikmNativeInteger(0);
        hikmNativeInteger ruleArrayCnt = new hikmNativeInteger(2);
        byte[] ruleArray = null;
        hikmNativeInteger textLen = new hikmNativeInteger(len - off);
        byte[] text = new byte[len - off];
        hikmNativeInteger chainVLen = new hikmNativeInteger(128);
        hikmNativeInteger hashLen = new hikmNativeInteger(16);
        if (buf == null) {
            if (this.first) {
                this.first = false;
                ruleText = new String("MD5     FIRST   ");
            } else {
                ruleText = new String("MD5     MIDDLE  ");
            }
        } else {
            ruleText = this.first ? new String("MD5     ONLY    ") : new String("MD5     LAST    ");
        }
        ruleArray = PlatformUtilities.getBytesPlatform(ruleText);
        System.arraycopy(data, off, text, 0, len - off);
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(exitData);
            String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
            String textString = "\n" + encoder.encodeBuffer(text);
            String chainVectorString = "\n" + encoder.encodeBuffer(this.chainVector);
            String hashString = "\n" + encoder.encodeBuffer(this.hash);
            String parmsReport = "\nKeyPairUtils: CSNBOWH INPUT PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    exitDataLen    : " + exitDataLen.getValue() + "\n    exitData       : " + exitDataString + "\n    ruleArrayCount : " + ruleArrayCnt.getValue() + "\n    ruleArray      : " + ruleArrayString + "\n    textLen        : " + textLen.getValue() + "\n    text           : " + textString + "\n    chainVLen      : " + chainVLen.getValue() + "\n    chainVector    : " + chainVectorString + "\n    hashLen        : " + hashLen.getValue() + "\n    hash           : " + hashString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "processBuffer", parmsReport);
        }
        try {
            hikm.CSNBOWHJ(returnCode, reasonCode, exitDataLen, exitData, ruleArrayCnt, ruleArray, textLen, text, chainVLen, this.chainVector, hashLen, this.hash);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "processBuffer", e);
            }
            throw new RuntimeException("Hardware error from call CSNBOWH " + e);
        }
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(exitData);
            String chainVectorString = "\n" + encoder.encodeBuffer(this.chainVector);
            String hashString = "\n" + encoder.encodeBuffer(this.hash);
            String parmsReport = "\nKeyPairUtils: CSNBOWH RETURN PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    exitDataLen    : " + exitDataLen.getValue() + "\n    exitData       : " + exitDataString + "\n    chainVLen      : " + chainVLen.getValue() + "\n    chainVector    : " + chainVectorString + "\n    hashLen        : " + hashLen.getValue() + "\n    hash           : " + hashString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "processBuffer", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "processBuffer", "CSNBOWH returnCode = " + returnCode.getValue() + "reasonCode = " + reasonCode.getValue());
        }
        if (returnCode.getValue() != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "processBuffer", "Hardware error from call CSNBOWH returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue());
            }
            throw new JCECCARuntimeException(1, "CSNBOWH", "Hardware error from call CSNBOWH returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
        }
        if (buf != null) {
            System.arraycopy(this.hash, 0, buf, 0, buf.length);
        } else if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "processBuffer", "**'to' is null");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "processBuffer ");
        }
    }
}

