/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.util.Arrays;

public final class MD2
extends MessageDigestSpi
implements Cloneable {
    private static final int MD2_LENGTH = 16;
    private byte[] digest;
    private byte[] buffer;
    private byte[] checksum;
    private byte[] mdBuffer;
    private int bufferIndex;
    private int bufferLeft;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.MD2";
    private static byte[] substitution = new byte[]{41, 46, 67, -55, -94, -40, 124, 1, 61, 54, 84, -95, -20, -16, 6, 19, 98, -89, 5, -13, -64, -57, 115, -116, -104, -109, 43, -39, -68, 76, -126, -54, 30, -101, 87, 60, -3, -44, -32, 22, 103, 66, 111, 24, -118, 23, -27, 18, -66, 78, -60, -42, -38, -98, -34, 73, -96, -5, -11, -114, -69, 47, -18, 122, -87, 104, 121, -111, 21, -78, 7, 63, -108, -62, 16, -119, 11, 34, 95, 33, -128, 127, 93, -102, 90, -112, 50, 39, 53, 62, -52, -25, -65, -9, -105, 3, -1, 25, 48, -77, 72, -91, -75, -47, -41, 94, -110, 42, -84, 86, -86, -58, 79, -72, 56, -46, -106, -92, 125, -74, 118, -4, 107, -30, -100, 116, 4, -15, 69, -99, 112, 89, 100, 113, -121, 32, -122, 91, -49, 101, -26, 45, -88, 2, 27, 96, 37, -83, -82, -80, -71, -10, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, -93, 35, -35, 81, -81, 58, -61, 92, -7, -50, -70, -59, -22, 38, 44, 83, 13, 110, -123, 40, -124, 9, -45, -33, -51, -12, 65, -127, 77, 82, 106, -36, 55, -56, 108, -63, -85, -6, 36, -31, 123, 8, 12, -67, -79, 74, 120, -120, -107, -117, -29, 99, -24, 109, -23, -53, -43, -2, 59, 0, 29, 57, -14, -17, -73, 14, 102, 88, -48, -28, -90, 119, 114, -8, -21, 117, 75, 10, 49, 68, 80, -76, -113, -19, 31, 26, -37, -103, -115, 51, -97, 17, -125, 20};

    public MD2() {
        this.init();
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "MD2");
            debug.exit(Debug.TYPE_FINE, className, "MD2");
        }
    }

    private MD2(MD2 md2) {
        this();
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "MD2", md2);
        }
        this.digest = (byte[])md2.digest.clone();
        this.buffer = (byte[])md2.buffer.clone();
        this.checksum = (byte[])md2.checksum.clone();
        this.mdBuffer = (byte[])md2.mdBuffer.clone();
        this.bufferIndex = md2.bufferIndex;
        this.bufferLeft = md2.bufferLeft;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "MD2");
        }
    }

    public void init() {
        int i;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "init");
        }
        this.digest = new byte[16];
        this.buffer = new byte[16];
        this.checksum = new byte[16];
        this.mdBuffer = new byte[48];
        this.bufferIndex = 0;
        this.bufferLeft = 16;
        for (i = 0; i < 16; ++i) {
            this.digest[i] = 0;
            this.buffer[i] = 0;
            this.checksum[i] = 0;
            this.mdBuffer[i] = 0;
        }
        for (i = 16; i < 48; ++i) {
            this.mdBuffer[i] = 0;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "init");
        }
    }

    @Override
    protected void engineReset() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineReset");
        }
        this.bufferIndex = 0;
        this.bufferLeft = 16;
        Arrays.fill(this.digest, (byte)0);
        Arrays.fill(this.buffer, (byte)0);
        Arrays.fill(this.checksum, (byte)0);
        Arrays.fill(this.mdBuffer, (byte)0);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineReset");
        }
    }

    @Override
    protected int engineGetDigestLength() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetDigestLength");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetDigestLength", 16);
        }
        return 16;
    }

    void processBuffer(boolean bf) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "processBuffer", new Boolean(bf));
        }
        if (bf) {
            byte temp = this.checksum[15];
            for (int i = 0; i < 16; ++i) {
                int n = i;
                byte by = (byte)(this.checksum[n] ^ substitution[MD2.position((byte)(this.buffer[i] ^ temp))]);
                this.checksum[n] = by;
                temp = by;
            }
            System.arraycopy(this.buffer, 0, this.mdBuffer, 16, 16);
        } else {
            System.arraycopy(this.checksum, 0, this.mdBuffer, 16, 16);
        }
        for (int i = 0; i < 16; ++i) {
            this.mdBuffer[i + 32] = (byte)(this.mdBuffer[i] ^ this.mdBuffer[i + 16]);
        }
        byte current = 0;
        for (int pass = 0; pass < 18; ++pass) {
            for (int step = 0; step < 48; ++step) {
                int n = step;
                this.mdBuffer[n] = (byte)(this.mdBuffer[n] ^ substitution[MD2.position(current)]);
                current = this.mdBuffer[step];
            }
            current = (byte)(current + pass & 0xFFFFFFFF);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "processBuffer");
        }
    }

    private static short position(byte b) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINEST, (Object)className, "position", new Byte(b));
        }
        short result = b >= 0 ? (short)b : (short)(b + 256);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINEST, (Object)className, "position", result);
        }
        return result;
    }

    @Override
    protected synchronized void engineUpdate(byte b) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", new Byte(b));
        }
        byte[] input = new byte[]{b};
        this.engineUpdate(input, 0, 1);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected synchronized void engineUpdate(byte[] input, int offset, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(offset), new Integer(len)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
        }
        int inputUsed = 0;
        this.bufferLeft = 16 - this.bufferIndex;
        for (int i = 0; i <= len / 16; ++i) {
            if (this.bufferLeft <= len - inputUsed) {
                System.arraycopy(input, inputUsed + offset, this.buffer, this.bufferIndex, this.bufferLeft);
                this.processBuffer(true);
                inputUsed += this.bufferLeft;
            } else {
                System.arraycopy(input, inputUsed + offset, this.buffer, this.bufferIndex, len - inputUsed);
                this.bufferIndex += len - inputUsed;
                this.bufferLeft = 16 - this.bufferIndex;
                break;
            }
            this.bufferIndex = 0;
            this.bufferLeft = 16;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    private void finish() {
        int i;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "finish");
        }
        for (i = 0; i < this.bufferLeft; ++i) {
            this.buffer[this.bufferIndex + i] = (byte)this.bufferLeft;
        }
        this.processBuffer(true);
        this.processBuffer(false);
        for (i = 0; i < 16; ++i) {
            this.digest[i] = this.mdBuffer[i];
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "finish");
        }
    }

    @Override
    protected byte[] engineDigest() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineDigest");
        }
        this.finish();
        byte[] result = new byte[16];
        System.arraycopy(this.digest, 0, result, 0, 16);
        this.engineReset();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDigest", result);
        }
        return result;
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (debug != null) {
            Object[] parms = new Object[]{buf, new Integer(offset), new Integer(len)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineDigest", parms);
        }
        this.finish();
        if (len < 16) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDigest", "Partial digests not returned");
            }
            throw new DigestException("partial digests not returned");
        }
        if (buf.length - offset < 16) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDigest", "Insufficient space in the output buffer to store the digest");
            }
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        System.arraycopy(this.digest, 0, buf, offset, 16);
        this.engineReset();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDigest", 16);
        }
        return 16;
    }

    @Override
    public Object clone() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "clone");
        }
        MD2 that = null;
        try {
            that = (MD2)super.clone();
            that.digest = (byte[])this.digest.clone();
            that.buffer = (byte[])this.buffer.clone();
            that.checksum = (byte[])this.checksum.clone();
            that.mdBuffer = (byte[])this.mdBuffer.clone();
            that.bufferIndex = this.bufferIndex;
            that.bufferLeft = this.bufferLeft;
            return that;
        }
        catch (CloneNotSupportedException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "clone", e);
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "clone", that);
            }
            return that;
        }
    }
}

