/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Arrays;

public final class LabelUtils {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.LabelUtils";
    private static HexDumpEncoder encoder = debug != null ? new HexDumpEncoder() : null;

    protected static String genLabelName() {
        byte[] labelName = new byte[64];
        byte[] labelSaltData = new byte[24];
        SecureRandom random = null;
        if (debug != null) {
            debug.entry(8192L, className, "genLabelName");
        }
        try {
            random = SecureRandom.getInstance("IBMSecureRandom", "IBMJCECCA");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            if (debug != null) {
                debug.exception(8192L, className, "genLabelName", e);
            }
            random = new SecureRandom();
        }
        random.nextBytes(labelSaltData);
        BigInteger bigInt = new BigInteger(1, labelSaltData);
        String bigIntString = bigInt.toString();
        byte[] labelTmp = bigIntString.getBytes(PlatformUtilities.CHARSET_ISO_8859_1);
        int labelLength = bigIntString.length();
        if (labelLength > 62) {
            labelLength = 62;
        }
        Arrays.fill(labelName, (byte)32);
        System.arraycopy(labelTmp, 0, labelName, 0, labelLength);
        labelName[0] = 73;
        labelName[1] = 66;
        labelName[2] = 77;
        labelName[3] = 52;
        labelName[4] = 55;
        labelName[5] = 53;
        labelName[6] = 56;
        for (int i = 8; i < labelLength; i += 9) {
            labelName[i] = i == labelLength - 1 ? 32 : 46;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "genLabelName", labelName);
        }
        return new String(labelName, PlatformUtilities.CHARSET_ISO_8859_1);
    }

    protected static boolean isLabel(byte[] label, Charset encoding) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "isLabel", "\nEncoding: " + encoding.displayName() + "\nLabel:\n" + encoder.encodeBuffer(label));
        }
        if (label == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "isLabel", "This is not a label, label is null.");
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "isLabel", false);
            }
            return false;
        }
        if (label.length != 64) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "isLabel", "This is not a label, label length " + label.length + " not equal to 64.");
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "isLabel", false);
            }
            return false;
        }
        if (encoding.equals(PlatformUtilities.CHARSET_IBM_1047) && (label[0] & 0xFF) > 64) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "isLabel", "This is a label in encoding " + encoding.displayName() + ".");
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "isLabel", true);
            }
            return true;
        }
        if (encoding.equals(PlatformUtilities.CHARSET_ISO_8859_1) && (label[0] & 0xFF) > 32 && label[0] != 255) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "isLabel", "This is a label in encoding " + encoding.displayName() + ".");
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "isLabel", true);
            }
            return true;
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "isLabel", "This is not a label in encoding " + encoding.displayName() + ", first character did not match expected range of values.");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "isLabel", false);
        }
        return false;
    }

    protected static byte[] padLabel(byte[] label, Charset encoding) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "padLabel", (Object)label);
        }
        if (label.length == 64) {
            byte[] ckdslabel = (byte[])label.clone();
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "padLabel", "Label already padded, return label.");
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "padLabel", label);
            }
            return ckdslabel;
        }
        if (label.length < 64) {
            byte[] ckdslabel = new byte[64];
            if (encoding.equals(PlatformUtilities.CHARSET_IBM_1047)) {
                Arrays.fill(ckdslabel, (byte)64);
            } else if (encoding.equals(PlatformUtilities.CHARSET_ISO_8859_1)) {
                Arrays.fill(ckdslabel, (byte)32);
            } else {
                RuntimeException e = new RuntimeException("Encoding Not Supported.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "padLabel", e);
                    debug.exit(Debug.TYPE_PUBLIC, className, "padLabel");
                }
                throw e;
            }
            System.arraycopy(label, 0, ckdslabel, 0, label.length);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "padLabel", "Label sucessfully padded.");
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "padLabel", ckdslabel);
            }
            return ckdslabel;
        }
        RuntimeException e = new RuntimeException("Cannot pad label since it is greater then 64 characters.");
        if (debug != null) {
            debug.exception(Debug.TYPE_PUBLIC, className, "padLabel", e);
            debug.exit(Debug.TYPE_PUBLIC, className, "padLabel");
        }
        throw e;
    }
}

