/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.ECUtils;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.KeyFactoryUtils;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.LabelUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;

final class KeyStoreUtils {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.KeyStoreUtils";
    private static HexDumpEncoder encoder = debug != null ? new HexDumpEncoder() : null;

    private KeyStoreUtils() {
    }

    static ECPrivateHWKey importSoftwareECPrivateKey(ECPrivateKey key, ECHWKeyAttributes keyAttributes) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "importSoftwareECPrivateKey", key, keyAttributes);
        }
        ECPrivateHWKey privateKey = null;
        BigInteger s = key.getS();
        ECParameterSpec parameterSpec = key.getParams();
        ECPoint w = ECUtils.multiply(s, parameterSpec.getGenerator(), parameterSpec.getCurve());
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(w, parameterSpec);
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(s, parameterSpec);
        byte[] externalKeyToken = KeyFactoryUtils.buildExternalPrivateKeyTokenEC(publicKeySpec, privateKeySpec, keyAttributes);
        KeyPairUtils util = new KeyPairUtils();
        byte[] internalKeyToken = util.importExternalToken(externalKeyToken, KeyPairUtils.KeyPairAlgorithm.EC);
        try {
            switch (keyAttributes.getKeyType()) {
                case 2: {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "importSoftwareECPrivateKey", "Hardware key type CLEAR");
                    }
                    privateKey = new ECPrivateHWKey(externalKeyToken, internalKeyToken, parameterSpec, keyAttributes);
                    break;
                }
                case 0: {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "importSoftwareECPrivateKey", "Hardware key type PKDS");
                    }
                    byte[] pkdsLabel = KeyStoreUtils.pkdsRecordCreate(internalKeyToken);
                    privateKey = new ECPrivateHWKey(pkdsLabel, parameterSpec, keyAttributes);
                    break;
                }
                default: {
                    InternalError ie = new InternalError("Unknown Elliptic Curve key type value: " + keyAttributes.getKeyType());
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "importSoftwareECPrivateKey", ie);
                        debug.exit(Debug.TYPE_PUBLIC, className, "importSoftwareECPrivateKey");
                    }
                    throw ie;
                }
            }
        }
        catch (InvalidParameterSpecException e) {
            InvalidKeyException ike = new InvalidKeyException("The domain parameters are not valid", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "importSoftwareECPrivateKey", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "importSoftwareECPrivateKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "importSoftwareECPrivateKey");
            }
            throw ike;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "importSoftwareECPrivateKey", privateKey);
        }
        return privateKey;
    }

    static ECPrivateKeySpec generateECPrivateKeySpec(ECPrivateHWKey key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "generateECPrivateKeySpec", key);
        }
        BigInteger s = null;
        byte[] externalKeyToken = key.getExternalKeyToken();
        if (externalKeyToken == null) {
            InvalidKeyException ike = new InvalidKeyException("CLEAR Elliptic Curve private key must have an external key token");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generateECPrivateKeySpec", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "generateECPrivateKeySpec");
            }
            throw ike;
        }
        s = KeyStoreUtils.parsePrivateKeyValueEC(externalKeyToken);
        ECPrivateKeySpec keySpec = new ECPrivateKeySpec(s, key.getParams());
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "generateECPrivateKeySpec", keySpec);
        }
        return keySpec;
    }

    static ECPrivateKey generateSoftwareECPrivateKey(ECPrivateHWKey key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "generateSoftwareECPrivateKey", key);
        }
        ECPrivateKeySpec keySpec = KeyStoreUtils.generateECPrivateKeySpec(key);
        KeyFactory keyFactory = null;
        ECPrivateKey softwareKey = null;
        try {
            keyFactory = KeyFactory.getInstance("EC", "IBMJCE");
        }
        catch (NoSuchProviderException e) {
            RuntimeException re = new RuntimeException("Internal error: unable to generate software key. The IBMJCE provider does not exist", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generateSoftwareECPrivateKey", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "generateSoftwareECPrivateKey", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "generateSoftwareECPrivateKey");
            }
            throw re;
        }
        catch (NoSuchAlgorithmException e) {
            RuntimeException re = new RuntimeException("Internal error: unable to generate software key. The IBMJCE provider does not support EC algorithm", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generateSoftwareECPrivateKey", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "generateSoftwareECPrivateKey", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "generateSoftwareECPrivateKey");
            }
            throw re;
        }
        try {
            softwareKey = (ECPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            InvalidKeyException ike = new InvalidKeyException("Unable to generate software key. The hardware private key is not a valid Elliptic Curve key", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generateSoftwareECPrivateKey", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "generateSoftwareECPrivateKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "generateSoftwareECPrivateKey");
            }
            throw ike;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "generateSoftwareECPrivateKey", softwareKey);
        }
        return softwareKey;
    }

    private static BigInteger parsePrivateKeyValueEC(byte[] externalKeyToken) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parsePrivateKeyValueEC", (Object)externalKeyToken);
        }
        ByteBuffer byteBuffer = null;
        byte[] privateKeyBytes = null;
        BigInteger privateKey = null;
        short associatedDataLength = 0;
        short formattedSectionLength = 0;
        if (externalKeyToken[0] != 30) {
            InvalidKeyException ike = new InvalidKeyException("The key token is not an external PKA key token");
            if (debug != null) {
                debug.exception(8192L, className, "parsePrivateKeyValueEC", ike);
                debug.exit(8192L, className, "parsePrivateKeyValueEC");
            }
            throw ike;
        }
        if (externalKeyToken[8] != 32) {
            InvalidKeyException ike = new InvalidKeyException("The external PKA key token is not valid");
            if (debug != null) {
                debug.exception(8192L, className, "parsePrivateKeyValueEC", ike);
                debug.exit(8192L, className, "parsePrivateKeyValueEC");
            }
            throw ike;
        }
        if (externalKeyToken[12] != 0) {
            InvalidKeyException ike = new InvalidKeyException("The external PKA key token is not a CLEAR token");
            if (debug != null) {
                debug.exception(8192L, className, "parsePrivateKeyValueEC", ike);
                debug.exit(8192L, className, "parsePrivateKeyValueEC");
            }
            throw ike;
        }
        byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.put(externalKeyToken[80]).put(externalKeyToken[81]);
        associatedDataLength = byteBuffer.getShort(0);
        byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.put(externalKeyToken[82]).put(externalKeyToken[83]);
        formattedSectionLength = byteBuffer.getShort(0);
        privateKeyBytes = new byte[formattedSectionLength];
        System.arraycopy(externalKeyToken, 84 + associatedDataLength, privateKeyBytes, 0, formattedSectionLength);
        privateKey = new BigInteger(1, privateKeyBytes);
        KeyStoreUtils.arrayFill(privateKeyBytes, (byte)32);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "parsePrivateKeyValueEC", privateKey);
        }
        return privateKey;
    }

    private static byte[] pkdsRecordCreate(byte[] keyToken) {
        String exitDataString;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "pkdsRecordCreate", (Object)keyToken);
        }
        byte[] exitData = new byte[]{};
        byte[] pkdsLabel = new byte[64];
        byte[] ruleArray = new byte[]{};
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger keyTokenLength = new hikmNativeInteger(keyToken.length);
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(0);
        HIKM hikm = new HIKM();
        byte[] label = LabelUtils.genLabelName().getBytes(PlatformUtilities.CHARSET_ISO_8859_1);
        KeyStoreUtils.arrayFill(pkdsLabel, (byte)32);
        System.arraycopy(label, 0, pkdsLabel, 0, label.length);
        if (debug != null) {
            debug.text(8192L, className, "pkdsRecordCreate", "Calling hikm.CSNDKRCJ() to create a PKDS record");
        }
        if (PlatformUtilities.isZOS()) {
            pkdsLabel = PlatformUtilities.convertBytesIfKeyLabelATOE(pkdsLabel);
        }
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(exitData);
            String pkdsLabelString = "\n" + encoder.encodeBuffer(pkdsLabel);
            String keyTokenString = "\n" + encoder.encodeBuffer(keyToken);
            String parmsReport = "\nKeyStoreUtils: CSNDKRC INPUT PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    exitDataLen    : " + exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    ruleArrayCount : " + ruleArrayCount.getValue() + "\n    pkdsLabel      : " + pkdsLabelString + "\n    keyTokenLength : " + keyTokenLength.getValue() + "\n    keyToken       : " + keyTokenString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "pkdsRecordCreate", parmsReport);
        }
        try {
            hikm.CSNDKRCJ(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, pkdsLabel, keyTokenLength, keyToken);
        }
        catch (IllegalArgumentException e) {
            RuntimeException re = new RuntimeException("Hardware error from call CSNDKRC " + e, e);
            if (debug != null) {
                debug.exception(8192L, className, "pkdsRecordCreate", e);
                debug.exception(8192L, className, "pkdsRecordCreate", re);
                debug.exit(8192L, className, "pkdsRecordCreate");
            }
            throw re;
        }
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(exitData);
            String parmsReport = "\nKeyStoreUtils: CSNDKRC RETURN PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    exitDataLen    : " + exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "pkdsRecordCreate", parmsReport);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "pkdsRecordCreate", "hikm.CSNKDRCJ() returnCode = " + returnCode + ", reasonCode = " + reasonCode);
        }
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException jre = new JCECCARuntimeException(1, "CSNDKRC", "Hardware error from call CSNDKRC, returnCode = " + returnCode.getValue() + ", reasonCode = " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(8192L, className, "pkdsRecordCreate", jre);
                debug.exit(8192L, className, "pkdsRecordCreate");
            }
            throw jre;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "pkdsRecordCreate", label);
        }
        return label;
    }

    private static void arrayFill(byte[] array, byte ch) {
        if (debug != null) {
            Object[] parms = new Object[]{array, new Byte(ch)};
            debug.entry(8192L, (Object)className, "arrayFill", parms);
        }
        for (int x = 0; x < array.length; ++x) {
            array[x] = ch;
        }
        if (debug != null) {
            debug.exit(8192L, className, "arrayFill");
        }
    }
}

