/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.CipherForKeyProtectorS2;
import com.ibm.crypto.hdwrCCA.provider.PBEKey;
import com.ibm.crypto.hdwrCCA.provider.PBES2Core;
import com.ibm.crypto.hdwrCCA.provider.SealedObjectForKeyProtectorS2;
import com.ibm.crypto.hdwrCCA.provider.SealedTokenForKeyProtectorS2;
import com.ibm.misc.Debug;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

final class KeyProtectorS2 {
    private static final int SALT_LEN = 20;
    private static final int DIGEST_LEN = 20;
    private static final String DIGEST_ALG = "HmacSHA1";
    private static final int ITER_COUNT = 1000;
    private static final String CIPHER_ALG = "AES";
    private static final String CIPHER_TRANSFORM = "PBEWithHmacSHA1And128BitAES";
    private static final String KEY_ALG = "PBEWithHmacSHA1And128BitAES";
    private static final int KEY_STRENGTH = 128;
    private final int blkSize = 16;
    private final int blkSizeBytes = 2;
    private char[] password;
    private byte[] passwdBytes;
    private static Provider prod = Security.getProvider("IBMJCECCA");
    private static Debug debug = Debug.getInstance((String)"ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.KeyProtectorS2";

    protected KeyProtectorS2(char[] password) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "KeyProtectorS2", (Object)password);
        }
        if (password == null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "KeyProtectorS2", "password can't be null");
            }
            throw new IllegalArgumentException("password can't be null");
        }
        this.password = password;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "KeyProtectorS2");
        }
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "finalize");
        }
        if (this.passwdBytes != null) {
            Arrays.fill(this.passwdBytes, (byte)0);
            this.passwdBytes = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "finalize");
        }
    }

    protected SealedTokenForKeyProtectorS2 protect(byte[] token) throws Exception {
        SecureRandom random = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "protect", (Object)token);
        }
        try {
            random = SecureRandom.getInstance("IBMSecureRandom");
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "protect", (Throwable)e);
            }
            random = new SecureRandom();
        }
        byte[] salt = new byte[20];
        random.nextBytes(salt);
        PBEParameterSpec pbeParmSpec = new PBEParameterSpec(salt, 1000);
        PBEKeySpec pbeKSpec = new PBEKeySpec(this.password);
        PBEKey skey = new PBEKey(pbeKSpec, "PBEWithHmacSHA1And128BitAES");
        Arrays.fill(pbeKSpec.getPassword(), ' ');
        PBES2Core.HmacSHA1AndAES_128 cipherSpi = new PBES2Core.HmacSHA1AndAES_128();
        CipherForKeyProtectorS2 cipher = new CipherForKeyProtectorS2(cipherSpi, prod, "PBEWithHmacSHA1And128BitAES");
        cipher.init(1, (Key)skey, pbeParmSpec, null);
        byte[] encr = cipher.doFinal(token, 0, token.length);
        byte[] ivBytes = cipher.getIV();
        IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
        PBEParameterSpec pbeParmSpec1 = new PBEParameterSpec(salt, 1000, ivSpec);
        SealedTokenForKeyProtectorS2 sealedToken = new SealedTokenForKeyProtectorS2(encr, pbeParmSpec1);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "protect", (Object)sealedToken);
        }
        return sealedToken;
    }

    protected byte[] recover(SealedTokenForKeyProtectorS2 sealedToken) throws UnrecoverableKeyException, NoSuchAlgorithmException {
        try {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "recover", (Object)sealedToken);
            }
            PBEParameterSpec pbeParamSpec = sealedToken.getParameterSpec();
            PBEKeySpec pbeKSpec = new PBEKeySpec(this.password);
            PBEKey skey = new PBEKey(pbeKSpec, "PBEWithHmacSHA1And128BitAES");
            Arrays.fill(pbeKSpec.getPassword(), ' ');
            PBES2Core.HmacSHA1AndAES_128 cipherSpi = new PBES2Core.HmacSHA1AndAES_128();
            CipherForKeyProtectorS2 cipher = new CipherForKeyProtectorS2(cipherSpi, prod, "PBEWithHmacSHA1And128BitAES");
            cipher.init(2, (Key)skey, pbeParamSpec, null);
            byte[] token = cipher.doFinal(sealedToken.getEncToken(), 0, sealedToken.getEncToken().length);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "recover", (Object)token);
            }
            return token;
        }
        catch (NoSuchPaddingException nspe) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "recover", (Throwable)nspe);
            }
            throw new UnrecoverableKeyException(nspe.getMessage());
        }
        catch (IllegalBlockSizeException ibse) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "recover", (Throwable)ibse);
            }
            throw new UnrecoverableKeyException(ibse.getMessage());
        }
        catch (InvalidParameterException ipe) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "recover", (Throwable)ipe);
            }
            throw new UnrecoverableKeyException(ipe.getMessage());
        }
        catch (InvalidAlgorithmParameterException iape) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "recover", (Throwable)iape);
            }
            throw new UnrecoverableKeyException(iape.getMessage());
        }
        catch (InvalidKeyException ike) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "recover", (Throwable)ike);
            }
            throw new UnrecoverableKeyException(ike.getMessage());
        }
        catch (InvalidKeySpecException ikse) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "recover", (Throwable)ikse);
            }
            throw new UnrecoverableKeyException(ikse.getMessage());
        }
        catch (BadPaddingException bpe) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "recover", (Throwable)bpe);
            }
            throw new UnrecoverableKeyException(bpe.getMessage());
        }
    }

    protected SealedObject seal(Key key) throws Exception {
        SecureRandom random = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "seal", (Object)key);
        }
        try {
            random = SecureRandom.getInstance("IBMSecureRandom");
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "seal", (Throwable)e);
            }
            random = new SecureRandom();
        }
        byte[] salt = new byte[20];
        random.nextBytes(salt);
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 1000);
        PBEKeySpec pbeKSpec = new PBEKeySpec(this.password);
        PBEKey skey = new PBEKey(pbeKSpec, "PBEWithHmacSHA1And128BitAES");
        Arrays.fill(pbeKSpec.getPassword(), ' ');
        PBES2Core.HmacSHA1AndAES_128 cipherSpi = new PBES2Core.HmacSHA1AndAES_128();
        CipherForKeyProtectorS2 cipher = new CipherForKeyProtectorS2(cipherSpi, prod, "PBEWithHmacSHA1And128BitAES");
        cipher.init(1, (Key)skey, pbeParamSpec);
        SealedObject retValue = new SealedObject(key, cipher);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "seal", (Object)retValue);
        }
        return retValue;
    }

    protected Key unseal(SealedObject so) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "unseal", (Object)so);
            }
            PBEKeySpec pbeKSpec = new PBEKeySpec(this.password);
            PBEKey skey = new PBEKey(pbeKSpec, "PBEWithHmacSHA1And128BitAES");
            Arrays.fill(pbeKSpec.getPassword(), ' ');
            SealedObjectForKeyProtectorS2 soForKeyProtectorS2 = null;
            soForKeyProtectorS2 = !(so instanceof SealedObjectForKeyProtectorS2) ? new SealedObjectForKeyProtectorS2(so) : (SealedObjectForKeyProtectorS2)so;
            AlgorithmParameters params = soForKeyProtectorS2.getParameters();
            if (params == null) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "unseal", "Cannot get algorithm parameters");
                }
                throw new UnrecoverableKeyException("Cannot get algorithm parameters");
            }
            PBES2Core.HmacSHA1AndAES_128 cipherSpi = new PBES2Core.HmacSHA1AndAES_128();
            CipherForKeyProtectorS2 cipher = new CipherForKeyProtectorS2(cipherSpi, prod, "PBEWithHmacSHA1And128BitAES");
            cipher.init(2, (Key)skey, params);
            Key retValue = (Key)soForKeyProtectorS2.getObject(cipher);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "unseal", (Object)retValue);
            }
            return retValue;
        }
        catch (IOException ioe) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "unseal", (Throwable)ioe);
            }
            throw new UnrecoverableKeyException(ioe.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "unseal", (Throwable)cnfe);
            }
            throw new UnrecoverableKeyException(cnfe.getMessage());
        }
        catch (InvalidKeyException ike) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "unseal", (Throwable)ike);
            }
            throw new UnrecoverableKeyException(ike.getMessage());
        }
        catch (InvalidKeySpecException ikse) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "unseal", (Throwable)ikse);
            }
            throw new UnrecoverableKeyException(ikse.getMessage());
        }
        catch (NoSuchPaddingException nspe) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "unseal", (Throwable)nspe);
            }
            throw new UnrecoverableKeyException(nspe.getMessage());
        }
        catch (IllegalBlockSizeException ibse) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "unseal", (Throwable)ibse);
            }
            throw new UnrecoverableKeyException(ibse.getMessage());
        }
        catch (InvalidAlgorithmParameterException iape) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "unseal", (Throwable)iape);
            }
            throw new UnrecoverableKeyException(iape.getMessage());
        }
        catch (BadPaddingException bpe) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "unseal", (Throwable)bpe);
            }
            throw new UnrecoverableKeyException(bpe.getMessage());
        }
    }
}

