/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.CipherForKeyProtector;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.PBEKey;
import com.ibm.crypto.hdwrCCA.provider.PBEWithMD5AndTripleDESCipher;
import com.ibm.crypto.hdwrCCA.provider.SealedObjectForKeyProtector;
import com.ibm.crypto.hdwrCCA.provider.SealedTokenForKeyProtector;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

final class KeyProtector {
    private static final int SALT_LEN = 20;
    private static final int DIGEST_LEN = 20;
    private char[] password;
    private byte[] passwdBytes;
    private static Provider prod = Security.getProvider("IBMJCECCA");
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.KeyProtector";

    KeyProtector(char[] password) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "KeyProtector", (Object)password);
        }
        if (password == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "KeyProtector", "password can't be null");
            }
            throw new IllegalArgumentException("password can't be null");
        }
        this.password = password;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "KeyProtector");
        }
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "finalize");
        }
        if (this.passwdBytes != null) {
            Arrays.fill(this.passwdBytes, (byte)0);
            this.passwdBytes = null;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "finalize");
        }
    }

    SealedTokenForKeyProtector protect(byte[] token) throws Exception {
        SecureRandom random = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "protect", (Object)token);
        }
        try {
            random = SecureRandom.getInstance("IBMSecureRandom");
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "protect", e);
            }
            random = new SecureRandom();
        }
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        PBEParameterSpec pbeParmSpec = new PBEParameterSpec(salt, 20);
        PBEKeySpec pbeKSpec = new PBEKeySpec(this.password);
        PBEKey sKey = new PBEKey(pbeKSpec, "PBEWithMD5AndTripleDES");
        Arrays.fill(pbeKSpec.getPassword(), ' ');
        PBEWithMD5AndTripleDESCipher cipher = new PBEWithMD5AndTripleDESCipher();
        cipher.engineInit(1, (Key)sKey, pbeParmSpec, null);
        byte[] encr = cipher.engineDoFinal(token, 0, token.length);
        SealedTokenForKeyProtector sealedToken = new SealedTokenForKeyProtector(encr, pbeParmSpec);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "protect", sealedToken);
        }
        return sealedToken;
    }

    byte[] recover(SealedTokenForKeyProtector sealedToken) throws UnrecoverableKeyException, NoSuchAlgorithmException {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, (Object)className, "recover", sealedToken);
            }
            PBEParameterSpec pbeParamSpec = sealedToken.getParameterSpec();
            PBEKeySpec pbeKSpec = new PBEKeySpec(this.password);
            PBEKey sKey = new PBEKey(pbeKSpec, "PBEWithMD5AndTripleDES");
            Arrays.fill(pbeKSpec.getPassword(), ' ');
            PBEWithMD5AndTripleDESCipher cipher = new PBEWithMD5AndTripleDESCipher();
            cipher.engineInit(2, (Key)sKey, pbeParamSpec, null);
            byte[] token = cipher.engineDoFinal(sealedToken.getEncToken(), 0, sealedToken.getEncToken().length);
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "recover", token);
            }
            return token;
        }
        catch (NoSuchPaddingException nspe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "recover", nspe);
            }
            throw new UnrecoverableKeyException(nspe.getMessage());
        }
        catch (IllegalBlockSizeException ibse) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "recover", ibse);
            }
            throw new UnrecoverableKeyException(ibse.getMessage());
        }
        catch (InvalidParameterException ipe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "recover", ipe);
            }
            throw new UnrecoverableKeyException(ipe.getMessage());
        }
        catch (InvalidAlgorithmParameterException iape) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "recover", iape);
            }
            throw new UnrecoverableKeyException(iape.getMessage());
        }
        catch (InvalidKeyException ike) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "recover", ike);
            }
            throw new UnrecoverableKeyException(ike.getMessage());
        }
        catch (InvalidKeySpecException ikse) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "recover", ikse);
            }
            throw new UnrecoverableKeyException(ikse.getMessage());
        }
        catch (BadPaddingException bpe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "recover", bpe);
            }
            throw new UnrecoverableKeyException(bpe.getMessage());
        }
    }

    SealedObject seal(Key key) throws Exception {
        SecureRandom random = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "seal", key);
        }
        try {
            random = SecureRandom.getInstance("IBMSecureRandom");
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "seal", e);
            }
            random = new SecureRandom();
        }
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 20);
        PBEKeySpec pbeKSpec = new PBEKeySpec(this.password);
        PBEKey sKey = new PBEKey(pbeKSpec, "PBEWithMD5AndTripleDES");
        Arrays.fill(pbeKSpec.getPassword(), ' ');
        PBEWithMD5AndTripleDESCipher cipherSpi = new PBEWithMD5AndTripleDESCipher();
        CipherForKeyProtector cipher = new CipherForKeyProtector(cipherSpi, prod, "PBEWithMD5AndTripleDES");
        cipher.init(1, (Key)sKey, pbeParamSpec);
        SealedObject retValue = new SealedObject(key, cipher);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "seal", retValue);
        }
        return retValue;
    }

    Key unseal(SealedObject so) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, (Object)className, "unseal", so);
            }
            PBEKeySpec pbeKSpec = new PBEKeySpec(this.password);
            PBEKey skey = new PBEKey(pbeKSpec, "PBEWithMD5AndTripleDES");
            Arrays.fill(pbeKSpec.getPassword(), ' ');
            SealedObjectForKeyProtector soForKeyProtector = null;
            soForKeyProtector = !(so instanceof SealedObjectForKeyProtector) ? new SealedObjectForKeyProtector(so) : (SealedObjectForKeyProtector)so;
            AlgorithmParameters params = soForKeyProtector.getParameters();
            if (params == null) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "unseal", "Cannot get algorithm parameters");
                }
                throw new UnrecoverableKeyException("Cannot get algorithm parameters");
            }
            PBEWithMD5AndTripleDESCipher cipherSpi = new PBEWithMD5AndTripleDESCipher();
            CipherForKeyProtector cipher = new CipherForKeyProtector(cipherSpi, prod, "PBEWithMD5AndTripleDES");
            cipher.init(2, (Key)skey, params);
            Key retValue = (Key)soForKeyProtector.getObject(cipher);
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "unseal", retValue);
            }
            return retValue;
        }
        catch (IOException ioe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "unseal", ioe);
            }
            throw new UnrecoverableKeyException(ioe.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "unseal", cnfe);
            }
            throw new UnrecoverableKeyException(cnfe.getMessage());
        }
        catch (InvalidKeyException ike) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "unseal", ike);
            }
            throw new UnrecoverableKeyException(ike.getMessage());
        }
        catch (InvalidKeySpecException ikse) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "unseal", ikse);
            }
            throw new UnrecoverableKeyException(ikse.getMessage());
        }
        catch (NoSuchPaddingException nspe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "unseal", nspe);
            }
            throw new UnrecoverableKeyException(nspe.getMessage());
        }
        catch (IllegalBlockSizeException ibse) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "unseal", ibse);
            }
            throw new UnrecoverableKeyException(ibse.getMessage());
        }
        catch (InvalidAlgorithmParameterException iape) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "unseal", iape);
            }
            throw new UnrecoverableKeyException(iape.getMessage());
        }
        catch (BadPaddingException bpe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "unseal", bpe);
            }
            throw new UnrecoverableKeyException(bpe.getMessage());
        }
    }
}

