/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import java.security.spec.KeySpec;

public class KeyLabelKeySpec
implements KeySpec {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.KeyLabelKeySpec";
    private String label;
    private byte[] labelBytes;

    public KeyLabelKeySpec(String label) throws IllegalArgumentException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "KeyLabelKeySpec", label);
        }
        if (label == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "KeyLabelKeySpec", "Label must not be null.");
                debug.exit(Debug.TYPE_PUBLIC, className, "KeyLabelKeySpec");
            }
            throw new NullPointerException("Label must not be null.");
        }
        if (label.length() > 64) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "KeyLabelKeySpec", "Label length must be 64 characters or less.");
                debug.exit(Debug.TYPE_PUBLIC, className, "KeyLabelKeySpec");
            }
            throw new IllegalArgumentException("Label length must be 64 characters or less.");
        }
        this.label = label.toUpperCase();
        this.labelBytes = "                                                                ".getBytes(PlatformUtilities.CHARSET_IBM_1047);
        byte[] tmp = this.label.getBytes(PlatformUtilities.CHARSET_IBM_1047);
        System.arraycopy(tmp, 0, this.labelBytes, 0, tmp.length);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "KeyLabelKeySpec");
        }
    }

    public String getLabel() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getLabel");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabel", this.label);
        }
        return this.label;
    }

    public byte[] getLabelBytes() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getLabelBytes");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabelBytes", this.labelBytes);
        }
        return this.labelBytes;
    }

    public String getLabelString() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getLabelString");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabelString", this.label);
        }
        return this.label;
    }
}

