/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes;
import com.ibm.crypto.hdwrCCA.provider.ECNamedCurve;
import com.ibm.crypto.hdwrCCA.provider.ECParameters;
import com.ibm.crypto.hdwrCCA.provider.ECPublicKey;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidParameterSpecException;

final class KeyFactoryUtils {
    private static final int maxTokenLength;
    private static Debug debug;
    private static String className;
    private static HexDumpEncoder encoder;

    private KeyFactoryUtils() {
    }

    static byte[] buildExternalPrivateKeyTokenEC(ECPublicKeySpec publicKeySpec, ECPrivateKeySpec privateKeySpec, ECHWKeyAttributes keyAttributes) {
        if (debug != null) {
            Object[] parms = new Object[]{publicKeySpec, privateKeySpec, keyAttributes};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "buildExternalPrivateKeyTokenEC", parms);
        }
        if (publicKeySpec == null || privateKeySpec == null) {
            NullPointerException npe = new NullPointerException("The public or private key specification must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "buildExternalPrivateKeyTokenEC", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "buildExternalPrivateKeyTokenEC");
            }
            throw npe;
        }
        byte[] ruleArray = null;
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(2);
        byte[] kvStructure = new byte[maxTokenLength];
        hikmNativeInteger kvStructureLength = new hikmNativeInteger(0);
        ECParameterSpec parameterSpec = publicKeySpec.getParams();
        int keySize = parameterSpec.getCurve().getField().getFieldSize();
        String curveName = ECNamedCurve.getName(parameterSpec);
        ECNamedCurve.CurveType curveType = ECNamedCurve.getCurveType(curveName);
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "buildExternalPrivateKeyTokenEC", "curveName = " + curveName + ", keySize = " + keySize + ", curveType = " + (Object)((Object)curveType));
        }
        switch (keyAttributes.getKeyUsage()) {
            case 3: {
                ruleArray = PlatformUtilities.getBytesPlatform("ECC-PAIRSIG-ONLY");
                break;
            }
            case 4: {
                if (!HardwareProfile.isECCDiffieHellmanSupported()) {
                    InternalError ie = new InternalError("Key management functionalities are not supported for Elliptic Curve keys on current level of ICSF");
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "buildExternalPrivateKeyTokenEC", ie);
                        debug.exit(Debug.TYPE_PUBLIC, className, "buildExternalPrivateKeyTokenEC");
                    }
                    throw ie;
                }
                ruleArray = PlatformUtilities.getBytesPlatform("ECC-PAIRKEY-MGMT");
                break;
            }
            default: {
                ruleArray = ECHWKeyAttributes.DEFAULT_USAGE == 3 ? PlatformUtilities.getBytesPlatform("ECC-PAIRSIG-ONLY") : PlatformUtilities.getBytesPlatform("ECC-PAIRKEY-MGMT");
            }
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "buildExternalPrivateKeyTokenEC", "ruleArray = " + new String(ruleArray));
        }
        int i = 0;
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb.put(curveType.byteValue());
        bb.put((byte)0);
        KeyFactoryUtils.copyShortToArray(bb.getShort(0), kvStructure, i);
        KeyFactoryUtils.copyShortToArray((short)keySize, kvStructure, i += 2);
        BigInteger s = privateKeySpec.getS();
        byte[] dVal = KeyFactoryUtils.trimZeroes(s.toByteArray());
        KeyFactoryUtils.copyShortToArray((short)dVal.length, kvStructure, i += 2);
        i += 2;
        ECPoint w = publicKeySpec.getW();
        byte[] qVal = null;
        try {
            qVal = ECParameters.encodePoint(w, parameterSpec.getCurve());
        }
        catch (IOException e) {
            RuntimeException re = new RuntimeException("Unable to build an Elliptic Curve key token with a clear private key", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "buildExternalPrivateKeyTokenEC", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "buildExternalPrivateKeyTokenEC", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "buildExternalPrivateKeyTokenEC");
            }
            throw re;
        }
        KeyFactoryUtils.copyShortToArray((short)qVal.length, kvStructure, i);
        System.arraycopy(dVal, 0, kvStructure, i += 2, dVal.length);
        System.arraycopy(qVal, 0, kvStructure, i += dVal.length, qVal.length);
        kvStructureLength.setValue(i += qVal.length);
        kvStructure = KeyFactoryUtils.trimToken(kvStructure, kvStructureLength.getValue());
        byte[] externalPrivateKeyToken = KeyFactoryUtils.pkaKeyTokenBuild(ruleArray, ruleArrayCount, kvStructure, kvStructureLength);
        KeyFactoryUtils.arrayFill(kvStructure, (byte)32);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "buildExternalPrivateKeyTokenEC", externalPrivateKeyToken);
        }
        return externalPrivateKeyToken;
    }

    static ECPublicKey extractPublicKeyEC(byte[] privateKeyTokenOrLabel) throws InvalidKeyException {
        byte[] token;
        ByteBuffer byteBuffer = null;
        ECNamedCurve.CurveType curveType = null;
        byte[] publicQValue = null;
        ECPoint w = null;
        ECParameterSpec parameterSpec = null;
        ECPublicKey publicKey = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "extractPublicKeyEC", (Object)privateKeyTokenOrLabel);
        }
        if ((token = KeyFactoryUtils.pkaPublicKeyExtract(privateKeyTokenOrLabel))[8] != 33 && token[9] != 0) {
            InvalidKeyException ike = new InvalidKeyException("Public key token is not an Elliptic Curve token. id = " + token[8] + " version = " + token[9]);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "extractPublicKeyEC", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "extractPublicKeyEC");
            }
            throw ike;
        }
        curveType = ECNamedCurve.CurveType.valueOf(token[16]);
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "extractPublicKeyEC", "curveType = " + (Object)((Object)curveType));
        }
        byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.put(token[18]).put(token[19]);
        short keySize = byteBuffer.getShort(0);
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "extractPublicKeyEC", "keySize = " + keySize);
        }
        byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.put(token[20]).put(token[21]);
        short publicQLength = byteBuffer.getShort(0);
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "extractPublicKeyEC", "publicQLength = " + publicQLength);
        }
        publicQValue = new byte[publicQLength];
        System.arraycopy(token, 22, publicQValue, 0, publicQLength);
        parameterSpec = ECNamedCurve.getECParameterSpec(curveType, keySize);
        if (parameterSpec == null) {
            InvalidKeyException ike = new InvalidKeyException("Public key token is of unknown type, curveType = " + (Object)((Object)curveType) + ", fieldSize = " + keySize);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "extractPublicKeyEC", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "extractPublicKeyEC");
            }
            throw ike;
        }
        try {
            w = ECParameters.decodePoint(publicQValue, parameterSpec.getCurve());
        }
        catch (IOException e) {
            InvalidKeyException ike = new InvalidKeyException("Invalid Elliptic Curve key", e);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "extractPublicKeyEC", "publicQValue = \n" + encoder.encodeBuffer(publicQValue));
                debug.exception(Debug.TYPE_PUBLIC, className, "extractPublicKeyEC", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "extractPublicKeyEC", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "extractPublicKeyEC");
            }
            throw ike;
        }
        try {
            publicKey = new ECPublicKey(token, w, parameterSpec);
        }
        catch (InvalidParameterSpecException e) {
            InvalidKeyException ike = new InvalidKeyException("Invalid Elliptic Curve parameters", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "extractPublicKeyEC", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "extractPublicKeyEC", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "extractPublicKeyEC");
            }
            throw ike;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "extractPublicKeyEC", publicKey);
        }
        return publicKey;
    }

    private static byte[] pkaKeyTokenBuild(byte[] ruleArray, hikmNativeInteger ruleArrayCount, byte[] keyValueStructure, hikmNativeInteger keyValueStructureLength) {
        if (debug != null) {
            Object[] parms = new Object[]{ruleArray, ruleArrayCount, keyValueStructure, keyValueStructureLength};
            debug.entry(8192L, (Object)className, "pkaKeyTokenBuild", parms);
        }
        HIKM hikm = new HIKM();
        byte[] userDefData = new byte[]{};
        byte[] reserved2 = new byte[]{};
        byte[] reserved3 = new byte[]{};
        byte[] reserved4 = new byte[]{};
        byte[] reserved5 = new byte[]{};
        byte[] privateKeyName = new byte[]{};
        byte[] exitData = new byte[]{};
        byte[] token = new byte[maxTokenLength];
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger userDefDataLen = new hikmNativeInteger(0);
        hikmNativeInteger reserved2Length = new hikmNativeInteger(0);
        hikmNativeInteger reserved3Length = new hikmNativeInteger(0);
        hikmNativeInteger reserved4Length = new hikmNativeInteger(0);
        hikmNativeInteger reserved5Length = new hikmNativeInteger(0);
        hikmNativeInteger privateKeyNameLength = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger tokenLength = new hikmNativeInteger(maxTokenLength);
        byte[] ruleArrayCopy = (byte[])ruleArray.clone();
        if (null != debug) {
            String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArrayCopy);
            String keyValStructString = "\n" + encoder.encodeBuffer(keyValueStructure);
            String privKeyNameString = "\n" + encoder.encodeBuffer(privateKeyName);
            String userDefDataString = encoder.encodeBuffer(userDefData);
            String parmsReport = "\nKeyFactoryUtils: CSNDPKB INPUT PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    ruleArrayCount : " + ruleArrayCount.getValue() + "\n    ruleArray      : " + ruleArrayString + "\n    keyValStructLen: " + keyValueStructureLength.getValue() + "\n    keyValStruct   : " + keyValStructString + "\n    privKeyNameLen : " + privateKeyNameLength.getValue() + "\n    privKeyName    : " + privKeyNameString + "\n    userDefDataLen : " + userDefDataLen + "\n    userDefData    : " + userDefDataString + "\n    keyTokenLength : " + tokenLength.getValue() + "\n";
            debug.text(Debug.TYPE_FINEST, className, "pkaKeyTokenBuild", parmsReport);
        }
        try {
            hikm.CSNDPKBJ(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArrayCopy, keyValueStructureLength, keyValueStructure, privateKeyNameLength, privateKeyName, userDefDataLen, userDefData, reserved2Length, reserved2, reserved3Length, reserved3, reserved4Length, reserved4, reserved5Length, reserved5, tokenLength, token);
        }
        catch (IllegalArgumentException e) {
            RuntimeException re = new RuntimeException("Hardware error from call CSNDPKB " + e, e);
            if (debug != null) {
                debug.exception(8192L, className, "pkaKeyTokenBuild", e);
                debug.exception(8192L, className, "pkaKeyTokenBuild", re);
                debug.exit(8192L, className, "pkaKeyTokenBuild");
            }
            throw re;
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "pkaKeyTokenBuild", "CSNDPKB: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
        }
        token = KeyFactoryUtils.trimToken(token, tokenLength.getValue());
        if (null != debug) {
            String tokenString = "\n" + encoder.encodeBuffer(token);
            String parmsReport = "\nKeyFactoryUtils: CSNDPKB RETURN PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    keyTokenLength : " + tokenLength.getValue() + "\n    token          : " + tokenString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "pkaKeyTokenBuild", parmsReport);
        }
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNDPKB", "Hardware error from call CSNDPKB, returnCode = " + returnCode.getValue() + ", reasonCode = " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(8192L, className, "pkaKeyTokenBuild", re);
                debug.exit(8192L, className, "pkaKeyTokenBuild");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "pkaKeyTokenBuild", token);
        }
        return token;
    }

    private static byte[] pkaPublicKeyExtract(byte[] sourceKeyIdentifier) {
        String parmsReport;
        String exitDataString;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "pkaPublicKeyExtract", (Object)sourceKeyIdentifier);
        }
        HIKM hikm = new HIKM();
        byte[] exitData = new byte[]{};
        byte[] ruleArray = new byte[]{};
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(0);
        hikmNativeInteger sourceKeyTokenLength = new hikmNativeInteger(sourceKeyIdentifier.length);
        byte[] sourceKeyToken = (byte[])sourceKeyIdentifier.clone();
        if (PlatformUtilities.isZOS()) {
            sourceKeyToken = PlatformUtilities.convertBytesIfKeyLabelATOE(sourceKeyToken);
        }
        byte[] targetKeyToken = new byte[maxTokenLength];
        hikmNativeInteger targetKeyTokenLength = new hikmNativeInteger(maxTokenLength);
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(exitData);
            String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
            String sourceTokenString = "\n" + encoder.encodeBuffer(sourceKeyToken);
            parmsReport = "\nKeyFactoryUtils: CSNDPKX INPUT PARAMETERS \n    returnCode        : " + returnCode.getValue() + "\n    reasonCode        : " + reasonCode.getValue() + "\n    exitDataLen       : " + exitDataLength.getValue() + "\n    exitData          : " + exitDataString + "\n    ruleArrayCount    : " + ruleArrayCount.getValue() + "\n    ruleArray         : " + ruleArrayString + "\n    sourceKeyTokenLen : " + sourceKeyTokenLength.getValue() + "\n    sourceKeyToken    : " + sourceTokenString + "\n    targetKeyTokenLen : " + targetKeyTokenLength.getValue() + "\n";
            debug.text(Debug.TYPE_FINEST, className, "pkaPublicKeyExtract", parmsReport);
        }
        try {
            hikm.CSNDPKXJ(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, sourceKeyTokenLength, sourceKeyToken, targetKeyTokenLength, targetKeyToken);
        }
        catch (IllegalArgumentException e) {
            RuntimeException re = new RuntimeException("Hardware error from call CSNDPKX " + e, e);
            if (debug != null) {
                debug.exception(8192L, className, "pkaPublicKeyExtract", e);
                debug.exception(8192L, className, "pkaPublicKeyExtract", re);
                debug.exit(8192L, className, "pkaPublicKeyExtract");
            }
            throw re;
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "pkaPublicKeyExtract", "CSNDPKX: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
        }
        targetKeyToken = KeyFactoryUtils.trimToken(targetKeyToken, targetKeyTokenLength.getValue());
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(exitData);
            String sourceTokenString = "\n" + encoder.encodeBuffer(sourceKeyToken);
            String targetTokenString = "\n" + encoder.encodeBuffer(targetKeyToken);
            parmsReport = "\nKeyFactoryUtils: CSNDPKX RETURN PARAMETERS \n    returnCode        : " + returnCode.getValue() + "\n    reasonCode        : " + reasonCode.getValue() + "\n    exitDataLen       : " + exitDataLength.getValue() + "\n    exitData          : " + exitDataString + "\n    sourceKeyTokenLen : " + sourceKeyTokenLength.getValue() + "\n    sourceKeyToken    : " + sourceTokenString + "\n    targetKeyTokenLen : " + targetKeyTokenLength.getValue() + "\n    targetKeyToken    : " + targetTokenString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "pkaPublicKeyExtract", parmsReport);
        }
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNDPKX", "Hardware error from call CSNDPKX, returnCode = " + returnCode.getValue() + ", reasonCode = " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(8192L, className, "pkaPublicKeyExtract", re);
                debug.exit(8192L, className, "pkaPublicKeyExtract");
            }
            throw re;
        }
        KeyFactoryUtils.arrayFill(sourceKeyToken, (byte)32);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "pkaPublicKeyExtract", targetKeyToken);
        }
        return targetKeyToken;
    }

    private static byte[] trimToken(byte[] token, int length) {
        if (debug != null) {
            Object[] parms = new Object[]{token, new Integer(length)};
            debug.entry(8192L, (Object)className, "trimToken", parms);
        }
        if (length > token.length || length < 0) {
            RuntimeException re = new RuntimeException("Invalid length for token trim. Current token length: " + token.length + ". Real token length: " + length);
            if (debug != null) {
                debug.exception(8192L, className, "trimToken", re);
                debug.exit(8192L, className, "trimToken");
            }
            throw re;
        }
        if (length == 0) {
            if (debug != null) {
                debug.text(8192L, className, "trimToken", "Trim length is 0, so returning the old byte array");
                debug.exit(8192L, (Object)className, "trimToken", token);
            }
            return token;
        }
        byte[] trimmedToken = new byte[length];
        if (debug != null) {
            debug.text(8192L, className, "trimToken", "token size before trim: " + token.length);
        }
        System.arraycopy(token, 0, trimmedToken, 0, length);
        if (debug != null) {
            debug.text(8192L, className, "trimToken", "trimmedToken size after trim: " + trimmedToken.length);
        }
        KeyFactoryUtils.arrayFill(token, (byte)32);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "trimToken", trimmedToken);
        }
        return trimmedToken;
    }

    private static void arrayFill(byte[] array, byte ch) {
        if (debug != null) {
            Object[] parms = new Object[]{array, new Byte(ch)};
            debug.entry(8192L, (Object)className, "arrayFill", parms);
        }
        for (int x = 0; x < array.length; ++x) {
            array[x] = ch;
        }
        if (debug != null) {
            debug.exit(8192L, className, "arrayFill");
        }
    }

    private static void copyShortToArray(short s, byte[] array, int offset) {
        Short sTemp;
        BigInteger temp;
        int i = 0;
        if (debug != null) {
            Object[] parms = new Object[]{new Short(s), array, new Integer(offset)};
            debug.entry(8192L, (Object)className, "copyShortToArray", parms);
        }
        if ((temp = new BigInteger((sTemp = new Short(s)).toString())).toByteArray().length != 2) {
            array[offset] = 0;
            i = offset + 1;
        } else {
            i = offset;
        }
        System.arraycopy(temp.toByteArray(), 0, array, i, temp.toByteArray().length);
        if (debug != null) {
            debug.exit(8192L, className, "copyShortToArray");
        }
    }

    private static byte[] trimZeroes(byte[] b) {
        int i = 0;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "trimZeroes", (Object)b);
        }
        while (i < b.length - 1 && b[i] == 0) {
            ++i;
        }
        if (i == 0) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "trimZeroes", b);
            }
            return b;
        }
        byte[] t = new byte[b.length - i];
        System.arraycopy(b, i, t, 0, t.length);
        if (debug != null) {
            debug.entry(8192L, (Object)className, "trimZeroes", (Object)t);
        }
        return t;
    }

    static {
        debug = Debug.getInstance("ibmjcecca");
        className = "com.ibm.crypto.hdwrCCA.provider.KeyFactoryUtils";
        encoder = debug != null ? new HexDumpEncoder() : null;
        boolean is4096RNGLSupported = HardwareProfile.getIs4096RNGLSupported();
        int n = maxTokenLength = is4096RNGLSupported ? 3500 : 2500;
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC | 0x8000L, className, "KeyFactoryUtils", HardwareProfile.getICSFlevel() + ": 4096RNGLSupported = " + is4096RNGLSupported);
        }
    }
}

