/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.ECPublicKey;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyUtils;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.security.InvalidParameterException;
import java.util.Arrays;

final class KeyAgreementUtils {
    private static final HIKM HIKM = new HIKM();
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.KeyAgreementUtils";
    private static HexDumpEncoder encoder = null;

    private KeyAgreementUtils() {
        throw new UnsupportedOperationException("Cannot instantiate");
    }

    static final byte[] generateSharedSecretECDH(ECPublicKey publicKey, ECPrivateHWKey privateKey) {
        byte[] privateKeyIdentifier;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "generateSharedSecretECDH", publicKey, privateKey);
        }
        if ((privateKeyIdentifier = privateKey.getExternalKeyToken()) == null) {
            privateKeyIdentifier = privateKey.getToken();
        }
        byte[] publicKeyIdentifier = publicKey.getToken();
        if (PlatformUtilities.isZOS()) {
            privateKeyIdentifier = PlatformUtilities.convertBytesIfKeyLabelATOE(privateKeyIdentifier);
            publicKeyIdentifier = PlatformUtilities.convertBytesIfKeyLabelATOE(publicKeyIdentifier);
        }
        int keyBitLength = 0;
        String ruleArray = "PASSTHRU";
        int ruleArrayCount = 1;
        byte[] sharedSecret = KeyAgreementUtils.eccDiffieHellman(ruleArray, ruleArrayCount, privateKeyIdentifier, publicKeyIdentifier, null, keyBitLength, null);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "generateSharedSecretECDH", sharedSecret);
        }
        return sharedSecret;
    }

    static final byte[] eccDiffieHellman(String ruleArrayString, int ruleArrayCount, byte[] privateKeyIdentifier, byte[] publicKeyIdentifier, byte[] partyIdentifier, int keyBitLength, byte[] outputKeyIdentifier) {
        String exitDataString;
        InvalidParameterException ipe;
        if (debug != null) {
            Object[] parms = new Object[]{ruleArrayString, ruleArrayCount, privateKeyIdentifier, publicKeyIdentifier, partyIdentifier, keyBitLength, outputKeyIdentifier};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "eccDiffieHellman", parms);
        }
        if (ruleArrayString == null || privateKeyIdentifier == null || publicKeyIdentifier == null) {
            NullPointerException npe = new NullPointerException("One or more required parameter is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "eccDiffieHellman", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "eccDiffieHellman");
            }
            throw npe;
        }
        if (8 * ruleArrayCount != ruleArrayString.length()) {
            ipe = new InvalidParameterException("ruleArrayCount does not match the number of keywords in ruleArray");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "eccDiffieHellman", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "eccDiffieHellman");
            }
            throw ipe;
        }
        if (partyIdentifier != null && partyIdentifier.length != 0 && (partyIdentifier.length < 8 || partyIdentifier.length > 64)) {
            ipe = new InvalidParameterException("Valid lengths for partyIdentifier are 0, or between 8 and 64");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "eccDiffieHellman", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "eccDiffieHellman");
            }
            throw ipe;
        }
        if (keyBitLength != 0 && (keyBitLength < 64 || keyBitLength > 2048)) {
            ipe = new InvalidParameterException("Valid values for keyBitLength are 0, or between 64 and 2048");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "eccDiffieHellman", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "eccDiffieHellman");
            }
            throw ipe;
        }
        if (outputKeyIdentifier != null && outputKeyIdentifier.length > 900) {
            ipe = new InvalidParameterException("Exceeded maximum length of outputKeyIdentifier at 900");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "eccDiffieHellman", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "eccDiffieHellman");
            }
            throw ipe;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger nativeRuleArrayCount = new hikmNativeInteger(ruleArrayCount);
        hikmNativeInteger privateKeyIdentifierLength = new hikmNativeInteger(privateKeyIdentifier.length);
        hikmNativeInteger privateKEKKeyIdentifierLength = new hikmNativeInteger(0);
        hikmNativeInteger publicKeyIdentifierLength = new hikmNativeInteger(publicKeyIdentifier.length);
        hikmNativeInteger chainingVectorLength = new hikmNativeInteger(0);
        hikmNativeInteger nativeKeyBitLength = new hikmNativeInteger(keyBitLength);
        hikmNativeInteger reserved1Length = new hikmNativeInteger(0);
        hikmNativeInteger reserved2Length = new hikmNativeInteger(0);
        hikmNativeInteger reserved3Length = new hikmNativeInteger(0);
        hikmNativeInteger reserved4Length = new hikmNativeInteger(0);
        hikmNativeInteger reserved5Length = new hikmNativeInteger(0);
        hikmNativeInteger outputKEKKeyIdentifierLength = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        byte[] ruleArray = PlatformUtilities.getBytesPlatform(ruleArrayString);
        byte[] privateKEKKeyIdentifier = new byte[]{};
        byte[] chainingVector = new byte[]{};
        byte[] reserved1 = new byte[]{};
        byte[] reserved2 = new byte[]{};
        byte[] reserved3 = new byte[]{};
        byte[] reserved4 = new byte[]{};
        byte[] reserved5 = new byte[]{};
        byte[] outputKEKKeyIdentifier = new byte[]{};
        byte[] privateKeyIdentifierCopy = (byte[])privateKeyIdentifier.clone();
        byte[] publicKeyIdentifierCopy = (byte[])publicKeyIdentifier.clone();
        byte[] partyIdentifierCopy = partyIdentifier == null ? new byte[]{} : (byte[])partyIdentifier.clone();
        hikmNativeInteger partyIdentifierLength = new hikmNativeInteger(partyIdentifierCopy.length);
        byte[] outputKeyIdentifierCopy = outputKeyIdentifier == null ? new byte[900] : (byte[])outputKeyIdentifier.clone();
        hikmNativeInteger outputKeyIdentifierLength = new hikmNativeInteger(outputKeyIdentifierCopy.length);
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(exitData);
            String ruleArrayHexString = "\n" + encoder.encodeBuffer(ruleArray);
            String privateKeyIdentifierString = "\n" + encoder.encodeBuffer(privateKeyIdentifierCopy);
            String privateKEKKeyIdentifierString = "\n" + encoder.encodeBuffer(privateKEKKeyIdentifier);
            String publicKeyIdentifierString = "\n" + encoder.encodeBuffer(publicKeyIdentifierCopy);
            String outputKEKKeyIdentifierString = "\n" + encoder.encodeBuffer(outputKEKKeyIdentifier);
            String outputKeyIdentifierString = "\n" + encoder.encodeBuffer(outputKeyIdentifierCopy);
            String parmsReport = "\nKeyAgreementUtils: CSNDEDH INPUT PARAMETERS \n    exitDataLen               : " + exitDataLength.getValue() + "\n    exitData                  : " + exitDataString + "\n    ruleArrayCount            : " + nativeRuleArrayCount.getValue() + "\n    ruleArray                 : " + ruleArrayHexString + "\n    privateKeyIdentifierLen   : " + privateKeyIdentifierLength.getValue() + "\n    privateKeyIdentifier      : " + privateKeyIdentifierString + "\n    privateKEKKeyIdentifierLen: " + privateKEKKeyIdentifierLength.getValue() + "\n    privateKEKKeyIdentifier   : " + privateKEKKeyIdentifierString + "\n    publicKeyIdentifierLen    : " + publicKeyIdentifierLength.getValue() + "\n    publicKeyIdentifier       : " + publicKeyIdentifierString + "\n    chainingVectorLen         : " + chainingVectorLength.getValue() + "\n    partyIdentifierLen        : " + partyIdentifierLength.getValue() + "\n    partyIdentifier           : XXX\n    keyBitLen                 : " + nativeKeyBitLength.getValue() + "\n    reserved1Length           : " + reserved1Length.getValue() + "\n    reserved2Length           : " + reserved2Length.getValue() + "\n    reserved3Length           : " + reserved3Length.getValue() + "\n    reserved4Length           : " + reserved4Length.getValue() + "\n    reserved5Length           : " + reserved5Length.getValue() + "\n    outputKEKKeyIdentifierLen : " + outputKEKKeyIdentifierLength.getValue() + "\n    outputKEKKeyIdentifier    : " + outputKEKKeyIdentifierString + "\n    outputKeyIdentifierLen    : " + outputKeyIdentifierLength.getValue() + "\n    outputKeyIdentifier       : " + outputKeyIdentifierString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "eccDiffieHellman", parmsReport);
        }
        try {
            HIKM.CSNDEDHJ(returnCode, reasonCode, exitDataLength, exitData, nativeRuleArrayCount, ruleArray, privateKeyIdentifierLength, privateKeyIdentifierCopy, privateKEKKeyIdentifierLength, privateKEKKeyIdentifier, publicKeyIdentifierLength, publicKeyIdentifierCopy, chainingVectorLength, chainingVector, partyIdentifierLength, partyIdentifierCopy, nativeKeyBitLength, reserved1Length, reserved1, reserved2Length, reserved2, reserved3Length, reserved3, reserved4Length, reserved4, reserved5Length, reserved5, outputKEKKeyIdentifierLength, outputKEKKeyIdentifier, outputKeyIdentifierLength, outputKeyIdentifierCopy);
        }
        catch (IllegalArgumentException e) {
            RuntimeException re = new RuntimeException("Hardware error from call CSNDEDH " + e, e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "eccDiffieHellman", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "eccDiffieHellman");
            }
            throw re;
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "eccDiffieHellman", "CSNDEDH: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
        }
        outputKeyIdentifierCopy = SymmetricKeyUtils.trimSensitiveData(outputKeyIdentifierCopy, outputKeyIdentifierLength.getValue());
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(exitData);
            String outputKEKKeyIdentifierString = "\n" + encoder.encodeBuffer(outputKEKKeyIdentifier);
            String parmsReport = "\nKeyAgreementUtils: CSNDEDH RETURN PARAMETERS \n    returnCode                : " + returnCode.getValue() + "\n    reasonCode                : " + reasonCode.getValue() + "\n    exitDataLen               : " + exitDataLength.getValue() + "\n    exitData                  : " + exitDataString + "\n    chainingVectorLen         : " + chainingVectorLength.getValue() + "\n    partyIdentifierLen        : " + partyIdentifierLength.getValue() + "\n    partyIdentifier           : XXX\n    keyBitLen                 : " + nativeKeyBitLength.getValue() + "\n    reserved1Length           : " + reserved1Length.getValue() + "\n    reserved2Length           : " + reserved2Length.getValue() + "\n    reserved3Length           : " + reserved3Length.getValue() + "\n    reserved4Length           : " + reserved4Length.getValue() + "\n    reserved5Length           : " + reserved5Length.getValue() + "\n    outputKEKKeyIdentifier    : " + outputKEKKeyIdentifierString + "\n    outputKeyIdentifierLen    : " + outputKeyIdentifierLength.getValue() + "\n    outputKeyIdentifier       : XXX\n";
            debug.text(Debug.TYPE_FINEST, className, "eccDiffieHellman", parmsReport);
        }
        Arrays.fill(privateKeyIdentifierCopy, (byte)0);
        Arrays.fill(publicKeyIdentifierCopy, (byte)0);
        Arrays.fill(partyIdentifierCopy, (byte)0);
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNDEDH", "Hardware error from call CSNDEDH returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "eccDiffieHellman", re);
                debug.exit(Debug.TYPE_PUBLIC, className, "eccDiffieHellman");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "eccDiffieHellman", outputKeyIdentifierCopy);
        }
        return outputKeyIdentifierCopy;
    }

    static {
        if (debug != null) {
            encoder = new HexDumpEncoder();
        }
    }
}

