/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyConstants;
import java.security.spec.AlgorithmParameterSpec;

public class KDFParameterSpec
implements AlgorithmParameterSpec {
    private static final int MINIMUM_KEY_SIZE = 56;
    private static final int MAXIMUM_KEY_SIZE = 2048;
    private static final int MINIMUM_SHARED_INFO_LENGTH = 8;
    private static final int MAXIMUM_SHARED_INFO_LENGTH = 64;
    private final int keySize;
    private final byte[] sharedInfo;
    private final SymmetricKeyConstants.KeyType keyType;
    private final String ckdsLabel;
    private final SymmetricKeyConstants.KeyUsage keyUsage;
    private boolean NoCvKEKOption = false;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String classname = "com.ibm.crypto.hdwrCCA.provider.KDFParameterSpec";

    public KDFParameterSpec(int keySize, byte[] sharedInfo) {
        this(keySize, sharedInfo, null, null, null, false);
    }

    public KDFParameterSpec(int keySize, byte[] sharedInfo, SymmetricKeyConstants.KeyType keyType, String ckdsLabel, SymmetricKeyConstants.KeyUsage keyUsage) {
        this(keySize, sharedInfo, keyType, ckdsLabel, keyUsage, false);
    }

    public KDFParameterSpec(int keySize, byte[] sharedInfo, SymmetricKeyConstants.KeyType keyType, String ckdsLabel, SymmetricKeyConstants.KeyUsage keyUsage, boolean NoCvKEK) {
        if (debug != null) {
            Object[] parms = new Object[]{keySize, sharedInfo, keyType, ckdsLabel, keyUsage, NoCvKEK};
            debug.entry(Debug.TYPE_FINE, (Object)classname, "KDFParameterSpec", parms);
        }
        if (keySize < 56 || keySize > 2048) {
            IllegalArgumentException iae = new IllegalArgumentException("Key size must be between 56 and 2048");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, classname, "KDFParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, classname, "KDFParameterSpec");
            }
            throw iae;
        }
        byte[] sharedInfoCopy = null;
        if (sharedInfo != null && ((sharedInfoCopy = (byte[])sharedInfo.clone()).length < 8 || sharedInfoCopy.length > 64)) {
            IllegalArgumentException iae = new IllegalArgumentException("Shared info must be between 8 and 64 bytes long");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, classname, "KDFParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, classname, "KDFParameterSpec");
            }
            throw iae;
        }
        if (keyType == SymmetricKeyConstants.KeyType.CLEAR) {
            IllegalArgumentException iae = new IllegalArgumentException("Deriving CLEAR keys is not supported");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, classname, "KDFParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, classname, "KDFParameterSpec");
            }
            throw iae;
        }
        if (ckdsLabel != null && ckdsLabel.length() > 64) {
            IllegalArgumentException iae = new IllegalArgumentException("CKDS label must contain 64 characters or less");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, classname, "KDFParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, classname, "KDFParameterSpec");
            }
            throw iae;
        }
        if (keyUsage != null && !SymmetricKeyConstants.KeyUsage.singleKeys().contains((Object)keyUsage)) {
            IllegalArgumentException iae = new IllegalArgumentException("Key usage must represent a single key");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, classname, "KDFParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, classname, "KDFParameterSpec");
            }
            throw iae;
        }
        if (NoCvKEK) {
            if (keyUsage != SymmetricKeyConstants.KeyUsage.OP_IMPORTER && keyUsage != SymmetricKeyConstants.KeyUsage.OP_EXPORTER) {
                IllegalArgumentException iae = new IllegalArgumentException("The NoCvKEK option is only allowed for a key with usage OP_IMPORTER or OP_EXPORTER key in the CKDS");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, classname, "KDFParameterSpec", iae);
                    debug.exit(Debug.TYPE_FINE, classname, "KDFParameterSpec");
                }
                throw iae;
            }
            if (keyType != SymmetricKeyConstants.KeyType.CKDS) {
                IllegalArgumentException iae = new IllegalArgumentException("The NoCvKEK option is only allowed for a key encrypting key in the CKDS");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, classname, "KDFParameterSpec", iae);
                    debug.exit(Debug.TYPE_FINE, classname, "KDFParameterSpec");
                }
                throw iae;
            }
        }
        this.keySize = keySize;
        this.sharedInfo = sharedInfoCopy;
        this.keyType = keyType;
        this.ckdsLabel = ckdsLabel;
        this.keyUsage = keyUsage;
        this.NoCvKEKOption = NoCvKEK;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, classname, "KDFParameterSpec");
        }
    }

    public int getKeySize() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)classname, "getKeySize", this.keySize);
        }
        return this.keySize;
    }

    public byte[] getSharedInfo() {
        byte[] returnSharedInfo = null;
        if (this.sharedInfo != null) {
            returnSharedInfo = (byte[])this.sharedInfo.clone();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)classname, "getSharedInfo", returnSharedInfo);
        }
        return returnSharedInfo;
    }

    public SymmetricKeyConstants.KeyType getKeyType() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)classname, "getKeyType", (Object)this.keyType);
        }
        return this.keyType;
    }

    public String getCKDSLabel() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)classname, "getCKDSLabel", this.ckdsLabel);
        }
        return this.ckdsLabel;
    }

    public SymmetricKeyConstants.KeyUsage getKeyUsage() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)classname, "getKeyUsage", (Object)this.keyUsage);
        }
        return this.keyUsage;
    }

    public boolean getNoCvKEK() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)classname, "getNoCvKEK", this.NoCvKEKOption);
        }
        return this.NoCvKEKOption;
    }
}

