/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.CrtToken;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKeySpec;
import com.ibm.crypto.hdwrCCA.provider.HWKeyEntryRACF;
import com.ibm.crypto.hdwrCCA.provider.KeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.KeyProtector;
import com.ibm.crypto.hdwrCCA.provider.KeyStoreUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.RSAPSSKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.TrustedCertEntryRACF;
import com.ibm.crypto.hdwrCCA.provider.WrapperKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.security.rsa.RSAUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.SecretKey;

public final class JceRACFKeyStore
extends KeyStoreSpi {
    private static final int JCERACFKS_MAGIC = 306006735;
    private static final String EYE_CATCHER = "JCECCARACFKS";
    private static final int VERSION_1 = 1;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.JceRACFKeyStore";
    private Hashtable<String, Object> entries = new Hashtable();
    private Hashtable<String, Object> deletedEntries = new Hashtable();
    private KeyHWAttributes keyAttrs = null;

    @Override
    public Key engineGetKey(String alias, char[] passwd) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        PrivateKey key;
        block19: {
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, className, "engineGetKey", alias, passwd);
            }
            key = null;
            if (alias == null) {
                IllegalArgumentException iae = new IllegalArgumentException("alias can't be null");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", iae);
                    debug.exit(Debug.TYPE_FINE, className, "engineGetKey");
                }
                throw iae;
            }
            char[] password = passwd == null ? "password".toCharArray() : passwd;
            KeyProtector keyProtector = new KeyProtector(password);
            Object entry = this.aliasLookUp(alias);
            if (entry == null || entry instanceof TrustedCertEntryRACF) {
                return null;
            }
            if (entry instanceof HWKeyEntryRACF) {
                HWKeyEntryRACF hwEntryRACF = (HWKeyEntryRACF)entry;
                byte[] token = keyProtector.recover(hwEntryRACF.encToken);
                try {
                    if (hwEntryRACF.keyType == 1 || hwEntryRACF.keyType == 2 || hwEntryRACF.keyType == 3) {
                        if (hwEntryRACF.externalKeyToken != null) {
                            byte[] extToken = keyProtector.recover(hwEntryRACF.externalKeyToken);
                            key = hwEntryRACF.keyAttribs instanceof RSAPSSKeyHWAttributes ? new RSAPrivateHWKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)RSAUtil.KeyType.PSS, null), token, extToken, (RSAPSSKeyHWAttributes)hwEntryRACF.keyAttribs) : new RSAPrivateHWKey(token, extToken, (RSAKeyHWAttributes)hwEntryRACF.keyAttribs);
                        } else {
                            key = hwEntryRACF.keyAttribs instanceof RSAPSSKeyHWAttributes ? new RSAPrivateHWKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)RSAUtil.KeyType.PSS, null), token, (RSAKeyHWAttributes)((RSAPSSKeyHWAttributes)hwEntryRACF.keyAttribs)) : new RSAPrivateHWKey(token, (RSAKeyHWAttributes)hwEntryRACF.keyAttribs);
                        }
                        break block19;
                    }
                    if (hwEntryRACF.keyType != 7 && hwEntryRACF.keyType != 9) break block19;
                    ECPrivateHWKeySpec keySpec = null;
                    ECPublicKey publicKey = (ECPublicKey)hwEntryRACF.chain[0].getPublicKey();
                    ECParameterSpec paramSpec = publicKey.getParams();
                    ECHWKeyAttributes keyAttributes = (ECHWKeyAttributes)hwEntryRACF.keyAttribs;
                    if (hwEntryRACF.externalKeyToken != null) {
                        byte[] extToken = keyProtector.recover(hwEntryRACF.externalKeyToken);
                        keySpec = new ECPrivateHWKeySpec(extToken, paramSpec, keyAttributes.getKeyType(), keyAttributes.getKeyUsage());
                    } else {
                        keySpec = new ECPrivateHWKeySpec(token, paramSpec, keyAttributes.getKeyType(), keyAttributes.getKeyUsage());
                    }
                    KeyFactory keyFactory = null;
                    try {
                        keyFactory = KeyFactory.getInstance("EC", "IBMJCECCA");
                    }
                    catch (NoSuchProviderException e) {
                        RuntimeException re = new RuntimeException("Internal error, no IBMJCECCA provider", e);
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", e);
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", re);
                            debug.exit(Debug.TYPE_FINE, className, "engineGetKey");
                        }
                        throw re;
                    }
                    catch (NoSuchAlgorithmException e) {
                        RuntimeException re = new RuntimeException("Internal error, no EC algorithm", e);
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", e);
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", re);
                            debug.exit(Debug.TYPE_FINE, className, "engineGetKey");
                        }
                        throw re;
                    }
                    key = keyFactory.generatePrivate(keySpec);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", e);
                    }
                    throw new UnrecoverableKeyException(e.getMessage());
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKey", key);
        }
        return key;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] chain = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetCertificateChain", alias);
        }
        if (alias == null) {
            IllegalArgumentException iae = new IllegalArgumentException("alias can't be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetCertificateChain", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineGetCertificateChain");
            }
            throw iae;
        }
        Object entry = this.aliasLookUp(alias);
        if (entry != null && entry instanceof HWKeyEntryRACF && ((HWKeyEntryRACF)entry).chain != null) {
            chain = (Certificate[])((HWKeyEntryRACF)entry).chain.clone();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCertificateChain", chain);
        }
        return chain;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetCertificate", alias);
        }
        if (alias == null) {
            IllegalArgumentException iae = new IllegalArgumentException("alias can't be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetCertificate", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineGetCertificate");
            }
            throw iae;
        }
        Certificate cert = null;
        Object entry = this.aliasLookUp(alias);
        if (entry != null) {
            if (entry instanceof TrustedCertEntryRACF) {
                cert = ((TrustedCertEntryRACF)entry).cert;
            } else if (entry instanceof HWKeyEntryRACF && ((HWKeyEntryRACF)entry).chain != null) {
                cert = ((HWKeyEntryRACF)entry).chain[0];
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCertificate", cert);
        }
        return cert;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetCreationDate", alias);
        }
        if (alias == null) {
            IllegalArgumentException iae = new IllegalArgumentException("alias can't be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetCreationDate", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineGetCreationDate");
            }
            throw iae;
        }
        Date date = null;
        Object entry = this.aliasLookUp(alias);
        if (entry != null) {
            if (entry instanceof TrustedCertEntryRACF) {
                date = new Date(((TrustedCertEntryRACF)entry).date.getTime());
            } else if (entry instanceof HWKeyEntryRACF) {
                date = new Date(((HWKeyEntryRACF)entry).date.getTime());
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCreationDate", date);
        }
        return date;
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        if (debug != null) {
            Object[] parms = new Object[]{alias, entry, protParam};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetEntry", parms);
        }
        this.checkAlias(alias);
        if (this.engineContainsAlias(alias)) {
            PrivateKey newPriv = null;
            Certificate newCertif = null;
            if (entry instanceof KeyStore.TrustedCertificateEntry) {
                newCertif = ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
            } else if (entry instanceof KeyStore.PrivateKeyEntry) {
                newPriv = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
                newCertif = ((KeyStore.PrivateKeyEntry)entry).getCertificate();
            }
            this.testForUpdate(alias, newPriv, newCertif, "Entry");
        }
        super.engineSetEntry(alias, entry, protParam);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineSetEntry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] passwd, Certificate[] chain) throws KeyStoreException {
        IllegalArgumentException iae;
        if (debug != null) {
            Object[] parms = new Object[]{alias, key, passwd, chain};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetKeyEntry", parms);
        }
        if (key instanceof SecretKey) {
            iae = new IllegalArgumentException("Secret (symmetric) keys are not supported in RACF");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
            }
            throw iae;
        }
        this.checkAlias(alias);
        if (chain == null) {
            iae = new IllegalArgumentException("Chain can't be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
            }
            throw iae;
        }
        if (chain.length == 0) {
            iae = new IllegalArgumentException("Chain must contain at least one certificate");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
            }
            throw iae;
        }
        if (key == null) {
            iae = new IllegalArgumentException("Key can't be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
            }
            throw iae;
        }
        if (key instanceof PKCS11PrivateKey && Boolean.TRUE.equals(((PKCS11PrivateKey)key).getSensitive())) {
            this.keyAttrs = null;
            KeyStoreException kse = new KeyStoreException("Private key value is sensitive and is not exportable");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", kse);
                debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
            }
            throw kse;
        }
        char[] password = passwd == null ? "password".toCharArray() : passwd;
        if (this.engineContainsAlias(alias)) {
            PrivateKey newPriv = (PrivateKey)key;
            Certificate newCertif = chain[0];
            this.testForUpdate(alias, newPriv, newCertif, "KeyEntry");
        }
        HWKeyEntryRACF hker = null;
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            if (key instanceof RSAPrivateHWKey) {
                if (((RSAPrivateHWKey)key).getType() == 1) {
                    KeyStoreException kse = new KeyStoreException("Unsupported hardware key format: RSAPrivateHWKey RETAIN");
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", kse);
                        debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
                    }
                    throw kse;
                }
                hker = ((RSAPrivateHWKey)key).getType() == 0 ? this.setICSFPKDSKeyEntry(alias, key, password, chain, 2) : this.setICSFClearRSAKeyEntry(alias, key, password, chain);
            } else if (key instanceof RSAPrivateKey || key instanceof RSAPrivateCrtKey) {
                hker = this.setSoftwareRSAKeyEntry(alias, key, password, chain);
            } else {
                if (key instanceof DSAPrivateKey) {
                    this.keyAttrs = null;
                    KeyStoreException kse = new KeyStoreException("Unsupported key format: DSAPrivateKey");
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", kse);
                        debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
                    }
                    throw kse;
                }
                if (key instanceof ECPrivateHWKey) {
                    ECPrivateHWKey privateHWKey = (ECPrivateHWKey)key;
                    hker = privateHWKey.getType() == 0 ? this.setICSFPKDSKeyEntry(alias, key, password, chain, 9) : this.setICSFClearECKeyEntry(alias, privateHWKey, password, chain);
                } else if (key instanceof ECPrivateKey) {
                    hker = this.setSoftwareECKeyEntry(alias, (ECPrivateKey)key, password, chain);
                } else if (key instanceof WrapperKey) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "WrapperKey passed in. Will now unwrap it.");
                    }
                    this.keyAttrs = ((WrapperKey)key).getKeyHWAttributes();
                    this.engineSetKeyEntry(alias, ((WrapperKey)key).getKey(), password, chain);
                } else {
                    this.keyAttrs = null;
                    KeyStoreException kse = new KeyStoreException("Unsupported key format");
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", kse);
                        debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
                    }
                    throw kse;
                }
            }
            if (hker != null) {
                Object entry = this.entries.get(alias);
                if (entry != null) {
                    String certOwner = null;
                    if (entry instanceof TrustedCertEntryRACF) {
                        certOwner = ((TrustedCertEntryRACF)entry).certOwner;
                    } else if (entry instanceof HWKeyEntryRACF) {
                        certOwner = ((HWKeyEntryRACF)entry).certOwner;
                    }
                    if (certOwner != null) {
                        this.deletedEntries.put(alias, entry);
                    }
                }
                this.entries.put(alias, hker);
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
            }
        }
    }

    private HWKeyEntryRACF setICSFPKDSKeyEntry(String alias, Key key, char[] password, Certificate[] chain, int keyType) throws KeyStoreException {
        if (debug != null) {
            Object[] parms = new Object[]{alias, key, password, chain};
            debug.entry(Debug.TYPE_FINE, (Object)className, "setICSFPKDSKeyEntry", parms);
        }
        KeyProtector keyProtector = new KeyProtector(password);
        HWKeyEntryRACF hker = new HWKeyEntryRACF();
        hker.date = new Date();
        hker.alias = new String(alias);
        hker.certOwner = null;
        hker.keyType = keyType;
        hker.chain = (Certificate[])chain.clone();
        hker.externalKeyToken = null;
        hker.encodedPrivateKey = null;
        if (keyType == 2) {
            try {
                hker.encToken = keyProtector.protect(((RSAPrivateHWKey)key).getToken());
            }
            catch (Exception e) {
                KeyStoreException kse = new KeyStoreException("Exception caught while protecting RSAPrivateHWKey PKDS", e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", kse);
                    debug.exit(Debug.TYPE_FINE, className, "engineGetKey");
                }
                throw kse;
            }
            hker.keyAttribs = ((RSAPrivateHWKey)key).getParams() instanceof PSSParameterSpec ? new RSAPSSKeyHWAttributes(((RSAPrivateHWKey)key).getType(), ((RSAPrivateHWKey)key).getUsage()) : new RSAKeyHWAttributes(((RSAPrivateHWKey)key).getType(), ((RSAPrivateHWKey)key).getUsage());
        } else if (keyType == 9) {
            try {
                hker.encToken = keyProtector.protect(((ECPrivateHWKey)key).getToken());
            }
            catch (Exception e) {
                KeyStoreException kse = new KeyStoreException("Exception caught while protecting ECPrivateHWKey PKDS", e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", kse);
                    debug.exit(Debug.TYPE_FINE, className, "engineGetKey");
                }
                throw kse;
            }
            hker.keyAttribs = new ECHWKeyAttributes(((ECPrivateHWKey)key).getType(), ((ECPrivateHWKey)key).getUsage());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "setICSFPKDSKeyEntry", hker);
        }
        return hker;
    }

    private HWKeyEntryRACF setICSFClearRSAKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (debug != null) {
            Object[] parms = new Object[]{alias, key, password, chain};
            debug.entry(Debug.TYPE_FINE, (Object)className, "setICSFClearRSAKeyEntry", parms);
        }
        KeyProtector keyProtector = new KeyProtector(password);
        HWKeyEntryRACF hker = new HWKeyEntryRACF();
        hker.date = new Date();
        hker.alias = new String(alias);
        hker.certOwner = null;
        hker.keyType = 1;
        hker.chain = (Certificate[])chain.clone();
        try {
            hker.encToken = keyProtector.protect(((RSAPrivateHWKey)key).getToken());
        }
        catch (Exception e) {
            KeyStoreException kse = new KeyStoreException("Exception caught while protecting RSAPrivateHWKey CLEAR", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearRSAKeyEntry", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearRSAKeyEntry", kse);
                debug.exit(Debug.TYPE_FINE, className, "setICSFClearRSAKeyEntry");
            }
            throw kse;
        }
        hker.keyAttribs = ((RSAPrivateHWKey)key).getParams() instanceof PSSParameterSpec ? new RSAPSSKeyHWAttributes(((RSAPrivateHWKey)key).getType(), ((RSAPrivateHWKey)key).getUsage()) : new RSAKeyHWAttributes(((RSAPrivateHWKey)key).getType(), ((RSAPrivateHWKey)key).getUsage());
        byte[] externalToken = ((RSAPrivateHWKey)key).getExternalKeyToken();
        if (externalToken == null) {
            KeyStoreException kse = new KeyStoreException("Unsupported hardware key format: RSAPrivateHWKey CLEAR without external key token");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearRSAKeyEntry", kse);
                debug.exit(Debug.TYPE_FINE, className, "setICSFClearRSAKeyEntry");
            }
            throw kse;
        }
        if (externalToken.length < 9 || externalToken[8] != 8) {
            KeyStoreException kse = new KeyStoreException("Unsupported hardware key format: RSAPrivateHWKey CLEAR with unsupported external key token");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearRSAKeyEntry", kse);
                debug.exit(Debug.TYPE_FINE, className, "setICSFClearRSAKeyEntry");
            }
            throw kse;
        }
        CrtToken crtToken = new CrtToken(externalToken, null);
        PrivateKey pkey = null;
        try {
            pkey = crtToken.generatePrivateCrtkey();
        }
        catch (Exception e) {
            KeyStoreException kse = new KeyStoreException("Exception caught while converting ICSF token", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearRSAKeyEntry", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearRSAKeyEntry", kse);
                debug.exit(Debug.TYPE_FINE, className, "setICSFClearRSAKeyEntry");
            }
            throw kse;
        }
        if (pkey == null) {
            KeyStoreException kse = new KeyStoreException("Error parsing RSAPrivateHWKey CLEAR external key token: null key returned");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearRSAKeyEntry", kse);
                debug.exit(Debug.TYPE_FINE, className, "setICSFClearRSAKeyEntry");
            }
            throw kse;
        }
        try {
            hker.externalKeyToken = keyProtector.protect(externalToken);
            hker.encodedPrivateKey = keyProtector.protect(pkey.getEncoded());
        }
        catch (Exception e) {
            KeyStoreException kse = new KeyStoreException("Exception caught while protecting RSAPrivateHWKey CLEAR", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearRSAKeyEntry", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearRSAKeyEntry", kse);
                debug.exit(Debug.TYPE_FINE, className, "setICSFClearRSAKeyEntry");
            }
            throw kse;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "setICSFClearRSAKeyEntry", hker);
        }
        return hker;
    }

    private HWKeyEntryRACF setICSFClearECKeyEntry(String alias, ECPrivateHWKey key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (debug != null) {
            Object[] parms = new Object[]{alias, key, password, chain};
            debug.entry(Debug.TYPE_FINE, (Object)className, "setICSFClearECCKeyEntry", parms);
        }
        ECPrivateKey softwareKey = null;
        KeyProtector keyProtector = new KeyProtector(password);
        HWKeyEntryRACF hker = new HWKeyEntryRACF();
        hker.date = new Date();
        hker.alias = new String(alias);
        hker.certOwner = null;
        hker.keyType = 7;
        hker.chain = (Certificate[])chain.clone();
        try {
            hker.encToken = keyProtector.protect(key.getToken());
        }
        catch (Exception e) {
            KeyStoreException kse = new KeyStoreException("Exception caught while protecting ECPrivateHWKey CLEAR", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearECCKeyEntry", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearECCKeyEntry", kse);
                debug.exit(Debug.TYPE_FINE, className, "setICSFClearECCKeyEntry");
            }
            throw kse;
        }
        hker.keyAttribs = new ECHWKeyAttributes(key.getType(), key.getUsage());
        byte[] externalToken = key.getExternalKeyToken();
        if (externalToken == null) {
            KeyStoreException kse = new KeyStoreException("Unsupported hardware key format: ECPrivateHWKey CLEAR without external key token");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearECCKeyEntry", kse);
                debug.exit(Debug.TYPE_FINE, className, "setICSFClearECCKeyEntry");
            }
            throw kse;
        }
        try {
            softwareKey = KeyStoreUtils.generateSoftwareECPrivateKey(key);
        }
        catch (InvalidKeyException e) {
            KeyStoreException kse = new KeyStoreException("Unable to generate software Elliptic Curve key from hardware type CLEAR key", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearECCKeyEntry", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearECCKeyEntry", kse);
                debug.exit(Debug.TYPE_FINE, className, "setICSFClearECCKeyEntry");
            }
            throw kse;
        }
        try {
            hker.externalKeyToken = keyProtector.protect(externalToken);
            hker.encodedPrivateKey = keyProtector.protect(softwareKey.getEncoded());
        }
        catch (Exception e) {
            KeyStoreException kse = new KeyStoreException("Exception caught while protecting ECPrivateHWKey CLEAR", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearECCKeyEntry", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "setICSFClearECCKeyEntry", kse);
                debug.exit(Debug.TYPE_FINE, className, "setICSFClearECCKeyEntry");
            }
            throw kse;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "setICSFClearECCKeyEntry", hker);
        }
        return hker;
    }

    private HWKeyEntryRACF setSoftwareRSAKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (debug != null) {
            Object[] parms = new Object[]{alias, key, password, chain};
            debug.entry(Debug.TYPE_FINE, (Object)className, "setSoftwareRSAKeyEntry", parms);
        }
        HWKeyEntryRACF hker = null;
        KeyProtector keyProtector = new KeyProtector(password);
        KeyPairUtils kpu = new KeyPairUtils();
        if (this.keyAttrs == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "setSoftwareRSAKeyEntry", "Not a WrapperKey, using default RSAKeyHWAttributes(CLEAR, KEYMANAGEMENT)");
            }
            this.keyAttrs = new RSAKeyHWAttributes(2, 4);
        }
        KeyPairUtils.KeyPairAlgorithm keyPairAlgorithm = ((RSAKey)((Object)key)).getParams() instanceof PSSParameterSpec ? KeyPairUtils.KeyPairAlgorithm.RSAPSS : KeyPairUtils.KeyPairAlgorithm.RSA;
        kpu.initializeRSA(((RSAPrivateKey)key).getPrivateExponent().bitLength(), null, (RSAKeyHWAttributes)this.keyAttrs, null, keyPairAlgorithm);
        this.keyAttrs = null;
        RSAPrivateHWKey migKey = (RSAPrivateHWKey)kpu.generatePrivateHWKey(chain[0].getPublicKey(), (PrivateKey)key);
        switch (migKey.getType()) {
            case 1: {
                KeyStoreException kse1 = new KeyStoreException("Unsupported hardware key format: RSAPrivateHWKey RETAIN");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "setSoftwareRSAKeyEntry", kse1);
                    debug.exit(Debug.TYPE_FINE, className, "setSoftwareRSAKeyEntry");
                }
                throw kse1;
            }
            case 0: {
                hker = this.setICSFPKDSKeyEntry(alias, migKey, password, chain, 2);
                break;
            }
            default: {
                hker = new HWKeyEntryRACF();
                hker.date = new Date();
                hker.alias = new String(alias);
                hker.certOwner = null;
                hker.keyType = 1;
                hker.chain = (Certificate[])chain.clone();
                hker.externalKeyToken = null;
                try {
                    hker.encodedPrivateKey = keyProtector.protect(key.getEncoded());
                }
                catch (Exception e) {
                    KeyStoreException kse2 = new KeyStoreException("Exception caught while protecting RSAPrivateHWKey private key", e);
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "setSoftwareRSAKeyEntry", e);
                        debug.exception(Debug.TYPE_PUBLIC, className, "setSoftwareRSAKeyEntry", kse2);
                        debug.exit(Debug.TYPE_FINE, className, "setSoftwareRSAKeyEntry");
                    }
                    throw kse2;
                }
                try {
                    hker.encToken = keyProtector.protect(migKey.getToken());
                    hker.externalKeyToken = keyProtector.protect(migKey.getExternalKeyToken());
                }
                catch (Exception e) {
                    KeyStoreException kse3 = new KeyStoreException("Exception caught while protecting RSAPrivateHWKey ICSF Token", e);
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "setSoftwareRSAKeyEntry", e);
                        debug.exception(Debug.TYPE_PUBLIC, className, "setSoftwareRSAKeyEntry", kse3);
                        debug.exit(Debug.TYPE_FINE, className, "setSoftwareRSAKeyEntry");
                    }
                    throw kse3;
                }
                hker.keyAttribs = migKey.getParams() instanceof PSSParameterSpec ? new RSAPSSKeyHWAttributes(migKey.getType(), migKey.getUsage()) : new RSAKeyHWAttributes(migKey.getType(), migKey.getUsage());
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "setSoftwareRSAKeyEntry", hker);
        }
        return hker;
    }

    private HWKeyEntryRACF setSoftwareECKeyEntry(String alias, ECPrivateKey key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (debug != null) {
            Object[] parms = new Object[]{alias, key, password, chain};
            debug.entry(Debug.TYPE_FINE, (Object)className, "setSoftwareECKeyEntry", parms);
        }
        ECPrivateHWKey hardwareKey = null;
        HWKeyEntryRACF hker = null;
        KeyProtector keyProtector = new KeyProtector(password);
        if (this.keyAttrs == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "setSoftwareECKeyEntry", "Not a WrapperKey, using default ECHWKeyAttributes");
            }
            this.keyAttrs = new ECHWKeyAttributes(2, ECHWKeyAttributes.DEFAULT_USAGE);
        }
        try {
            hardwareKey = KeyStoreUtils.importSoftwareECPrivateKey(key, (ECHWKeyAttributes)this.keyAttrs);
        }
        catch (InvalidKeyException e) {
            KeyStoreException kse = new KeyStoreException("Exception caught while importing software private key", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "setSoftwareECKeyEntry", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "setSoftwareECKeyEntry", kse);
                debug.exit(Debug.TYPE_FINE, className, "setSoftwareECKeyEntry");
            }
            throw kse;
        }
        finally {
            this.keyAttrs = null;
        }
        switch (hardwareKey.getType()) {
            case 0: {
                hker = this.setICSFPKDSKeyEntry(alias, hardwareKey, password, chain, 9);
                break;
            }
            default: {
                hker = new HWKeyEntryRACF();
                hker.date = new Date();
                hker.alias = new String(alias);
                hker.certOwner = null;
                hker.keyType = 7;
                hker.chain = (Certificate[])chain.clone();
                hker.externalKeyToken = null;
                try {
                    hker.encodedPrivateKey = keyProtector.protect(key.getEncoded());
                }
                catch (Exception e) {
                    KeyStoreException kse = new KeyStoreException("Exception caught while protecting ECPrivateHWKey encoded private key", e);
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "setSoftwareECKeyEntry", e);
                        debug.exception(Debug.TYPE_PUBLIC, className, "setSoftwareECKeyEntry", kse);
                        debug.exit(Debug.TYPE_FINE, className, "setSoftwareECKeyEntry");
                    }
                    throw kse;
                }
                try {
                    hker.encToken = keyProtector.protect(hardwareKey.getToken());
                    hker.externalKeyToken = keyProtector.protect(hardwareKey.getExternalKeyToken());
                }
                catch (Exception e) {
                    KeyStoreException kse2 = new KeyStoreException("Exception caught while protecting ECPrivateHWKey ICSF tokens", e);
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "setSoftwareECKeyEntry", e);
                        debug.exception(Debug.TYPE_PUBLIC, className, "setSoftwareECKeyEntry", kse2);
                        debug.exit(Debug.TYPE_FINE, className, "setSoftwareECKeyEntry");
                    }
                    throw kse2;
                }
                hker.keyAttribs = new ECHWKeyAttributes(hardwareKey.getType(), hardwareKey.getUsage());
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "setSoftwareECKeyEntry", hker);
        }
        return hker;
    }

    private void checkAlias(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "checkAlias", alias);
        }
        if (alias == null) {
            IllegalArgumentException iae = new IllegalArgumentException("alias can't be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "checkAlias", iae);
                debug.exit(Debug.TYPE_FINE, className, "checkAlias");
            }
            throw iae;
        }
        if (alias.length() < 1) {
            IllegalArgumentException iae = new IllegalArgumentException("alias length must be at least 1");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "checkAlias", iae);
                debug.exit(Debug.TYPE_FINE, className, "checkAlias");
            }
            throw iae;
        }
        if (alias.length() > 32) {
            IllegalArgumentException iae = new IllegalArgumentException("alias length must be no greater than 32");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "checkAlias", iae);
                debug.exit(Debug.TYPE_FINE, className, "checkAlias");
            }
            throw iae;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "checkAlias");
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        if (debug != null) {
            Object[] parms = new Object[]{alias, key, chain};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetKeyEntry", parms);
        }
        KeyStoreException kse = new KeyStoreException("Key to be stored must be a Key Object. Therefore, this function is unsupported ");
        if (debug != null) {
            debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", kse);
            debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
        }
        throw kse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            Object entry;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, className, "engineSetCertificateEntry", alias, cert);
            }
            this.checkAlias(alias);
            if (cert == null) {
                IllegalArgumentException iae = new IllegalArgumentException("cert can't be null");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineSetCertificateEntry", iae);
                    debug.exit(Debug.TYPE_FINE, className, "engineSetCertificateEntry");
                }
                throw iae;
            }
            if (this.engineContainsAlias(alias)) {
                PrivateKey newPriv = null;
                this.testForUpdate(alias, newPriv, cert, "CertEntry");
            }
            if ((entry = this.entries.get(alias)) != null && !(entry instanceof TrustedCertEntryRACF)) {
                KeyStoreException kse = new KeyStoreException("Cannot overwrite key entry");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineSetCertificateEntry", kse);
                    debug.exit(Debug.TYPE_FINE, className, "engineSetCertificateEntry");
                }
                throw kse;
            }
            TrustedCertEntryRACF tcer = new TrustedCertEntryRACF();
            tcer.alias = new String(alias);
            tcer.certOwner = null;
            tcer.date = new Date();
            tcer.cert = cert;
            if (entry != null && ((TrustedCertEntryRACF)entry).certOwner != null) {
                this.deletedEntries.put(alias, entry);
            }
            this.entries.put(alias, tcer);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "engineSetCertificateEntry");
            }
        }
    }

    private void testForUpdate(String alias, PrivateKey newPrivate, Certificate newCert, String callerFlag) throws KeyStoreException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "testForUpdate", callerFlag);
        }
        if (this.engineIsKeyEntry(alias) && null == newPrivate) {
            KeyStoreException kse = new KeyStoreException("Unsupported operation for JCECCARACFKS KeyStore (" + callerFlag + "). A key entry cannot be updated with a certificate entry");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "testForUpdate", kse);
                debug.exit(Debug.TYPE_FINE, (Object)className, "testForUpdate", "RACF update would not be successful.");
            }
            throw kse;
        }
        if (this.engineIsCertificateEntry(alias) && null != newPrivate) {
            KeyStoreException kse = new KeyStoreException("Unsupported operation for JCECCARACFKS KeyStore (" + callerFlag + "). A certificate entry cannot be updated with a key entry");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "testForUpdate", kse);
                debug.exit(Debug.TYPE_FINE, (Object)className, "testForUpdate", "RACF update would not be successful.");
            }
            throw kse;
        }
        if (null == newCert) {
            KeyStoreException kse = new KeyStoreException("Unsupported operation for JCECCARACFKS KeyStore (" + callerFlag + "). A certificate cannot be updated with a null certificate");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "testForUpdate", kse);
                debug.exit(Debug.TYPE_FINE, (Object)className, "testForUpdate", "RACF update would not be successful.");
            }
            throw kse;
        }
        if (!(newCert instanceof X509Certificate)) {
            KeyStoreException kse = new KeyStoreException("Unsupported certificate for JCECCARACFKS KeyStore (" + callerFlag + "). Certificate is not an X509Certificate");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "testForUpdate", kse);
                debug.exit(Debug.TYPE_FINE, (Object)className, "testForUpdate", "RACF update would not be successful.");
            }
            throw kse;
        }
        try {
            ((X509Certificate)newCert).checkValidity();
        }
        catch (Exception ex) {
            if (ex instanceof CertificateExpiredException) {
                KeyStoreException kse = new KeyStoreException("Unsupported operation for JCECCARACFKS KeyStore (" + callerFlag + "). An entry cannot be updated with an expired certificate", ex);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "testForUpdate", kse);
                    debug.exit(Debug.TYPE_FINE, (Object)className, "testForUpdate", "RACF update would not be successful.");
                }
                throw kse;
            }
            RuntimeException rte = new RuntimeException("Error attempting to validate new certificate. (" + callerFlag + ")", ex);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "testForUpdate", rte);
                debug.exit(Debug.TYPE_FINE, (Object)className, "testForUpdate", "We will not allow RACF update with an expired certificate.");
            }
            throw rte;
        }
        try {
            X509Certificate origCert = (X509Certificate)this.engineGetCertificate(alias);
            origCert.checkValidity();
        }
        catch (Exception ex) {
            if (ex instanceof CertificateExpiredException) {
                KeyStoreException kse = new KeyStoreException("Unsupported operation for JCECCARACFKS KeyStore (" + callerFlag + "). An entry with an expired certificate cannot be updated", ex);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "testForUpdate", kse);
                    debug.exit(Debug.TYPE_FINE, (Object)className, "testForUpdate", "RACF update would not be successful.");
                }
                throw kse;
            }
            RuntimeException rte = new RuntimeException("Error attempting to validate original certificate. (" + callerFlag + ")", ex);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "testForUpdate", rte);
                debug.exit(Debug.TYPE_FINE, (Object)className, "testForUpdate", "RACF update would not be successful.");
            }
            throw rte;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "testForUpdate", "No problem detected that would prevent update.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineDeleteEntry", alias);
        }
        if (alias == null) {
            IllegalArgumentException iae = new IllegalArgumentException("alias can't be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDeleteEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineDeleteEntry");
            }
            throw iae;
        }
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            Object entry = this.aliasLookUp(alias);
            if (entry != null) {
                String certOwner = null;
                if (entry instanceof TrustedCertEntryRACF) {
                    certOwner = ((TrustedCertEntryRACF)entry).certOwner;
                } else if (entry instanceof HWKeyEntryRACF) {
                    certOwner = ((HWKeyEntryRACF)entry).certOwner;
                }
                if (certOwner != null) {
                    this.deletedEntries.put(alias, entry);
                }
                this.entries.remove(alias);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineDeleteEntry");
        }
    }

    public Enumeration engineAliases() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineAliases");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineAliases", this.entries.keys());
        }
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineContainsAlias", alias);
        }
        boolean eca = false;
        if (alias == null) {
            IllegalArgumentException iae = new IllegalArgumentException("alias can't be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineContainsAlias", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineContainsAlias");
            }
            throw iae;
        }
        Object entry = this.aliasLookUp(alias);
        if (entry != null) {
            eca = true;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineContainsAlias", new Boolean(eca));
        }
        return eca;
    }

    @Override
    public int engineSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSize");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineSize", this.entries.size());
        }
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineIsKeyEntry", alias);
        }
        if (alias == null) {
            IllegalArgumentException iae = new IllegalArgumentException("alias can't be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineIsKeyEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineIsKeyEntry");
            }
            throw iae;
        }
        boolean isKey = false;
        Object entry = this.aliasLookUp(alias);
        if (entry != null && entry instanceof HWKeyEntryRACF) {
            isKey = true;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineIsKeyEntry", new Boolean(isKey));
        }
        return isKey;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineIsCertificateEntry", alias);
        }
        if (alias == null) {
            IllegalArgumentException iae = new IllegalArgumentException("alias can't be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineIsCertificateEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineIsCertificateEntry");
            }
            throw iae;
        }
        boolean isCert = false;
        Object entry = this.aliasLookUp(alias);
        if (entry != null && entry instanceof TrustedCertEntryRACF) {
            isCert = true;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineIsCertificateEntry", new Boolean(isCert));
        }
        return isCert;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetCertificateAlias", cert);
        }
        Enumeration<String> e = this.entries.keys();
        while (e.hasMoreElements()) {
            Certificate certElem;
            String alias = e.nextElement();
            Object entry = this.entries.get(alias);
            if (entry instanceof TrustedCertEntryRACF) {
                certElem = ((TrustedCertEntryRACF)entry).cert;
            } else {
                if (!(entry instanceof HWKeyEntryRACF) || ((HWKeyEntryRACF)entry).chain == null) continue;
                certElem = ((HWKeyEntryRACF)entry).chain[0];
            }
            if (!certElem.equals(cert)) continue;
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCertificateAlias", alias);
            }
            return alias;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCertificateAlias", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineStore", stream, password);
        }
        if (stream == null) {
            IllegalArgumentException iae = new IllegalArgumentException("stream can't be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineStore", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineStore");
            }
            throw iae;
        }
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            char[] pass = null;
            pass = password == null ? "password".toCharArray() : (char[])password.clone();
            MessageDigest md = this.getPreKeyedHash(pass);
            ObjectOutputStream oos = new ObjectOutputStream(new DigestOutputStream(stream, md));
            oos.writeObject(EYE_CATCHER);
            oos.writeInt(306006735);
            oos.writeInt(1);
            oos.writeInt(this.deletedEntries.size());
            oos.writeInt(this.entries.size());
            Enumeration<String> deletedEntrykeys = this.deletedEntries.keys();
            while (deletedEntrykeys.hasMoreElements()) {
                oos.writeObject(this.deletedEntries.get(deletedEntrykeys.nextElement()));
            }
            Enumeration<String> entrykeys = this.entries.keys();
            while (entrykeys.hasMoreElements()) {
                oos.writeObject(this.entries.get(entrykeys.nextElement()));
            }
            byte[] digest = md.digest();
            oos.write(digest);
            oos.flush();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineStore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineLoad", stream, password);
        }
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            int xVersion;
            int xMagic;
            String eyeCatcher;
            ObjectInputStream ois = null;
            MessageDigest md = null;
            if (stream == null) {
                return;
            }
            if (password != null) {
                md = this.getPreKeyedHash(password);
                ois = new ObjectInputStream(new DigestInputStream(stream, md));
            } else {
                ois = new ObjectInputStream(stream);
            }
            try {
                eyeCatcher = (String)ois.readObject();
                xMagic = ois.readInt();
                xVersion = ois.readInt();
            }
            catch (Throwable e) {
                IOException ioex = new IOException("Invalid keystore format", e);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineLoad", "Unable to read EyeCatcher, MagicNumber, or Version");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineLoad", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineLoad", ioex);
                }
                throw ioex;
            }
            if (xMagic != 306006735 || xVersion != 1 || !eyeCatcher.equals(EYE_CATCHER)) {
                IOException ioex = new IOException("Invalid keystore format");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineLoad", "Unexpected value for MagicNumber, Version, or EyeCatcher");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineLoad", ioex);
                }
                throw ioex;
            }
            this.entries.clear();
            int count = ois.readInt();
            for (int i = 0; i < count; ++i) {
                Object obj;
                String alias = null;
                boolean skip = false;
                try {
                    obj = ois.readObject();
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineLoad", e);
                    }
                    throw new IOException(e.getMessage(), e);
                }
                if (obj instanceof HWKeyEntryRACF) {
                    alias = ((HWKeyEntryRACF)obj).alias;
                } else if (obj instanceof TrustedCertEntryRACF) {
                    alias = ((TrustedCertEntryRACF)obj).alias;
                } else {
                    skip = true;
                }
                if (!skip) {
                    this.entries.put(alias, obj);
                }
                skip = false;
            }
            if (password != null && count != 0) {
                byte[] computed = md.digest();
                byte[] actual = new byte[computed.length];
                ois.readFully(actual);
                for (int i = 0; i < computed.length; ++i) {
                    if (computed[i] == actual[i]) continue;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineLoad", "incorrect password");
                    }
                    throw new IOException("Keystore was tampered with, or password was incorrect");
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineLoad");
        }
    }

    private MessageDigest getPreKeyedHash(char[] password) throws NoSuchAlgorithmException {
        int i;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "getPreKeyedHash", (Object)password);
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA", "IBMJCECCA");
        }
        catch (NoSuchProviderException nspe) {
            try {
                md = MessageDigest.getInstance("SHA", "IBMJCE4758");
            }
            catch (NoSuchProviderException nspe2) {
                md = MessageDigest.getInstance("SHA");
            }
        }
        byte[] passwdBytes = new byte[password.length * 2];
        int j = 0;
        for (i = 0; i < password.length; ++i) {
            passwdBytes[j++] = (byte)(password[i] >> 8);
            passwdBytes[j++] = (byte)password[i];
        }
        md.update(passwdBytes);
        for (i = 0; i < passwdBytes.length; ++i) {
            passwdBytes[i] = 0;
        }
        md.update("Mighty Aphrodite".getBytes(PlatformUtilities.CHARSET_UTF8));
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "getPreKeyedHash", md);
        }
        return md;
    }

    private Object aliasLookUp(String alias) {
        Object entry;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "aliasLookUp", alias);
        }
        if ((entry = this.entries.get(alias)) == null) {
            Enumeration<String> e = this.entries.keys();
            while (e.hasMoreElements()) {
                String aliasInTable = e.nextElement();
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "aliasInTable =", aliasInTable);
                }
                if (alias.compareToIgnoreCase(aliasInTable) != 0) continue;
                entry = this.entries.get(aliasInTable);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "aliasLookUp: ignore case match", entry);
                }
                return entry;
            }
        } else {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "aliasLookUp: exact case match", entry);
            }
            return entry;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "aliasLookUp: no match", null);
        }
        return null;
    }
}

