/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.AESKey;
import com.ibm.crypto.hdwrCCA.provider.DSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.DSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKeySpec;
import com.ibm.crypto.hdwrCCA.provider.HWKeyEntryV3KS;
import com.ibm.crypto.hdwrCCA.provider.HWKeyEntryV3W;
import com.ibm.crypto.hdwrCCA.provider.HWKeyEntryV4KS;
import com.ibm.crypto.hdwrCCA.provider.HWKeyEntryV4W;
import com.ibm.crypto.hdwrCCA.provider.KeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.KeyProtector;
import com.ibm.crypto.hdwrCCA.provider.KeyProtectorS2;
import com.ibm.crypto.hdwrCCA.provider.KeyStoreUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.SealedTokenForKeyProtector;
import com.ibm.crypto.hdwrCCA.provider.SealedTokenForKeyProtectorS2;
import com.ibm.crypto.hdwrCCA.provider.SecretKeyEntry;
import com.ibm.crypto.hdwrCCA.provider.TrustedCertEntryV2KS;
import com.ibm.crypto.hdwrCCA.provider.TrustedCertEntryV2W;
import com.ibm.crypto.hdwrCCA.provider.WrapperKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.security.rsa.RSAUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public final class JceCCAKeyStore
extends KeyStoreSpi {
    private static final int JCECCAKS_MAGIC = 306008024;
    private static final String EYE_S2_CATCHER = "JCECCAKS_s2";
    private static final String EYE_CATCHER = "JCECCAKS";
    private static final String EYE_OLD_CATCHER = "JCE4758KS";
    private static final int VERSION_3 = 3;
    private static final int DSA_KEY = 0;
    private static final int RSA_KEY = 1;
    private static final int ECC_KEY = 2;
    private static final int RSAPSS_KEY = 3;
    private static final int S1_KSprotection = 1;
    private static final int S2_KSprotection = 2;
    private int ksProtectionLevel = 2;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.JceCCAKeyStore";
    private Hashtable<String, Object> entries = new Hashtable();
    private KeyHWAttributes keyAttrs = null;

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetKey", alias, password);
        }
        if (null == alias || "".equals(alias)) {
            IllegalArgumentException iae = new IllegalArgumentException("alias passed to getKey() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineGetKey");
            }
            throw iae;
        }
        Serializable key = null;
        try {
            Object entry = this.entries.get(alias.toLowerCase());
            if (entry == null || entry instanceof TrustedCertEntryV2W) {
                return null;
            }
            KeyProtector keyProtector1 = null;
            KeyProtectorS2 keyProtector2 = null;
            if (this.ksProtectionLevel == 2) {
                keyProtector2 = new KeyProtectorS2(password);
            } else {
                keyProtector1 = new KeyProtector(password);
            }
            if (entry instanceof HWKeyEntryV4W) {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "engineGetKey", "ksProtectionLevel==" + this.ksProtectionLevel + ", (entry instanceof HWKeyEntryV4W)");
                }
                HWKeyEntryV4W hwEntry2 = (HWKeyEntryV4W)entry;
                byte[] token = keyProtector2.recover(hwEntry2.storeEntry.encToken);
                byte[] extToken = null;
                if (hwEntry2.storeEntry.externalKeyToken != null) {
                    extToken = keyProtector2.recover(hwEntry2.storeEntry.externalKeyToken);
                }
                if (hwEntry2.storeEntry.keyType == 1) {
                    key = new RSAPrivateHWKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)RSAUtil.KeyType.RSA, null), token, extToken, (RSAKeyHWAttributes)hwEntry2.storeEntry.keyAttribs);
                } else if (hwEntry2.storeEntry.keyType == 3) {
                    key = new RSAPrivateHWKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)RSAUtil.KeyType.PSS, null), token, extToken, (RSAKeyHWAttributes)hwEntry2.storeEntry.keyAttribs);
                } else if (hwEntry2.storeEntry.keyType == 0) {
                    DSAPublicKey pubkey = (DSAPublicKey)hwEntry2.chain[0].getPublicKey();
                    DSAParams params = pubkey.getParams();
                    key = new DSAPrivateHWKey(token, params.getP(), params.getQ(), params.getG(), (DSAKeyHWAttributes)hwEntry2.storeEntry.keyAttribs);
                } else if (hwEntry2.storeEntry.keyType == 2) {
                    ECPrivateHWKeySpec keySpec = null;
                    ECPublicKey pubkey = (ECPublicKey)hwEntry2.chain[0].getPublicKey();
                    ECParameterSpec paramSpec = pubkey.getParams();
                    ECHWKeyAttributes keyAttributes = (ECHWKeyAttributes)hwEntry2.storeEntry.keyAttribs;
                    keySpec = extToken != null ? new ECPrivateHWKeySpec(extToken, paramSpec, keyAttributes.getKeyType(), keyAttributes.getKeyUsage()) : new ECPrivateHWKeySpec(token, paramSpec, keyAttributes.getKeyType(), keyAttributes.getKeyUsage());
                    KeyFactory keyFactory = null;
                    try {
                        keyFactory = KeyFactory.getInstance("EC", "IBMJCECCA");
                    }
                    catch (NoSuchProviderException e) {
                        RuntimeException re = new RuntimeException("Internal error, no IBMJCECCA provider", e);
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", e);
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", re);
                            debug.exit(Debug.TYPE_PUBLIC, className, "engineGetKey");
                        }
                        throw re;
                    }
                    catch (NoSuchAlgorithmException e) {
                        RuntimeException re = new RuntimeException("Internal error, no EC algorithm", e);
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", e);
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", re);
                            debug.exit(Debug.TYPE_PUBLIC, className, "engineGetKey");
                        }
                        throw re;
                    }
                    key = keyFactory.generatePrivate(keySpec);
                }
            } else if (entry instanceof HWKeyEntryV3W) {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "engineGetKey", "ksProtectionLevel==" + this.ksProtectionLevel + ", (entry instanceof HWKeyEntryV3W)");
                }
                HWKeyEntryV3W hwEntry1 = (HWKeyEntryV3W)entry;
                byte[] token = keyProtector1.recover(hwEntry1.storeEntry.encToken);
                byte[] extToken = null;
                if (hwEntry1.storeEntry.externalKeyToken != null) {
                    extToken = keyProtector1.recover(hwEntry1.storeEntry.externalKeyToken);
                }
                if (hwEntry1.storeEntry.keyType == 1) {
                    key = new RSAPrivateHWKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)RSAUtil.KeyType.RSA, null), token, extToken, (RSAKeyHWAttributes)hwEntry1.storeEntry.keyAttribs);
                } else if (hwEntry1.storeEntry.keyType == 3) {
                    key = new RSAPrivateHWKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)RSAUtil.KeyType.PSS, null), token, extToken, (RSAKeyHWAttributes)hwEntry1.storeEntry.keyAttribs);
                } else if (hwEntry1.storeEntry.keyType == 0) {
                    DSAPublicKey pubkey = (DSAPublicKey)hwEntry1.chain[0].getPublicKey();
                    DSAParams params = pubkey.getParams();
                    key = new DSAPrivateHWKey(token, params.getP(), params.getQ(), params.getG(), (DSAKeyHWAttributes)hwEntry1.storeEntry.keyAttribs);
                } else if (hwEntry1.storeEntry.keyType == 2) {
                    ECPrivateHWKeySpec keySpec = null;
                    ECPublicKey pubkey = (ECPublicKey)hwEntry1.chain[0].getPublicKey();
                    ECParameterSpec paramSpec = pubkey.getParams();
                    ECHWKeyAttributes keyAttributes = (ECHWKeyAttributes)hwEntry1.storeEntry.keyAttribs;
                    keySpec = extToken != null ? new ECPrivateHWKeySpec(extToken, paramSpec, keyAttributes.getKeyType(), keyAttributes.getKeyUsage()) : new ECPrivateHWKeySpec(token, paramSpec, keyAttributes.getKeyType(), keyAttributes.getKeyUsage());
                    KeyFactory keyFactory = null;
                    try {
                        keyFactory = KeyFactory.getInstance("EC", "IBMJCECCA");
                    }
                    catch (NoSuchProviderException e) {
                        RuntimeException re = new RuntimeException("Internal error, no IBMJCECCA provider", e);
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", e);
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", re);
                            debug.exit(Debug.TYPE_FINE, className, "engineGetKey");
                        }
                        throw re;
                    }
                    catch (NoSuchAlgorithmException e) {
                        RuntimeException re = new RuntimeException("Internal error, no EC algorithm", e);
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", e);
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", re);
                            debug.exit(Debug.TYPE_FINE, className, "engineGetKey");
                        }
                        throw re;
                    }
                    key = keyFactory.generatePrivate(keySpec);
                }
            } else if (entry instanceof SecretKeyEntry) {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "engineGetKey", "ksProtectionLevel==" + this.ksProtectionLevel + ", (entry instanceof SecretKeyEntry)");
                }
                try {
                    key = this.ksProtectionLevel == 2 ? keyProtector2.unseal(((SecretKeyEntry)entry).sealedKey) : keyProtector1.unseal(((SecretKeyEntry)entry).sealedKey);
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", ex);
                    }
                    String new_msg = ex.getMessage() + "\n alias = " + alias + "\n The key password may be incorrect or the key store may be corrupted.";
                    throw new KeyStoreException(new_msg, ex);
                }
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKey", key);
            }
            return key;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", e);
                debug.exit(Debug.TYPE_FINE, className, "engineGetKey");
            }
            throw new UnrecoverableKeyException(e.getMessage());
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] chain = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetCertificateChain", alias);
        }
        if (null == alias || "".equals(alias)) {
            IllegalArgumentException iae = new IllegalArgumentException("alias passed to getCertificateChain() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetCertificateChain", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineGetCertificateChain");
            }
            throw iae;
        }
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof HWKeyEntryV4W && ((HWKeyEntryV4W)entry).chain != null) {
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "engineGetCertificateChain", "ksProtectionLevel==" + this.ksProtectionLevel + ", (entry instanceof HWKeyEntryV4W)");
            }
            chain = (Certificate[])((HWKeyEntryV4W)entry).chain.clone();
        } else if (entry != null && entry instanceof HWKeyEntryV3W && ((HWKeyEntryV3W)entry).chain != null) {
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "engineGetCertificateChain", "ksProtectionLevel==" + this.ksProtectionLevel + ", (entry instanceof HWKeyEntryV3W)");
            }
            chain = (Certificate[])((HWKeyEntryV3W)entry).chain.clone();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCertificateChain", chain);
        }
        return chain;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetCertificate", alias);
        }
        if (null == alias || "".equals(alias)) {
            IllegalArgumentException iae = new IllegalArgumentException("alias passed to getCertificate() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetCertificate", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineGetCertificate");
            }
            throw iae;
        }
        Certificate cert = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof TrustedCertEntryV2W) {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "engineGetCertificate", "ksProtectionLevel==" + this.ksProtectionLevel + ", (entry instanceof TrustedCertEntryV2W)");
                }
                cert = ((TrustedCertEntryV2W)entry).cert;
            } else if (entry instanceof HWKeyEntryV3W && ((HWKeyEntryV3W)entry).chain != null) {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "engineGetCertificate", "ksProtectionLevel==" + this.ksProtectionLevel + ", (entry instanceof HWKeyEntryV3W)");
                }
                cert = ((HWKeyEntryV3W)entry).chain[0];
            } else if (entry instanceof HWKeyEntryV4W && ((HWKeyEntryV4W)entry).chain != null) {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "engineGetCertificate", "ksProtectionLevel==" + this.ksProtectionLevel + ", (entry instanceof HWKeyEntryV4W)");
                }
                cert = ((HWKeyEntryV4W)entry).chain[0];
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCertificate", cert);
        }
        return cert;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetCreationDate", alias);
        }
        Date date = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof TrustedCertEntryV2W) {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "engineGetCreationDate", "ksProtectionLevel==" + this.ksProtectionLevel + ", (entry instanceof TrustedCertEntryV2W)");
                }
                date = new Date(((TrustedCertEntryV2W)entry).storeEntry.date.getTime());
            } else if (entry instanceof HWKeyEntryV3W) {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "engineGetCreationDate", "ksProtectionLevel==" + this.ksProtectionLevel + ", (entry instanceof HWKeyEntryV3W)");
                }
                date = new Date(((HWKeyEntryV3W)entry).storeEntry.date.getTime());
            } else if (entry instanceof HWKeyEntryV4W) {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "engineGetCreationDate", "ksProtectionLevel==" + this.ksProtectionLevel + ", (entry instanceof HWKeyEntryV4W)");
                }
                date = new Date(((HWKeyEntryV4W)entry).storeEntry.date.getTime());
            } else if (entry instanceof SecretKeyEntry) {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "engineGetCreationDate", "ksProtectionLevel==" + this.ksProtectionLevel + ", (entry instanceof SecretKeyEntry)");
                }
                date = new Date(((SecretKeyEntry)entry).date.getTime());
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCreationDate", date);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        IllegalArgumentException iae;
        if (debug != null) {
            Object[] parms = new Object[]{alias, key, password, chain};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetKeyEntry", parms);
        }
        if (null == alias || "".equals(alias)) {
            iae = new IllegalArgumentException("alias passed to setKeyEntry() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
            }
            throw new KeyStoreException(iae);
        }
        if (null == key) {
            iae = new IllegalArgumentException("key passed to setKeyEntry() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
            }
            throw new KeyStoreException(iae);
        }
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            block98: {
                try {
                    KeyProtector keyProtector1 = null;
                    KeyProtectorS2 keyProtector2 = null;
                    if (this.ksProtectionLevel == 2) {
                        keyProtector2 = new KeyProtectorS2(password);
                    } else {
                        keyProtector1 = new KeyProtector(password);
                    }
                    if (key instanceof PrivateKey) {
                        if (key instanceof PKCS11PrivateKey && Boolean.TRUE.equals(((PKCS11PrivateKey)key).getSensitive())) {
                            this.keyAttrs = null;
                            KeyStoreException kse = new KeyStoreException("Private key value is sensitive and is not exportable");
                            if (debug != null) {
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", kse);
                            }
                            throw kse;
                        }
                        HWKeyEntryV3W entry1 = null;
                        HWKeyEntryV4W entry2 = null;
                        if (this.ksProtectionLevel == 2) {
                            if (debug != null) {
                                debug.text(Debug.TYPE_FINE, className, "engineSetKeyEntry", "ksProtectionLevel==" + this.ksProtectionLevel + ", (key instanceof PrivateKey), entry=new HWKeyEntryV4W()");
                            }
                            entry2 = new HWKeyEntryV4W();
                            entry2.storeEntry = new HWKeyEntryV4KS();
                            entry2.storeEntry.date = new Date();
                            entry2.storeEntry.alias = new String(alias.toLowerCase());
                            entry2.storeEntry.externalKeyToken = null;
                        } else {
                            if (debug != null) {
                                debug.text(Debug.TYPE_FINE, className, "engineSetKeyEntry", "ksProtectionLevel==" + this.ksProtectionLevel + ", (key instanceof PrivateKey), entry=new HWKeyEntryV3W()");
                            }
                            entry1 = new HWKeyEntryV3W();
                            entry1.storeEntry = new HWKeyEntryV3KS();
                            entry1.storeEntry.date = new Date();
                            entry1.storeEntry.alias = new String(alias.toLowerCase());
                            entry1.storeEntry.externalKeyToken = null;
                        }
                        if (key instanceof RSAPrivateHWKey) {
                            if (this.ksProtectionLevel == 2) {
                                entry2.storeEntry.keyType = ((RSAPrivateHWKey)key).getParams() instanceof PSSParameterSpec ? 3 : 1;
                                entry2.storeEntry.encToken = keyProtector2.protect(((RSAPrivateHWKey)key).getToken());
                                entry2.storeEntry.keyAttribs = new RSAKeyHWAttributes(((RSAPrivateHWKey)key).getType(), ((RSAPrivateHWKey)key).getUsage());
                            } else {
                                entry1.storeEntry.keyType = ((RSAPrivateHWKey)key).getParams() instanceof PSSParameterSpec ? 3 : 1;
                                entry1.storeEntry.encToken = keyProtector1.protect(((RSAPrivateHWKey)key).getToken());
                                entry1.storeEntry.keyAttribs = new RSAKeyHWAttributes(((RSAPrivateHWKey)key).getType(), ((RSAPrivateHWKey)key).getUsage());
                            }
                            byte[] myExternalToken = ((RSAPrivateHWKey)key).getExternalKeyToken();
                            if (myExternalToken != null) {
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "Storing external key token for use with clear key");
                                }
                                if (this.ksProtectionLevel == 2) {
                                    entry2.storeEntry.externalKeyToken = keyProtector2.protect(myExternalToken);
                                } else {
                                    entry1.storeEntry.externalKeyToken = keyProtector1.protect(myExternalToken);
                                }
                            } else if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "No external key token was saved must not be a clear key");
                            }
                        } else if (key instanceof DSAPrivateHWKey) {
                            if (this.ksProtectionLevel == 2) {
                                entry2.storeEntry.keyType = 0;
                                entry2.storeEntry.encToken = keyProtector2.protect(((DSAPrivateHWKey)((Object)key)).getToken());
                                entry2.storeEntry.externalKeyToken = null;
                                entry2.storeEntry.keyAttribs = new DSAKeyHWAttributes(((DSAPrivateHWKey)((Object)key)).getType(), 3);
                            } else {
                                entry1.storeEntry.keyType = 0;
                                entry1.storeEntry.encToken = keyProtector1.protect(((DSAPrivateHWKey)((Object)key)).getToken());
                                entry1.storeEntry.externalKeyToken = null;
                                entry1.storeEntry.keyAttribs = new DSAKeyHWAttributes(((DSAPrivateHWKey)((Object)key)).getType(), 3);
                            }
                        } else if (key instanceof ECPrivateHWKey) {
                            if (this.ksProtectionLevel == 2) {
                                entry2.storeEntry.keyType = 2;
                                entry2.storeEntry.encToken = keyProtector2.protect(((ECPrivateHWKey)key).getToken());
                                entry2.storeEntry.externalKeyToken = null;
                                entry2.storeEntry.keyAttribs = new ECHWKeyAttributes(((ECPrivateHWKey)key).getType(), ((ECPrivateHWKey)key).getUsage());
                            } else {
                                entry1.storeEntry.keyType = 2;
                                entry1.storeEntry.encToken = keyProtector1.protect(((ECPrivateHWKey)key).getToken());
                                entry1.storeEntry.externalKeyToken = null;
                                entry1.storeEntry.keyAttribs = new ECHWKeyAttributes(((ECPrivateHWKey)key).getType(), ((ECPrivateHWKey)key).getUsage());
                            }
                            byte[] myExternalToken = ((ECPrivateHWKey)key).getExternalKeyToken();
                            if (myExternalToken != null) {
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "Storing external key token for use with CLEAR key");
                                }
                                if (this.ksProtectionLevel == 2) {
                                    entry2.storeEntry.externalKeyToken = keyProtector2.protect(myExternalToken);
                                } else {
                                    entry1.storeEntry.externalKeyToken = keyProtector1.protect(myExternalToken);
                                }
                            } else if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "External key token not found, not a CLEAR key");
                            }
                        } else if (key instanceof RSAPrivateKey || key instanceof RSAPrivateCrtKey) {
                            if (this.keyAttrs == null) {
                                this.keyAttrs = new RSAKeyHWAttributes(2, 4);
                            }
                            KeyPairUtils kpu = new KeyPairUtils();
                            KeyPairUtils.KeyPairAlgorithm keyPairAlgorithm = ((RSAKey)((Object)key)).getParams() instanceof PSSParameterSpec ? KeyPairUtils.KeyPairAlgorithm.RSAPSS : KeyPairUtils.KeyPairAlgorithm.RSA;
                            kpu.initializeRSA(((RSAPrivateKey)key).getPrivateExponent().bitLength(), null, (RSAKeyHWAttributes)this.keyAttrs, null, keyPairAlgorithm);
                            this.keyAttrs = null;
                            RSAPrivateHWKey migKey = (RSAPrivateHWKey)kpu.generatePrivateHWKey(chain[0].getPublicKey(), (PrivateKey)key);
                            if (this.ksProtectionLevel == 2) {
                                entry2.storeEntry.keyType = migKey.getParams() instanceof PSSParameterSpec ? 3 : 1;
                                entry2.storeEntry.encToken = keyProtector2.protect(migKey.getToken());
                                entry2.storeEntry.externalKeyToken = null;
                                entry2.storeEntry.keyAttribs = new RSAKeyHWAttributes(migKey.getType(), migKey.getUsage());
                            } else {
                                entry1.storeEntry.keyType = migKey.getParams() instanceof PSSParameterSpec ? 3 : 1;
                                entry1.storeEntry.encToken = keyProtector1.protect(migKey.getToken());
                                entry1.storeEntry.externalKeyToken = null;
                                entry1.storeEntry.keyAttribs = new RSAKeyHWAttributes(migKey.getType(), migKey.getUsage());
                            }
                            byte[] myExternalToken = migKey.getExternalKeyToken();
                            if (myExternalToken != null) {
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "Storing external key token for use with clear key");
                                }
                                if (this.ksProtectionLevel == 2) {
                                    entry2.storeEntry.externalKeyToken = keyProtector2.protect(myExternalToken);
                                } else {
                                    entry1.storeEntry.externalKeyToken = keyProtector1.protect(myExternalToken);
                                }
                            } else if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "No external key token was saved must not be a clear key");
                            }
                        } else if (key instanceof DSAPrivateKey) {
                            if (this.keyAttrs == null) {
                                this.keyAttrs = new DSAKeyHWAttributes(0, 3);
                            }
                            KeyPairUtils kpu = new KeyPairUtils();
                            try {
                                kpu.initializeDSA(((DSAPrivateKey)key).getParams().getP().bitLength(), null, (DSAKeyHWAttributes)this.keyAttrs, null, new DSAParameterSpec(((DSAPrivateKey)key).getParams().getP(), ((DSAPrivateKey)key).getParams().getQ(), ((DSAPrivateKey)key).getParams().getG()));
                            }
                            finally {
                                this.keyAttrs = null;
                            }
                            DSAPrivateHWKey migKey = (DSAPrivateHWKey)((Object)kpu.generatePrivateHWKey(chain[0].getPublicKey(), (PrivateKey)key));
                            if (this.ksProtectionLevel == 2) {
                                entry2.storeEntry.keyType = 0;
                                entry2.storeEntry.encToken = keyProtector2.protect(migKey.getToken());
                                entry2.storeEntry.externalKeyToken = null;
                                entry2.storeEntry.keyAttribs = new DSAKeyHWAttributes(migKey.getType(), 3);
                            } else {
                                entry1.storeEntry.keyType = 0;
                                entry1.storeEntry.encToken = keyProtector1.protect(migKey.getToken());
                                entry1.storeEntry.externalKeyToken = null;
                                entry1.storeEntry.keyAttribs = new DSAKeyHWAttributes(migKey.getType(), 3);
                            }
                        } else if (key instanceof ECPrivateKey) {
                            if (this.keyAttrs == null) {
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "Not a WrapperKey, using default ECHWKeyAttributes");
                                }
                                this.keyAttrs = new ECHWKeyAttributes(2, ECHWKeyAttributes.DEFAULT_USAGE);
                            }
                            ECPrivateHWKey hardwareKey = null;
                            try {
                                hardwareKey = KeyStoreUtils.importSoftwareECPrivateKey((ECPrivateKey)key, (ECHWKeyAttributes)this.keyAttrs);
                            }
                            finally {
                                this.keyAttrs = null;
                            }
                            if (this.ksProtectionLevel == 2) {
                                entry2.storeEntry.keyType = 2;
                                entry2.storeEntry.encToken = keyProtector2.protect(hardwareKey.getToken());
                                entry2.storeEntry.externalKeyToken = null;
                                entry2.storeEntry.keyAttribs = new ECHWKeyAttributes(hardwareKey.getType(), hardwareKey.getUsage());
                            } else {
                                entry1.storeEntry.keyType = 2;
                                entry1.storeEntry.encToken = keyProtector1.protect(hardwareKey.getToken());
                                entry1.storeEntry.externalKeyToken = null;
                                entry1.storeEntry.keyAttribs = new ECHWKeyAttributes(hardwareKey.getType(), hardwareKey.getUsage());
                            }
                            byte[] myExternalToken = hardwareKey.getExternalKeyToken();
                            if (myExternalToken != null) {
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "Storing external key token for use with CLEAR key");
                                }
                                if (this.ksProtectionLevel == 2) {
                                    entry2.storeEntry.externalKeyToken = keyProtector2.protect(myExternalToken);
                                } else {
                                    entry1.storeEntry.externalKeyToken = keyProtector1.protect(myExternalToken);
                                }
                            } else if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "External key token not found, not a CLEAR key");
                            }
                        } else {
                            this.keyAttrs = null;
                            KeyStoreException kse = new KeyStoreException("Key is of unknown instance");
                            if (debug != null) {
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", kse);
                            }
                            throw kse;
                        }
                        if (chain != null) {
                            if (this.ksProtectionLevel == 2) {
                                entry2.chain = (Certificate[])chain.clone();
                                entry2.storeEntry.certChainEncoding = this.CreateCertChainEncodings(entry2.chain);
                            } else {
                                entry1.chain = (Certificate[])chain.clone();
                                entry1.storeEntry.certChainEncoding = this.CreateCertChainEncodings(entry1.chain);
                            }
                        }
                        if (this.ksProtectionLevel == 2) {
                            this.entries.put(alias.toLowerCase(), entry2);
                        } else {
                            this.entries.put(alias.toLowerCase(), entry1);
                        }
                        break block98;
                    }
                    if (key instanceof SecretKey) {
                        if (key instanceof PKCS11SecretKey && Boolean.TRUE.equals(((PKCS11SecretKey)key).getSensitive())) {
                            KeyStoreException kse = new KeyStoreException("Secret key value is sensitive and is not exportable");
                            if (debug != null) {
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", kse);
                            }
                            throw kse;
                        }
                        if (debug != null) {
                            debug.text(Debug.TYPE_FINE, className, "engineSetKeyEntry", "ksProtectionLevel==" + this.ksProtectionLevel + ", (key instanceof SecretKey), entry=new SecretKeyEntry()");
                        }
                        SecretKeyEntry entry = new SecretKeyEntry();
                        entry.date = new Date();
                        entry.alias = new String(alias.toLowerCase());
                        try {
                            entry.sealedKey = this.ksProtectionLevel == 2 ? keyProtector2.seal(key) : keyProtector1.seal(key);
                        }
                        catch (NotSerializableException nse) {
                            KeyStoreException kse = new KeyStoreException("The key object is not serializable", nse);
                            if (debug != null) {
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", nse);
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", kse);
                            }
                            throw kse;
                        }
                        if (key instanceof AESKey && !((AESKey)key).getCanBeStored()) {
                            KeyStoreException kse = new KeyStoreException("Error inserting AES secret key. AES secret keys containing ICSF tokens wrapped with DES master keys are ineligible for storage in a keystore.");
                            if (debug != null) {
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", kse);
                            }
                            throw kse;
                        }
                        this.entries.put(alias.toLowerCase(), entry);
                        break block98;
                    }
                    if (key instanceof WrapperKey) {
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "WrapperKey passed in. Will now unwrap it.");
                        }
                        this.keyAttrs = ((WrapperKey)key).getKeyHWAttributes();
                        this.engineSetKeyEntry(alias, ((WrapperKey)key).getKey(), password, chain);
                    }
                }
                catch (Exception e) {
                    KeyStoreException kse = new KeyStoreException(e.getMessage(), e);
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", e);
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", kse);
                        debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
                    }
                    throw kse;
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "Key to be stored must be a Key Object");
        }
        throw new KeyStoreException("Key to be stored must be a Key Object. Therefore, this function is unsupported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSetCertiticateEntry", alias, cert);
        }
        if (null == alias || "".equals(alias)) {
            IllegalArgumentException iae = new IllegalArgumentException("alias passed to setCertificateEntry() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetCertificateEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineSetCertificateEntry");
            }
            throw new KeyStoreException(iae);
        }
        if (null == cert) {
            IllegalArgumentException iae = new IllegalArgumentException("certificate passed to setCertificateEntry() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetCertificateEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineSetCertificateEntry");
            }
            throw new KeyStoreException(iae);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "engineSetKeyEntry", "ksProtectionLevel==" + this.ksProtectionLevel + ", entry=new TrustedCertEntryV2W()");
        }
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            Object entry = this.entries.get(alias.toLowerCase());
            if (entry != null) {
                if (entry instanceof HWKeyEntryV4W || entry instanceof HWKeyEntryV3W) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_FINE, className, "engineSetCertificateEntry", "cannot overwrite own certificate");
                    }
                    throw new KeyStoreException("Cannot overwrite own certificate");
                }
                if (entry instanceof SecretKeyEntry) {
                    throw new KeyStoreException("Cannot overwrite secret key");
                }
            }
            TrustedCertEntryV2W trustedCertEntry = new TrustedCertEntryV2W();
            trustedCertEntry.storeEntry = new TrustedCertEntryV2KS();
            trustedCertEntry.cert = cert;
            try {
                trustedCertEntry.storeEntry.certEncoding = cert.getEncoded();
            }
            catch (Exception e) {
                throw new KeyStoreException(e.getMessage(), e);
            }
            trustedCertEntry.storeEntry.date = new Date();
            trustedCertEntry.storeEntry.alias = new String(alias);
            this.entries.put(alias.toLowerCase(), trustedCertEntry);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineSetCertiticateEntry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineDeleteEntry", alias);
        }
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            this.entries.remove(alias.toLowerCase());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineDeleteEntry");
        }
    }

    public Enumeration engineAliases() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineAliases");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineAliases", this.entries.keys());
        }
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineContainsAlias", alias);
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineContainsAlias", new Boolean(this.entries.containsKey(alias.toLowerCase())));
        }
        return this.entries.containsKey(alias.toLowerCase());
    }

    @Override
    public int engineSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSize");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineSize", this.entries.size());
        }
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineIsKeyEntry", alias);
        }
        boolean isKey = false;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && (entry instanceof HWKeyEntryV3W || entry instanceof HWKeyEntryV4W || entry instanceof SecretKeyEntry)) {
            isKey = true;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineIsKeyEntry", new Boolean(isKey));
        }
        return isKey;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineIsCertificateEntry", alias);
        }
        boolean isCert = false;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof TrustedCertEntryV2W) {
            isCert = true;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineIsCertificateEntry", new Boolean(isCert));
        }
        return isCert;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetCertificateAlias", cert);
        }
        Enumeration<String> e = this.entries.keys();
        while (e.hasMoreElements()) {
            Certificate certElem;
            String alias = e.nextElement();
            Object entry = this.entries.get(alias.toLowerCase());
            if (entry instanceof TrustedCertEntryV2W) {
                certElem = ((TrustedCertEntryV2W)entry).cert;
            } else if (entry instanceof HWKeyEntryV3W && ((HWKeyEntryV3W)entry).chain != null) {
                certElem = ((HWKeyEntryV3W)entry).chain[0];
            } else {
                if (!(entry instanceof HWKeyEntryV4W) || ((HWKeyEntryV4W)entry).chain == null) continue;
                certElem = ((HWKeyEntryV4W)entry).chain[0];
            }
            if (!certElem.equals(cert)) continue;
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCertificateAlias", alias);
            }
            return alias;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCertificateAlias", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineStore", stream, password);
        }
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            if (password == null) {
                throw new IllegalArgumentException("password can't be null");
            }
            MessageDigest md = this.getPreKeyedHash(password);
            DataOutputStream dos = new DataOutputStream(new DigestOutputStream(stream, md));
            if (this.ksProtectionLevel == 2) {
                dos.writeUTF(EYE_S2_CATCHER);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineStore", "ProtectionLevel: " + this.ksProtectionLevel + "  EyeCatcher: " + EYE_S2_CATCHER);
                }
            } else {
                dos.writeUTF(EYE_CATCHER);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineStore", "ProtectionLevel: " + this.ksProtectionLevel + "  EyeCatcher: " + EYE_CATCHER);
                }
            }
            dos.writeInt(306008024);
            dos.writeInt(3);
            dos.writeInt(this.entries.size());
            Enumeration<String> e = this.entries.keys();
            while (e.hasMoreElements()) {
                int i;
                Serializable pentry;
                String alias = e.nextElement();
                Object entry = this.entries.get(alias);
                if (entry instanceof HWKeyEntryV4W) {
                    byte[] iv;
                    IvParameterSpec ivSpec;
                    PBEParameterSpec pSpec;
                    pentry = ((HWKeyEntryV4W)entry).storeEntry;
                    if (debug != null) {
                        debug.text(Debug.TYPE_FINE, className, "engineStore", "ProtectionLevel: " + this.ksProtectionLevel + "  starting HWKeyEntryV4KS alias: " + alias);
                    }
                    dos.writeInt(1);
                    dos.writeUTF(alias);
                    dos.writeLong(pentry.date.getTime());
                    dos.writeInt(pentry.keyType);
                    if (null == pentry.encToken) {
                        dos.writeInt(0);
                    } else {
                        dos.writeInt(pentry.encToken.getEncToken().length);
                        dos.write(pentry.encToken.getEncToken());
                        pSpec = pentry.encToken.getParameterSpec();
                        dos.writeInt(pSpec.getIterationCount());
                        dos.writeInt(pSpec.getSalt().length);
                        dos.write(pSpec.getSalt());
                        ivSpec = (IvParameterSpec)pSpec.getParameterSpec();
                        iv = ivSpec.getIV();
                        dos.writeInt(iv.length);
                        dos.write(iv);
                    }
                    if (null == pentry.externalKeyToken) {
                        dos.writeInt(0);
                    } else {
                        dos.writeInt(pentry.externalKeyToken.getEncToken().length);
                        dos.write(pentry.externalKeyToken.getEncToken());
                        pSpec = pentry.externalKeyToken.getParameterSpec();
                        dos.writeInt(pSpec.getIterationCount());
                        dos.writeInt(pSpec.getSalt().length);
                        dos.write(pSpec.getSalt());
                        ivSpec = (IvParameterSpec)pSpec.getParameterSpec();
                        iv = ivSpec.getIV();
                        dos.writeInt(iv.length);
                        dos.write(iv);
                    }
                    dos.write(pentry.keyAttribs.getKeyType());
                    dos.write(pentry.keyAttribs.getKeyUsage());
                    int chainLength = pentry.certChainEncoding.length;
                    dos.writeInt(chainLength);
                    for (i = 0; i < chainLength; ++i) {
                        dos.writeInt(pentry.certChainEncoding[i].length);
                        dos.write(pentry.certChainEncoding[i]);
                    }
                    if (debug == null) continue;
                    debug.text(Debug.TYPE_FINE, className, "engineStore", "ProtectionLevel: " + this.ksProtectionLevel + "  completed HWKeyEntryV4KS alias: " + alias);
                    continue;
                }
                if (entry instanceof HWKeyEntryV3W) {
                    pentry = ((HWKeyEntryV3W)entry).storeEntry;
                    if (debug != null) {
                        debug.text(Debug.TYPE_FINE, className, "engineStore", "ProtectionLevel: " + this.ksProtectionLevel + "  starting HWKeyEntryV3KS alias: " + alias);
                    }
                    dos.writeInt(1);
                    dos.writeUTF(alias);
                    dos.writeLong(((HWKeyEntryV3KS)pentry).date.getTime());
                    dos.writeInt(((HWKeyEntryV3KS)pentry).keyType);
                    if (null == ((HWKeyEntryV3KS)pentry).encToken) {
                        dos.writeInt(0);
                    } else {
                        dos.writeInt(((HWKeyEntryV3KS)pentry).encToken.getEncToken().length);
                        dos.write(((HWKeyEntryV3KS)pentry).encToken.getEncToken());
                        PBEParameterSpec pSpec = ((HWKeyEntryV3KS)pentry).encToken.getParameterSpec();
                        dos.writeInt(pSpec.getIterationCount());
                        dos.writeInt(pSpec.getSalt().length);
                        dos.write(pSpec.getSalt());
                    }
                    if (null == ((HWKeyEntryV3KS)pentry).externalKeyToken) {
                        dos.writeInt(0);
                    } else {
                        dos.writeInt(((HWKeyEntryV3KS)pentry).externalKeyToken.getEncToken().length);
                        dos.write(((HWKeyEntryV3KS)pentry).externalKeyToken.getEncToken());
                        PBEParameterSpec pSpec = ((HWKeyEntryV3KS)pentry).externalKeyToken.getParameterSpec();
                        dos.writeInt(pSpec.getIterationCount());
                        dos.writeInt(pSpec.getSalt().length);
                        dos.write(pSpec.getSalt());
                    }
                    dos.write(((HWKeyEntryV3KS)pentry).keyAttribs.getKeyType());
                    dos.write(((HWKeyEntryV3KS)pentry).keyAttribs.getKeyUsage());
                    int chainLength = ((HWKeyEntryV3KS)pentry).certChainEncoding.length;
                    dos.writeInt(chainLength);
                    for (i = 0; i < chainLength; ++i) {
                        dos.writeInt(((HWKeyEntryV3KS)pentry).certChainEncoding[i].length);
                        dos.write(((HWKeyEntryV3KS)pentry).certChainEncoding[i]);
                    }
                    if (debug == null) continue;
                    debug.text(Debug.TYPE_FINE, className, "engineStore", "ProtectionLevel: " + this.ksProtectionLevel + "  completed HWKeyEntryV3KS alias: " + alias);
                    continue;
                }
                if (entry instanceof TrustedCertEntryV2W) {
                    TrustedCertEntryV2KS centry = ((TrustedCertEntryV2W)entry).storeEntry;
                    if (debug != null) {
                        debug.text(Debug.TYPE_FINE, className, "engineStore", "ProtectionLevel: " + this.ksProtectionLevel + "  starting TrustedCertEntryV2KS alias: " + alias);
                    }
                    dos.writeInt(2);
                    dos.writeUTF(alias);
                    dos.writeLong(centry.date.getTime());
                    dos.writeInt(centry.certEncoding.length);
                    dos.write(centry.certEncoding);
                    if (debug == null) continue;
                    debug.text(Debug.TYPE_FINE, className, "engineStore", "ProtectionLevel: " + this.ksProtectionLevel + "  completed TrustedCertEntryV2KS alias: " + alias);
                    continue;
                }
                SecretKeyEntry sentry = (SecretKeyEntry)entry;
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "engineStore", "ProtectionLevel: " + this.ksProtectionLevel + "  starting SecretKeyEntry alias: " + alias);
                }
                dos.writeInt(3);
                dos.writeUTF(alias);
                dos.writeLong(sentry.date.getTime());
                ObjectOutputStream oos = new ObjectOutputStream(dos);
                oos.writeObject(sentry.sealedKey);
                if (debug == null) continue;
                debug.text(Debug.TYPE_FINE, className, "engineStore", "ProtectionLevel: " + this.ksProtectionLevel + "  completed SecretKeyEntry alias: " + alias);
            }
            byte[] digest = md.digest();
            dos.write(digest);
            dos.flush();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineStore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineLoad", stream, password);
        }
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            MessageDigest md = null;
            DataInputStream dis = null;
            if (stream == null) {
                return;
            }
            if (password != null) {
                md = this.getPreKeyedHash(password);
                dis = new DataInputStream(new DigestInputStream(stream, md));
            } else {
                dis = new DataInputStream(stream);
            }
            String eyeCatcher = null;
            int xMagic = 0;
            int xVersion = 0;
            try {
                eyeCatcher = dis.readUTF();
                xMagic = dis.readInt();
                xVersion = dis.readInt();
            }
            catch (Throwable e) {
                IOException ioex = new IOException("Invalid keystore format", e);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineLoad", "Unable to read EyeCatcher, MagicNumber, or Version");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineLoad", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineLoad", ioex);
                }
                throw ioex;
            }
            if (xMagic != 306008024 || xVersion != 3 || !eyeCatcher.equals(EYE_S2_CATCHER) && !eyeCatcher.equals(EYE_CATCHER) && !eyeCatcher.equals(EYE_OLD_CATCHER)) {
                IOException ioex = new IOException("Invalid keystore format");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineLoad", "Unexpected value for MagicNumber, Version, or EyeCatcher");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineLoad", ioex);
                }
                throw ioex;
            }
            this.ksProtectionLevel = eyeCatcher.equals(EYE_S2_CATCHER) ? 2 : 1;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineLoad", "EyeCatcher: " + eyeCatcher + "  ProtectionLevel: " + this.ksProtectionLevel);
            }
            this.entries.clear();
            int count = dis.readInt();
            for (int i = 0; i < count; ++i) {
                Serializable entry;
                String alias = null;
                Serializable obj = null;
                int length = 0;
                boolean skip = false;
                int tag = dis.readInt();
                if (tag == 1) {
                    int j;
                    int chainSize;
                    byte usage;
                    byte type;
                    int iterationCount;
                    byte[] readArray;
                    if (this.ksProtectionLevel == 2) {
                        PBEParameterSpec spec;
                        IvParameterSpec ivSpec;
                        byte[] iv;
                        byte[] salt;
                        HWKeyEntryV4W entry2 = new HWKeyEntryV4W();
                        entry2.storeEntry = new HWKeyEntryV4KS();
                        entry2.storeEntry.alias = alias = dis.readUTF();
                        if (debug != null) {
                            debug.text(Debug.TYPE_FINE, className, "engineLoad", "ProtectionLevel: " + this.ksProtectionLevel + "  starting HWKeyEntryV4KS entry alias: " + alias);
                        }
                        entry2.storeEntry.date = new Date(dis.readLong());
                        entry2.storeEntry.keyType = dis.readInt();
                        length = dis.readInt();
                        if (length == 0) {
                            entry2.storeEntry.encToken = null;
                        } else {
                            readArray = new byte[length];
                            dis.readFully(readArray);
                            iterationCount = dis.readInt();
                            salt = new byte[dis.readInt()];
                            dis.readFully(salt);
                            iv = new byte[dis.readInt()];
                            dis.readFully(iv);
                            ivSpec = new IvParameterSpec(iv);
                            spec = new PBEParameterSpec(salt, iterationCount, ivSpec);
                            entry2.storeEntry.encToken = new SealedTokenForKeyProtectorS2(readArray, spec);
                        }
                        length = dis.readInt();
                        if (length == 0) {
                            entry2.storeEntry.externalKeyToken = null;
                        } else {
                            readArray = new byte[length];
                            dis.readFully(readArray);
                            iterationCount = dis.readInt();
                            salt = new byte[dis.readInt()];
                            dis.readFully(salt);
                            iv = new byte[dis.readInt()];
                            dis.readFully(iv);
                            ivSpec = new IvParameterSpec(iv);
                            spec = new PBEParameterSpec(salt, iterationCount, ivSpec);
                            entry2.storeEntry.externalKeyToken = new SealedTokenForKeyProtectorS2(readArray, spec);
                        }
                        type = dis.readByte();
                        usage = dis.readByte();
                        if (entry2.storeEntry.keyType == 1 || entry2.storeEntry.keyType == 3) {
                            entry2.storeEntry.keyAttribs = new RSAKeyHWAttributes(type, usage);
                        } else if (entry2.storeEntry.keyType == 0) {
                            entry2.storeEntry.keyAttribs = new DSAKeyHWAttributes(type, usage);
                        } else if (entry2.storeEntry.keyType == 2) {
                            entry2.storeEntry.keyAttribs = new ECHWKeyAttributes(type, usage);
                        } else {
                            IOException ioex = new IOException("Invalid key format");
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineLoad", "Unexpected value for keyType");
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineLoad", ioex);
                                debug.exit(Debug.TYPE_PUBLIC, className, "engineLoad");
                            }
                            throw ioex;
                        }
                        chainSize = dis.readInt();
                        entry2.storeEntry.certChainEncoding = new byte[chainSize][];
                        for (j = 0; j < chainSize; ++j) {
                            entry2.storeEntry.certChainEncoding[j] = new byte[dis.readInt()];
                            dis.readFully(entry2.storeEntry.certChainEncoding[j]);
                        }
                        entry2.chain = this.CreateCertChain(entry2.storeEntry.certChainEncoding);
                        obj = entry2;
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineLoad", "ProtectionLevel: " + this.ksProtectionLevel + "  completed HWKeyEntryV4KS entry alias: " + alias);
                        }
                    } else {
                        HWKeyEntryV3W entry1 = new HWKeyEntryV3W();
                        entry1.storeEntry = new HWKeyEntryV3KS();
                        entry1.storeEntry.alias = alias = dis.readUTF();
                        if (debug != null) {
                            debug.text(Debug.TYPE_FINE, className, "engineLoad", "ProtectionLevel: " + this.ksProtectionLevel + "  starting HWKeyEntryV3KS entry alias: " + alias);
                        }
                        entry1.storeEntry.date = new Date(dis.readLong());
                        entry1.storeEntry.keyType = dis.readInt();
                        length = dis.readInt();
                        if (length == 0) {
                            entry1.storeEntry.encToken = null;
                        } else {
                            readArray = new byte[length];
                            dis.readFully(readArray);
                            iterationCount = dis.readInt();
                            byte[] salt = new byte[dis.readInt()];
                            dis.readFully(salt);
                            PBEParameterSpec spec = new PBEParameterSpec(salt, iterationCount);
                            entry1.storeEntry.encToken = new SealedTokenForKeyProtector(readArray, spec);
                        }
                        length = dis.readInt();
                        if (length == 0) {
                            entry1.storeEntry.externalKeyToken = null;
                        } else {
                            readArray = new byte[length];
                            dis.readFully(readArray);
                            iterationCount = dis.readInt();
                            byte[] salt = new byte[dis.readInt()];
                            dis.readFully(salt);
                            PBEParameterSpec spec = new PBEParameterSpec(salt, iterationCount);
                            entry1.storeEntry.externalKeyToken = new SealedTokenForKeyProtector(readArray, spec);
                        }
                        type = dis.readByte();
                        usage = dis.readByte();
                        if (entry1.storeEntry.keyType == 1 || entry1.storeEntry.keyType == 3) {
                            entry1.storeEntry.keyAttribs = new RSAKeyHWAttributes(type, usage);
                        } else if (entry1.storeEntry.keyType == 0) {
                            entry1.storeEntry.keyAttribs = new DSAKeyHWAttributes(type, usage);
                        } else if (entry1.storeEntry.keyType == 2) {
                            entry1.storeEntry.keyAttribs = new ECHWKeyAttributes(type, usage);
                        } else {
                            IOException ioex = new IOException("Invalid key format");
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineLoad", "Unexpected value for keyType");
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineLoad", ioex);
                                debug.exit(Debug.TYPE_FINE, className, "engineLoad");
                            }
                            throw ioex;
                        }
                        chainSize = dis.readInt();
                        entry1.storeEntry.certChainEncoding = new byte[chainSize][];
                        for (j = 0; j < chainSize; ++j) {
                            entry1.storeEntry.certChainEncoding[j] = new byte[dis.readInt()];
                            dis.readFully(entry1.storeEntry.certChainEncoding[j]);
                        }
                        entry1.chain = this.CreateCertChain(entry1.storeEntry.certChainEncoding);
                        obj = entry1;
                        if (debug != null) {
                            debug.text(Debug.TYPE_FINE, className, "engineLoad", "ProtectionLevel: " + this.ksProtectionLevel + "  completed HWKeyEntryV3KS entry alias: " + alias);
                        }
                    }
                } else if (tag == 2) {
                    entry = new TrustedCertEntryV2W();
                    entry.storeEntry = new TrustedCertEntryV2KS();
                    entry.storeEntry.alias = alias = dis.readUTF();
                    if (debug != null) {
                        debug.text(Debug.TYPE_FINE, className, "engineLoad", "ProtectionLevel: " + this.ksProtectionLevel + "  starting TrustedCertEntryV2KS entry alias: " + alias);
                    }
                    entry.storeEntry.date = new Date(dis.readLong());
                    entry.storeEntry.certEncoding = new byte[dis.readInt()];
                    dis.readFully(entry.storeEntry.certEncoding);
                    entry.cert = this.CreateCert(entry.storeEntry.certEncoding);
                    obj = entry;
                    if (debug != null) {
                        debug.text(Debug.TYPE_FINE, className, "engineLoad", "ProtectionLevel: " + this.ksProtectionLevel + "  completed TrustedCertEntryV2KS entry alias: " + alias);
                    }
                } else if (tag == 3) {
                    entry = new SecretKeyEntry();
                    ((SecretKeyEntry)entry).alias = alias = dis.readUTF();
                    if (debug != null) {
                        debug.text(Debug.TYPE_FINE, className, "engineLoad", "ProtectionLevel: " + this.ksProtectionLevel + "  starting SecretKeyEntry entry alias: " + alias);
                    }
                    ((SecretKeyEntry)entry).date = new Date(dis.readLong());
                    ObjectInputStream ois = new ObjectInputStream(dis);
                    try {
                        ((SecretKeyEntry)entry).sealedKey = (SealedObject)ois.readObject();
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new IOException(cnfe.getMessage(), cnfe);
                    }
                    obj = entry;
                    if (debug != null) {
                        debug.text(Debug.TYPE_FINE, className, "engineLoad", "ProtectionLevel: " + this.ksProtectionLevel + "  completed SecretKeyEntry entry alias: " + alias);
                    }
                } else {
                    skip = true;
                    if (debug != null) {
                        debug.text(Debug.TYPE_FINE, className, "engineLoad", "ProtectionLevel: " + this.ksProtectionLevel + "  skipping unrecognized type entry ");
                    }
                }
                if (!skip) {
                    this.entries.put(alias.toLowerCase(), obj);
                }
                skip = false;
            }
            if (password != null && count != 0) {
                byte[] computed = md.digest();
                byte[] actual = new byte[computed.length];
                dis.readFully(actual);
                for (int i = 0; i < computed.length; ++i) {
                    if (computed[i] == actual[i]) continue;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineLoad", "incorrect password");
                    }
                    throw new IOException("Keystore was tampered with, or password was incorrect");
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineLoad");
        }
    }

    private MessageDigest getPreKeyedHash(char[] password) throws NoSuchAlgorithmException {
        int i;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "getPreKeyedHash", (Object)password);
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA", "IBMJCECCA");
        }
        catch (NoSuchProviderException nspe) {
            try {
                md = MessageDigest.getInstance("SHA", "IBMJCE4758");
            }
            catch (NoSuchProviderException nspe2) {
                md = MessageDigest.getInstance("SHA");
            }
        }
        byte[] passwdBytes = new byte[password.length * 2];
        int j = 0;
        for (i = 0; i < password.length; ++i) {
            passwdBytes[j++] = (byte)(password[i] >> 8);
            passwdBytes[j++] = (byte)password[i];
        }
        md.update(passwdBytes);
        for (i = 0; i < passwdBytes.length; ++i) {
            passwdBytes[i] = 0;
        }
        md.update("Mighty Aphrodite".getBytes(PlatformUtilities.CHARSET_UTF8));
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "getPreKeyedHash", md);
        }
        return md;
    }

    private Certificate[] CreateCertChain(byte[][] chain) throws CertificateException {
        int i = 0;
        Certificate[] retCert = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "CreateCertChain", (Object[])chain);
        }
        if (chain != null) {
            retCert = new Certificate[chain.length];
            for (i = 0; i < chain.length; ++i) {
                retCert[i] = this.CreateCert(chain[i]);
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "CreateCertChain", chain);
            }
        }
        return retCert;
    }

    private byte[][] CreateCertChainEncodings(Certificate[] chain) throws CertificateException {
        int i = 0;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "CreateCertChainEncodings", chain);
        }
        byte[][] retCertEncoding = new byte[chain.length][];
        try {
            for (i = 0; i < chain.length; ++i) {
                retCertEncoding[i] = chain[i].getEncoded();
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "CreateCertChainEncodings", chain);
            }
            return retCertEncoding;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "CreateCertChainEncodings", e.getMessage());
            }
            throw new CertificateException(e.getMessage(), e);
        }
    }

    private Certificate CreateCert(byte[] encoding) throws CertificateException {
        Certificate retCert;
        block7: {
            retCert = null;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "CreateCert", (Object)encoding);
            }
            if (encoding != null) {
                try {
                    CertificateFactory cf = null;
                    try {
                        cf = CertificateFactory.getInstance("X.509", "IBMJCECCA");
                    }
                    catch (NoSuchProviderException nspe) {
                        cf = CertificateFactory.getInstance("X.509", "IBMJCE4758");
                    }
                    ByteArrayInputStream stream = new ByteArrayInputStream(encoding);
                    retCert = cf.generateCertificate(stream);
                }
                catch (NoSuchProviderException e) {
                    if (debug == null) break block7;
                    debug.text(Debug.TYPE_PUBLIC, className, "CreateCert", "NoSuchProvider");
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "CreateCert", encoding);
        }
        return retCert;
    }
}

