/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.DSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HWKeyEntryV3KS;
import com.ibm.crypto.hdwrCCA.provider.HWKeyEntryV3W;
import com.ibm.crypto.hdwrCCA.provider.KeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.KeyProtector;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.SealedTokenForKeyProtector;
import com.ibm.crypto.hdwrCCA.provider.SecretKeyEntry;
import com.ibm.crypto.hdwrCCA.provider.TrustedCertEntryV2KS;
import com.ibm.crypto.hdwrCCA.provider.TrustedCertEntryV2W;
import com.ibm.crypto.hdwrCCA.provider.WrapperKey;
import com.ibm.security.rsa.RSAUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;

public final class Jce4758KeyStore
extends KeyStoreSpi {
    private static final int JCE4758KS_MAGIC = 306008024;
    private static final String EYE_CATCHER = "JCE4758KS";
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int VERSION_3 = 3;
    private static final int DSA_KEY = 0;
    private static final int RSA_KEY = 1;
    private static final int RSAPSS_KEY = 2;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.Jce4758KeyStore";
    private Hashtable entries = new Hashtable();
    private KeyHWAttributes keyAttrs = null;

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "engineGetKey", alias, password);
        }
        if (null == alias || "".equals(alias)) {
            IllegalArgumentException iae = new IllegalArgumentException("alias passed to getKey() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "engineGetKey");
            }
            throw iae;
        }
        Serializable key = null;
        try {
            Object entry = this.entries.get(alias.toLowerCase());
            if (entry == null || entry instanceof TrustedCertEntryV2W) {
                return null;
            }
            KeyProtector keyProtector = new KeyProtector(password);
            if (entry instanceof HWKeyEntryV3W) {
                HWKeyEntryV3W hwEntry = (HWKeyEntryV3W)entry;
                byte[] token = keyProtector.recover(hwEntry.storeEntry.encToken);
                byte[] extToken = null;
                if (hwEntry.storeEntry.externalKeyToken != null) {
                    extToken = keyProtector.recover(hwEntry.storeEntry.externalKeyToken);
                }
                if (hwEntry.storeEntry.keyType == 1) {
                    key = new RSAPrivateHWKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)RSAUtil.KeyType.RSA, null), token, extToken, (RSAKeyHWAttributes)hwEntry.storeEntry.keyAttribs);
                } else if (hwEntry.storeEntry.keyType == 2) {
                    key = new RSAPrivateHWKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)RSAUtil.KeyType.PSS, null), token, extToken, (RSAKeyHWAttributes)hwEntry.storeEntry.keyAttribs);
                } else if (hwEntry.storeEntry.keyType == 0) {
                    DSAPublicKey pubkey = (DSAPublicKey)hwEntry.chain[0].getPublicKey();
                    DSAParams params = pubkey.getParams();
                    key = new DSAPrivateHWKey(token, params.getP(), params.getQ(), params.getG(), (DSAKeyHWAttributes)hwEntry.storeEntry.keyAttribs);
                }
            } else if (entry instanceof SecretKeyEntry) {
                key = keyProtector.unseal(((SecretKeyEntry)entry).sealedKey);
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineGetKey", key);
            }
            return key;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", e);
            }
            throw new UnrecoverableKeyException(e.getMessage());
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] chain = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineGetCertificateChain", alias);
        }
        if (null == alias || "".equals(alias)) {
            IllegalArgumentException iae = new IllegalArgumentException("alias passed to getCertificateChain() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetCertificateChain", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "engineGetCertificateChain");
            }
            throw iae;
        }
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof HWKeyEntryV3W && ((HWKeyEntryV3W)entry).chain != null) {
            chain = (Certificate[])((HWKeyEntryV3W)entry).chain.clone();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineGetCertificateChain", chain);
        }
        return chain;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineGetCertificate", alias);
        }
        if (null == alias || "".equals(alias)) {
            IllegalArgumentException iae = new IllegalArgumentException("alias passed to getCertificate() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetCertificate", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "engineGetCertificate");
            }
            throw iae;
        }
        Certificate cert = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof TrustedCertEntryV2W) {
                cert = ((TrustedCertEntryV2W)entry).cert;
            } else if (entry instanceof HWKeyEntryV3W && ((HWKeyEntryV3W)entry).chain != null) {
                cert = ((HWKeyEntryV3W)entry).chain[0];
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineGetCertificate", cert);
        }
        return cert;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineGetCreationDate", alias);
        }
        Date date = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof TrustedCertEntryV2W) {
                date = new Date(((TrustedCertEntryV2W)entry).storeEntry.date.getTime());
            } else if (entry instanceof HWKeyEntryV3W) {
                date = new Date(((HWKeyEntryV3W)entry).storeEntry.date.getTime());
            } else if (entry instanceof SecretKeyEntry) {
                date = new Date(((SecretKeyEntry)entry).date.getTime());
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineGetCreationDate", date);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        IllegalArgumentException iae;
        if (debug != null) {
            Object[] parms = new Object[]{alias, key, password, chain};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineSetKeyEntry", parms);
        }
        if (null == alias || "".equals(alias)) {
            iae = new IllegalArgumentException("alias passed to setKeyEntry() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry");
            }
            throw new KeyStoreException(iae);
        }
        if (null == key) {
            iae = new IllegalArgumentException("key passed to setKeyEntry() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry");
            }
            throw new KeyStoreException(iae);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            try {
                KeyProtector keyProtector = new KeyProtector(password);
                if (key instanceof PrivateKey) {
                    HWKeyEntryV3W entry = new HWKeyEntryV3W();
                    entry.storeEntry = new HWKeyEntryV3KS();
                    entry.storeEntry.date = new Date();
                    entry.storeEntry.alias = new String(alias.toLowerCase());
                    if (key instanceof RSAPrivateHWKey) {
                        entry.storeEntry.keyType = ((RSAPrivateHWKey)key).getParams() instanceof PSSParameterSpec ? 2 : 1;
                        entry.storeEntry.encToken = keyProtector.protect(((RSAPrivateHWKey)key).getToken());
                        byte[] myExternalToken = ((RSAPrivateHWKey)key).getExternalKeyToken();
                        if (myExternalToken != null) {
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "Storing external key token for use with clear key");
                            }
                            entry.storeEntry.externalKeyToken = keyProtector.protect(myExternalToken);
                        } else {
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "No external key token was saved must not be a clear key");
                            }
                            entry.storeEntry.externalKeyToken = null;
                        }
                        entry.storeEntry.keyAttribs = new RSAKeyHWAttributes(((RSAPrivateHWKey)key).getType(), ((RSAPrivateHWKey)key).getUsage());
                    } else if (key instanceof DSAPrivateHWKey) {
                        entry.storeEntry.keyType = 0;
                        entry.storeEntry.encToken = keyProtector.protect(((DSAPrivateHWKey)((Object)key)).getToken());
                        entry.storeEntry.externalKeyToken = null;
                        entry.storeEntry.keyAttribs = new DSAKeyHWAttributes(((DSAPrivateHWKey)((Object)key)).getType(), 3);
                    } else if (key instanceof RSAPrivateKey || key instanceof RSAPrivateCrtKey) {
                        KeyPairUtils.KeyPairAlgorithm keyPairAlgorithm;
                        KeyPairUtils kpu = new KeyPairUtils();
                        if (this.keyAttrs == null) {
                            this.keyAttrs = new RSAKeyHWAttributes(2, 4);
                        }
                        if (((RSAKey)((Object)key)).getParams() instanceof PSSParameterSpec) {
                            keyPairAlgorithm = KeyPairUtils.KeyPairAlgorithm.RSAPSS;
                            entry.storeEntry.keyType = 2;
                        } else {
                            keyPairAlgorithm = KeyPairUtils.KeyPairAlgorithm.RSA;
                            entry.storeEntry.keyType = 1;
                        }
                        kpu.initializeRSA(((RSAPrivateKey)key).getPrivateExponent().bitLength(), null, (RSAKeyHWAttributes)this.keyAttrs, null, keyPairAlgorithm);
                        this.keyAttrs = null;
                        RSAPrivateHWKey migKey = (RSAPrivateHWKey)kpu.generatePrivateHWKey(chain[0].getPublicKey(), (PrivateKey)key);
                        entry.storeEntry.encToken = keyProtector.protect(migKey.getToken());
                        byte[] myExternalToken = migKey.getExternalKeyToken();
                        if (myExternalToken != null) {
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "Storing external key token for use with clear key");
                            }
                            entry.storeEntry.externalKeyToken = keyProtector.protect(myExternalToken);
                        } else {
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "No external key token was saved must not be a clear key");
                            }
                            entry.storeEntry.externalKeyToken = null;
                        }
                        entry.storeEntry.keyAttribs = new RSAKeyHWAttributes(migKey.getType(), migKey.getUsage());
                    } else if (key instanceof DSAPrivateKey) {
                        KeyPairUtils kpu = new KeyPairUtils();
                        if (this.keyAttrs == null) {
                            this.keyAttrs = new DSAKeyHWAttributes(0, 3);
                        }
                        kpu.initializeDSA(((DSAPrivateKey)key).getParams().getP().bitLength(), null, (DSAKeyHWAttributes)this.keyAttrs, null, new DSAParameterSpec(((DSAPrivateKey)key).getParams().getP(), ((DSAPrivateKey)key).getParams().getQ(), ((DSAPrivateKey)key).getParams().getG()));
                        this.keyAttrs = null;
                        DSAPrivateHWKey migKey = (DSAPrivateHWKey)((Object)kpu.generatePrivateHWKey(chain[0].getPublicKey(), (PrivateKey)key));
                        entry.storeEntry.keyType = 0;
                        entry.storeEntry.encToken = keyProtector.protect(migKey.getToken());
                        entry.storeEntry.externalKeyToken = null;
                        entry.storeEntry.keyAttribs = new DSAKeyHWAttributes(migKey.getType(), 3);
                    } else {
                        throw new KeyStoreException("Key is of unknown instance.");
                    }
                    if (chain != null) {
                        entry.chain = (Certificate[])chain.clone();
                        entry.storeEntry.certChainEncoding = this.CreateCertChainEncodings(entry.chain);
                    }
                    this.entries.put(alias.toLowerCase(), entry);
                } else if (key instanceof SecretKey) {
                    SecretKeyEntry entry = new SecretKeyEntry();
                    entry.date = new Date();
                    entry.alias = new String(alias.toLowerCase());
                    entry.sealedKey = keyProtector.seal(key);
                    this.entries.put(alias.toLowerCase(), entry);
                } else if (key instanceof WrapperKey) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "WrapperKey passed in. Will now unwrap it.");
                    }
                    this.keyAttrs = ((WrapperKey)key).getKeyHWAttributes();
                    this.engineSetKeyEntry(alias, ((WrapperKey)key).getKey(), password, chain);
                }
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", e);
                }
                throw new KeyStoreException(e.getMessage());
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry");
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "Key to be stored must be a Key Object");
        }
        throw new KeyStoreException("Key to be stored must be a Key Object. Therefore, this function is unsupported ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "engineSetCertiticateEntry", alias, cert);
        }
        if (null == alias || "".equals(alias)) {
            IllegalArgumentException iae = new IllegalArgumentException("alias passed to setCertificateEntry() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetCertificateEntry", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "engineSetCertificateEntry");
            }
            throw new KeyStoreException(iae);
        }
        if (null == cert) {
            IllegalArgumentException iae = new IllegalArgumentException("certificate passed to setCertificateEntry() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetCertificateEntry", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "engineSetCertificateEntry");
            }
            throw new KeyStoreException(iae);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object entry = this.entries.get(alias.toLowerCase());
            if (entry != null) {
                if (entry instanceof HWKeyEntryV3W) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineSetCertiticateEntry", "cannot overwrite own certificate");
                    }
                    throw new KeyStoreException("Cannot overwrite own certificate");
                }
                if (entry instanceof SecretKeyEntry) {
                    throw new KeyStoreException("Cannot overwrite secret key");
                }
            }
            TrustedCertEntryV2W trustedCertEntry = new TrustedCertEntryV2W();
            trustedCertEntry.storeEntry = new TrustedCertEntryV2KS();
            trustedCertEntry.cert = cert;
            try {
                trustedCertEntry.storeEntry.certEncoding = cert.getEncoded();
            }
            catch (Exception e) {
                throw new KeyStoreException(e.getMessage());
            }
            trustedCertEntry.storeEntry.date = new Date();
            trustedCertEntry.storeEntry.alias = new String(alias);
            this.entries.put(alias.toLowerCase(), trustedCertEntry);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "engineSetCertiticateEntry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineDeleteEntry", alias);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            this.entries.remove(alias.toLowerCase());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "engineDeleteEntry");
        }
    }

    public Enumeration engineAliases() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "engineAliases");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineAliases", this.entries.keys());
        }
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineContainsAlias", alias);
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineContainsAlias", new Boolean(this.entries.containsKey(alias.toLowerCase())));
        }
        return this.entries.containsKey(alias.toLowerCase());
    }

    @Override
    public int engineSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "engineSize");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineSize", this.entries.size());
        }
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineIsKeyEntry", alias);
        }
        boolean isKey = false;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && (entry instanceof HWKeyEntryV3W || entry instanceof SecretKeyEntry)) {
            isKey = true;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineIsKeyEntry", new Boolean(isKey));
        }
        return isKey;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineIsCertificateEntry", alias);
        }
        boolean isCert = false;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof TrustedCertEntryV2W) {
            isCert = true;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineIsCertificateEntry", new Boolean(isCert));
        }
        return isCert;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineGetCertificateAlias", cert);
        }
        Enumeration e = this.entries.keys();
        while (e.hasMoreElements()) {
            Certificate certElem;
            String alias = (String)e.nextElement();
            Object entry = this.entries.get(alias.toLowerCase());
            if (entry instanceof TrustedCertEntryV2W) {
                certElem = ((TrustedCertEntryV2W)entry).cert;
            } else {
                if (!(entry instanceof HWKeyEntryV3W) || ((HWKeyEntryV3W)entry).chain == null) continue;
                certElem = ((HWKeyEntryV3W)entry).chain[0];
            }
            if (!certElem.equals(cert)) continue;
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineGetCertificateAlias", alias);
            }
            return alias;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "engineGetCertificateAlias", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "engineStore", stream, password);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            if (password == null) {
                throw new IllegalArgumentException("password can't be null");
            }
            MessageDigest md = this.getPreKeyedHash(password);
            DataOutputStream dos = new DataOutputStream(new DigestOutputStream(stream, md));
            dos.writeUTF(EYE_CATCHER);
            dos.writeInt(306008024);
            dos.writeInt(3);
            dos.writeInt(this.entries.size());
            Enumeration e = this.entries.keys();
            while (e.hasMoreElements()) {
                String alias = (String)e.nextElement();
                Object entry = this.entries.get(alias);
                if (entry instanceof HWKeyEntryV3W) {
                    PBEParameterSpec pSpec;
                    HWKeyEntryV3KS pentry = ((HWKeyEntryV3W)entry).storeEntry;
                    dos.writeInt(1);
                    dos.writeUTF(alias);
                    dos.writeLong(pentry.date.getTime());
                    dos.writeInt(pentry.keyType);
                    if (null == pentry.encToken) {
                        dos.writeInt(0);
                    } else {
                        dos.writeInt(pentry.encToken.getEncToken().length);
                        dos.write(pentry.encToken.getEncToken());
                        pSpec = pentry.encToken.getParameterSpec();
                        dos.writeInt(pSpec.getIterationCount());
                        dos.writeInt(pSpec.getSalt().length);
                        dos.write(pSpec.getSalt());
                    }
                    if (null == pentry.externalKeyToken) {
                        dos.writeInt(0);
                    } else {
                        dos.writeInt(pentry.externalKeyToken.getEncToken().length);
                        dos.write(pentry.externalKeyToken.getEncToken());
                        pSpec = pentry.externalKeyToken.getParameterSpec();
                        dos.writeInt(pSpec.getIterationCount());
                        dos.writeInt(pSpec.getSalt().length);
                        dos.write(pSpec.getSalt());
                    }
                    dos.write(pentry.keyAttribs.getKeyType());
                    dos.write(pentry.keyAttribs.getKeyUsage());
                    int chainLength = pentry.certChainEncoding.length;
                    dos.writeInt(chainLength);
                    for (int i = 0; i < chainLength; ++i) {
                        dos.writeInt(pentry.certChainEncoding[i].length);
                        dos.write(pentry.certChainEncoding[i]);
                    }
                    continue;
                }
                if (entry instanceof TrustedCertEntryV2W) {
                    TrustedCertEntryV2KS centry = ((TrustedCertEntryV2W)entry).storeEntry;
                    dos.writeInt(2);
                    dos.writeUTF(alias);
                    dos.writeLong(centry.date.getTime());
                    dos.writeInt(centry.certEncoding.length);
                    dos.write(centry.certEncoding);
                    continue;
                }
                SecretKeyEntry sentry = (SecretKeyEntry)entry;
                dos.writeInt(3);
                dos.writeUTF(alias);
                dos.writeLong(sentry.date.getTime());
                ObjectOutputStream oos = new ObjectOutputStream(dos);
                oos.writeObject(sentry.sealedKey);
            }
            byte[] digest = md.digest();
            dos.write(digest);
            dos.flush();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "engineStore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "engineLoad", stream, password);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            MessageDigest md = null;
            DataInputStream dis = null;
            Object cf = null;
            Object cfs = null;
            Object bais = null;
            Object encoded = null;
            if (stream == null) {
                return;
            }
            if (password != null) {
                md = this.getPreKeyedHash(password);
                dis = new DataInputStream(new DigestInputStream(stream, md));
            } else {
                dis = new DataInputStream(stream);
            }
            String eyeCatcher = null;
            try {
                eyeCatcher = dis.readUTF();
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineLoad", e);
                }
                throw new IOException(e.getMessage());
            }
            int xMagic = dis.readInt();
            int xVersion = dis.readInt();
            if (xMagic != 306008024 || xVersion != 3 || !eyeCatcher.equals(EYE_CATCHER)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineLoad", "Invalid keystore format");
                }
                throw new IOException("Invalid keystore format");
            }
            this.entries.clear();
            int count = dis.readInt();
            for (int i = 0; i < count; ++i) {
                Serializable entry;
                String alias = null;
                Serializable obj = null;
                int length = 0;
                boolean skip = false;
                int tag = dis.readInt();
                if (tag == 1) {
                    PBEParameterSpec spec;
                    byte[] salt;
                    int iterationCount;
                    byte[] readArray;
                    entry = new HWKeyEntryV3W();
                    entry.storeEntry = new HWKeyEntryV3KS();
                    entry.storeEntry.alias = alias = dis.readUTF();
                    entry.storeEntry.date = new Date(dis.readLong());
                    entry.storeEntry.keyType = dis.readInt();
                    length = dis.readInt();
                    if (length == 0) {
                        entry.storeEntry.encToken = null;
                    } else {
                        readArray = new byte[length];
                        dis.readFully(readArray);
                        iterationCount = dis.readInt();
                        salt = new byte[dis.readInt()];
                        dis.readFully(salt);
                        spec = new PBEParameterSpec(salt, iterationCount);
                        entry.storeEntry.encToken = new SealedTokenForKeyProtector(readArray, spec);
                    }
                    length = dis.readInt();
                    if (length == 0) {
                        entry.storeEntry.externalKeyToken = null;
                    } else {
                        readArray = new byte[length];
                        dis.readFully(readArray);
                        iterationCount = dis.readInt();
                        salt = new byte[dis.readInt()];
                        dis.readFully(salt);
                        spec = new PBEParameterSpec(salt, iterationCount);
                        entry.storeEntry.externalKeyToken = new SealedTokenForKeyProtector(readArray, spec);
                    }
                    byte type = dis.readByte();
                    byte usage = dis.readByte();
                    entry.storeEntry.keyAttribs = entry.storeEntry.keyType == 1 || entry.storeEntry.keyType == 2 ? new RSAKeyHWAttributes(type, usage) : new DSAKeyHWAttributes(type, usage);
                    int chainSize = dis.readInt();
                    entry.storeEntry.certChainEncoding = new byte[chainSize][];
                    for (int j = 0; j < chainSize; ++j) {
                        entry.storeEntry.certChainEncoding[j] = new byte[dis.readInt()];
                        dis.readFully(entry.storeEntry.certChainEncoding[j]);
                    }
                    entry.chain = this.CreateCertChain(entry.storeEntry.certChainEncoding);
                    obj = entry;
                } else if (tag == 2) {
                    entry = new TrustedCertEntryV2W();
                    ((TrustedCertEntryV2W)entry).storeEntry = new TrustedCertEntryV2KS();
                    ((TrustedCertEntryV2W)entry).storeEntry.alias = alias = dis.readUTF();
                    ((TrustedCertEntryV2W)entry).storeEntry.date = new Date(dis.readLong());
                    ((TrustedCertEntryV2W)entry).storeEntry.certEncoding = new byte[dis.readInt()];
                    dis.readFully(((TrustedCertEntryV2W)entry).storeEntry.certEncoding);
                    ((TrustedCertEntryV2W)entry).cert = this.CreateCert(((TrustedCertEntryV2W)entry).storeEntry.certEncoding);
                    obj = entry;
                } else if (tag == 3) {
                    entry = new SecretKeyEntry();
                    ((SecretKeyEntry)entry).alias = alias = dis.readUTF();
                    ((SecretKeyEntry)entry).date = new Date(dis.readLong());
                    ObjectInputStream ois = new ObjectInputStream(dis);
                    try {
                        ((SecretKeyEntry)entry).sealedKey = (SealedObject)ois.readObject();
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new IOException(cnfe.getMessage());
                    }
                    obj = entry;
                } else {
                    skip = true;
                }
                if (!skip) {
                    this.entries.put(alias.toLowerCase(), obj);
                }
                skip = false;
            }
            if (password != null && count != 0) {
                byte[] computed = md.digest();
                byte[] actual = new byte[computed.length];
                dis.readFully(actual);
                for (int i = 0; i < computed.length; ++i) {
                    if (computed[i] == actual[i]) continue;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineLoad", "incorrect password");
                    }
                    throw new IOException("Keystore was tampered with, or password was incorrect");
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "engineLoad");
        }
    }

    private MessageDigest getPreKeyedHash(char[] password) throws NoSuchAlgorithmException {
        int i;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getPreKeyedHash", (Object)password);
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA", "IBMJCE4758");
        }
        catch (NoSuchProviderException nspe) {
            md = MessageDigest.getInstance("SHA");
        }
        byte[] passwdBytes = new byte[password.length * 2];
        int j = 0;
        for (i = 0; i < password.length; ++i) {
            passwdBytes[j++] = (byte)(password[i] >> 8);
            passwdBytes[j++] = (byte)password[i];
        }
        md.update(passwdBytes);
        for (i = 0; i < passwdBytes.length; ++i) {
            passwdBytes[i] = 0;
        }
        md.update("Mighty Aphrodite".getBytes(PlatformUtilities.CHARSET_UTF8));
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getPreKeyedHash", md);
        }
        return md;
    }

    private Certificate[] CreateCertChain(byte[][] chain) throws CertificateException {
        int i = 0;
        Certificate[] retCert = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "CreateCertChain", (Object[])chain);
        }
        if (chain != null) {
            retCert = new Certificate[chain.length];
            for (i = 0; i < chain.length; ++i) {
                retCert[i] = this.CreateCert(chain[i]);
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "CreateCertChain", chain);
            }
        }
        return retCert;
    }

    private byte[][] CreateCertChainEncodings(Certificate[] chain) throws CertificateException {
        int i = 0;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "CreateCertChainEncodings", chain);
        }
        byte[][] retCertEncoding = new byte[chain.length][];
        try {
            for (i = 0; i < chain.length; ++i) {
                retCertEncoding[i] = chain[i].getEncoded();
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "CreateCertChainEncodings", chain);
            }
            return retCertEncoding;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "CreateCertChainEncodings", e.getMessage());
            }
            throw new CertificateException(e.getMessage());
        }
    }

    private Certificate CreateCert(byte[] encoding) throws CertificateException {
        Certificate retCert;
        block5: {
            retCert = null;
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, (Object)className, "CreateCert", (Object)encoding);
            }
            if (encoding != null) {
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509", "IBMJCE4758");
                    ByteArrayInputStream stream = new ByteArrayInputStream(encoding);
                    retCert = cf.generateCertificate(stream);
                }
                catch (NoSuchProviderException e) {
                    if (debug == null) break block5;
                    debug.text(Debug.TYPE_PUBLIC, className, "CreateCert", "NoSuchProvider");
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "CreateCert", encoding);
        }
        return retCert;
    }
}

