/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.DSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.DSAPublicKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.JcaHWKeyEntry;
import com.ibm.crypto.hdwrCCA.provider.JcaHWKeyEntryV2KS;
import com.ibm.crypto.hdwrCCA.provider.JcaHWKeyEntryV2W;
import com.ibm.crypto.hdwrCCA.provider.JcaKeyProtector;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.TrustedCertEntry;
import com.ibm.crypto.hdwrCCA.provider.TrustedCertEntryV2KS;
import com.ibm.crypto.hdwrCCA.provider.TrustedCertEntryV2W;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.rsa.RSAUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.DSAParams;
import java.security.spec.PSSParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

@Deprecated
public final class Jca4758KeyStore
extends KeyStoreSpi {
    private static final int JCA4758KS_MAGIC = 591220723;
    private static final String EYE_CATCHER = "JCA4758KS";
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int DSA_KEY = 0;
    private static final int RSA_KEY = 1;
    private static final int RSAPSS_KEY = 2;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.Jca4758KeyStore";
    private Hashtable entries = new Hashtable();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetKey", alias, password);
        }
        if (null == alias || "".equals(alias)) {
            IllegalArgumentException iae = new IllegalArgumentException("alias passed to getKey() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineGetKey");
            }
            throw iae;
        }
        PrivateKeyInfo key = null;
        try {
            Object entry = this.entries.get(alias.toLowerCase());
            if (entry == null || entry instanceof TrustedCertEntryV2W) {
                return null;
            }
            JcaKeyProtector keyProtector = new JcaKeyProtector(password);
            if (entry instanceof JcaHWKeyEntryV2W) {
                JcaHWKeyEntryV2W hwEntry = (JcaHWKeyEntryV2W)entry;
                byte[] token = keyProtector.recover(hwEntry.storeEntry.encToken);
                if (hwEntry.storeEntry.keyType == 1) {
                    key = new RSAPrivateHWKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)RSAUtil.KeyType.RSA, null), token, (RSAKeyHWAttributes)hwEntry.storeEntry.keyAttribs);
                } else if (hwEntry.storeEntry.keyType == 2) {
                    key = new RSAPrivateHWKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)RSAUtil.KeyType.PSS, null), token, (RSAKeyHWAttributes)hwEntry.storeEntry.keyAttribs);
                } else if (hwEntry.storeEntry.keyType == 0) {
                    DSAPublicKey pubkey = (DSAPublicKey)hwEntry.chain[0].getPublicKey();
                    DSAParams params = pubkey.getParams();
                    key = new DSAPrivateHWKey(token, params.getP(), params.getQ(), params.getG(), (DSAKeyHWAttributes)hwEntry.storeEntry.keyAttribs);
                }
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKey", key);
            }
            return key;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKey", e);
            }
            throw new UnrecoverableKeyException(e.getMessage());
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] chain = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetCertificateChain", alias);
        }
        if (null == alias || "".equals(alias)) {
            IllegalArgumentException iae = new IllegalArgumentException("alias passed to getCertificateChain() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetCertificateChain", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineGetCertificateChain");
            }
            throw iae;
        }
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof JcaHWKeyEntryV2W && ((JcaHWKeyEntryV2W)entry).chain != null) {
            chain = (Certificate[])((JcaHWKeyEntryV2W)entry).chain.clone();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCertificateChain", chain);
        }
        return chain;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetCertificate", alias);
        }
        if (null == alias || "".equals(alias)) {
            IllegalArgumentException iae = new IllegalArgumentException("alias passed to getCertificate() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetCertificate", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineGetCertificate");
            }
            throw iae;
        }
        Certificate cert = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof TrustedCertEntryV2W) {
                cert = ((TrustedCertEntryV2W)entry).cert;
            } else if (entry instanceof JcaHWKeyEntryV2W && ((JcaHWKeyEntryV2W)entry).chain != null) {
                cert = ((JcaHWKeyEntryV2W)entry).chain[0];
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCertificate", cert);
        }
        return cert;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetCreationDate", alias);
        }
        Date date = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof TrustedCertEntryV2W) {
                date = new Date(((TrustedCertEntryV2W)entry).storeEntry.date.getTime());
            } else if (entry instanceof JcaHWKeyEntryV2W) {
                date = new Date(((JcaHWKeyEntryV2W)entry).storeEntry.date.getTime());
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCreationDate", date);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        IllegalArgumentException iae;
        if (debug != null) {
            Object[] parms = new Object[]{alias, key, password, chain};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetKeyEntry", parms);
        }
        if (null == alias || "".equals(alias)) {
            iae = new IllegalArgumentException("alias passed to setKeyEntry() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
            }
            throw new KeyStoreException(iae);
        }
        if (null == key) {
            iae = new IllegalArgumentException("key passed to setKeyEntry() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
            }
            throw new KeyStoreException(iae);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            try {
                JcaKeyProtector keyProtector = new JcaKeyProtector(password);
                if (key instanceof PrivateKey) {
                    JcaHWKeyEntryV2W entry = new JcaHWKeyEntryV2W();
                    entry.storeEntry = new JcaHWKeyEntryV2KS();
                    entry.storeEntry.date = new Date();
                    entry.storeEntry.alias = new String(alias.toLowerCase());
                    if (key instanceof RSAPrivateHWKey) {
                        entry.storeEntry.keyType = ((RSAPrivateHWKey)key).getParams() instanceof PSSParameterSpec ? 2 : 1;
                        entry.storeEntry.encToken = keyProtector.protect(((RSAPrivateHWKey)key).getToken());
                        entry.storeEntry.keyAttribs = new RSAKeyHWAttributes(((RSAPrivateHWKey)key).getType(), ((RSAPrivateHWKey)key).getUsage());
                    } else {
                        entry.storeEntry.keyType = 0;
                        entry.storeEntry.encToken = keyProtector.protect(((DSAPrivateHWKey)((Object)key)).getToken());
                        entry.storeEntry.keyAttribs = new DSAKeyHWAttributes(((DSAPrivateHWKey)((Object)key)).getType(), 3);
                    }
                    if (chain != null) {
                        entry.chain = (Certificate[])chain.clone();
                        entry.storeEntry.certChainEncoding = this.CreateCertChainEncodings(entry.chain);
                    }
                    this.entries.put(alias.toLowerCase(), entry);
                }
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", e);
                }
                throw new KeyStoreException(e.getMessage());
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineSetKeyEntry");
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineSetKeyEntry", "Key to be stored must be a Key Object");
        }
        throw new KeyStoreException("Key to be stored must be a Key Object. Therefore, this function is unsupported ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSetCertiticateEntry", alias, cert);
        }
        if (null == alias || "".equals(alias)) {
            IllegalArgumentException iae = new IllegalArgumentException("alias passed to setCertificateEntry() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetCertificateEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineSetCertificateEntry");
            }
            throw new KeyStoreException(iae);
        }
        if (null == cert) {
            IllegalArgumentException iae = new IllegalArgumentException("certificate passed to setCertificateEntry() cannot be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetCertificateEntry", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineSetCertificateEntry");
            }
            throw new KeyStoreException(iae);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object entry = this.entries.get(alias.toLowerCase());
            if (entry != null && entry instanceof JcaHWKeyEntryV2W) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineSetCertiticateEntry", "cannot overwrite own certificate");
                }
                throw new KeyStoreException("Cannot overwrite own certificate");
            }
            TrustedCertEntryV2W trustedCertEntry = new TrustedCertEntryV2W();
            trustedCertEntry.storeEntry = new TrustedCertEntryV2KS();
            trustedCertEntry.cert = cert;
            try {
                trustedCertEntry.storeEntry.certEncoding = cert.getEncoded();
            }
            catch (Exception e) {
                throw new KeyStoreException(e.getMessage());
            }
            trustedCertEntry.storeEntry.date = new Date();
            trustedCertEntry.storeEntry.alias = new String(alias);
            this.entries.put(alias.toLowerCase(), trustedCertEntry);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineSetCertiticateEntry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineDeleteEntry", alias);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            this.entries.remove(alias.toLowerCase());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineDeleteEntry");
        }
    }

    public Enumeration engineAliases() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineAliases");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineAliases", this.entries.keys());
        }
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineContainsAlias", alias);
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineContainsAlias", new Boolean(this.entries.containsKey(alias.toLowerCase())));
        }
        return this.entries.containsKey(alias.toLowerCase());
    }

    @Override
    public int engineSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSize");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineSize", this.entries.size());
        }
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineIsKeyEntry", alias);
        }
        boolean isKey = false;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof JcaHWKeyEntryV2W) {
            isKey = true;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineIsKeyEntry", new Boolean(isKey));
        }
        return isKey;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineIsCertificateEntry", alias);
        }
        boolean isCert = false;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof TrustedCertEntryV2W) {
            isCert = true;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineIsCertificateEntry", new Boolean(isCert));
        }
        return isCert;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetCertificateAlias", cert);
        }
        Enumeration e = this.entries.keys();
        while (e.hasMoreElements()) {
            Certificate certElem;
            String alias = (String)e.nextElement();
            Object entry = this.entries.get(alias.toLowerCase());
            if (entry instanceof TrustedCertEntryV2W) {
                certElem = ((TrustedCertEntryV2W)entry).cert;
            } else {
                if (!(entry instanceof JcaHWKeyEntryV2W) || ((JcaHWKeyEntryV2W)entry).chain == null) continue;
                certElem = ((JcaHWKeyEntryV2W)entry).chain[0];
            }
            if (!certElem.equals(cert)) continue;
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCertificateAlias", alias);
            }
            return alias;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetCertificateAlias", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineStore", stream, password);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            if (password == null) {
                throw new IllegalArgumentException("password can't be null");
            }
            MessageDigest md = this.getPreKeyedHash(password);
            ObjectOutputStream oos = new ObjectOutputStream(new DigestOutputStream(stream, md));
            oos.writeObject(EYE_CATCHER);
            oos.writeInt(591220723);
            oos.writeInt(2);
            oos.writeInt(this.entries.size());
            Enumeration e = this.entries.keys();
            while (e.hasMoreElements()) {
                String alias = (String)e.nextElement();
                Object entry = this.entries.get(alias);
                if (entry instanceof JcaHWKeyEntryV2W) {
                    JcaHWKeyEntryV2KS pentry = ((JcaHWKeyEntryV2W)entry).storeEntry;
                    oos.writeObject(pentry);
                    continue;
                }
                if (!(entry instanceof TrustedCertEntryV2W)) continue;
                TrustedCertEntryV2KS centry = ((TrustedCertEntryV2W)entry).storeEntry;
                oos.writeObject(centry);
            }
            byte[] digest = md.digest();
            oos.write(digest);
            oos.flush();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineStore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineLoad", stream, password);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            String eyeCatcher;
            ObjectInputStream ois = null;
            MessageDigest md = null;
            Object cf = null;
            Object cfs = null;
            Object bais = null;
            Object encoded = null;
            if (stream == null) {
                return;
            }
            if (password != null) {
                md = this.getPreKeyedHash(password);
                ois = new ObjectInputStream(new DigestInputStream(stream, md));
            } else {
                ois = new ObjectInputStream(stream);
            }
            try {
                eyeCatcher = (String)ois.readObject();
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineLoad", e);
                }
                throw new IOException(e.getMessage());
            }
            int xMagic = ois.readInt();
            int xVersion = ois.readInt();
            if (xMagic != 591220723 || xVersion != 1 && xVersion != 2 || !eyeCatcher.equals(EYE_CATCHER)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineLoad", "Invalid keystore format");
                }
                throw new IOException("Invalid keystore format");
            }
            this.entries.clear();
            int count = ois.readInt();
            for (int i = 0; i < count; ++i) {
                Serializable entry;
                Object obj;
                String alias = null;
                boolean skip = false;
                try {
                    obj = ois.readObject();
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineLoad", e);
                    }
                    throw new IOException(e.getMessage());
                }
                if (obj instanceof JcaHWKeyEntry) {
                    entry = new JcaHWKeyEntryV2W();
                    entry.storeEntry = new JcaHWKeyEntryV2KS();
                    alias = ((JcaHWKeyEntry)obj).alias;
                    entry.storeEntry.alias = ((JcaHWKeyEntry)obj).alias;
                    entry.storeEntry.date = ((JcaHWKeyEntry)obj).date;
                    entry.storeEntry.keyType = ((JcaHWKeyEntry)obj).keyType;
                    entry.storeEntry.encToken = ((JcaHWKeyEntry)obj).encToken;
                    entry.storeEntry.keyAttribs = ((JcaHWKeyEntry)obj).keyAttribs;
                    if (((JcaHWKeyEntry)obj).chain != null) {
                        entry.storeEntry.certChainEncoding = this.CreateCertChainEncodings(((JcaHWKeyEntry)obj).chain);
                        entry.chain = this.CreateCertChain(entry.storeEntry.certChainEncoding);
                    }
                    obj = entry;
                } else if (obj instanceof JcaHWKeyEntryV2KS) {
                    entry = new JcaHWKeyEntryV2W();
                    entry.storeEntry = (JcaHWKeyEntryV2KS)obj;
                    alias = entry.storeEntry.alias;
                    if (entry.storeEntry.certChainEncoding != null) {
                        entry.chain = this.CreateCertChain(entry.storeEntry.certChainEncoding);
                    }
                    obj = entry;
                } else if (obj instanceof TrustedCertEntry) {
                    entry = new TrustedCertEntryV2W();
                    ((TrustedCertEntryV2W)entry).storeEntry = new TrustedCertEntryV2KS();
                    alias = ((TrustedCertEntry)obj).alias;
                    ((TrustedCertEntryV2W)entry).storeEntry.alias = ((TrustedCertEntry)obj).alias;
                    ((TrustedCertEntryV2W)entry).storeEntry.date = ((TrustedCertEntry)obj).date;
                    ((TrustedCertEntryV2W)entry).storeEntry.certEncoding = ((TrustedCertEntry)obj).cert.getEncoded();
                    ((TrustedCertEntryV2W)entry).cert = this.CreateCert(((TrustedCertEntryV2W)entry).storeEntry.certEncoding);
                    obj = entry;
                } else if (obj instanceof TrustedCertEntryV2KS) {
                    entry = new TrustedCertEntryV2W();
                    ((TrustedCertEntryV2W)entry).storeEntry = (TrustedCertEntryV2KS)obj;
                    alias = ((TrustedCertEntryV2W)entry).storeEntry.alias;
                    ((TrustedCertEntryV2W)entry).cert = this.CreateCert(((TrustedCertEntryV2W)entry).storeEntry.certEncoding);
                    obj = entry;
                } else {
                    skip = true;
                }
                if (!skip) {
                    this.entries.put(alias, obj);
                }
                skip = false;
            }
            if (password != null && count != 0) {
                byte[] computed = md.digest();
                byte[] actual = new byte[computed.length];
                ois.readFully(actual);
                for (int i = 0; i < computed.length; ++i) {
                    if (computed[i] == actual[i]) continue;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineLoad", "incorrect password");
                    }
                    throw new IOException("Keystore was tampered with, or password was incorrect");
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineLoad");
        }
    }

    private MessageDigest getPreKeyedHash(char[] password) throws NoSuchAlgorithmException {
        int i;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "getPreKeyedHash", (Object)password);
        }
        MessageDigest md = null;
        try {
            md = Security.getProvider("IBMJCECCA") == null ? (Security.getProvider("IBMJCE4758") == null ? MessageDigest.getInstance("SHA", "IBMJCA4758") : MessageDigest.getInstance("SHA", "IBMJCE4758")) : MessageDigest.getInstance("SHA", "IBMJCECCA");
        }
        catch (NoSuchProviderException nspe) {
            md = MessageDigest.getInstance("SHA");
        }
        byte[] passwdBytes = new byte[password.length * 2];
        int j = 0;
        for (i = 0; i < password.length; ++i) {
            passwdBytes[j++] = (byte)(password[i] >> 8);
            passwdBytes[j++] = (byte)password[i];
        }
        md.update(passwdBytes);
        for (i = 0; i < passwdBytes.length; ++i) {
            passwdBytes[i] = 0;
        }
        md.update("Mighty Aphrodite".getBytes(PlatformUtilities.CHARSET_UTF8));
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "getPreKeyedHash", md);
        }
        return md;
    }

    private Certificate[] CreateCertChain(byte[][] chain) throws CertificateException {
        int i = 0;
        Certificate[] retCert = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "CreateCertChain", (Object[])chain);
        }
        if (chain != null) {
            retCert = new Certificate[chain.length];
            for (i = 0; i < chain.length; ++i) {
                retCert[i] = this.CreateCert(chain[i]);
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "CreateCertChain", chain);
            }
        }
        return retCert;
    }

    private byte[][] CreateCertChainEncodings(Certificate[] chain) throws CertificateException {
        int i = 0;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "CreateCertChainEncodings", chain);
        }
        byte[][] retCertEncoding = new byte[chain.length][];
        try {
            for (i = 0; i < chain.length; ++i) {
                retCertEncoding[i] = chain[i].getEncoded();
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "CreateCertChainEncodings", chain);
            }
            return retCertEncoding;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "CreateCertChainEncodings", e.getMessage());
            }
            throw new CertificateException(e.getMessage());
        }
    }

    private Certificate CreateCert(byte[] encoding) throws CertificateException {
        Certificate retCert;
        block5: {
            retCert = null;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "CreateCert", (Object)encoding);
            }
            if (encoding != null) {
                try {
                    CertificateFactory cf = null;
                    cf = Security.getProvider("IBMJCECCA") == null ? (Security.getProvider("IBMJCE4758") == null ? CertificateFactory.getInstance("X.509", "IBMJCA4758") : CertificateFactory.getInstance("X.509", "IBMJCE4758")) : CertificateFactory.getInstance("X.509", "IBMJCECCA");
                    ByteArrayInputStream stream = new ByteArrayInputStream(encoding);
                    retCert = cf.generateCertificate(stream);
                }
                catch (NoSuchProviderException e) {
                    if (debug == null) break block5;
                    debug.text(Debug.TYPE_PUBLIC, className, "CreateCert", "NoSuchProvider");
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "CreateCert", encoding);
        }
        return retCert;
    }
}

