/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

class JarVerifier {
    private URL jarURL;
    private JarFile jarFile;
    private boolean retrievedJarFile;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.JarVerifier";

    JarVerifier(URL jarURL) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "JarVerifier", jarURL);
            debug.exit(Debug.TYPE_PUBLIC, className, "JarVerifier");
        }
        this.jarURL = jarURL;
    }

    public void verify(X509Certificate[] trustedCaCerts) throws JarException, IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "verify", trustedCaCerts);
        }
        try {
            this.verifyJars(this.jarURL, null, trustedCaCerts);
        }
        catch (NoSuchProviderException nspe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "verify", nspe);
            }
            throw new JarException("Cannot verify " + this.jarURL.toString());
        }
        catch (CertificateException ce) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "verify", ce);
            }
            throw new JarException("Cannot verify " + this.jarURL.toString());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "verify");
        }
    }

    public JarFile getJarFile() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getJarFile");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getJarFile", this.jarFile);
        }
        this.retrievedJarFile = true;
        return this.jarFile;
    }

    private void verifyJars(URL jarURL, Vector verifiedJarsCache, X509Certificate[] trustedCaCerts) throws NoSuchProviderException, CertificateException, IOException {
        String jarURLString = jarURL.toString();
        if (debug != null) {
            debug.entry(8192L, className, "verifyJars", verifiedJarsCache, trustedCaCerts);
        }
        if (verifiedJarsCache == null || !verifiedJarsCache.contains(jarURLString)) {
            String supportingJars = this.verifySingleJar(jarURL, trustedCaCerts);
            if (verifiedJarsCache != null) {
                verifiedJarsCache.addElement(jarURLString);
            }
            if (supportingJars != null) {
                if (verifiedJarsCache == null) {
                    verifiedJarsCache = new Vector<String>();
                    verifiedJarsCache.addElement(jarURLString);
                }
                this.verifyManifestClassPathJars(jarURL, supportingJars, verifiedJarsCache, trustedCaCerts);
            }
        }
        if (debug != null) {
            debug.exit(8192L, className, "verifyJars");
        }
    }

    private void verifyManifestClassPathJars(URL baseURL, String supportingJars, Vector verifiedJarsCache, X509Certificate[] trustedCaCerts) throws NoSuchProviderException, CertificateException, IOException {
        if (debug != null) {
            Object[] parms = new Object[]{baseURL, supportingJars, verifiedJarsCache, trustedCaCerts};
            debug.entry(8192L, (Object)className, "verifyManifestClassPathJars", parms);
        }
        String[] jarFileNames = this.parseAttrClasspath(supportingJars);
        try {
            for (int i = 0; i < jarFileNames.length; ++i) {
                URL url = new URL(baseURL, jarFileNames[i]);
                this.verifyJars(url, verifiedJarsCache, trustedCaCerts);
            }
        }
        catch (MalformedURLException mue) {
            if (debug != null) {
                debug.exception(8192L, className, "verifyManifestClassPathJars", mue);
            }
            throw new MalformedURLException("The JAR file " + baseURL.toString() + "contains invalid URLs in its Class-Path attribute " + mue);
        }
        if (debug != null) {
            debug.exit(8192L, className, "verifyManifestClassPathJars");
        }
    }

    private String verifySingleJar(URL jarURL, X509Certificate[] trustedCaCerts) throws NoSuchProviderException, CertificateException, IOException {
        Manifest man;
        JarFile jf;
        if (debug != null) {
            debug.entry(8192L, className, "verifySingleJar", jarURL, trustedCaCerts);
        }
        final URL url = jarURL.getProtocol().equalsIgnoreCase("jar") ? jarURL : new URL("jar:" + jarURL.toString() + "!/");
        try {
            jf = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (debug != null) {
                        debug.entry(Debug.TYPE_PUBLIC, className, "verifySingleJar.run");
                    }
                    JarFile result = ((JarURLConnection)url.openConnection()).getJarFile();
                    if (debug != null) {
                        debug.exit(Debug.TYPE_PUBLIC, (Object)className, "verifySingleJar.run", result);
                    }
                    return result;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            if (debug != null) {
                debug.exception(8192L, className, "verifySingleJar", pae);
            }
            throw new SecurityException("Cannot authenticate " + url.toString() + pae);
        }
        byte[] buffer = new byte[8192];
        Vector<JarEntry> entriesVec = new Vector<JarEntry>();
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            int n;
            JarEntry je = entries.nextElement();
            entriesVec.addElement(je);
            InputStream is = jf.getInputStream(je);
            while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            }
            is.close();
        }
        if (jarURL.equals(this.jarURL)) {
            this.jarFile = jf;
        }
        if ((man = jf.getManifest()) == null) {
            if (debug != null) {
                debug.text(8192L, className, "verifySingleJar", jarURL.toString() + " is not signed.");
            }
            throw new JarException(jarURL.toString() + " is not signed.");
        }
        Vector<X509Certificate> verifiedSignerCache = new Vector<X509Certificate>(2);
        Enumeration e = entriesVec.elements();
        while (e.hasMoreElements()) {
            X509Certificate[] certChain;
            JarEntry je = (JarEntry)e.nextElement();
            if (je.isDirectory()) continue;
            Certificate[] certs = je.getCertificates();
            if (certs == null || certs.length == 0) {
                if (je.getName().startsWith("META-INF")) continue;
                if (debug != null) {
                    debug.text(8192L, className, "verifySingleJar", jarURL.toString() + "has unsigned class files.");
                }
                throw new JarException(jarURL.toString() + "has unsigned class files.");
            }
            int startIndex = 0;
            boolean signedAsExpected = false;
            while ((certChain = this.getAChain(certs, startIndex)) != null) {
                for (int i = 0; i < certChain.length; ++i) {
                    if (verifiedSignerCache.contains(certChain[0])) {
                        signedAsExpected = true;
                        break;
                    }
                    if (!this.isTrusted(certChain, trustedCaCerts)) continue;
                    signedAsExpected = true;
                    verifiedSignerCache.addElement(certChain[0]);
                    break;
                }
                startIndex += certChain.length;
                if (!signedAsExpected) continue;
            }
            if (signedAsExpected) continue;
            throw new JarException(jarURL.toString() + " is not signed by a  trusted signer.");
        }
        String result = man.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        return result;
    }

    private String[] parseAttrClasspath(String supportingJars) throws JarException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parseAttrClasspath", supportingJars);
        }
        supportingJars = supportingJars.trim();
        int endIndex = supportingJars.indexOf(32);
        String name = null;
        Vector<String> values = new Vector<String>();
        boolean done = false;
        do {
            if (endIndex > 0) {
                name = supportingJars.substring(0, endIndex);
                supportingJars = supportingJars.substring(endIndex + 1).trim();
                endIndex = supportingJars.indexOf(32);
            } else {
                name = supportingJars;
                done = true;
            }
            if (!name.endsWith(".jar")) {
                if (debug != null) {
                    debug.text(8192L, className, "parseAttrClasspath", "The provider contains un-verifiable components");
                }
                throw new JarException("The provider contains un-verifiable components");
            }
            values.addElement(name);
        } while (!done);
        Object[] result = new String[values.size()];
        values.copyInto(result);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "parseAttrClasspath", result);
        }
        return result;
    }

    private boolean isTrusted(X509Certificate[] chain, X509Certificate[] trustedCaCerts) {
        int i;
        if (debug != null) {
            debug.entry(8192L, className, "isTrusted", chain, trustedCaCerts);
        }
        for (int i2 = 0; i2 < chain.length; ++i2) {
            X509Certificate currentCert = chain[i2];
            try {
                this.checkCriticalExts(currentCert, i2);
                continue;
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(8192L, className, "isTrusted", e);
                    debug.exit(8192L, (Object)className, "isTrusted1", false);
                }
                return false;
            }
        }
        X509Certificate cert = chain[chain.length - 1];
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!cert.getSubjectDN().equals(trustedCaCerts[i].getSubjectDN()) || !cert.equals(trustedCaCerts[i])) continue;
            if (debug != null) {
                debug.exit(8192L, (Object)className, "isTrusted2", true);
            }
            return true;
        }
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!cert.getIssuerDN().equals(trustedCaCerts[i].getSubjectDN())) continue;
            try {
                cert.verify(trustedCaCerts[i].getPublicKey());
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "isTrusted3", true);
                }
                return true;
            }
            catch (Exception e) {
                if (debug == null) continue;
                debug.exception(8192L, className, "isTrusted5", e);
            }
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "isTrusted4", false);
        }
        return false;
    }

    private void checkCriticalExts(X509Certificate cert, int index) throws Exception {
        Set<String> critSet;
        if (debug != null) {
            debug.entry(8192L, className, "checkCriticalExts", cert, new Integer(index));
        }
        if ((critSet = cert.getCriticalExtensionOIDs()) == null || critSet.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "checkCriticalExts1");
            }
            return;
        }
        this.checkBasicConstraints(cert, critSet, index);
        if (debug != null) {
            debug.exit(8192L, className, "checkCriticalExts2");
        }
    }

    private void checkBasicConstraints(X509Certificate cert, Set critSet, int index) throws Exception {
        int constraints;
        if (debug != null) {
            Object[] parms = new Object[]{cert, critSet, new Integer(index)};
            debug.entry(8192L, (Object)className, "checkBasicConstraints", parms);
        }
        if (critSet != null && !critSet.isEmpty() && critSet.contains(new String("2.5.29.19")) && (constraints = cert.getBasicConstraints()) >= 0 && index > 0 && index - 1 > constraints) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "checkBasicConstraints", "Violated basic constraints");
            }
            throw new Exception("Violated basic constraints");
        }
        if (debug != null) {
            debug.exit(8192L, className, "checkBasicConstraints");
        }
    }

    private X509Certificate[] getAChain(Certificate[] certs, int startIndex) {
        int i;
        Vector<Certificate> result = new Vector<Certificate>(3);
        if (debug != null) {
            debug.entry(8192L, className, "getAChain", certs, new Integer(startIndex));
        }
        if (startIndex > certs.length - 1) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getAChain1", null);
            }
            return null;
        }
        for (i = startIndex; i < certs.length - 1 && ((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN()); ++i) {
            result.addElement(certs[i]);
        }
        result.addElement(certs[i]);
        Object[] ret = new X509Certificate[result.size()];
        result.copyInto(ret);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getAChain2", ret);
        }
        return ret;
    }
}

