/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.AESKey;
import com.ibm.crypto.hdwrCCA.provider.DESKey;
import com.ibm.crypto.hdwrCCA.provider.DESedeKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.ICVSelection;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import com.ibm.jit.crypto.JITFullHardwareCrypt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.util.Arrays;

final class JCEHdwrUtils {
    private hikmNativeInteger returnCode = new hikmNativeInteger(0);
    private hikmNativeInteger reasonCode = new hikmNativeInteger(0);
    private HIKM hikm = null;
    private byte[] exitData = new byte[0];
    private byte[] keyIdentifier = new byte[64];
    private byte[] output;
    private hikmNativeInteger textLength;
    private hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
    private byte[] iv;
    private byte[] ov = new byte[32];
    private int GCM_T_size = -1;
    private byte[] GCM_AAD = null;
    private static final int GCM_FAILOVER_THRESHOLD = 0x10000000;
    private static final int AES_BLOCK_SIZE = 16;
    private int unitBytes = 16;
    byte[] rawKey;
    boolean isToken = false;
    boolean isLabel = false;
    private boolean jitOptimized = false;
    private String modeNameString = "";
    protected JITFullHardwareCrypt jitCipher;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.JCEHdwrUtils";
    protected static final int ECB_MODE = 0;
    protected static final int CBC_MODE = 1;
    protected static final int CFB_MODE = 2;
    protected static final int OFB_MODE = 3;
    protected static final int PCBC_MODE = 4;
    protected static final int GCM_MODE = 5;
    protected static final int NONE_FUNC = 0;
    protected static final int SY_FUNC = 2;
    protected static final int EN_FUNC = 3;
    private int hardwareFunc = 0;

    public JCEHdwrUtils() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "JCEHdwrUtils");
        }
        this.hikm = new HIKM();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "JCEHdwrUtils");
        }
    }

    protected byte[] initHdwr(String algorithmName, String modeName, boolean encrypting, Key key, byte[] iv) {
        byte[] rawKey = new byte[]{};
        if (debug != null) {
            Object[] parms = new Object[]{algorithmName, modeName, encrypting, key, iv};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "initHdwr(3)", parms);
        }
        this.jitOptimized = true;
        this.modeNameString = modeName;
        if (iv != null) {
            this.iv = new byte[iv.length];
            System.arraycopy(iv, 0, this.iv, 0, iv.length);
        } else {
            this.iv = new byte[0];
        }
        rawKey = key.getEncoded();
        if (debug != null) {
            debug.text(Debug.TYPE_FINEST, className, "initHdwr(3)", "Creating jitCipher with JITFullHardwareCrypt.getCrypto(" + algorithmName + ", " + modeName + ", " + 8 * rawKey.length + ")");
        }
        this.jitCipher = JITFullHardwareCrypt.getCrypto((String)algorithmName, (String)modeName, (int)(8 * rawKey.length));
        if (debug != null) {
            debug.text(Debug.TYPE_FINEST, className, "initHdwr(3)", "Calling jitCipher.init(" + encrypting + ", rawKey, this.iv)");
        }
        this.jitCipher.init(encrypting, rawKey, this.iv);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "initHdwr(3)", rawKey);
        }
        return rawKey;
    }

    protected byte[] initHdwr(String algorithmName, String modeName, boolean encrypting, Key key, byte[] iv, int unit_bytes) throws InvalidParameterException, InvalidKeyException {
        byte[] rawKey = new byte[]{};
        if (debug != null) {
            Object[] parms = new Object[]{algorithmName, modeName, encrypting, key, iv, unit_bytes};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "initHdwr(4)", parms);
        }
        this.jitOptimized = true;
        this.modeNameString = modeName;
        this.unitBytes = unit_bytes;
        if (iv != null) {
            this.iv = new byte[iv.length];
            System.arraycopy(iv, 0, this.iv, 0, iv.length);
        } else {
            this.iv = new byte[0];
        }
        rawKey = key.getEncoded();
        if (debug != null) {
            debug.text(Debug.TYPE_FINEST, className, "initHdwr(4)", "Creating jitCipher with JITFullHardwareCrypt.getCrypto(" + algorithmName + ", " + modeName + ", " + 8 * rawKey.length + ")");
        }
        this.jitCipher = JITFullHardwareCrypt.getCrypto((String)algorithmName, (String)modeName, (int)(8 * rawKey.length));
        if (debug != null) {
            debug.text(Debug.TYPE_FINEST, className, "initHdwr(4)", "Calling jitCipher.init(" + encrypting + ", rawKey, IV, " + this.unitBytes + ")");
        }
        this.jitCipher.init(encrypting, rawKey, this.iv, this.unitBytes);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "initHdwr(4)", rawKey);
        }
        return rawKey;
    }

    protected byte[] initHdwr(Key key, byte[] iv) throws InvalidParameterException, InvalidKeyException {
        byte[] result = new byte[]{};
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "initHdwr(1)", key, iv);
        }
        this.jitOptimized = false;
        result = this.initHdwr(key, iv, -1, result);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "initHdwr(1)", result);
        }
        return result;
    }

    protected byte[] initHdwr(Key key, byte[] iv, int GCM_tSize, byte[] GCM_aad) throws InvalidParameterException, InvalidKeyException {
        String exitDataString;
        HexDumpEncoder encoder;
        if (debug != null) {
            Object[] parms = new Object[]{key, iv, GCM_tSize, GCM_aad};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "initHdwr(2)", parms);
        }
        this.GCM_T_size = GCM_tSize;
        this.GCM_AAD = GCM_aad;
        this.jitOptimized = false;
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(1);
        String ruleText = new String("DES     ");
        byte[] ruleArray = PlatformUtilities.getBytesPlatform(ruleText);
        if (key == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initHdwr(2)", "Key missing");
            }
            throw new InvalidKeyException("Key missing");
        }
        if (!(key.getAlgorithm().equalsIgnoreCase("DES") || key.getAlgorithm().equalsIgnoreCase("DESede") || key.getAlgorithm().equalsIgnoreCase("AES") || key.getAlgorithm().equalsIgnoreCase("TripleDES"))) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initHdwr(2)", "Wrong algorithm: AES or DES or DESede or TripleDES required");
            }
            throw new InvalidKeyException("Wrong algorithm: AES, DES, DESede, or TripleDES required");
        }
        if (key.getFormat().equalsIgnoreCase("RAW") && (this.rawKey = key.getEncoded()) == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initHdwr(2)", "RAW bytes missing");
            }
            throw new InvalidKeyException("RAW bytes missing");
        }
        if (iv != null) {
            this.iv = new byte[iv.length];
            System.arraycopy(iv, 0, this.iv, 0, iv.length);
        } else {
            this.iv = new byte[0];
        }
        if (key.getFormat().equalsIgnoreCase("CKDSLabel")) {
            this.isLabel = true;
            byte[] label = new byte[64];
            Arrays.fill(label, (byte)64);
            if (key.getAlgorithm().equalsIgnoreCase("DES")) {
                byte[] tmp = ((DESKey)key).getLabelString().getBytes(PlatformUtilities.CHARSET_IBM_1047);
                System.arraycopy(tmp, 0, label, 0, tmp.length);
            } else if (key.getAlgorithm().equalsIgnoreCase("DESede")) {
                byte[] tmp = ((DESedeKey)key).getLabelString().getBytes(PlatformUtilities.CHARSET_IBM_1047);
                System.arraycopy(tmp, 0, label, 0, tmp.length);
            } else {
                byte[] tmp = ((AESKey)key).getLabelString().getBytes(PlatformUtilities.CHARSET_IBM_1047);
                System.arraycopy(tmp, 0, label, 0, tmp.length);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initHdwr(2)", "Returning CKDS label: <" + new String(label, PlatformUtilities.CHARSET_IBM_1047) + ">");
                debug.exit(Debug.TYPE_PUBLIC, className, "initHdwr(2)");
            }
            return label;
        }
        if (key.getFormat().equalsIgnoreCase("ICSFToken")) {
            this.isToken = true;
            byte[] token = null;
            token = key.getAlgorithm().equalsIgnoreCase("DES") ? ((DESKey)key).getToken() : (key.getAlgorithm().equalsIgnoreCase("DESede") ? ((DESedeKey)key).getToken() : ((AESKey)key).getToken());
            if (debug != null) {
                String tok = "";
                try {
                    HexDumpEncoder hd = new HexDumpEncoder();
                    ByteArrayOutputStream oStream = new ByteArrayOutputStream();
                    hd.encodeBuffer(new ByteArrayInputStream(token, 0, token.length), oStream);
                    tok = oStream.toString("8859_1");
                }
                catch (IOException hd) {
                    // empty catch block
                }
                debug.text(Debug.TYPE_PUBLIC, className, "initHdwr(2)", "Returning ICSF token: \n" + tok);
                debug.exit(Debug.TYPE_PUBLIC, className, "initHdwr(2)");
            }
            return token;
        }
        hikmNativeInteger clearKeyLength = new hikmNativeInteger(this.rawKey.length);
        if (HardwareProfile.getIsCryptoAssistPresent() && HardwareProfile.getIsDESCryptoAssistPresent() && this.rawKey.length == 8 || HardwareProfile.getIsCryptoAssistPresent() && HardwareProfile.getIs3DESCryptoAssistPresent() && this.rawKey.length >= 8 || key.getAlgorithm().equalsIgnoreCase("AES")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initHdwr(2)", "Crypto Assist for DES/AES acceleration is available. Skipping call to CSNBCKM and returning clear key.");
            }
            return this.rawKey;
        }
        if (null != debug) {
            encoder = new HexDumpEncoder();
            exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
            String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
            String rawKeyString = "\n" + encoder.encodeBuffer(this.rawKey);
            String keyIdentifierString = "\n" + encoder.encodeBuffer(this.keyIdentifier);
            String parmsReport = "\nJCEHdwrUtils: CSNBCKM INPUT PARAMETERS \n    returnCode : " + this.returnCode.getValue() + "\n    reasonCode : " + this.reasonCode.getValue() + "\n    exitDataLen: " + this.exitDataLength.getValue() + "\n    exitData   : " + exitDataString + "\n    ruleArrayCount  : " + ruleArrayCount.getValue() + "\n    ruleArray  : " + ruleArrayString + "\n    clearKeyLength    : " + clearKeyLength.getValue() + "\n    rawKey  : " + rawKeyString + "\n    keyIdentifier   : " + keyIdentifierString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "initHdwr(2)", parmsReport);
        }
        try {
            this.hikm.CSNBCKMJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, clearKeyLength, this.rawKey, this.keyIdentifier);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "initHdwr(2)", e);
            }
            throw new RuntimeException("Hardware error from call CSNBCKM " + e);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "initHdwr(2)", "CSNBCKM: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
        }
        if (null != debug) {
            encoder = new HexDumpEncoder();
            exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
            String keyIdentifierString = "\n" + encoder.encodeBuffer(this.keyIdentifier);
            String parmsReport = "\nJCEHdwrUtils: CSNBCKM RETURN PARAMETERS \n    returnCode : " + this.returnCode.getValue() + "\n    reasonCode : " + this.reasonCode.getValue() + "\n    exitDataLen: " + this.exitDataLength.getValue() + "\n    exitData   : " + exitDataString + "\n    keyIdentifier   : " + keyIdentifierString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "initHdwr(2)", parmsReport);
        }
        if (this.returnCode.getValue() != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initHdwr(2)", "Hardware error from call CSNBCKM RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue());
            }
            throw new JCECCARuntimeException(1, "CSNBCKM", "Hardware error from call CSNBCKM RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
        }
        byte[] rtnIdentifier = new byte[this.keyIdentifier.length];
        System.arraycopy(this.keyIdentifier, 0, rtnIdentifier, 0, this.keyIdentifier.length);
        Arrays.fill(this.rawKey, (byte)0);
        Arrays.fill(this.keyIdentifier, (byte)0);
        this.rawKey = null;
        this.keyIdentifier = null;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "initHdwr(2)", rtnIdentifier);
        }
        return rtnIdentifier;
    }

    protected void encrypt(byte[] in, int inOff, int len, byte[] out, int outOff, byte[] keyToken, String algorithm, int mode) {
        this.encrypt(in, inOff, len, out, outOff, keyToken, algorithm, mode, 0, ICVSelection.ICV_INITIAL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected void encrypt(byte[] in, int inOff, int len, byte[] out, int outOff, byte[] keyToken, String algorithm, int mode, int lcfbLen, ICVSelection icvSelection) throws InvalidParameterException {
        String keyTokenString;
        String ruleArrayString;
        HexDumpEncoder encoder;
        hikmNativeInteger ruleArrayCount;
        String ruleText;
        byte[] ruleArray;
        RuntimeException rte;
        String method_called = null;
        byte[] AuthTag = new byte[]{};
        hikmNativeInteger keyParmLength = new hikmNativeInteger(0);
        byte[] keyParmsByte = new byte[1];
        hikmNativeInteger optional_data_length = new hikmNativeInteger(0);
        byte[] optional_data = null;
        if (debug != null) {
            Object[] parms = new Object[]{in, new Integer(inOff), new Integer(len), out, new Integer(outOff), keyToken, algorithm, new Integer(mode), new Integer(lcfbLen), icvSelection};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "encrypt(in,inoff,len,out,outOff,keyToken,Alg,mode,lcfbLen,icvSelection)", parms);
        }
        if (this.jitOptimized) {
            this.JIT_encrypt(in, inOff, len, out, outOff);
            if (debug == null) return;
            debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
            return;
        }
        if (0 != inOff) {
            rte = new RuntimeException("Internal Error. Input buffer offset must be 0.");
            if (debug == null) throw rte;
            debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Internal Error. Input buffer offset must be 0.");
            debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte);
            debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
            throw rte;
        }
        if (algorithm == null) {
            rte = new RuntimeException("Algorithm passed can not be null.");
            if (debug == null) throw rte;
            debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Algorithm passed can not be null.");
            debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte);
            debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
            throw rte;
        }
        if (!algorithm.equals("AES") && !algorithm.equals("DES")) {
            rte = new RuntimeException("Only support algorithm of DES or AES.");
            if (debug == null) throw rte;
            debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Only support algorithm of DES or AES.");
            debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte);
            debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
            throw rte;
        }
        if (mode != 0 && mode != 1 && mode != 2 && mode != 3 && mode != 5) {
            rte = new RuntimeException("Only support modes of CBC, CFB, OFB, GCM, and ECB.");
            if (debug == null) throw rte;
            debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Only support modes of CBC, CFB, OFB, GCM, and ECB.");
            debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte);
            debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
            throw rte;
        }
        if (PlatformUtilities.isLinux()) {
            this.hardwareFunc = 3;
        }
        if (this.hardwareFunc == 0) {
            this.hardwareFunc = mode == 5 ? 2 : (algorithm.equals("AES") && HardwareProfile.getIsCryptoAssistPresent() && HardwareProfile.getIsAES128CryptoAssistPresent() || algorithm.equals("AES") && HardwareProfile.getIsCryptoAssistPresent() && HardwareProfile.getIsAES192CryptoAssistPresent() || algorithm.equals("AES") && HardwareProfile.getIsCryptoAssistPresent() && HardwareProfile.getIsAES256CryptoAssistPresent() || algorithm.equals("DES") && HardwareProfile.getIsCryptoAssistPresent() && HardwareProfile.getIsDESCryptoAssistPresent() || algorithm.equals("DES") && HardwareProfile.getIsCryptoAssistPresent() && HardwareProfile.getIs3DESCryptoAssistPresent() || algorithm.equals("DES") && mode == 0 && (this.isToken || this.isLabel) || algorithm.equals("DES") && mode == 3 && this.isLabel || algorithm.equals("DES") && mode == 2 && this.isLabel ? 2 : 3);
        }
        if (this.hardwareFunc == 2) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Crypto Assist for DES/AES is available. Routing call to faster CSNBSYE. (Clear DES/AES Key Required)");
            }
            ruleArray = null;
            ruleText = "";
            ruleArrayCount = null;
            int textCalc = len - inOff;
            this.textLength = new hikmNativeInteger(textCalc);
            this.output = new byte[textCalc + 16];
            keyParmLength = new hikmNativeInteger(0);
            int count = 0;
            if (algorithm.equals("AES")) {
                ruleText = ruleText + "AES     ";
                ++count;
            }
            if (algorithm.equals("DES")) {
                ruleText = ruleText + "DES     ";
                ++count;
            }
            if (mode == 0) {
                ruleText = ruleText + "ECB     ";
                ++count;
            } else if (mode == 2) {
                if (lcfbLen != 0) {
                    ruleText = ruleText + "CFB-LCFB";
                    keyParmLength.setValue(1);
                } else {
                    ruleText = ruleText + "CFB     ";
                }
                ++count;
                ruleText = ruleText + icvSelection.getType();
                ++count;
            } else if (mode == 1) {
                ruleText = ruleText + "CBC     ";
                ++count;
                ruleText = ruleText + icvSelection.getType();
                ++count;
            } else if (mode == 3) {
                ruleText = ruleText + "OFB     ";
                ++count;
                ruleText = ruleText + icvSelection.getType();
                ++count;
            } else if (mode == 5) {
                ruleText = ruleText + "GCM     ";
                ++count;
                ruleText = ruleText + icvSelection.getType();
                ++count;
            }
            if (this.isToken || this.isLabel) {
                ruleText = ruleText + "KEYIDENT";
                ++count;
            }
            ruleArrayCount = new hikmNativeInteger(count);
            ruleArray = PlatformUtilities.getBytesPlatform(ruleText);
            hikmNativeInteger initialization_vector_length = null;
            if (this.iv == null) {
                initialization_vector_length = new hikmNativeInteger(0);
                this.iv = new byte[0];
            } else {
                initialization_vector_length = new hikmNativeInteger(this.iv.length);
            }
            hikmNativeInteger output_vector_length = null;
            if (this.ov == null) {
                output_vector_length = new hikmNativeInteger(0);
                this.ov = new byte[0];
            } else {
                output_vector_length = new hikmNativeInteger(this.ov.length);
            }
            hikmNativeInteger output_length = null;
            if (this.ov == null) {
                output_length = new hikmNativeInteger(0);
                this.output = new byte[0];
            } else {
                output_length = new hikmNativeInteger(this.output.length);
            }
            hikmNativeInteger blockSize = null;
            blockSize = algorithm.equals("DES") ? new hikmNativeInteger(8) : new hikmNativeInteger(16);
            byte[] zero = new byte[]{};
            try {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Calling hardware service: ICSF CSNBSYE");
                }
                method_called = "CSNBSYE";
                Integer segmentSize = new Integer(lcfbLen);
                keyParmLength = new hikmNativeInteger(0);
                keyParmsByte[0] = segmentSize.byteValue();
                optional_data_length = new hikmNativeInteger(0);
                optional_data = null;
                if (mode == 5) {
                    AuthTag = new byte[this.GCM_T_size];
                    keyParmLength = new hikmNativeInteger(this.GCM_T_size);
                    keyParmsByte = AuthTag;
                    optional_data_length = new hikmNativeInteger(this.GCM_AAD.length);
                    optional_data = this.GCM_AAD;
                } else {
                    optional_data_length = new hikmNativeInteger(0);
                    optional_data = zero;
                    if (lcfbLen != 0 && mode == 2) {
                        keyParmLength = new hikmNativeInteger(1);
                    }
                }
                if (null != debug) {
                    encoder = new HexDumpEncoder();
                    ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
                    keyTokenString = "\n" + encoder.encodeBuffer(keyToken);
                    String keyParmsString = "\n" + encoder.encodeBuffer(keyParmsByte);
                    String ivString = "\n" + encoder.encodeBuffer(this.iv);
                    String ovString = "\n" + encoder.encodeBuffer(this.ov);
                    String parmsReport = "\nJCEHdwrUtils: CSNBSYE INPUT PARAMETERS \n    returnCode : " + this.returnCode.getValue() + "\n    reasonCode : " + this.reasonCode.getValue() + "\n    rule_array_count: " + ruleArrayCount.getValue() + "\n    rule_array   : " + ruleArrayString + "\n    key_length  : " + keyToken.length + "\n    key_identifier  : " + keyTokenString + "\n    key_parms_length   : " + keyParmLength.getValue() + "\n    key_parms   : " + keyParmsString + "\n    block_size   : " + blockSize.getValue() + "\n    initialization_vector_length    : " + initialization_vector_length.getValue() + "\n    initialization_vector  : " + ivString + "\n    chain_data_length   : " + output_vector_length.getValue() + "\n    chain_data   : " + ovString + "\n    clear_text_length   : " + this.textLength.getValue() + "\n    clear_text : XXX\n    cipher_text_length   : " + output_length.getValue() + "\n    optional_data_length   : " + optional_data_length.getValue() + "\n    optional_data   : XXX\n";
                    debug.text(Debug.TYPE_FINEST, className, "encrypt", parmsReport);
                }
                this.hikm.CSNBSYEJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, new hikmNativeInteger(keyToken.length), keyToken, keyParmLength, keyParmsByte, blockSize, initialization_vector_length, this.iv, output_vector_length, this.ov, this.textLength, in, output_length, this.output, optional_data_length, optional_data);
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "encrypt", "CSNBSYE: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
                }
                if (null != debug) {
                    encoder = new HexDumpEncoder();
                    String keyParmsString = "\n" + encoder.encodeBuffer(keyParmsByte);
                    String ovString = "\n" + encoder.encodeBuffer(this.ov);
                    String parmsReport = "\nJCEHdwrUtils: CSNBSYE RETURN PARAMETERS \n    returnCode : " + this.returnCode.getValue() + "\n    reasonCode : " + this.reasonCode.getValue() + "\n    key_parms_length   : " + keyParmLength.getValue() + "\n    key_parms   : " + keyParmsString + "\n    chain_data_length   : " + output_vector_length.getValue() + "\n    chain_data   : " + ovString + "\n    cipher_text_length   : " + output_length.getValue() + "\n    cipher_text : XXX\n";
                    debug.text(Debug.TYPE_FINEST, className, "encrypt", parmsReport);
                }
            }
            catch (IllegalArgumentException e) {
                RuntimeException rte2 = new RuntimeException("Hardware error from call " + method_called + " " + e);
                if (debug == null) throw rte2;
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Hardware error from call " + method_called + " " + e);
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte2);
                debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
                throw rte2;
            }
            catch (Exception e) {
                RuntimeException rte3 = new RuntimeException("Exception from calling " + method_called + " " + e);
                if (debug == null) throw rte3;
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Exception from calling " + method_called + " " + e);
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte3);
                debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
                throw rte3;
            }
            if (this.returnCode.getValue() == 8 && this.reasonCode.getValue() == 10128 && (this.isLabel || this.isToken) || this.returnCode.getValue() == 8 && this.reasonCode.getValue() == 10012 && (this.isLabel || this.isToken) || this.returnCode.getValue() == 8 && this.reasonCode.getValue() == 2079 && (this.isLabel || this.isToken) || this.returnCode.getValue() == 12 && this.reasonCode.getValue() == 8 && (this.isLabel || this.isToken) || this.returnCode.getValue() == 8 && this.reasonCode.getValue() == 3067 && (this.isLabel || this.isToken) || this.returnCode.getValue() == 8 && this.reasonCode.getValue() == 3059 && (this.isLabel || this.isToken)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Enabling failover call since this possible non clear key value cannot be used with SYE");
                }
                this.hardwareFunc = 3;
            } else if (this.returnCode.getValue() != 0) {
                JCECCARuntimeException rte4 = new JCECCARuntimeException(1, method_called, "Hardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                if (debug == null) throw rte4;
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Hardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue());
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte4);
                debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
                throw rte4;
            }
        }
        if (this.hardwareFunc == 3 && algorithm.equalsIgnoreCase("DES")) {
            String keyIdCopyString;
            String exitDataString;
            HexDumpEncoder encoder2;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Crypto Assist for DES acceleration is not available. Routing call to CSNBENC.");
            }
            if (mode != 1) {
                rte = null;
                rte = PlatformUtilities.isLinux() ? new UnsupportedOperationException("Operation not supported for the specified mode using a DES key in this format.") : new JCECCARuntimeException(1, method_called, "Operation not supported for the specified mode using a DES key in this format.\nHardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                if (debug == null) throw rte;
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Tried to route call to CSNBENC but the cipher mode is not CBC. Cipher Mode: " + mode);
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Hardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue());
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte);
                debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
                throw rte;
            }
            this.returnCode.setValue(0);
            this.reasonCode.setValue(0);
            ruleArray = null;
            ruleText = "";
            ruleArrayCount = null;
            hikmNativeInteger padCharacter = new hikmNativeInteger(0);
            byte[] keyIdCopy = new byte[keyToken.length];
            System.arraycopy(keyToken, 0, keyIdCopy, 0, keyToken.length);
            if (PlatformUtilities.isLinux()) {
                keyIdCopy = PlatformUtilities.convertBytesIfKeyLabelETOA(keyIdCopy);
            }
            int textCalc = len - inOff;
            this.textLength = new hikmNativeInteger(textCalc);
            this.output = new byte[textCalc + 24];
            ruleText = "CBC     " + icvSelection.getType();
            ruleArrayCount = new hikmNativeInteger(2);
            ruleArray = PlatformUtilities.getBytesPlatform(ruleText);
            if (null != debug) {
                encoder2 = new HexDumpEncoder();
                exitDataString = "\n" + encoder2.encodeBuffer(this.exitData);
                keyIdCopyString = "\n" + encoder2.encodeBuffer(keyIdCopy);
                String ivString = "\n" + encoder2.encodeBuffer(this.iv);
                String ruleArrayString2 = "\n" + encoder2.encodeBuffer(ruleArray);
                String ovString = "\n" + encoder2.encodeBuffer(this.ov);
                String parmsReport = "\nJCEHdwrUtils: CSNBENC INPUT PARAMETERS \n    returnCode : " + this.returnCode.getValue() + "\n    reasonCode : " + this.reasonCode.getValue() + "\n    exit_data_length : " + this.exitDataLength.getValue() + "\n    exit_data : " + exitDataString + "\n    key_identifier : " + keyIdCopyString + "\n    text_length : " + this.textLength.getValue() + "\n    clear_text : XXX\n    initialization_vector : " + ivString + "\n    rule_array_count : " + ruleArrayCount.getValue() + "\n    rule_array : " + ruleArrayString2 + "\n    pad_character : " + padCharacter.getValue() + "\n    chaining_vector : " + ovString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "encrypt", parmsReport);
            }
            try {
                this.hikm.CSNBENCJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, keyIdCopy, this.textLength, in, this.iv, ruleArrayCount, ruleArray, padCharacter, this.ov, this.output);
            }
            catch (IllegalArgumentException e) {
                RuntimeException rte5 = new RuntimeException("Hardware error from call CSNBENC " + e);
                if (debug == null) throw rte5;
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Hardware error from call CSNBENC " + e);
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte5);
                debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
                throw rte5;
            }
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "encrypt", "CSNBENC: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
            }
            if (null != debug) {
                encoder2 = new HexDumpEncoder();
                exitDataString = "\n" + encoder2.encodeBuffer(this.exitData);
                keyIdCopyString = "\n" + encoder2.encodeBuffer(keyIdCopy);
                String ovString = "\n" + encoder2.encodeBuffer(this.ov);
                String parmsReport = "\nJCEHdwrUtils: CSNBENC RETURN PARAMETERS \n    returnCode : " + this.returnCode.getValue() + "\n    reasonCode : " + this.reasonCode.getValue() + "\n    exit_data_length : " + this.exitDataLength.getValue() + "\n    exit_data : " + exitDataString + "\n    key_identifier : " + keyIdCopyString + "\n    text_length : " + this.textLength.getValue() + "\n    chaining_vector : " + ovString + "\n    cipher_text : XXX\n";
                debug.text(Debug.TYPE_FINEST, className, "encrypt", parmsReport);
            }
            if (this.returnCode.getValue() != 0) {
                JCECCARuntimeException rte6 = new JCECCARuntimeException(1, "CSNBENC", "Hardware error from call CSNBENC RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                if (debug == null) throw rte6;
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Hardware error from call CSNBENC RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue());
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte6);
                debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
                throw rte6;
            }
        }
        if (this.hardwareFunc == 3 && algorithm.equalsIgnoreCase("AES")) {
            RuntimeException rte7;
            if (!HardwareProfile.getIsHCR7751OrLaterPresent()) {
                String exMsg = new String("The operation using an AES key is not supported on ICSF levels less than HCR7751.");
                rte7 = new RuntimeException(exMsg);
                if (debug == null) throw rte7;
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", exMsg);
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte7);
                debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
                throw rte7;
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Attempt Symmetric Algorithm Encryption.  Routing call to CSNBSAE.");
            }
            if (mode != 0 && mode != 1) {
                rte = null;
                rte = PlatformUtilities.isLinux() ? new UnsupportedOperationException("Operation not supported for the specified mode using an AES key in this format.") : new JCECCARuntimeException(1, method_called, "Operation not supported for the specified mode using an AES key in this format.\nHardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                if (debug == null) throw rte;
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Tried to route call to CSNBSAE but the cipher mode is not ECB or CBC. Cipher Mode: " + mode);
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Hardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue());
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte);
                debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
                throw rte;
            }
            try {
                this.returnCode.setValue(0);
                this.reasonCode.setValue(0);
                ruleArray = null;
                ruleText = "";
                ruleArrayCount = null;
                byte[] keyIdCopy = new byte[keyToken.length];
                System.arraycopy(keyToken, 0, keyIdCopy, 0, keyToken.length);
                if (PlatformUtilities.isLinux()) {
                    keyIdCopy = PlatformUtilities.convertBytesIfKeyLabelETOA(keyIdCopy);
                }
                int textCalc = len - inOff;
                this.textLength = new hikmNativeInteger(textCalc);
                this.output = new byte[textCalc + 24];
                int count = 0;
                ruleText = ruleText + "AES     ";
                ++count;
                if (mode == 0) {
                    ruleText = ruleText + "ECB     ";
                    ++count;
                } else if (mode == 1) {
                    ruleText = ruleText + "CBC     ";
                    ++count;
                    ruleText = ruleText + icvSelection.getType();
                    ++count;
                }
                ruleText = PlatformUtilities.isLinux() && !this.isLabel && !this.isToken ? ruleText + "KEY-CLR " : ruleText + "KEYIDENT";
                ruleArrayCount = new hikmNativeInteger(++count);
                ruleArray = PlatformUtilities.getBytesPlatform(ruleText);
                hikmNativeInteger initialization_vector_length = null;
                if (this.iv == null) {
                    initialization_vector_length = new hikmNativeInteger(0);
                    this.iv = new byte[0];
                } else {
                    initialization_vector_length = new hikmNativeInteger(this.iv.length);
                }
                hikmNativeInteger output_vector_length = null;
                if (this.ov == null) {
                    output_vector_length = new hikmNativeInteger(0);
                    this.ov = new byte[0];
                } else {
                    output_vector_length = new hikmNativeInteger(this.ov.length);
                }
                hikmNativeInteger output_length = null;
                if (this.ov == null) {
                    output_length = new hikmNativeInteger(0);
                    this.output = new byte[0];
                } else {
                    output_length = new hikmNativeInteger(this.output.length);
                }
                hikmNativeInteger blockSize = new hikmNativeInteger(16);
                byte[] zero = new byte[]{};
                if (null != debug) {
                    encoder = new HexDumpEncoder();
                    ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
                    keyTokenString = "\n" + encoder.encodeBuffer(keyIdCopy);
                    String ivString = "\n" + encoder.encodeBuffer(this.iv);
                    String ovString = "\n" + encoder.encodeBuffer(this.ov);
                    String parmsReport = "\nJCEHdwrUtils: CSNBSAE INPUT PARAMETERS \n    returnCode : " + this.returnCode.getValue() + "\n    reasonCode : " + this.reasonCode.getValue() + "\n    rule_array_count: " + ruleArrayCount.getValue() + "\n    rule_array   : " + ruleArrayString + "\n    key_length  : " + keyIdCopy.length + "\n    key_identifier  : " + keyTokenString + "\n    key_parms_length   : " + 0 + "\n    block_size   : " + blockSize.getValue() + "\n    initialization_vector_length    : " + initialization_vector_length.getValue() + "\n    initialization_vector  : " + ivString + "\n    chain_data_length   : " + output_vector_length.getValue() + "\n    chain_data   : " + ovString + "\n    clear_text_length   : " + this.textLength.getValue() + "\n    clear_text : XXX\n    cipher_text_length   : " + output_length.getValue() + "\n    optional_data_length   : " + 0 + "\n";
                    debug.text(Debug.TYPE_FINEST, className, "encrypt", parmsReport);
                }
                this.hikm.CSNBSAEJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, new hikmNativeInteger(keyIdCopy.length), keyIdCopy, new hikmNativeInteger(0), zero, blockSize, initialization_vector_length, this.iv, output_vector_length, this.ov, this.textLength, in, output_length, this.output, new hikmNativeInteger(0), zero);
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "encrypt", "CSNBSAE: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
                }
                if (null != debug) {
                    encoder = new HexDumpEncoder();
                    String ovString = "\n" + encoder.encodeBuffer(this.ov);
                    String parmsReport = "\nJCEHdwrUtils: CSNBSAE RETURN PARAMETERS \n    returnCode : " + this.returnCode.getValue() + "\n    reasonCode : " + this.reasonCode.getValue() + "\n    chain_data_length   : " + output_vector_length.getValue() + "\n    chain_data   : " + ovString + "\n    cipher_text_length   : " + output_length.getValue() + "\n    cipher_text : XXX\n";
                    debug.text(Debug.TYPE_FINEST, className, "encrypt", parmsReport);
                }
            }
            catch (IllegalArgumentException e) {
                rte7 = new RuntimeException("Hardware error from call CSNBSAE " + e);
                if (debug == null) throw rte7;
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Hardware error from call CSNBSAE " + e);
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte7);
                debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
                throw rte7;
            }
            catch (Exception e) {
                rte7 = new RuntimeException("Exception from calling CSNBSAE " + e);
                if (debug == null) throw rte7;
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Exception from calling CSNBSAE " + e);
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte7);
                debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
                throw rte7;
            }
            if (this.returnCode.getValue() != 0) {
                rte = new JCECCARuntimeException(1, "CSNBSAE", "Hardware error from call CSNBSAE RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                if (debug == null) throw rte;
                debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Hardware error from call CSNBSAE RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue());
                debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte);
                debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
                throw rte;
            }
        } else if (this.returnCode.getValue() != 0) {
            rte = new JCECCARuntimeException(1, "CSNBSAE", "Hardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
            if (debug == null) throw rte;
            debug.text(Debug.TYPE_PUBLIC, className, "encrypt", "Hardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue());
            debug.exception(Debug.TYPE_PUBLIC, className, "encrypt", rte);
            debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
            throw rte;
        }
        if (null != this.output) {
            int txtLen = this.textLength.getValue();
            System.arraycopy(this.output, 0, out, outOff, txtLen);
            if (mode == 5) {
                String gcmEncryptOut;
                HexDumpEncoder encoder2;
                if (debug != null) {
                    encoder2 = new HexDumpEncoder();
                    gcmEncryptOut = "\nGCM Mode encryption completed.\n\tcipherText length    = " + txtLen + "\n\tcipherText bufferLen = " + out.length + "\n\tAuth Tag length      = " + this.GCM_T_size + "\n\tcipherText w/o AuthTag: \n" + encoder2.encodeBuffer(out);
                    debug.text(Debug.TYPE_PUBLIC, className, "encrypt", gcmEncryptOut);
                }
                System.arraycopy(AuthTag, 0, out, outOff + txtLen, this.GCM_T_size);
                if (debug != null) {
                    encoder2 = new HexDumpEncoder();
                    gcmEncryptOut = "\nGCM Mode encryption completed.\n\tcipherText w/ AuthTag: \n" + encoder2.encodeBuffer(out);
                    debug.text(Debug.TYPE_PUBLIC, className, "encrypt", gcmEncryptOut);
                }
            }
        }
        this.output = null;
        if (debug == null) return;
        debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
    }

    private void JIT_encrypt(byte[] in, int inOff, int len, byte[] out, int outOff) throws InvalidParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{in, new Integer(inOff), new Integer(len), out, new Integer(outOff)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "JIT_encrypt(in,inoff,len,out,outOff)", parms);
        }
        if (0 < len) {
            int overflowLen = len % this.unitBytes;
            if (overflowLen != 0 && ("CFB".equals(this.modeNameString) || "OFB".equals(this.modeNameString))) {
                int blockMultipleLen = len / this.unitBytes * this.unitBytes;
                if (debug != null) {
                    debug.text(Debug.TYPE_FINEST, className, "JIT_encrypt", "\n\toverflowLen != 0. \n\t1st: calling jitCipher.cipher(in, " + blockMultipleLen + ", " + inOff + ", out, " + outOff + ")");
                }
                this.jitCipher.cipher(in, blockMultipleLen, inOff, out, outOff);
                byte[] overflow = new byte[this.unitBytes];
                System.arraycopy(in, inOff + blockMultipleLen, overflow, 0, overflowLen);
                if (debug != null) {
                    debug.text(Debug.TYPE_FINEST, className, "JIT_encrypt", "\n\t2nd: calling jitCipher.cipher(in, " + this.unitBytes + ", " + inOff + ", out, " + outOff + " )");
                }
                this.jitCipher.cipher(overflow, this.unitBytes, 0, overflow, 0);
                System.arraycopy(overflow, 0, out, outOff + blockMultipleLen, overflowLen);
            } else {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINEST, className, "JIT_encrypt", "\n\toverflowLen == 0. \n\tcalling jitCipher.cipher(in, " + len + ", " + inOff + ", out, " + outOff + " )");
                }
                this.jitCipher.cipher(in, len, inOff, out, outOff);
            }
        } else if (debug != null) {
            debug.text(Debug.TYPE_FINEST, className, "JIT_encrypt", "0 !< len so nothing to do.");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "JIT_encrypt");
        }
    }

    protected void decrypt(byte[] in, int inOff, int len, byte[] out, int outOff, byte[] keyToken, String algorithm, int mode) {
        this.decrypt(in, inOff, len, out, outOff, keyToken, algorithm, mode, 0, ICVSelection.ICV_INITIAL, false);
    }

    protected void decrypt(byte[] in, int inOff, int len, byte[] out, int outOff, byte[] keyToken, String algorithm, int mode, int lcfbLen, ICVSelection icvSelection) throws InvalidParameterException {
        this.decrypt(in, inOff, len, out, outOff, keyToken, algorithm, mode, lcfbLen, icvSelection, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void decrypt(byte[] in, int inOff, int len, byte[] out, int outOff, byte[] keyToken, String algorithm, int mode, int lcfbLen, ICVSelection icvSelection, boolean aesGCM_failover) throws InvalidParameterException {
        String parmsReport;
        String ovString;
        String keyTokenString;
        String ruleArrayString;
        HexDumpEncoder encoder;
        hikmNativeInteger ruleArrayCount;
        String ruleText;
        RuntimeException rte;
        String method_called = null;
        int txtLen = len;
        byte[] AuthTag = new byte[]{};
        hikmNativeInteger keyParmLength = new hikmNativeInteger(0);
        byte[] keyParmsByte = new byte[1];
        hikmNativeInteger optional_data_length = new hikmNativeInteger(0);
        byte[] optional_data = null;
        if (debug != null) {
            Object[] parms = new Object[]{in, new Integer(inOff), new Integer(len), out, new Integer(outOff), keyToken, algorithm, new Integer(mode), new Integer(lcfbLen), icvSelection, new Boolean(aesGCM_failover)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "decrypt", parms);
        }
        if (this.jitOptimized) {
            this.JIT_decrypt(in, inOff, len, out, outOff);
            if (debug == null) return;
            debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
            return;
        }
        if (mode == 5) {
            txtLen = len - this.GCM_T_size;
        }
        if (0 != inOff) {
            rte = new RuntimeException("Internal Error. Input buffer offset must be 0.");
            if (debug == null) throw rte;
            debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Internal Error. Input buffer offset must be 0.");
            debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte);
            debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
            throw rte;
        }
        if (algorithm == null) {
            rte = new RuntimeException("Algorithm passed can not be null.");
            if (debug == null) throw rte;
            debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Algorithm passed can not be null.");
            debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte);
            debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
            throw rte;
        }
        if (!algorithm.equals("AES") && !algorithm.equals("DES")) {
            rte = new RuntimeException("Only support algorithm of DES or AES.");
            if (debug == null) throw rte;
            debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Only support algorithm of DES or AES.");
            debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte);
            debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
            throw rte;
        }
        if (mode != 0 && mode != 1 && mode != 2 && mode != 3 && mode != 5) {
            rte = new RuntimeException("Only support modes of CBC, CFB, OFB, GCM, and ECB.");
            if (debug == null) throw rte;
            debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Only support modes of CBC, CFB, OFB, GCM, and ECB.");
            debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte);
            debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
            throw rte;
        }
        if (PlatformUtilities.isLinux()) {
            this.hardwareFunc = 3;
        }
        if (this.hardwareFunc == 0) {
            this.hardwareFunc = mode == 5 ? 2 : (algorithm.equals("AES") && HardwareProfile.getIsCryptoAssistPresent() && HardwareProfile.getIsAES128CryptoAssistPresent() || algorithm.equals("AES") && HardwareProfile.getIsCryptoAssistPresent() && HardwareProfile.getIsAES192CryptoAssistPresent() || algorithm.equals("AES") && HardwareProfile.getIsCryptoAssistPresent() && HardwareProfile.getIsAES256CryptoAssistPresent() || algorithm.equals("DES") && HardwareProfile.getIsCryptoAssistPresent() && HardwareProfile.getIsDESCryptoAssistPresent() || algorithm.equals("DES") && HardwareProfile.getIsCryptoAssistPresent() && HardwareProfile.getIs3DESCryptoAssistPresent() || algorithm.equals("DES") && mode == 0 && (this.isToken || this.isLabel) || algorithm.equals("DES") && mode == 3 && this.isLabel || algorithm.equals("DES") && mode == 2 && this.isLabel ? 2 : 3);
        }
        if (this.hardwareFunc == 2) {
            int textCalc = len - inOff;
            this.textLength = new hikmNativeInteger(textCalc);
            this.output = new byte[textCalc + 24];
            byte[] ruleArray = null;
            ruleText = "";
            ruleArrayCount = null;
            keyParmLength = new hikmNativeInteger(0);
            int count = 0;
            if (algorithm.equals("AES")) {
                ruleText = ruleText + "AES     ";
                ++count;
            }
            if (algorithm.equals("DES")) {
                ruleText = ruleText + "DES     ";
                ++count;
            }
            if (mode == 0) {
                ruleText = ruleText + "ECB     ";
                ++count;
            } else if (mode == 2) {
                if (lcfbLen != 0) {
                    ruleText = ruleText + "CFB-LCFB";
                    keyParmLength.setValue(1);
                } else {
                    ruleText = ruleText + "CFB     ";
                }
                ++count;
                ruleText = ruleText + icvSelection.getType();
                ++count;
            } else if (mode == 1) {
                ruleText = ruleText + "CBC     ";
                ++count;
                ruleText = ruleText + icvSelection.getType();
                ++count;
            } else if (mode == 3) {
                ruleText = ruleText + "OFB     ";
                ++count;
                ruleText = ruleText + icvSelection.getType();
                ++count;
            } else if (mode == 5) {
                ruleText = true == aesGCM_failover ? ruleText + "GCM-LG  " : ruleText + "GCM     ";
                ++count;
                ruleText = ruleText + icvSelection.getType();
                ++count;
            }
            if (this.isToken || this.isLabel) {
                ruleText = ruleText + "KEYIDENT";
                ++count;
            }
            ruleArrayCount = new hikmNativeInteger(count);
            ruleArray = PlatformUtilities.getBytesPlatform(ruleText);
            hikmNativeInteger initialization_vector_length = null;
            if (this.iv == null) {
                initialization_vector_length = new hikmNativeInteger(0);
                this.iv = new byte[0];
            } else {
                initialization_vector_length = new hikmNativeInteger(this.iv.length);
            }
            hikmNativeInteger output_vector_length = null;
            if (this.ov == null) {
                output_vector_length = new hikmNativeInteger(0);
                this.ov = new byte[0];
            } else {
                output_vector_length = new hikmNativeInteger(this.ov.length);
            }
            hikmNativeInteger output_length = null;
            if (this.ov == null) {
                output_length = new hikmNativeInteger(0);
                this.output = new byte[0];
            } else {
                output_length = new hikmNativeInteger(this.output.length);
            }
            hikmNativeInteger blockSize = null;
            blockSize = algorithm.equals("DES") ? new hikmNativeInteger(8) : new hikmNativeInteger(16);
            byte[] zero = new byte[]{};
            try {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Calling hardware service: ICSF CSNBSYD");
                }
                method_called = "CSNBSYD";
                Integer segmentSize = new Integer(lcfbLen);
                keyParmsByte[0] = segmentSize.byteValue();
                optional_data_length = new hikmNativeInteger(0);
                optional_data = null;
                keyParmLength = lcfbLen != 0 && mode == 2 ? new hikmNativeInteger(1) : new hikmNativeInteger(0);
                if (mode == 5) {
                    if (debug != null) {
                        String gcmDecryptIn = "\nGCM Mode decryption starting.\n\tcipherText len w/ Tag = " + len + "\n\tAuth Tag length       = " + this.GCM_T_size + "\n\tcipherText len w/o T: " + txtLen;
                        debug.text(Debug.TYPE_PUBLIC, className, "encrypt", gcmDecryptIn);
                    }
                    AuthTag = new byte[this.GCM_T_size];
                    System.arraycopy(in, inOff + txtLen, AuthTag, 0, this.GCM_T_size);
                    this.textLength = new hikmNativeInteger(txtLen);
                    if (debug != null) {
                        HexDumpEncoder encoder3 = new HexDumpEncoder();
                        String gcmDecryptIn = "\nGCM Mode decryption starting.\n\tAuthTag: " + encoder3.encodeBuffer(AuthTag) + "\n\tcipherText Offset = " + inOff + "  CipherTextLen = " + txtLen + "\n\tcipherText: \n" + encoder3.encodeBuffer(in);
                        debug.text(Debug.TYPE_PUBLIC, className, "encrypt", gcmDecryptIn);
                    }
                    keyParmLength = new hikmNativeInteger(this.GCM_T_size);
                    keyParmsByte = AuthTag;
                    optional_data_length = new hikmNativeInteger(this.GCM_AAD.length);
                    optional_data = this.GCM_AAD;
                    output_length = new hikmNativeInteger(txtLen);
                } else {
                    optional_data_length = new hikmNativeInteger(0);
                    optional_data = zero;
                    keyParmLength = lcfbLen != 0 && mode == 2 ? new hikmNativeInteger(1) : new hikmNativeInteger(0);
                }
                if (null != debug) {
                    encoder = new HexDumpEncoder();
                    ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
                    keyTokenString = "\n" + encoder.encodeBuffer(keyToken);
                    String keyParmsString = "\n" + encoder.encodeBuffer(keyParmsByte);
                    String ivString = "\n" + encoder.encodeBuffer(this.iv);
                    String ovString2 = "\n" + encoder.encodeBuffer(this.ov);
                    String parmsReport2 = "\nJCEHdwrUtils: CSNBSYD INPUT PARAMETERS \n    returnCode : " + this.returnCode.getValue() + "\n    reasonCode : " + this.reasonCode.getValue() + "\n    rule_array_count: " + ruleArrayCount.getValue() + "\n    rule_array   : " + ruleArrayString + "\n    key_length  : " + keyToken.length + "\n    key_identifier  : " + keyTokenString + "\n    key_parms_length   : " + keyParmLength.getValue() + "\n    key_parms   : " + keyParmsString + "\n    block_size   : " + blockSize.getValue() + "\n    initialization_vector_length    : " + initialization_vector_length.getValue() + "\n    initialization_vector  : " + ivString + "\n    chain_data_length   : " + output_vector_length.getValue() + "\n    chain_data   : " + ovString2 + "\n    cipher_text_length   : " + this.textLength.getValue() + "\n    cipher_text : XXX\n    clear_text_length   : " + output_length.getValue() + "\n    optional_data_length : " + optional_data_length.getValue() + "\n    optional_data   : XXX\n";
                    debug.text(Debug.TYPE_FINEST, className, "decrypt", parmsReport2);
                }
                this.hikm.CSNBSYDJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, new hikmNativeInteger(keyToken.length), keyToken, keyParmLength, keyParmsByte, blockSize, initialization_vector_length, this.iv, output_vector_length, this.ov, this.textLength, in, output_length, this.output, optional_data_length, optional_data);
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "decrypt", "CSNBSYD: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
                }
                if (null != debug) {
                    encoder = new HexDumpEncoder();
                    ovString = "\n" + encoder.encodeBuffer(this.ov);
                    parmsReport = "\nJCEHdwrUtils: CSNBSYD RETURN PARAMETERS \n    returnCode : " + this.returnCode.getValue() + "\n    reasonCode : " + this.reasonCode.getValue() + "\n    chain_data_length   : " + output_vector_length.getValue() + "\n    chain_data   : " + ovString + "\n    clear_text_length   : " + output_length.getValue() + "\n    clear_text : XXX\n";
                    debug.text(Debug.TYPE_FINEST, className, "decrypt", parmsReport);
                }
            }
            catch (IllegalArgumentException e) {
                RuntimeException rte2 = new RuntimeException("Hardware error from call " + method_called + " " + e);
                if (debug == null) throw rte2;
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Hardware error from call " + method_called + " " + e);
                debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte2);
                debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
                throw rte2;
            }
            if (this.returnCode.getValue() == 8 && this.reasonCode.getValue() == 10128 && (this.isLabel || this.isToken) || this.returnCode.getValue() == 8 && this.reasonCode.getValue() == 10012 && (this.isLabel || this.isToken) || this.returnCode.getValue() == 8 && this.reasonCode.getValue() == 2079 && (this.isLabel || this.isToken) || this.returnCode.getValue() == 12 && this.reasonCode.getValue() == 8 && (this.isLabel || this.isToken) || this.returnCode.getValue() == 8 && this.reasonCode.getValue() == 3067 && (this.isLabel || this.isToken) || this.returnCode.getValue() == 8 && this.reasonCode.getValue() == 3059 && (this.isLabel || this.isToken)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Enabling failover call since this possible non clear key value cannot be used with SYD");
                }
                this.hardwareFunc = 3;
            } else if (!(mode != 5 || aesGCM_failover || this.returnCode.getValue() != 8 || this.reasonCode.getValue() != 2028 || 0x10000000 > this.textLength.getValue() && 0x10000000 > this.GCM_AAD.length)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "decrypt", "Enabling failover call since this AES/GCM decryption might need to be done with legacy SYD");
                }
                this.decrypt(in, inOff, len, out, outOff, keyToken, algorithm, mode, lcfbLen, icvSelection, true);
            } else if (this.returnCode.getValue() != 0) {
                if (aesGCM_failover && this.returnCode.getValue() == 8 && this.reasonCode.getValue() == 2016) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_FINE, className, "decrypt", "In AES/GCM decryption failover, but ICSF OA46558 hasn't been applied. Resetting reason code to 2028.");
                    }
                    this.reasonCode = new hikmNativeInteger(2028);
                }
                JCECCARuntimeException rte3 = new JCECCARuntimeException(1, method_called, "Hardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                if (debug == null) throw rte3;
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Hardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue());
                debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte3);
                debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
                throw rte3;
            }
        }
        if (this.hardwareFunc == 3 && algorithm.equalsIgnoreCase("DES")) {
            String keyIdCopyString;
            String exitDataString;
            HexDumpEncoder encoder2;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Crypto Assist for DES acceleration is not available. Routing call to CSNBDEC.");
            }
            if (mode != 1) {
                rte = null;
                rte = PlatformUtilities.isLinux() ? new UnsupportedOperationException("Operation not supported for the specified mode using a DES key in this format.") : new JCECCARuntimeException(1, method_called, "Operation not supported for the specified mode using a DES key in this format.\nHardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                if (debug == null) throw rte;
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Tried to route call to CSNBENC but the cipher mode is not CBC. Cipher Mode: " + mode);
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Hardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue());
                debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte);
                debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
                throw rte;
            }
            byte[] keyIdCopy = new byte[keyToken.length];
            System.arraycopy(keyToken, 0, keyIdCopy, 0, keyToken.length);
            if (PlatformUtilities.isLinux()) {
                keyIdCopy = PlatformUtilities.convertBytesIfKeyLabelETOA(keyIdCopy);
            }
            int textCalc = len - inOff;
            this.textLength = new hikmNativeInteger(textCalc);
            this.output = new byte[textCalc + 8];
            ruleText = "CBC     " + icvSelection.getType();
            ruleArrayCount = new hikmNativeInteger(2);
            byte[] ruleArray = PlatformUtilities.getBytesPlatform(ruleText);
            method_called = "CSNBDEC";
            if (null != debug) {
                encoder2 = new HexDumpEncoder();
                exitDataString = "\n" + encoder2.encodeBuffer(this.exitData);
                keyIdCopyString = "\n" + encoder2.encodeBuffer(keyIdCopy);
                String ivString = "\n" + encoder2.encodeBuffer(this.iv);
                String ruleArrayString2 = "\n" + encoder2.encodeBuffer(ruleArray);
                String ovString3 = "\n" + encoder2.encodeBuffer(this.ov);
                String parmsReport3 = "\nJCEHdwrUtils: CSNBDEC INPUT PARAMETERS \n    returnCode : " + this.returnCode.getValue() + "\n    reasonCode : " + this.reasonCode.getValue() + "\n    exit_data_length : " + this.exitDataLength.getValue() + "\n    exit_data : " + exitDataString + "\n    key_identifier : " + keyIdCopyString + "\n    text_length : " + this.textLength.getValue() + "\n    cipher_text : XXX\n    initialization_vector : " + ivString + "\n    rule_array_count : " + ruleArrayCount.getValue() + "\n    rule_array : " + ruleArrayString2 + "\n    chaining_vector : " + ovString3 + "\n";
                debug.text(Debug.TYPE_FINEST, className, "decrypt", parmsReport3);
            }
            try {
                this.hikm.CSNBDECJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, keyIdCopy, this.textLength, in, this.iv, ruleArrayCount, ruleArray, this.ov, this.output);
            }
            catch (IllegalArgumentException e) {
                RuntimeException rte4 = new RuntimeException("Hardware error from call CSNBDEC " + e);
                if (debug == null) throw rte4;
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Hardware error from call CSNBDEC " + e);
                debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte4);
                debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
                throw rte4;
            }
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "decrypt", "CSNBDEC: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
            }
            if (null != debug) {
                encoder2 = new HexDumpEncoder();
                exitDataString = "\n" + encoder2.encodeBuffer(this.exitData);
                keyIdCopyString = "\n" + encoder2.encodeBuffer(keyIdCopy);
                String ovString4 = "\n" + encoder2.encodeBuffer(this.ov);
                String parmsReport4 = "\nJCEHdwrUtils: CSNBDEC RETURN PARAMETERS \n    returnCode : " + this.returnCode.getValue() + "\n    reasonCode : " + this.reasonCode.getValue() + "\n    exit_data_length : " + this.exitDataLength.getValue() + "\n    exit_data : " + exitDataString + "\n    key_identifier : " + keyIdCopyString + "\n    chaining_vector : " + ovString4 + "\n    clear_text : XXX\n";
                debug.text(Debug.TYPE_FINEST, className, "decrypt", parmsReport4);
            }
            if (this.returnCode.getValue() != 0) {
                JCECCARuntimeException rte5 = new JCECCARuntimeException(1, "CSNBDEC", "Hardware error from call CSNBDEC RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                if (debug == null) throw rte5;
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Hardware error from call CSNBDEC RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue());
                debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte5);
                debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
                throw rte5;
            }
        }
        if (this.hardwareFunc == 3 && algorithm.equalsIgnoreCase("AES")) {
            if (!HardwareProfile.getIsHCR7751OrLaterPresent()) {
                String exMsg = new String("The operation using an AES key is not supported on ICSF levels less than HCR7751.");
                RuntimeException rte6 = new RuntimeException(exMsg);
                if (debug == null) throw rte6;
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", exMsg);
                debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte6);
                debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
                throw rte6;
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Attempt Symmetric Algorithm Encryption.  Routing call to CSNBSAD.");
            }
            if (mode != 0 && mode != 1) {
                rte = null;
                rte = PlatformUtilities.isLinux() ? new UnsupportedOperationException("Operation not supported for the specified mode using an AES key in this format.") : new JCECCARuntimeException(1, method_called, "Operation not supported for the specified mode using an AES key in this format.\nHardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                if (debug == null) throw rte;
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Tried to route call to CSNBSAD but the cipher mode is not ECB or CBC. Cipher Mode: " + mode);
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Hardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue());
                debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte);
                debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
                throw rte;
            }
            try {
                this.returnCode.setValue(0);
                this.reasonCode.setValue(0);
                byte[] ruleArray = null;
                String ruleText2 = "";
                hikmNativeInteger ruleArrayCount2 = null;
                byte[] keyIdCopy = new byte[keyToken.length];
                System.arraycopy(keyToken, 0, keyIdCopy, 0, keyToken.length);
                if (PlatformUtilities.isLinux()) {
                    keyIdCopy = PlatformUtilities.convertBytesIfKeyLabelETOA(keyIdCopy);
                }
                int textCalc = len - inOff;
                this.textLength = new hikmNativeInteger(textCalc);
                this.output = new byte[textCalc + 24];
                int count = 0;
                ruleText2 = ruleText2 + "AES     ";
                ++count;
                if (mode == 0) {
                    ruleText2 = ruleText2 + "ECB     ";
                    ++count;
                } else if (mode == 1) {
                    ruleText2 = ruleText2 + "CBC     ";
                    ++count;
                    ruleText2 = ruleText2 + icvSelection.getType();
                    ++count;
                }
                ruleText2 = PlatformUtilities.isLinux() && !this.isLabel && !this.isToken ? ruleText2 + "KEY-CLR " : ruleText2 + "KEYIDENT";
                ruleArrayCount2 = new hikmNativeInteger(++count);
                ruleArray = PlatformUtilities.getBytesPlatform(ruleText2);
                hikmNativeInteger initialization_vector_length = null;
                if (this.iv == null) {
                    initialization_vector_length = new hikmNativeInteger(0);
                    this.iv = new byte[0];
                } else {
                    initialization_vector_length = new hikmNativeInteger(this.iv.length);
                }
                hikmNativeInteger output_vector_length = null;
                if (this.ov == null) {
                    output_vector_length = new hikmNativeInteger(0);
                    this.ov = new byte[0];
                } else {
                    output_vector_length = new hikmNativeInteger(this.ov.length);
                }
                hikmNativeInteger output_length = null;
                if (this.ov == null) {
                    output_length = new hikmNativeInteger(0);
                    this.output = new byte[0];
                } else {
                    output_length = new hikmNativeInteger(this.output.length);
                }
                hikmNativeInteger blockSize = new hikmNativeInteger(16);
                byte[] zero = new byte[]{};
                if (null != debug) {
                    encoder = new HexDumpEncoder();
                    ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
                    keyTokenString = "\n" + encoder.encodeBuffer(keyIdCopy);
                    String ivString = "\n" + encoder.encodeBuffer(this.iv);
                    String ovString5 = "\n" + encoder.encodeBuffer(this.ov);
                    String parmsReport5 = "\nJCEHdwrUtils: CSNBSAD INPUT PARAMETERS \n    returnCode : " + this.returnCode.getValue() + "\n    reasonCode : " + this.reasonCode.getValue() + "\n    rule_array_count: " + ruleArrayCount2.getValue() + "\n    rule_array   : " + ruleArrayString + "\n    key_length  : " + keyIdCopy.length + "\n    key_identifier  : " + keyTokenString + "\n    key_parms_length   : " + 0 + "\n    block_size   : " + blockSize.getValue() + "\n    initialization_vector_length    : " + initialization_vector_length.getValue() + "\n    initialization_vector  : " + ivString + "\n    chain_data_length   : " + output_vector_length.getValue() + "\n    chain_data   : " + ovString5 + "\n    cipher_text_length   : " + this.textLength.getValue() + "\n    cipher_text : XXX\n    clear_text_length   : " + output_length.getValue() + "\n    optional_data_length   : " + 0 + "\n";
                    debug.text(Debug.TYPE_FINEST, className, "decrypt", parmsReport5);
                }
                this.hikm.CSNBSADJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount2, ruleArray, new hikmNativeInteger(keyIdCopy.length), keyIdCopy, new hikmNativeInteger(0), zero, blockSize, initialization_vector_length, this.iv, output_vector_length, this.ov, this.textLength, in, output_length, this.output, new hikmNativeInteger(0), zero);
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "decrypt", "CSNBSAD: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
                }
                if (null != debug) {
                    encoder = new HexDumpEncoder();
                    ovString = "\n" + encoder.encodeBuffer(this.ov);
                    parmsReport = "\nJCEHdwrUtils: CSNBSAD RETURN PARAMETERS \n    returnCode : " + this.returnCode.getValue() + "\n    reasonCode : " + this.reasonCode.getValue() + "\n    chain_data_length   : " + output_vector_length.getValue() + "\n    chain_data   : " + ovString + "\n    clear_text_length   : " + output_length.getValue() + "\n    clear_text : XXX\n";
                    debug.text(Debug.TYPE_FINEST, className, "decrypt", parmsReport);
                }
            }
            catch (IllegalArgumentException e) {
                RuntimeException rte7 = new RuntimeException("Hardware error from call CSNBSAD " + e);
                if (debug == null) throw rte7;
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Hardware error from call CSNBSAD " + e);
                debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte7);
                debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
                throw rte7;
            }
            catch (Exception e) {
                RuntimeException rte8 = new RuntimeException("Exception from calling CSNBSAD " + e);
                if (debug == null) throw rte8;
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Exception from calling CSNBSAD " + e);
                debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte8);
                debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
                throw rte8;
            }
            if (this.returnCode.getValue() != 0) {
                rte = new JCECCARuntimeException(1, "CSNBSAD", "Hardware error from call CSNBSAD RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                if (debug == null) throw rte;
                debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Hardware error from call CSNBSAD RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue());
                debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte);
                debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
                throw rte;
            }
        } else if (this.returnCode.getValue() != 0) {
            rte = new JCECCARuntimeException(1, "CSNBSAD", "Hardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
            if (debug == null) throw rte;
            debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "Hardware error from call " + method_called + " RC = " + this.returnCode.getValue() + " RSN = " + this.reasonCode.getValue());
            debug.exception(Debug.TYPE_PUBLIC, className, "decrypt", rte);
            debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
            throw rte;
        }
        if (null != this.output) {
            System.arraycopy(this.output, 0, out, outOff, this.textLength.getValue());
        }
        this.output = null;
        if (debug == null) return;
        debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
    }

    protected void JIT_decrypt(byte[] in, int inOff, int len, byte[] out, int outOff) throws InvalidParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{in, new Integer(inOff), new Integer(len), out, new Integer(outOff)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "JIT_decrypt", parms);
        }
        if (0 < len) {
            int overflowLen = len % this.unitBytes;
            if (overflowLen != 0 && ("CFB".equals(this.modeNameString) || "OFB".equals(this.modeNameString))) {
                int blockMultipleLen = len / this.unitBytes * this.unitBytes;
                if (debug != null) {
                    debug.text(Debug.TYPE_FINEST, className, "JIT_decrypt", "\n\toverflowLen != 0. \n\t1st: calling jitCipher.cipher(in, " + blockMultipleLen + ", " + inOff + ", out, " + outOff + ")");
                }
                this.jitCipher.cipher(in, blockMultipleLen, inOff, out, outOff);
                byte[] overflow = new byte[this.unitBytes];
                System.arraycopy(in, inOff + blockMultipleLen, overflow, 0, overflowLen);
                if (debug != null) {
                    debug.text(Debug.TYPE_FINEST, className, "JIT_decrypt", "\n\t2nd: calling jitCipher.cipher(in, " + this.unitBytes + ", " + inOff + ", out, " + outOff + " )");
                }
                this.jitCipher.cipher(overflow, this.unitBytes, 0, overflow, 0);
                System.arraycopy(overflow, 0, out, outOff + blockMultipleLen, overflowLen);
            } else {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINEST, className, "JIT_decrypt", "\n\toverflowLen == 0. \n\tcalling jitCipher.cipher(in, " + len + ", " + inOff + ", out, " + outOff + " )");
                }
                this.jitCipher.cipher(in, len, inOff, out, outOff);
            }
        } else if (debug != null) {
            debug.text(Debug.TYPE_FINEST, className, "JIT_decrypt", "0 !< len so nothing to do.");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "JIT_decrypt");
        }
    }
}

