/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.JarVerifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class IBMJCE4758
extends Provider {
    static final long serialVersionUID = 1798769492039881162L;
    private static String info = "IBMJCE4758 Provider implements the following: HMAC-SHA1, HMAC-MD5, HMAC-MD2, MD2, MD5, SHA, MD2withRSA, MD5withRSA, SHA1withRSA, RSA, SHA1withDSA* \nimplements the following:\nSignature algorithms               : SHA1withDSA* , SHA1withRSA, MD5withRSA, MD2withRSA \nCipher algorithms                  : DES, TripleDES, AES, PBEWithMD2AndDES, \n                                       PBEWithMD2AndTripleDES,\n                                       PBEWithMD5AndDES, PBEWithMD5AndTripleDES, \n                                       PBEWithSHA1AndDES \n                                       PBEWithSHA1AndTripleDES,\n                                       PBEWithSHAAnd2KeyTripleDES, PBEWithSHAAnd3KeyTripleDES \n                                       RSA\nMessage authentication code (MAC)  : HmacSHA1, HmacMD2, HmacMD5\nKey (pair) generator               : DSA*, DES, TripleDES, HmacMD2,\n                                       HmacMD5, HmacSHA1, RSA\nMessage digest                     : MD2, MD5, SHA-1\nAlgorithm parameter generator      : DSA*\nAlgorithm parameter                : DES, TripleDES, DSA, AES*\n                                       PBEwithMD5AndDES\nKey factory                        : DSA*, RSA\nSecret key factory                 : DES, TripleDES, AES\n                                       PKCS5Key, PBKDF1 and PBKDF2(PKCS5Derived Key).\nCertificate                        : X.509\nSecure random                      : IBMSecureRandom\nKey store                          : JCE4758KS, JCA4758KS\nNote * - Only Supported By Pre Trex Machines (IBM 2084 eServer zSeries 900)";
    private static boolean verifiedJce = false;
    private static boolean verifiedSelfIntegrity = false;
    private static X509Certificate[] trustedCaCerts = null;
    private static final byte[][] bytesOfTrustedCaCerts = new byte[][]{{48, -126, 3, 79, 48, -126, 3, 13, -96, 3, 2, 1, 2, 2, 4, 57, 36, -91, 85, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 48, 96, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 24, 48, 22, 6, 3, 85, 4, 10, 19, 15, 73, 66, 77, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 73, 66, 77, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, 30, 23, 13, 48, 48, 48, 53, 49, 57, 48, 50, 50, 50, 49, 51, 90, 23, 13, 48, 54, 48, 53, 49, 56, 48, 50, 50, 50, 49, 51, 90, 48, 96, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 24, 48, 22, 6, 3, 85, 4, 10, 19, 15, 73, 66, 77, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 73, 66, 77, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, -126, 1, -72, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, 21, 0, -105, 96, 80, -113, 21, 35, 11, -52, -78, -110, -71, -126, -94, -21, -124, 11, -16, 88, 28, -11, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 3, -127, -123, 0, 2, -127, -127, 0, -22, 107, 0, -57, -33, 16, 59, -71, 116, 53, -89, -31, 109, 102, -126, 77, -9, 91, 86, 113, -62, 38, 69, 39, 114, 61, 81, 16, 98, -1, -77, -36, 16, -55, -5, 81, 19, -44, -83, -117, -88, 37, 110, 93, -55, 120, -46, 91, 39, -45, 19, 65, 71, 20, 6, 124, -53, -126, 56, 94, -58, 11, 97, -96, 76, -125, 45, -108, -52, -116, 46, -124, -112, 58, -113, 66, 10, 105, 82, -45, 116, 38, 119, -92, 20, 125, 42, 113, 65, -120, -119, 119, -90, 45, 98, -102, -95, 88, -104, 109, 108, -49, -50, -88, -22, -70, -35, -24, -95, 16, 68, -116, -124, 66, -63, -72, 31, 43, -76, -68, -77, 93, 116, 96, -128, -115, 66, 84, -93, 83, 48, 81, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 126, 61, 77, 77, -52, 16, 89, -70, -7, -82, 66, 61, -27, -55, 87, 90, 82, 11, 126, -121, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 126, 61, 77, 77, -52, 16, 89, -70, -7, -82, 66, 61, -27, -55, 87, 90, 82, 11, 126, -121, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 3, 47, 0, 48, 44, 2, 20, 28, -17, -10, -64, 92, -19, -109, 112, 34, -31, 75, -55, 15, -16, -99, 122, 9, -18, -122, -122, 2, 20, 18, 119, 71, 98, -62, -97, 25, 97, -36, 41, -6, -71, 73, -91, 25, -42, -91, -68, 69, 77}, {48, -126, 3, -64, 48, -126, 3, 126, -96, 3, 2, 1, 2, 2, 1, 1, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 48, -127, -112, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 11, 48, 9, 6, 3, 85, 4, 8, 19, 2, 67, 65, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 80, 97, 108, 111, 32, 65, 108, 116, 111, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 32, 73, 110, 99, 49, 35, 48, 33, 6, 3, 85, 4, 11, 19, 26, 74, 97, 118, 97, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, 30, 23, 13, 48, 48, 48, 52, 49, 50, 48, 55, 48, 48, 48, 48, 90, 23, 13, 48, 54, 48, 52, 49, 50, 48, 55, 48, 48, 48, 48, 90, 48, -127, -112, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 11, 48, 9, 6, 3, 85, 4, 8, 19, 2, 67, 65, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 80, 97, 108, 111, 32, 65, 108, 116, 111, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 32, 73, 110, 99, 49, 35, 48, 33, 6, 3, 85, 4, 11, 19, 26, 74, 97, 118, 97, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, -126, 1, -73, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -21, -81, 55, 4, 30, -54, 81, 30, 105, 93, -80, -14, -113, -10, -75, 73, 31, -58, -92, -103, 5, -41, 41, -65, 116, -73, 106, -11, 25, -40, 30, -28, 27, -8, 10, 1, -102, -104, -1, 112, -85, -30, 74, 86, -122, 108, 83, -77, -4, -31, -56, -127, -116, 49, -16, -60, -13, -80, -117, -26, 112, 6, -20, -9, 105, 104, -37, -125, 76, 114, 41, -119, 41, 54, 23, 92, 59, 74, 7, -96, 32, 2, 42, 70, -105, 81, 29, 112, -56, 8, 24, 11, -50, 12, 110, -101, 118, -9, 5, -29, -25, -5, -45, 97, 121, -31, 96, -102, 36, -115, 6, -107, -125, 60, 81, 32, -31, 48, -49, 56, 87, -126, -90, 26, 114, 13, -50, -45, 2, 21, 0, -124, 37, 69, -31, -70, -71, -87, 98, -85, 121, -24, 91, 48, -72, -119, 107, 27, -1, 123, 117, 2, -127, -127, 0, -85, -55, 116, 123, 116, -17, -18, 66, -75, 106, 83, 77, 59, -35, -112, 6, 114, 104, -111, 15, 11, -92, 41, 118, 46, 85, 59, -43, -82, 77, 101, 92, 126, 42, 58, 4, -90, 103, -90, -48, 113, -86, -91, -41, -73, -30, -63, 114, 13, -92, -47, -86, 30, -110, 84, 76, 32, 0, 9, -94, -80, 9, 65, 25, 51, 0, -78, -61, 92, -82, 66, -8, -79, -117, -54, 124, -106, -40, 16, 127, 55, 68, 91, -86, -52, 120, -56, -41, 114, 118, 55, 107, 64, -103, -88, 85, 102, -6, -88, 3, 30, -117, 74, 17, 2, 105, -53, 76, -72, 37, 6, 28, -96, 119, -46, -55, -84, -46, 61, -23, 10, 16, -6, 118, 112, -73, -5, -36, 3, -127, -124, 0, 2, -127, -128, 45, 9, -104, 92, -84, -72, -100, -57, -103, 126, -18, 32, 25, 42, 52, -112, -7, -41, -85, -85, -82, -35, 107, 114, -107, 13, 102, -8, -17, 39, -113, 68, -78, -19, 40, 68, -57, -2, -81, -80, -90, 39, 111, 0, 103, 69, -126, 91, 7, -88, 86, 86, 59, -46, 41, 81, 97, 94, 105, 57, -41, 46, 116, 119, 18, -49, 25, 74, -11, 45, -56, -53, 114, 97, -60, 78, 111, -6, 71, 67, 63, 20, -69, -6, -68, 24, 102, 40, -62, -39, 102, -117, 122, 45, 47, -62, 96, -110, 75, 20, -2, 88, 62, 33, 127, 104, 98, -66, 108, 72, 73, -7, -96, 75, 94, -123, -99, 25, 16, -7, 21, 69, 81, 27, 113, -44, -9, 11, -93, 102, 48, 100, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 0, 7, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 101, -30, -12, -122, -55, -45, 78, -16, -111, 78, 88, -94, 106, -11, -40, 120, 90, -102, -63, -90, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 101, -30, -12, -122, -55, -45, 78, -16, -111, 78, 88, -94, 106, -11, -40, 120, 90, -102, -63, -90, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 3, 47, 0, 48, 44, 2, 20, 36, -97, 2, -61, -5, 49, -43, -111, 59, -7, 126, 86, 111, -106, -33, 100, 10, 4, -104, -76, 2, 20, 110, 121, -124, -89, -18, 104, -93, 2, 114, 49, 99, -37, 67, -85, 8, -20, 77, -17, 22, 58}};
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.IBMJCE4758";
    private static HardwareProfile hwprof = null;

    public IBMJCE4758() {
        super("IBMJCE4758", 1.2, info);
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "IBMJCE4758");
        }
        hwprof = new HardwareProfile();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                IBMJCE4758.this.put("SecureRandom.IBMSecureRandom", "com.ibm.crypto.hdwrCCA.provider.SecureRandom");
                IBMJCE4758.this.put("Signature.SHA1withRSA", "com.ibm.crypto.hdwrCCA.provider.SHA1withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.SHA-1withRSA", "SHA1withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.SHA-1/RSA", "SHA1withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.SHA1/RSA", "SHA1withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.SHA/RSA", "SHA1withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.RSA", "SHA1withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.26", "SHA1withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.1.3.14.3.2.26", "SHA1withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.5", "SHA1withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.1.2.840.113549.1.1.5", "SHA1withRSA");
                IBMJCE4758.this.put("Signature.NoHashwithRSA", "com.ibm.crypto.hdwrCCA.provider.DatawithRSA");
                IBMJCE4758.this.put("Signature.RSAforSSL", "com.ibm.crypto.hdwrCCA.provider.DatawithRSA");
                hwprof;
                if (!HardwareProfile.getIsCryptoAssistPresent()) {
                    hwprof;
                    if (!HardwareProfile.getIsPCIXCCPresent()) {
                        IBMJCE4758.this.put("Signature.NoHashwithDSA", "com.ibm.crypto.hdwrCCA.provider.DatawithDSA");
                        IBMJCE4758.this.put("Signature.DSAforSSL", "com.ibm.crypto.hdwrCCA.provider.DatawithDSA");
                    }
                }
                IBMJCE4758.this.put("Signature.MD2withRSA", "com.ibm.crypto.hdwrCCA.provider.MD2withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.MD2/RSA", "MD2withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.2", "MD2withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.1.2.840.113549.1.1.2", "MD2withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.24", "MD2withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.1.3.14.3.2.24", "MD2withRSA");
                IBMJCE4758.this.put("Signature.MD5withRSA", "com.ibm.crypto.hdwrCCA.provider.MD5withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.MD5/RSA", "MD5withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.4", "MD5withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.1.2.840.113549.1.1.4", "MD5withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.25", "MD5withRSA");
                IBMJCE4758.this.put("Alg.Alias.Signature.1.3.14.3.2.25", "MD5withRSA");
                hwprof;
                if (!HardwareProfile.getIsCryptoAssistPresent()) {
                    hwprof;
                    if (!HardwareProfile.getIsPCIXCCPresent()) {
                        IBMJCE4758.this.put("Signature.SHA1withDSA", "com.ibm.crypto.hdwrCCA.provider.SHA1withDSA");
                        IBMJCE4758.this.put("Alg.Alias.Signature.SHA-1withDSA", "SHA1withDSA");
                        IBMJCE4758.this.put("Alg.Alias.Signature.SHA-1/DSA", "SHA1withDSA");
                        IBMJCE4758.this.put("Alg.Alias.Signature.SHA1/DSA", "SHA1withDSA");
                        IBMJCE4758.this.put("Alg.Alias.Signature.SHA/DSA", "SHA1withDSA");
                        IBMJCE4758.this.put("Alg.Alias.Signature.DSA", "SHA1withDSA");
                        IBMJCE4758.this.put("Alg.Alias.Signature.DSS", "SHA1withDSA");
                        IBMJCE4758.this.put("Alg.Alias.Signature.SHAwithDSA", "SHA1withDSA");
                        IBMJCE4758.this.put("Alg.Alias.Signature.DSAWithSHA1", "SHA1withDSA");
                        IBMJCE4758.this.put("Alg.Alias.Signature.OID.1.2.840.10040.4.3", "SHA1withDSA");
                        IBMJCE4758.this.put("Alg.Alias.Signature.1.2.840.10040.4.3", "SHA1withDSA");
                        IBMJCE4758.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.13", "SHA1withDSA");
                        IBMJCE4758.this.put("Alg.Alias.Signature.1.3.14.3.2.13", "SHA1withDSA");
                        IBMJCE4758.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.27", "SHA1withDSA");
                        IBMJCE4758.this.put("Alg.Alias.Signature.1.3.14.3.2.27", "SHA1withDSA");
                    }
                }
                IBMJCE4758.this.put("Cipher.DES/CBC/NoPadding", "com.ibm.crypto.hdwrCCA.provider.DCNP");
                IBMJCE4758.this.put("Cipher.TripleDES/CBC/NoPadding", "com.ibm.crypto.hdwrCCA.provider.TDCNP");
                IBMJCE4758.this.put("Alg.Alias.Cipher.DESede/CBC/NoPadding", "TripleDES/CBC/NoPadding");
                IBMJCE4758.this.put("Cipher.AES", "com.ibm.crypto.hdwrCCA.provider.AESCipher");
                IBMJCE4758.this.put("Cipher.AES/CBC/PKCS5Padding", "com.ibm.crypto.hdwrCCA.provider.AESCBCPKCS5Padding");
                IBMJCE4758.this.put("Cipher.AES/ECB/PKCS5Padding", "com.ibm.crypto.hdwrCCA.provider.AESECBPKCS5Padding");
                IBMJCE4758.this.put("Cipher.AES/CBC/NoPadding", "com.ibm.crypto.hdwrCCA.provider.AESCBCNoPadding");
                IBMJCE4758.this.put("Cipher.AES/ECB/NoPadding", "com.ibm.crypto.hdwrCCA.provider.AESECBNoPadding");
                IBMJCE4758.this.put("Cipher.DES", "com.ibm.crypto.hdwrCCA.provider.DESCipher");
                IBMJCE4758.this.put("Cipher.DESede", "com.ibm.crypto.hdwrCCA.provider.DESedeCipher");
                IBMJCE4758.this.put("Alg.Alias.Cipher.TripleDES", "DESede");
                IBMJCE4758.this.put("Alg.Alias.Cipher.3DES", "DESede");
                IBMJCE4758.this.put("Cipher.PBEWithMD2AndDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithMD2AndDESCipher");
                IBMJCE4758.this.put("Cipher.PBEWithMD2AndTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithMD2AndTripleDESCipher");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithMD2And3DES", "PBEWithMD2AndTripleDES");
                IBMJCE4758.this.put("Cipher.PBEWithMD5AndDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithMD5AndDESCipher");
                IBMJCE4758.this.put("Cipher.PBEWithMD5AndTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithMD5AndTripleDESCipher");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithMD5And3DES", "PBEWithMD5AndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithMD5AndDESede", "PBEWithMD5AndTripleDES");
                IBMJCE4758.this.put("Cipher.PBEWithSHA1AndDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithSHA1AndDESCipher");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHAAndDES", "PBEWithSHA1AndDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA-1AndDES", "PBEWithSHA1AndDES");
                IBMJCE4758.this.put("Cipher.PBEWithSHA1AndTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithSHA1AndTripleDESCipher");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHAAndTripleDES", "PBEWithSHA1AndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA-1AndTripleDES", "PBEWithSHA1AndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA1And3DES", "PBEWithSHA1AndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHAAnd3DES", "PBEWithSHA1AndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA-1And3DES", "PBEWithSHA1AndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA1AndDESede", "PBEWithSHA1AndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHAAndDESede", "PBEWithSHA1AndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA-1AndDESede", "PBEWithSHA1AndTripleDES");
                IBMJCE4758.this.put("Cipher.RSA", "com.ibm.crypto.hdwrCCA.provider.RSA");
                IBMJCE4758.this.put("Cipher.RSAforSSL", "com.ibm.crypto.hdwrCCA.provider.RSA");
                IBMJCE4758.this.put("Cipher.RSA/ECB/PKCS1Padding", "com.ibm.crypto.hdwrCCA.provider.RSA");
                IBMJCE4758.this.put("Cipher.RSA/SSL/PKCS1Padding", "com.ibm.crypto.hdwrCCA.provider.RSA");
                IBMJCE4758.this.put("Cipher.PBEWithSHAAnd2KeyTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithSHAAnd2KeyTripleDESCipher");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA1And2KeyTripleDES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA-1And2KeyTripleDES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHAAnd2Key3DES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA1And2Key3DES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA-1And2Key3DES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHAAnd2KeyDESede", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA1And2KeyDESede", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA-1And2KeyDESede", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Cipher.PBEWithSHAAnd3KeyTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEWithSHAAnd3KeyTripleDESCipher");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA1And3KeyTripleDES", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA-1And3KeyTripleDES", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHAAnd3Key3DES", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA1And3Key3DES", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA-1And3Key3DES", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHAAnd3KeyDESede", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA1And3KeyDESede", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.Cipher.PBEWithSHA-1And3KeyDESede", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("KeyGenerator.DES", "com.ibm.crypto.hdwrCCA.provider.DESKeyGenerator");
                IBMJCE4758.this.put("KeyGenerator.DESede", "com.ibm.crypto.hdwrCCA.provider.DESedeKeyGenerator");
                IBMJCE4758.this.put("Alg.Alias.KeyGenerator.TripleDES", "DESede");
                IBMJCE4758.this.put("Alg.Alias.KeyGenerator.3DES", "DESede");
                IBMJCE4758.this.put("KeyGenerator.AES", "com.ibm.crypto.hdwrCCA.provider.AESKeyGenerator");
                IBMJCE4758.this.put("KeyGenerator.HmacMD2", "com.ibm.crypto.hdwrCCA.provider.HmacMD2KeyGenerator");
                IBMJCE4758.this.put("Alg.Alias.KeyGenerator.HMACwithMD2", "HmacMD2");
                IBMJCE4758.this.put("KeyGenerator.HmacMD5", "com.ibm.crypto.hdwrCCA.provider.HmacMD5KeyGenerator");
                IBMJCE4758.this.put("Alg.Alias.KeyGenerator.HMACwithMD5", "HmacMD5");
                IBMJCE4758.this.put("KeyGenerator.HmacSHA1", "com.ibm.crypto.hdwrCCA.provider.HmacSHA1KeyGenerator");
                IBMJCE4758.this.put("Alg.Alias.KeyGenerator.HMACwithSHA1", "HmacSHA1");
                IBMJCE4758.this.put("KeyPairGenerator.RSA", "com.ibm.crypto.hdwrCCA.provider.RSAKeyPairGenerator");
                IBMJCE4758.this.put("Alg.Alias.KeyPairGenerator.OID.1.2.5.8.1.1", "RSA");
                IBMJCE4758.this.put("Alg.Alias.KeyPairGenerator.1.2.5.8.1.1", "RSA");
                hwprof;
                if (!HardwareProfile.getIsCryptoAssistPresent()) {
                    hwprof;
                    if (!HardwareProfile.getIsPCIXCCPresent()) {
                        IBMJCE4758.this.put("KeyPairGenerator.DSA", "com.ibm.crypto.hdwrCCA.provider.DSAKeyPairGenerator");
                        IBMJCE4758.this.put("Alg.Alias.KeyPairGenerator.OID.1.2.840.10040.4.1", "DSA");
                        IBMJCE4758.this.put("Alg.Alias.KeyPairGenerator.1.2.840.10040.4.1", "DSA");
                        IBMJCE4758.this.put("Alg.Alias.KeyPairGenerator.OID.1.3.14.3.2.12", "DSA");
                        IBMJCE4758.this.put("Alg.Alias.KeyPairGenerator.1.3.14.3.2.12", "DSA");
                    }
                }
                IBMJCE4758.this.put("MessageDigest.MD5", "com.ibm.crypto.hdwrCCA.provider.MD5");
                IBMJCE4758.this.put("MessageDigest.SHA", "com.ibm.crypto.hdwrCCA.provider.SHA");
                IBMJCE4758.this.put("Alg.Alias.MessageDigest.SHA-1", "SHA");
                IBMJCE4758.this.put("Alg.Alias.MessageDigest.SHA1", "SHA");
                IBMJCE4758.this.put("MessageDigest.MD2", "com.ibm.crypto.hdwrCCA.provider.MD2");
                hwprof;
                if (!HardwareProfile.getIsCryptoAssistPresent()) {
                    hwprof;
                    if (!HardwareProfile.getIsPCIXCCPresent()) {
                        IBMJCE4758.this.put("AlgorithmParameterGenerator.DSA", "com.ibm.crypto.hdwrCCA.provider.DSAParameterGenerator");
                    }
                }
                IBMJCE4758.this.put("AlgorithmParameters.DES", "com.ibm.crypto.hdwrCCA.provider.DESParameters");
                IBMJCE4758.this.put("AlgorithmParameters.DESede", "com.ibm.crypto.hdwrCCA.provider.DESedeParameters");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.TripleDES", "DESede");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.3DES", "DESede");
                IBMJCE4758.this.put("AlgorithmParameters.AES", "com.ibm.crypto.hdwrCCA.provider.AESParameters");
                IBMJCE4758.this.put("AlgorithmParameters.PBE", "com.ibm.crypto.hdwrCCA.provider.PBEParameters");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithMD2AndDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithMD2AndTripleDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithMD2And3DES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithMD2AndDESede", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithMD5AndDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithMD5AndTripleDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithMD5And3DES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithMD5AndDESede", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHAAndDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA1AndDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA-1AndDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHAAndTripleDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA1AndTripleDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA-1AndTripleDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHAAnd3DES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA1And3DES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA-1And3DES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHAAndDESede", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA1AndDESede", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA-1AndDESede", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHAAnd2KeyTripleDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA1And2KeyTripleDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA-1And2KeyTripleDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHAAnd2Key3DES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA1And2Key3DES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA-1And2Key3DES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHAAnd2KeyDESede", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA1And2KeyDESede", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA-1And2KeyDESede", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHAAnd3KeyTripleDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA1And3KeyTripleDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA-1And3KeyTripleDES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHAAnd3Key3DES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA1And3Key3DES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA-1And3Key3DES", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHAAnd3KeyDESede", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA1And3KeyDESede", "PBE");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PBEWithSHA-1And3KeyDESede", "PBE");
                IBMJCE4758.this.put("AlgorithmParameters.PBM", "com.ibm.crypto.hdwrCCA.provider.PBMParameters");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.1.2.840.113533.7.66.13", "PBM");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.OID.1.2.840.113533.7.66.13", "PBM");
                IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.PasswordBasedMac", "PBM");
                hwprof;
                if (!HardwareProfile.getIsCryptoAssistPresent()) {
                    hwprof;
                    if (!HardwareProfile.getIsPCIXCCPresent()) {
                        IBMJCE4758.this.put("AlgorithmParameters.DSA", "com.ibm.crypto.hdwrCCA.provider.DSAParameters");
                        IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.1.3.14.3.2.12", "DSA");
                        IBMJCE4758.this.put("Alg.Alias.AlgorithmParameters.1.2.840.10040.4.1", "DSA");
                    }
                }
                IBMJCE4758.this.put("KeyFactory.RSA", "com.ibm.crypto.hdwrCCA.provider.RSAKeyFactory");
                IBMJCE4758.this.put("Alg.Alias.KeyFactory.OID.1.2.5.8.1.1", "RSA");
                IBMJCE4758.this.put("Alg.Alias.KeyFactory.1.2.5.8.1.1", "RSA");
                IBMJCE4758.this.put("Alg.Alias.KeyFactory.OID.1.2.840.113549.1.1.1", "RSA");
                IBMJCE4758.this.put("Alg.Alias.KeyFactory.1.2.840.113549.1.1.1", "RSA");
                hwprof;
                if (!HardwareProfile.getIsCryptoAssistPresent()) {
                    hwprof;
                    if (!HardwareProfile.getIsPCIXCCPresent()) {
                        IBMJCE4758.this.put("KeyFactory.DSA", "com.ibm.crypto.hdwrCCA.provider.DSAKeyFactory");
                        IBMJCE4758.this.put("Alg.Alias.KeyFactory.OID.1.3.14.3.2.12", "DSA");
                        IBMJCE4758.this.put("Alg.Alias.KeyFactory.1.3.14.3.2.12", "DSA");
                        IBMJCE4758.this.put("Alg.Alias.KeyFactory.OID.1.2.840.10040.4.1", "DSA");
                        IBMJCE4758.this.put("Alg.Alias.KeyFactory.1.2.840.10040.4.1", "DSA");
                    }
                }
                IBMJCE4758.this.put("SecretKeyFactory.DES", "com.ibm.crypto.hdwrCCA.provider.DESKeyFactory");
                IBMJCE4758.this.put("SecretKeyFactory.DESede", "com.ibm.crypto.hdwrCCA.provider.DESedeKeyFactory");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.TripleDES", "DESede");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.3DES", "DESede");
                IBMJCE4758.this.put("SecretKeyFactory.AES", "com.ibm.crypto.hdwrCCA.provider.AESKeyFactory");
                IBMJCE4758.this.put("SecretKeyFactory.PBEWithMD2AndDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory");
                IBMJCE4758.this.put("SecretKeyFactory.PBEWithMD5AndDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory");
                IBMJCE4758.this.put("SecretKeyFactory.PBEWithSHAAndDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1AndDES", "PBEWithSHAAndDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA-1AndDES", "PBEWithSHAAndDES");
                IBMJCE4758.this.put("SecretKeyFactory.PBEWithSHAAndTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1AndTripleDES", "PBEWithSHAAndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA-1AndTripleDES", "PBEWithSHAAndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHAAnd3DES", "PBEWithSHAAndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1And3DES", "PBEWithSHAAndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA-1And3DES", "PBEWithSHAAndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHAAndDESede", "PBEWithSHAAndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1AndDESede", "PBEWithSHAAndTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA-1AndDESede", "PBEWithSHAAndTripleDES");
                IBMJCE4758.this.put("SecretKeyFactory.PBEWithSHAAnd2KeyTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHAAnd2Key3DES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHAAnd2KeyDESede", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1And2KeyTripleDES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1And2Key3DES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1And2KeyDESede", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA-1And2KeyTripleDES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA-1And2Key3DES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA-1And2KeyDESede", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("SecretKeyFactory.PBEWithMD2AndTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithMD2AndDESede", "PBEWithMD2AndTripleDES");
                IBMJCE4758.this.put("SecretKeyFactory.PBEWithMD5AndTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithMD5AndDESede", "PBEWithMD5AndTripleDES");
                IBMJCE4758.this.put("SecretKeyFactory.PBEWithSHA1AndTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1AndDESede", "PBEWithSHA1AndTripleDES");
                IBMJCE4758.this.put("SecretKeyFactory.PBEWithSHAAnd2KeyTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1And2KeyTripleDES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA-1And2KeyTripleDES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHAAnd2Key3DES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1And2Key3DES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA-1And2Key3DES", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHAAnd2KeyDESede", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1And2KeyDESede", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA-1And2KeyDESede", "PBEWithSHAAnd2KeyTripleDES");
                IBMJCE4758.this.put("SecretKeyFactory.PBEWithSHAAnd3KeyTripleDES", "com.ibm.crypto.hdwrCCA.provider.PBEKeyFactory");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHAAnd3Key3DES", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHAAnd3KeyDESede", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1And3KeyTripleDES", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1And3Key3DES", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1And3KeyDESede", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1And3KeyTripleDES", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1And3Key3DES", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1And3KeyDESede", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1And3KeyTripleDES", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA-1And3KeyTripleDES", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA-1And3Key3DES", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA-1And3KeyDESede", "PBEWithSHAAnd3KeyTripleDES");
                IBMJCE4758.this.put("SecretKeyFactory.PKCS5Key", "com.ibm.crypto.hdwrCCA.provider.PKCS5KeyFactory");
                IBMJCE4758.this.put("SecretKeyFactory.PBKDF1", "com.ibm.crypto.hdwrCCA.provider.PKCS5DerivedKeyFactory");
                IBMJCE4758.this.put("SecretKeyFactory.PBKDF2", "com.ibm.crypto.hdwrCCA.provider.PKCS5DerivedKeyFactory");
                IBMJCE4758.this.put("Mac.HmacMD2", "com.ibm.crypto.hdwrCCA.provider.HmacMD2");
                IBMJCE4758.this.put("Alg.Alias.Mac.HMACwithMD2", "HmacMD2");
                IBMJCE4758.this.put("Mac.HmacMD5", "com.ibm.crypto.hdwrCCA.provider.HmacMD5");
                IBMJCE4758.this.put("Alg.Alias.Mac.HMACwithMD5", "HmacMD5");
                IBMJCE4758.this.put("Mac.HmacSHA1", "com.ibm.crypto.hdwrCCA.provider.HmacSHA1");
                IBMJCE4758.this.put("Alg.Alias.Mac.HMACwithSHA1", "HmacSHA1");
                IBMJCE4758.this.put("Mac.PBM", "com.ibm.crypto.hdwrCCA.provider.PBM");
                IBMJCE4758.this.put("Alg.Alias.Mac.1.2.840.113533.7.66.13", "PBM");
                IBMJCE4758.this.put("Alg.Alias.Mac.OID.1.2.840.113533.7.66.13", "PBM");
                IBMJCE4758.this.put("Alg.Alias.Mac.PasswordBasedMac", "PBM");
                IBMJCE4758.this.put("CertificateFactory.X509", "com.ibm.crypto.hdwrCCA.provider.X509Factory");
                IBMJCE4758.this.put("Alg.Alias.CertificateFactory.X.509", "X509");
                IBMJCE4758.this.put("KeyStore.JCE4758KS", "com.ibm.crypto.hdwrCCA.provider.Jce4758KeyStore");
                IBMJCE4758.this.put("KeyStore.JCA4758KS", "com.ibm.crypto.hdwrCCA.provider.Jca4758KeyStore");
                IBMJCE4758.this.put("KeyStore.JCE4758RACFKS", "com.ibm.crypto.hdwrCCA.provider.JceRACFKeyStore");
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "IBMJCE4758", null);
                }
                return null;
            }
        });
    }

    static final void verifyJceJar() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC | 0x8000L, className, "verifyJceJar");
        }
        if (verifiedJce) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC | 0x8000L, className, "verifyJceJar_1");
            }
            return;
        }
        String javaVersion = System.getProperty("java.version");
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC | 0x8000L, className, "***check java version", ".");
        }
        if (javaVersion.compareTo("1.4") >= 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC | 0x8000L, className, "javaVersion > 1.4", ".");
            }
            verifiedJce = true;
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC | 0x8000L, className, "verifyJceJar_3");
            }
            return;
        }
        IBMJCE4758.doVerifyJceJar();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC | 0x8000L, className, "verifyJceJar_2");
        }
    }

    private static final synchronized void doVerifyJceJar() {
        JarFile jf;
        if (debug != null) {
            debug.entry(40960L, className, "doVerifyJceJar");
        }
        if (verifiedJce) {
            if (debug != null) {
                debug.exit(40960L, className, "doVerifyJceJar_1");
            }
            return;
        }
        URL jceJarURL = null;
        try {
            Class<IBMJCE4758> c = IBMJCE4758.class;
            final ClassLoader cl = c.getClassLoader();
            URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return cl.getResource("javax/crypto/Cipher.class");
                }
            });
            if (url == null) {
                if (debug != null) {
                    debug.text(40960L, className, "doVerifyJceJar", "Cannot get the JCE framework URL. Check that IBMJCE4758 can read the JCE framework");
                }
                throw new SecurityException("Cannot get the JCE framework URL. Check that IBMJCE4758 can read the JCE framework");
            }
            int bang = IBMJCE4758.indexOfBang(url.toString());
            if (bang == -1) {
                if (debug != null) {
                    debug.text(40960L, className, "doVerifyJceJar", "The JCE framework is invalid");
                }
                throw new SecurityException("The JCE framework is invalid");
            }
            jceJarURL = new URL(url.toString().substring(0, bang + 1));
            int beginIndex = 4;
            URL jceURL = new URL(url.toString().substring(beginIndex, bang - 1));
            if (!jceURL.getProtocol().equalsIgnoreCase("file")) {
                if (debug != null) {
                    debug.text(40960L, className, "doVerifyJceJar", "JCE should be deployed as an installed extension");
                }
                throw new SecurityException("JCE should be deployed as an installed extension");
            }
        }
        catch (IOException ioe) {
            if (debug != null) {
                debug.exception(40960L, className, "doVerifyJceJar", ioe);
            }
            throw new SecurityException("The provider IBMJCE4758 cannot authenticate JCE framework" + ioe);
        }
        try {
            final URL url = jceJarURL;
            jf = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ((JarURLConnection)url.openConnection()).getJarFile();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            if (debug != null) {
                debug.exception(40960L, className, "doVerifyJceJar", pae);
            }
            throw new SecurityException("Cannot authenticate JCE framework " + pae);
        }
        try {
            IBMJCE4758.verifySingleJarFile(jf);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(40960L, className, "doVerifyJceJar", e);
            }
            throw new SecurityException("Cannot authenticate JCE framework " + e);
        }
        verifiedJce = true;
        if (debug != null) {
            debug.exit(40960L, className, "doVerifyJceJar");
        }
    }

    private static void verifySingleJarFile(JarFile jf) throws IOException, CertificateException {
        Vector<JarEntry> entriesVec = new Vector<JarEntry>();
        byte[] buffer = new byte[8192];
        Enumeration<JarEntry> entries = jf.entries();
        if (debug != null) {
            debug.entry(40960L, (Object)className, "verifySingleJarFile", jf);
        }
        while (entries.hasMoreElements()) {
            int n;
            JarEntry je = entries.nextElement();
            entriesVec.addElement(je);
            InputStream is = jf.getInputStream(je);
            while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            }
            is.close();
        }
        Manifest man = jf.getManifest();
        if (man == null) {
            if (debug != null) {
                debug.text(40960L, className, "verifySingleJarFile", "The JCE framework is not signed");
            }
            throw new SecurityException("The JCE framework is not signed");
        }
        trustedCaCerts = IBMJCE4758.setupTrustedCaCerts();
        Vector verifiedRootCache = new Vector(2);
        Enumeration e = entriesVec.elements();
        while (e.hasMoreElements()) {
            JarEntry je = (JarEntry)e.nextElement();
            if (je.isDirectory()) continue;
            Certificate[] certs = je.getCertificates();
            if (certs == null || certs.length == 0) {
                if (je.getName().startsWith("META-INF")) continue;
                if (debug != null) {
                    debug.text(40960L, className, "verifySingleJarFile", "The JCE framework has unsigned class files.");
                }
                throw new SecurityException("The JCE framework has unsigned class files.");
            }
            Certificate[] chainRoots = IBMJCE4758.getChainRoots(certs);
            boolean signedAsExpected = false;
            for (int i = 0; i < chainRoots.length; ++i) {
                if (verifiedRootCache.contains((X509Certificate)chainRoots[i])) {
                    signedAsExpected = true;
                    break;
                }
                if (!IBMJCE4758.isTrusted((X509Certificate)chainRoots[i])) continue;
                signedAsExpected = true;
                break;
            }
            if (signedAsExpected) continue;
            if (debug != null) {
                debug.text(40960L, className, "verifySingleJarFile", "JCE framework is not signed by a trusted signer");
            }
            throw new SecurityException("JCE framework is not signed by a trusted signer");
        }
        if (debug != null) {
            debug.exit(40960L, className, "verifySingleJarFile");
        }
    }

    private static boolean isTrusted(X509Certificate cert) {
        int i;
        if (debug != null) {
            debug.entry(40960L, (Object)className, "isTrusted", cert);
        }
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!cert.getSubjectDN().equals(trustedCaCerts[i].getSubjectDN()) || !cert.equals(trustedCaCerts[i])) continue;
            if (debug != null) {
                debug.exit(40960L, (Object)className, "isTrusted_1", true);
            }
            return true;
        }
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!cert.getIssuerDN().equals(trustedCaCerts[i].getSubjectDN())) continue;
            try {
                cert.verify(trustedCaCerts[i].getPublicKey());
                if (debug != null) {
                    debug.exit(40960L, (Object)className, "isTrusted_2", true);
                }
                return true;
            }
            catch (Exception e) {
                if (debug == null) continue;
                debug.exception(40960L, className, "isTrusted", e);
            }
        }
        if (debug != null) {
            debug.exit(40960L, (Object)className, "isTrusted_3", false);
        }
        return false;
    }

    private static Certificate[] getChainRoots(Certificate[] certs) {
        Vector<Certificate> result = new Vector<Certificate>(3);
        if (debug != null) {
            debug.entry(40960L, (Object)className, "getChainRoots", certs);
        }
        for (int i = 0; i < certs.length - 1; ++i) {
            if (((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN())) continue;
            result.addElement(certs[i]);
        }
        result.addElement(certs[certs.length - 1]);
        Object[] ret = new Certificate[result.size()];
        result.copyInto(ret);
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getChainRoots", ret);
        }
        return ret;
    }

    private static X509Certificate[] setupTrustedCaCerts() throws IOException, CertificateException {
        if (debug != null) {
            debug.entry(40960L, className, "setupTrustedCaCerts");
        }
        int numberOfTrustedCas = bytesOfTrustedCaCerts.length;
        X509Certificate[] certs = new X509Certificate[numberOfTrustedCas];
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < numberOfTrustedCas; ++i) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(bytesOfTrustedCaCerts[i]);
            certs[i] = (X509Certificate)cf.generateCertificate(inStream);
            inStream.close();
        }
        if (debug != null) {
            debug.exit(40960L, (Object)className, "setupTrustedCaCerts", certs);
        }
        return certs;
    }

    private static int indexOfBang(String spec) {
        int indexOfBang;
        if (debug != null) {
            debug.entry(40960L, (Object)className, "indexOfBang", spec);
        }
        if ((indexOfBang = spec.lastIndexOf(".jar!/")) > 0) {
            if (debug != null) {
                debug.exit(40960L, (Object)className, "indexOfBang_1", indexOfBang + 5);
            }
            return indexOfBang + 5;
        }
        if (debug != null) {
            debug.exit(40960L, (Object)className, "indexOfBang_1", -1);
        }
        return -1;
    }

    static final boolean verifySelfIntegrity(Class c) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC | 0x8000L, (Object)className, "verifySelfIntegrity", c);
        }
        if (verifiedSelfIntegrity) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC | 0x8000L, (Object)className, "verifySelfIntegrity_1", true);
            }
            return true;
        }
        boolean retValue = IBMJCE4758.doSelfVerification(c);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC | 0x8000L, (Object)className, "verifySelfIntegrity_2", retValue);
        }
        return retValue;
    }

    private static final synchronized boolean doSelfVerification(Class c) {
        Class cc;
        URL url;
        if (debug != null) {
            debug.entry(40960L, (Object)className, "doSelfVerification", c);
        }
        if (verifiedSelfIntegrity) {
            if (debug != null) {
                debug.exit(40960L, (Object)className, "doSelfVerification_1", true);
            }
            return true;
        }
        if (trustedCaCerts == null) {
            try {
                trustedCaCerts = IBMJCE4758.setupTrustedCaCerts();
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exit(40960L, (Object)className, "doSelfVerification_2", true);
                }
                return false;
            }
        }
        if ((url = (URL)AccessController.doPrivileged(new PrivilegedAction(cc = c){
            final /* synthetic */ Class val$cc;
            {
                this.val$cc = clazz;
            }

            public Object run() {
                CodeSource s1 = this.val$cc.getProtectionDomain().getCodeSource();
                return s1.getLocation();
            }
        })) == null) {
            if (debug != null) {
                debug.exit(40960L, (Object)className, "doSelfVerification_2", false);
            }
            return false;
        }
        JarVerifier jv = new JarVerifier(url);
        try {
            jv.verify(trustedCaCerts);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(40960L, className, "doSelfVerification", e);
                debug.exit(40960L, (Object)className, "doSelfVerification_3", false);
            }
            return false;
        }
        verifiedSelfIntegrity = true;
        if (debug != null) {
            debug.exit(40960L, (Object)className, "doSelfVerification_4", true);
        }
        return true;
    }

    private static Certificate[] getSignerCertificates(Class c) {
        final Class cc = c;
        if (debug != null) {
            debug.entry(40960L, (Object)className, "getSignedCertificates", c);
        }
        Certificate[] certs = (Certificate[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource s1 = cc.getProtectionDomain().getCodeSource();
                return s1.getCertificates();
            }
        });
        if (debug != null) {
            debug.exit(40960L, (Object)className, "getSignedCertificates", certs);
        }
        return certs;
    }
}

