/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

public final class HmacMD2
extends MacSpi
implements Cloneable {
    private MessageDigest md2;
    private byte[] k_ipad;
    private byte[] k_opad;
    private boolean first = true;
    private static final int MD2_LENGTH = 16;
    private static final int MD2_BLOCK_LENGTH = 16;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.HmacMD2";

    public HmacMD2() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "HmacHD2");
        }
        try {
            this.md2 = Security.getProvider("IBMJCECCA") == null ? MessageDigest.getInstance("MD2", "IBMJCE4758") : MessageDigest.getInstance("MD2", "IBMJCECCA");
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "HmacHD2", e);
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchProviderException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "HmacHD2", e);
            }
            throw new RuntimeException(e.getMessage());
        }
        this.k_ipad = new byte[16];
        this.k_opad = new byte[16];
        IBMJCECCA.verifyJceJar();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "HmacHD2");
        }
    }

    @Override
    protected int engineGetMacLength() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetMacLength");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetMacLength", this.md2.getDigestLength());
        }
        return this.md2.getDigestLength();
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int i;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit", key, params);
        }
        if (key == null) {
            InvalidKeyException ike = new InvalidKeyException("Key is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "engineInit");
            }
            throw ike;
        }
        if (!(key instanceof SecretKey)) {
            InvalidKeyException ike = new InvalidKeyException("Key is not an instance of SecretKey");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "engineInit");
            }
            throw ike;
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            InvalidKeyException ike = new InvalidKeyException("Key must be a RAW format SecretKey");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "engineInit");
            }
            throw ike;
        }
        byte[] secret = key.getEncoded();
        if (secret == null || secret.length == 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Missing key data");
            }
            throw new InvalidKeyException("Missing key data");
        }
        if (secret.length > 16) {
            secret = this.md2.digest(secret);
        }
        byte[] k = null;
        if (secret.length == 16) {
            k = secret;
        } else {
            k = new byte[16];
            System.arraycopy(secret, 0, k, 0, secret.length);
            for (i = secret.length; i < 16; ++i) {
                k[i] = 0;
            }
        }
        for (i = 0; i < 16; ++i) {
            this.k_ipad[i] = (byte)(k[i] ^ 0x36);
            this.k_opad[i] = (byte)(k[i] ^ 0x5C);
        }
        for (i = 0; i < secret.length; ++i) {
            secret[i] = 0;
        }
        if (k != secret) {
            for (i = 0; i < k.length; ++i) {
                k[i] = 0;
            }
        }
        secret = null;
        k = null;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineUpdate(byte input) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", new Byte(input));
        }
        if (this.first) {
            this.md2.update(this.k_ipad);
            this.first = false;
        }
        this.md2.update(input);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(offset), new Integer(len)};
            debug.entry(Debug.TYPE_FINE, className, "engineUpdate");
        }
        if (this.first) {
            this.md2.update(this.k_ipad);
            this.first = false;
        }
        this.md2.update(input, offset, len);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected byte[] engineDoFinal() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineDoFinal");
        }
        if (this.first) {
            this.md2.update(this.k_ipad);
        } else {
            this.first = true;
        }
        byte[] innerDigest = this.md2.digest();
        this.md2.update(this.k_opad);
        byte[] result = this.md2.digest(innerDigest);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDoFinal", result);
        }
        return result;
    }

    @Override
    protected void engineReset() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineReset");
        }
        this.md2.reset();
        this.first = true;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineReset");
        }
    }

    @Override
    public Object clone() {
        HmacMD2 that = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "clone");
        }
        try {
            that = (HmacMD2)super.clone();
            that.md2 = (MessageDigest)this.md2.clone();
            that.k_ipad = (byte[])this.k_ipad.clone();
            that.k_opad = (byte[])this.k_opad.clone();
            that.first = this.first;
            return that;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "clone", that);
            }
            return that;
        }
    }
}

