/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.misc.CharacterEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

class HexDumpEncoder
extends CharacterEncoder {
    private static final char[] ASCII_MAP = HexDumpEncoder.buildASCIIMap();
    private static final char[] EBCDIC_MAP = HexDumpEncoder.buildEBCDICMap();
    private int offset;
    private int thisLineLength;
    private int currentByte;
    private byte[] thisLine = new byte[16];

    HexDumpEncoder() {
    }

    private static char[] buildASCIIMap() {
        char[] map = new char[256];
        Arrays.fill(map, '.');
        int digitIndex = 48;
        for (char character : "0123456789".toCharArray()) {
            map[digitIndex++] = character;
        }
        int upperCaseIndex = 65;
        for (char character : "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray()) {
            map[upperCaseIndex++] = character;
        }
        int lowerCaseIndex = 97;
        for (char character : "abcdefghijklmnopqrstuvwxyz".toCharArray()) {
            map[lowerCaseIndex++] = character;
        }
        return map;
    }

    private static char[] buildEBCDICMap() {
        char[] map = new char[256];
        Arrays.fill(map, '.');
        int segmentIndex = 129;
        for (char character : "abcdefghi".toCharArray()) {
            map[segmentIndex++] = character;
        }
        segmentIndex = 145;
        for (char character : "jklmnopqr".toCharArray()) {
            map[segmentIndex++] = character;
        }
        segmentIndex = 162;
        for (char character : "stuvwxyz".toCharArray()) {
            map[segmentIndex++] = character;
        }
        segmentIndex = 193;
        for (char character : "ABCDEFGHI".toCharArray()) {
            map[segmentIndex++] = character;
        }
        segmentIndex = 209;
        for (char character : "JKLMNOPQR".toCharArray()) {
            map[segmentIndex++] = character;
        }
        segmentIndex = 226;
        for (char character : "STUVWXYZ".toCharArray()) {
            map[segmentIndex++] = character;
        }
        segmentIndex = 240;
        for (char character : "0123456789".toCharArray()) {
            map[segmentIndex++] = character;
        }
        return map;
    }

    private static void hexDigit(OutputStream o, byte x) {
        int workarea = 0;
        try {
            workarea = x >> 4;
            o.write(HexDumpEncoder.trimIt(Integer.toHexString(workarea)).getBytes(StandardCharsets.ISO_8859_1));
            workarea = x & 0xF;
            o.write(HexDumpEncoder.trimIt(Integer.toHexString(workarea)).getBytes(StandardCharsets.ISO_8859_1));
        }
        catch (Exception e) {
            System.out.println("Unable to write to internal output stream: " + e);
        }
    }

    private static String trimIt(String origResult) {
        if (origResult == null) {
            return "00";
        }
        int currLength = origResult.length();
        if (currLength == 0) {
            return "00";
        }
        if (currLength <= 2) {
            return origResult;
        }
        return origResult.substring(currLength - 1);
    }

    protected int bytesPerAtom() {
        return 1;
    }

    protected int bytesPerLine() {
        return 16;
    }

    protected void encodeBufferPrefix(OutputStream o) throws IOException {
        this.offset = 0;
        super.encodeBufferPrefix(o);
    }

    protected void encodeLinePrefix(OutputStream o, int len) throws IOException {
        HexDumpEncoder.hexDigit(o, (byte)(this.offset >>> 8 & 0xFF));
        HexDumpEncoder.hexDigit(o, (byte)(this.offset & 0xFF));
        o.write(58);
        o.write(32);
        this.currentByte = 0;
        this.thisLineLength = len;
    }

    protected void encodeAtom(OutputStream o, byte[] buf, int off, int len) throws IOException {
        this.thisLine[this.currentByte] = buf[off];
        HexDumpEncoder.hexDigit(o, buf[off]);
        o.write(32);
        ++this.currentByte;
        if (this.currentByte == 8) {
            o.write(32);
        }
    }

    protected void encodeLineSuffix(OutputStream o) throws IOException {
        int i;
        if (this.thisLineLength < 16) {
            for (i = this.thisLineLength; i < 16; ++i) {
                o.write(32);
                o.write(32);
                o.write(32);
                if (i != 7) continue;
                o.write(32);
            }
        }
        o.write(32);
        for (i = 0; i < this.thisLineLength; ++i) {
            o.write(ASCII_MAP[this.thisLine[i] & 0xFF]);
        }
        if (this.thisLineLength < 16) {
            for (i = this.thisLineLength; i < 16; ++i) {
                o.write(32);
            }
        }
        o.write(32);
        o.write(32);
        for (i = 0; i < this.thisLineLength; ++i) {
            o.write(EBCDIC_MAP[this.thisLine[i] & 0xFF]);
        }
        o.write(10);
        this.offset += this.thisLineLength;
    }
}

