/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HMACKey;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.KeyLabelKeySpec;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;

class HMACKeyFactory
extends SecretKeyFactorySpi {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.HMACKeyFactory";
    private final String algorithm;

    public HMACKeyFactory(String algorithm) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "HMACKeyFactory");
        }
        if (!IBMJCECCA.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBMJCECCA provider may have been tampered.");
        }
        this.algorithm = algorithm;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "HMACKeyFactory");
        }
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", keySpec);
        }
        if (keySpec == null || !(keySpec instanceof KeyLabelKeySpec)) {
            InvalidKeySpecException ikse = new InvalidKeySpecException("Inappropriate key specification");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", ikse);
                debug.exit(Debug.TYPE_FINE, className, "engineGenerateSecret");
            }
            throw ikse;
        }
        HMACKey hmacKey = null;
        try {
            String ckdsLabel = ((KeyLabelKeySpec)keySpec).getLabelString();
            hmacKey = HMACKey.newLabelKey(this.algorithm, ckdsLabel);
        }
        catch (InvalidKeyException e) {
            InvalidKeySpecException ikse = new InvalidKeySpecException("Inappropriate key specification", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", ikse);
                debug.exit(Debug.TYPE_FINE, className, "engineGenerateSecret");
            }
            throw ikse;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", hmacKey);
        }
        return hmacKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetKeySpec", key, keySpec);
        }
        UnsupportedOperationException uoe = new UnsupportedOperationException("This method is currently unsupported by this SecretKeyFactory");
        if (debug != null) {
            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", uoe);
            debug.exit(Debug.TYPE_FINE, className, "engineGetKeySpec");
        }
        throw uoe;
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", key);
        }
        UnsupportedOperationException uoe = new UnsupportedOperationException("This method is currently unsupported by this SecretKeyFactory");
        if (debug != null) {
            debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey", uoe);
            debug.exit(Debug.TYPE_FINE, className, "engineTranslateKey");
        }
        throw uoe;
    }
}

