/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.LabelUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyUtils;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.security.InvalidKeyException;
import java.util.Arrays;
import javax.crypto.SecretKey;

public class HMACKey
implements SecretKey {
    private static final long serialVersionUID = -7066594197346167064L;
    private final String algorithm;
    private final String keyType;
    private byte[] ckdsLabel;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.HMACKey";

    private HMACKey(String algorithm, String keyType, byte[] keyLabel) throws InvalidKeyException {
        InvalidKeyException ike;
        if (debug != null) {
            Object[] parms = new Object[]{algorithm, keyType, keyLabel};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "HMACKey", parms);
        }
        if (!"CKDSLabel".equals(keyType)) {
            ike = new InvalidKeyException("Key type must be CKDSLabel.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "HMACKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "HMACKey");
            }
            throw ike;
        }
        if (null == keyLabel || 0 == keyLabel.length) {
            ike = new InvalidKeyException("Key label must not be null or have zero length.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "HMACKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "HMACKey");
            }
            throw ike;
        }
        this.algorithm = algorithm;
        this.keyType = keyType;
        this.ckdsLabel = LabelUtils.padLabel(keyLabel, PlatformUtilities.CHARSET_IBM_1047);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "HMACKey");
        }
    }

    static HMACKey newLabelKey(String algorithm, String label) throws InvalidKeyException {
        return new HMACKey(algorithm, "CKDSLabel", label.getBytes(PlatformUtilities.CHARSET_IBM_1047));
    }

    @Override
    public byte[] getEncoded() {
        byte[] returnValue = null;
        if ("CKDSLabel".equals(this.keyType)) {
            returnValue = (byte[])this.ckdsLabel.clone();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", returnValue);
        }
        return returnValue;
    }

    public String getLabelString() throws InvalidKeyException {
        if (!"CKDSLabel".equals(this.keyType)) {
            InvalidKeyException ike = new InvalidKeyException("Only a CKDSLabel key has a CKDS label.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getLabelString", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "getLabelString");
            }
            throw ike;
        }
        String returnLabel = new String(this.ckdsLabel, PlatformUtilities.CHARSET_IBM_1047);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabelString", returnLabel);
        }
        return returnLabel;
    }

    @Override
    public String getAlgorithm() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getAlgorithm", this.algorithm);
        }
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getFormat", this.keyType);
        }
        return this.keyType;
    }

    public void deleteCKDSEntry() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "deleteCKDSEntry");
        }
        SymmetricKeyUtils.deleteCKDSEntry(this);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "deleteCKDSEntry");
        }
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "hashCode");
        }
        int retval = 0;
        byte[] keyData = this.getEncoded();
        for (int i = 1; i < keyData.length; ++i) {
            retval += keyData[i] * i;
        }
        retval ^= this.algorithm.toUpperCase().hashCode();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "hashCode", retval);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "equals", obj);
        }
        if (this == obj) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals1", true);
            }
            return true;
        }
        if (!(obj instanceof HMACKey)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals2", false);
            }
            return false;
        }
        String thatAlg = ((HMACKey)obj).getAlgorithm();
        if (!thatAlg.equalsIgnoreCase(this.algorithm)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals3", false);
            }
            return false;
        }
        String thatKeyType = ((HMACKey)obj).getFormat();
        if (!thatKeyType.equals(this.keyType)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals5", false);
            }
            return false;
        }
        byte[] thiskeyData = null;
        byte[] thatkeyData = null;
        try {
            thiskeyData = this.getEncoded();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "equals6", e);
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals6", false);
            }
            return false;
        }
        try {
            thatkeyData = ((HMACKey)obj).getEncoded();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "equals7", e);
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals7", false);
            }
            return false;
        }
        boolean ret = Arrays.equals(thiskeyData, thatkeyData);
        Arrays.fill(thiskeyData, (byte)0);
        Arrays.fill(thatkeyData, (byte)0);
        return ret;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINER, (Object)className, "readObject", s);
        }
        s.defaultReadObject();
        if (!"CKDSLabel".equals(this.keyType)) {
            InvalidObjectException ioe = new InvalidObjectException("Key type must be CKDSLabel");
            if (debug != null) {
                debug.exception(Debug.TYPE_FINER, className, "readObject", ioe);
                debug.exit(Debug.TYPE_FINER, className, "readObject");
            }
            throw ioe;
        }
        this.ckdsLabel = (byte[])this.ckdsLabel.clone();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINER, className, "readObject");
        }
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "finalize");
        }
        if (null != this.ckdsLabel) {
            Arrays.fill(this.ckdsLabel, (byte)0);
            this.ckdsLabel = null;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "finalize");
        }
    }
}

