/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECNamedCurve;
import com.ibm.crypto.hdwrCCA.provider.ECParameters;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class ECPublicKey
extends X509Key
implements java.security.interfaces.ECPublicKey,
ECKey,
Serializable {
    static final long serialVersionUID = 2528368728672251115L;
    private ECPoint w;
    private ECParameterSpec parameterSpec;
    private byte[] token;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.ECPublicKey";

    ECPublicKey(byte[] encoded) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "ECPublicKey", (Object)encoded);
        }
        if (encoded == null) {
            InvalidKeyException ike = new InvalidKeyException("The supplied X.509 ASN.1 encoded public key must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPublicKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPublicKey");
            }
            throw ike;
        }
        this.decode(encoded);
        String name = ECNamedCurve.getName(this.parameterSpec);
        if (name == null) {
            InvalidKeyException ike = new InvalidKeyException("The encoded Elliptic Curve domain parameters are not supported");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPublicKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPublicKey");
            }
            throw ike;
        }
        KeyPairUtils utils = new KeyPairUtils();
        utils.initializeEC(ECNamedCurve.getCurveType(name), ECNamedCurve.getKeySize(name), null, null, null);
        this.token = utils.generateToken(this);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "ECPublicKey");
        }
    }

    ECPublicKey(ECPoint w, ECParameterSpec params) throws InvalidKeyException, InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "ECPublicKey", w, params);
        }
        if (w == null) {
            InvalidKeyException ike = new InvalidKeyException("The supplied Elliptic Curve public point must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPublicKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPublicKey");
            }
            throw ike;
        }
        if (params == null) {
            NullPointerException npe = new NullPointerException("The supplied domain parameters must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPublicKey", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPublicKey");
            }
            throw npe;
        }
        this.w = w;
        this.parameterSpec = params;
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(params));
        try {
            this.key = ECParameters.encodePoint(w, params.getCurve());
        }
        catch (IOException e) {
            InvalidKeyException ike = new InvalidKeyException("Unable to encode the Elliptic Curve public point");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPublicKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPublicKey");
            }
            throw ike;
        }
        this.encode();
        String name = ECNamedCurve.getName(params);
        if (name == null) {
            InvalidParameterSpecException ipse = new InvalidParameterSpecException("The specified Elliptic Curve domain parameters are not supported");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPublicKey", ipse);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPublicKey");
            }
            throw ipse;
        }
        KeyPairUtils utils = new KeyPairUtils();
        utils.initializeEC(ECNamedCurve.getCurveType(name), ECNamedCurve.getKeySize(name), null, null, null);
        this.token = utils.generateToken(this);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "ECPublicKey");
        }
    }

    ECPublicKey(byte[] token, ECPoint w, ECParameterSpec params) throws InvalidKeyException, InvalidParameterSpecException {
        if (debug != null) {
            Object[] parms = new Object[]{token, w, params};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "ECPublicKey", parms);
        }
        if (token == null || w == null) {
            InvalidKeyException ike = new InvalidKeyException("The supplied PKA public key token and public point values must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPublicKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPublicKey");
            }
            throw ike;
        }
        if (params == null) {
            NullPointerException npe = new NullPointerException("The supplied domain parameters must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPublicKey", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPublicKey");
            }
            throw npe;
        }
        this.token = token;
        this.w = w;
        this.parameterSpec = params;
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(params));
        try {
            this.key = ECParameters.encodePoint(w, params.getCurve());
        }
        catch (IOException e) {
            InvalidKeyException ike = new InvalidKeyException("Unable to encode the Elliptic Curve public point");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPublicKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPublicKey");
            }
            throw ike;
        }
        this.encode();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "ECPublicKey");
        }
    }

    protected void parseKeyBits() throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "parseKeyBits");
        }
        try {
            AlgorithmParameters parameters = this.algid.getAlgParameters();
            this.parameterSpec = parameters.getParameterSpec(ECParameterSpec.class);
            this.w = ECParameters.decodePoint(this.key, this.parameterSpec.getCurve());
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage(), e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "parseKeyBits", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "parseKeyBits", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "parseKeyBits");
            }
            throw ioe;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "parseKeyBits");
        }
    }

    @Override
    public ECPoint getW() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getW");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getW", this.w);
        }
        return this.w;
    }

    @Override
    public ECParameterSpec getParams() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getParams");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getParams", this.parameterSpec);
        }
        return this.parameterSpec;
    }

    public byte[] getToken() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getToken");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getToken", this.token);
        }
        if (this.token != null) {
            return (byte[])this.token.clone();
        }
        return null;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "toString");
        }
        String provider = new String("IBMJCECCA");
        HexDumpEncoder encoder = new HexDumpEncoder();
        String hexStringKeyToken = encoder.encodeBuffer(this.token);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "toString");
        }
        return provider + " Elliptic Curve public key:\n" + hexStringKeyToken + "\n";
    }
}

