/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes;
import java.security.spec.ECParameterSpec;
import java.security.spec.KeySpec;

public class ECPrivateHWKeySpec
implements KeySpec {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKeySpec";
    private byte[] externalKeyTokenOrLabel = null;
    private ECParameterSpec parameterSpec = null;
    private ECHWKeyAttributes keyAttributes = null;

    public ECPrivateHWKeySpec(byte[] tokenOrLabel, ECParameterSpec spec, byte type) {
        this(tokenOrLabel, spec, type, ECHWKeyAttributes.DEFAULT_USAGE);
    }

    public ECPrivateHWKeySpec(byte[] tokenOrLabel, ECParameterSpec spec, byte type, byte usage) {
        IllegalArgumentException iae;
        NullPointerException npe;
        if (debug != null) {
            Object[] parms = new Object[]{tokenOrLabel, spec, new Byte(type), new Byte(usage)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "ECPrivateHWKeySpec", parms);
        }
        if (tokenOrLabel == null) {
            npe = new NullPointerException("The external token or PKDS label is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKeySpec", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKeySpec");
            }
            throw npe;
        }
        if (spec == null) {
            npe = new NullPointerException("The Elliptic Curve parameter specification is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKeySpec", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKeySpec");
            }
            throw npe;
        }
        if (type != 0 && type != 2) {
            iae = new IllegalArgumentException("Private key type is not valid");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKeySpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKeySpec");
            }
            throw iae;
        }
        if (usage != 3 && usage != 4) {
            iae = new IllegalArgumentException("Private key usage is not valid");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKeySpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKeySpec");
            }
            throw iae;
        }
        if (type == 0 && tokenOrLabel.length > 64) {
            iae = new IllegalArgumentException("PKDS private key must have a PKDS record label of 64 characters or less");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKeySpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKeySpec");
            }
            throw iae;
        }
        this.externalKeyTokenOrLabel = (byte[])tokenOrLabel.clone();
        this.parameterSpec = spec;
        this.keyAttributes = new ECHWKeyAttributes(type, usage);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKeySpec");
        }
    }

    public byte[] getToken() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getToken");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getToken", this.externalKeyTokenOrLabel);
        }
        if (this.externalKeyTokenOrLabel != null) {
            return (byte[])this.externalKeyTokenOrLabel.clone();
        }
        return null;
    }

    public ECHWKeyAttributes getAttributes() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getAttributes");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getAttributes", this.keyAttributes);
        }
        return this.keyAttributes;
    }

    public ECParameterSpec getParams() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getParams");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getParams", this.parameterSpec);
        }
        return this.parameterSpec;
    }
}

