/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes;
import com.ibm.crypto.hdwrCCA.provider.ECKeyFactory;
import com.ibm.crypto.hdwrCCA.provider.ECParameters;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.KeyStoreUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.security.auth.DestroyFailedException;

public final class ECPrivateHWKey
extends PrivateKeyInfo
implements ECPrivateKey,
ECKey,
Serializable {
    static final long serialVersionUID = 3503623093811037403L;
    private boolean hasBeenDestroyed = false;
    private byte[] externalKeyToken = null;
    private byte[] internalKeyTokenOrLabel = null;
    private ECParameterSpec parameterSpec = null;
    private ECHWKeyAttributes keyAttributes = null;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey";

    ECPrivateHWKey(byte[] encoded) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "ECPrivateHWKey", (Object)encoded);
        }
        if (encoded == null) {
            InvalidKeyException ike = new InvalidKeyException("The supplied PKCS#8 DER encoded private key must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
            }
            throw ike;
        }
        try {
            this.decode(encoded);
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.getTag() != 48) {
                IOException ioe = new IOException("Bad Elliptic Curve private key encoding, expected a SEQUENCE tag");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", ioe);
                    debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
                }
                throw ioe;
            }
            DerInputStream derData = derValue.getData();
            int privateKeyVersion = derData.getInteger().intValue();
            if (privateKeyVersion != 1) {
                IOException ioe = new IOException("Bad Elliptic Curve private key version, expected version 1");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", ioe);
                    debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
                }
                throw ioe;
            }
            byte[] privateKeyData = derData.getOctetString();
            BigInteger s = new BigInteger(1, privateKeyData);
            ECKeyFactory keyFactory = new ECKeyFactory();
            ECPrivateHWKey migratedKey = (ECPrivateHWKey)keyFactory.engineGeneratePrivate(new ECPrivateKeySpec(s, this.parameterSpec));
            this.externalKeyToken = migratedKey.getExternalKeyToken();
            this.internalKeyTokenOrLabel = migratedKey.getToken();
            this.keyAttributes = new ECHWKeyAttributes(migratedKey.getType(), migratedKey.getUsage());
            DerValue[] value = new DerValue[]{new DerValue(4, this.internalKeyTokenOrLabel)};
            DerOutputStream out = new DerOutputStream();
            out.putSequence(value);
            this.key = out.toByteArray();
            out.close();
        }
        catch (IOException e) {
            InvalidKeyException ike = new InvalidKeyException("Bad Elliptic Curve private key encoding", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
            }
            throw ike;
        }
        catch (InvalidKeySpecException e) {
            InvalidKeyException ike = new InvalidKeyException("Internal error converting Elliptic Curve software private key", e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
            }
            throw ike;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
        }
    }

    ECPrivateHWKey(byte[] externalTokenOrLabel, ECParameterSpec spec, ECHWKeyAttributes attributes) throws InvalidKeyException, InvalidParameterSpecException {
        if (debug != null) {
            Object[] parms = new Object[]{externalTokenOrLabel, spec, attributes};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "ECPrivateHWKey", parms);
        }
        if (externalTokenOrLabel == null) {
            InvalidKeyException ike = new InvalidKeyException("The supplied external token or PKDS label must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
            }
            throw ike;
        }
        if (spec == null || attributes == null) {
            NullPointerException npe = new NullPointerException("The supplied Elliptic Curve domain parameters and hardware key attributes must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
            }
            throw npe;
        }
        if (attributes.getKeyType() == 2) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", "Key type is CLEAR");
            }
            this.externalKeyToken = (byte[])externalTokenOrLabel.clone();
            KeyPairUtils util = new KeyPairUtils();
            this.internalKeyTokenOrLabel = util.importExternalToken(this.externalKeyToken, KeyPairUtils.KeyPairAlgorithm.EC);
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", "Key type is PKDS");
            }
            this.internalKeyTokenOrLabel = (byte[])externalTokenOrLabel.clone();
        }
        this.parameterSpec = spec;
        this.keyAttributes = new ECHWKeyAttributes(attributes.getKeyType(), attributes.getKeyUsage());
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(spec));
        try {
            DerValue[] value = new DerValue[]{new DerValue(4, this.internalKeyTokenOrLabel)};
            DerOutputStream out = new DerOutputStream();
            out.putSequence(value);
            this.key = out.toByteArray();
            out.close();
        }
        catch (IOException e) {
            InvalidKeyException ike = new InvalidKeyException("Could not DER encode: " + e.getMessage(), e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
            }
            throw ike;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
        }
    }

    ECPrivateHWKey(byte[] externalKeyToken, byte[] internalKeyToken, ECParameterSpec spec, ECHWKeyAttributes attributes) throws InvalidKeyException, InvalidParameterSpecException {
        InvalidKeyException ike;
        if (debug != null) {
            Object[] parms = new Object[]{externalKeyToken, internalKeyToken, spec, attributes};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "ECPrivateHWKey", parms);
        }
        if (externalKeyToken == null || internalKeyToken == null) {
            ike = new InvalidKeyException("The specified PKA private key tokens are not valid");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
            }
            throw ike;
        }
        if (spec == null || attributes == null) {
            NullPointerException npe = new NullPointerException("The supplied Elliptic Curve domain parameters and hardware key attributes must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
            }
            throw npe;
        }
        if (attributes.getKeyType() != 2) {
            ike = new InvalidKeyException("The specified key is not a CLEAR private key");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
            }
            throw ike;
        }
        this.externalKeyToken = (byte[])externalKeyToken.clone();
        this.internalKeyTokenOrLabel = (byte[])internalKeyToken.clone();
        this.parameterSpec = spec;
        this.keyAttributes = new ECHWKeyAttributes(attributes.getKeyType(), attributes.getKeyUsage());
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(spec));
        try {
            DerValue[] value = new DerValue[]{new DerValue(4, this.internalKeyTokenOrLabel)};
            DerOutputStream out = new DerOutputStream();
            out.putSequence(value);
            this.key = out.toByteArray();
            out.close();
        }
        catch (IOException e) {
            InvalidKeyException ike2 = new InvalidKeyException("Could not DER encode: " + e.getMessage(), e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey", ike2);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
            }
            throw ike2;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "ECPrivateHWKey");
        }
    }

    protected void parseKeyBits() throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "parseKeyBits");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "parseKeyBits", ise);
            }
            throw ise;
        }
        try {
            AlgorithmParameters parameters = this.algid.getAlgParameters();
            if (parameters == null) {
                IOException ioe = new IOException("Unable to retrieve the Elliptic Curve domain parameters");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "parseKeyBits", ioe);
                    debug.exit(Debug.TYPE_PUBLIC, className, "parseKeyBits");
                }
                throw ioe;
            }
            this.parameterSpec = parameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage(), e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "parseKeyBits", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "parseKeyBits", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "parseKeyBits");
            }
            throw ioe;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "parseKeyBits");
        }
    }

    public byte[] getToken() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getToken");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getToken", ise);
            }
            throw ise;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getToken", this.internalKeyTokenOrLabel);
        }
        if (this.internalKeyTokenOrLabel != null) {
            return (byte[])this.internalKeyTokenOrLabel.clone();
        }
        return null;
    }

    public String getLabelString() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getLabelString");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getLabelString", ise);
            }
            throw ise;
        }
        if (this.getType() != 0) {
            InvalidKeyException ike = new InvalidKeyException("Key must be of type KeyHWAttributeValues.PKDS.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getLabelString", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "getLabelString");
            }
            throw ike;
        }
        String returnLabel = new String(this.internalKeyTokenOrLabel, PlatformUtilities.CHARSET_ISO_8859_1);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabelString", returnLabel);
        }
        return returnLabel;
    }

    public byte[] getExternalKeyToken() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getExternalKeyToken");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getExternalKeyToken", ise);
            }
            throw ise;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getExternalKeyToken", this.externalKeyToken);
        }
        if (this.externalKeyToken != null) {
            return (byte[])this.externalKeyToken.clone();
        }
        return null;
    }

    public byte getType() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getType");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getExternalKeyToken", ise);
            }
            throw ise;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getType", this.keyAttributes.getKeyType());
        }
        return this.keyAttributes.getKeyType();
    }

    public byte getUsage() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getUsage");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getUsage", ise);
            }
            throw ise;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getUsage", this.keyAttributes.getKeyUsage());
        }
        return this.keyAttributes.getKeyUsage();
    }

    @Override
    public BigInteger getS() {
        UnsupportedOperationException uoe = new UnsupportedOperationException("Hardware error, function getS has no meaning in hardware");
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getS");
            debug.exception(Debug.TYPE_PUBLIC, className, "getS", uoe);
            debug.exit(Debug.TYPE_PUBLIC, className, "getS");
        }
        throw uoe;
    }

    @Override
    public ECParameterSpec getParams() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getParams");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getParams", ise);
            }
            throw ise;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getParams", this.parameterSpec);
        }
        return this.parameterSpec;
    }

    @Override
    public synchronized byte[] getEncoded() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getEncoded");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getEncoded", ise);
            }
            throw ise;
        }
        if (this.keyAttributes.getKeyType() == 2) {
            byte[] token = this.getExternalKeyToken();
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", token);
            }
            return token;
        }
        byte[] token = this.getToken();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", token);
        }
        return token;
    }

    @Override
    public String getFormat() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getFormat");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getFormat", ise);
            }
            throw ise;
        }
        if (this.keyAttributes.getKeyType() == 2) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getFormat", "ICSFToken");
            }
            return "ICSFToken";
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getFormat", "PKDSLabel");
        }
        return "PKDSLabel";
    }

    public ECPrivateKey getSoftwareECPrivateKey() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getSoftwareECPrivateKey");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getSoftwareECPrivateKey", ise);
            }
            throw ise;
        }
        if (this.keyAttributes.getKeyType() == 2) {
            ECPrivateKey softwareKey = KeyStoreUtils.generateSoftwareECPrivateKey(this);
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getSoftwareECPrivateKey", softwareKey);
            }
            return softwareKey;
        }
        InvalidKeyException ike = new InvalidKeyException("This is a PKDS hardware Elliptic Curve key. Software Elliptic Curve keys can only be generated from CLEAR hardware Elliptic Curve keys");
        if (debug != null) {
            debug.exception(Debug.TYPE_PUBLIC, className, "getSoftwareECPrivateKey", ike);
            debug.exit(Debug.TYPE_PUBLIC, className, "getSoftwareECPrivateKey");
        }
        throw ike;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "toString");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "toString", ise);
            }
            throw ise;
        }
        String provider = new String("IBMJCECCA");
        HexDumpEncoder encoder = new HexDumpEncoder();
        String hexStringKeyToken = encoder.encodeBuffer(this.internalKeyTokenOrLabel);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "toString");
        }
        return provider + " Elliptic Curve private key:\n" + hexStringKeyToken + "\n";
    }

    public void deletePKDSEntry() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "deletePKDSEntry");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "deletePKDSEntry", ise);
            }
            throw ise;
        }
        if (this.getType() != 0) {
            InvalidKeyException newException = new InvalidKeyException("Error attempting to delete non-PKDS key from PKDS");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "deletePKDSEntry", newException);
                debug.exit(Debug.TYPE_PUBLIC, className, "deletePKDSEntry");
            }
            throw newException;
        }
        byte[] pkdsLabel = this.getToken();
        if (pkdsLabel.length > 64) {
            RuntimeException newException = new RuntimeException("Invalid label length for PKDS key object");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "deletePKDSEntry", newException);
                debug.exit(Debug.TYPE_PUBLIC, className, "deletePKDSEntry");
            }
            throw newException;
        }
        KeyPairUtils.deletePKDSEntry(pkdsLabel);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "deletePKDSEntry");
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        int idx;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "destroy");
        }
        if (null != this.internalKeyTokenOrLabel) {
            for (idx = 0; idx < this.internalKeyTokenOrLabel.length; ++idx) {
                this.internalKeyTokenOrLabel[idx] = 0;
            }
            this.internalKeyTokenOrLabel = null;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "destroy", "internalKeyTokenOrLabel has been zeroed out and set to null.");
            }
        }
        if (null != this.externalKeyToken) {
            for (idx = 0; idx < this.externalKeyToken.length; ++idx) {
                this.externalKeyToken[idx] = 0;
            }
            this.externalKeyToken = null;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "destroy", "externalKeyToken has been zeroed out and set to null.");
            }
        }
        this.hasBeenDestroyed = true;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "destroy");
        }
    }

    @Override
    public boolean isDestroyed() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "destroy", "" + this.hasBeenDestroyed);
        }
        return this.hasBeenDestroyed;
    }
}

