/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

final class ECNamedCurve
extends ECGenParameterSpec {
    static final int DEFAULT_KEY_SIZE = 256;
    static final CurveType DEFAULT_CURVE_TYPE = CurveType.NISTPRIME;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.ECNamedCurve";
    private static final Map<String, ECParameterSpec> NAME_MAP = new HashMap<String, ECParameterSpec>();
    private static final Map<String, ECParameterSpec> OID_MAP = new HashMap<String, ECParameterSpec>();
    private static final Map<Integer, ECParameterSpec> SIZE_MAP = new HashMap<Integer, ECParameterSpec>();
    private static final Map<Integer, ECParameterSpec> NISTPRIME_SIZE_MAP = new HashMap<Integer, ECParameterSpec>();
    private static final Map<Integer, ECParameterSpec> BRAINPOOL_SIZE_MAP = new HashMap<Integer, ECParameterSpec>();
    private static final Map<String, String> OID_NAME_MAP = new HashMap<String, String>();
    private static final Map<String, CurveType> NAME_CURVETYPE_MAP = new HashMap<String, CurveType>();
    private static final Map<Integer, String> SIZE_NAME_MAP = new HashMap<Integer, String>();
    private static Pattern SPLIT_PATTERN = Pattern.compile(",|\\[|\\]");

    private ECNamedCurve(String name) {
        super(name);
    }

    static ObjectIdentifier getOid(ECParameterSpec parameterSpec) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getOid", parameterSpec);
        }
        if (parameterSpec == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getOid", "The parameterSpec is null, match not found");
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getOid", null);
            }
            return null;
        }
        Set<Map.Entry<String, ECParameterSpec>> set = OID_MAP.entrySet();
        for (Map.Entry<String, ECParameterSpec> entry : set) {
            String mappedOid = entry.getKey();
            ECParameterSpec mappedParameterSpec = entry.getValue();
            if (!mappedParameterSpec.getCurve().equals(parameterSpec.getCurve()) || !mappedParameterSpec.getGenerator().equals(parameterSpec.getGenerator()) || !mappedParameterSpec.getOrder().equals(parameterSpec.getOrder()) || mappedParameterSpec.getCofactor() != parameterSpec.getCofactor()) continue;
            try {
                ObjectIdentifier oid = new ObjectIdentifier(mappedOid);
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getOid", oid);
                }
                return oid;
            }
            catch (IOException e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "getOid", e);
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getOid", null);
                }
                return null;
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getOid", null);
        }
        return null;
    }

    static byte[] getEncoded(ObjectIdentifier oid) {
        DerOutputStream out = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", oid);
        }
        if (oid == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getEncoded", "The Elliptic Curve OID is null, so it can not be DER-encoded");
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", null);
            }
            return null;
        }
        try {
            out = new DerOutputStream();
            out.putOID(oid);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getEncoded", "The Elliptic Curve OID could not be DER-encoded");
                debug.exception(Debug.TYPE_PUBLIC, className, "getEncoded", e);
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", null);
            }
            return null;
        }
        byte[] encodedOid = out.toByteArray();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", encodedOid);
        }
        return encodedOid;
    }

    static CurveType getCurveType(String name) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getCurveType", name);
        }
        CurveType curveType = NAME_CURVETYPE_MAP.get(name);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getCurveType", (Object)curveType);
        }
        return curveType;
    }

    static int getKeySize(String name) {
        ECParameterSpec spec;
        int keySize;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getKeySize", name);
        }
        int n = keySize = (spec = NAME_MAP.get(name)) == null ? -1 : spec.getCurve().getField().getFieldSize();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKeySize", keySize);
        }
        return keySize;
    }

    static String getName(int keysize) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getName", new Integer(keysize));
        }
        String name = SIZE_NAME_MAP.get(keysize);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getName", name);
        }
        return name;
    }

    static String getName(ECParameterSpec parameterSpec) {
        ObjectIdentifier foundOid;
        String name;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getName", parameterSpec);
        }
        String string = name = (foundOid = ECNamedCurve.getOid(parameterSpec)) == null ? null : OID_NAME_MAP.get(foundOid.toString());
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getName", name);
        }
        return name;
    }

    static String getName(ECGenParameterSpec parameterSpec) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getName(ECGenParameterSpec)", parameterSpec);
            if (parameterSpec != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getName(ECGenParameterSpec)", "parameterSpec Name: " + parameterSpec.getName());
            }
        }
        if (parameterSpec == null) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getName(ECGenParameterSpec)", "parameterSpec == null -> null");
            }
            return null;
        }
        String foundName = OID_NAME_MAP.get(parameterSpec.getName());
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "getName(ECGenParameterSpec)", "foundName(oid check): " + foundName);
            debug.text(Debug.TYPE_FINEST, className, "getName(ECGenParameterSpec)", "OID_MAP: " + OID_MAP);
            debug.text(Debug.TYPE_FINEST, className, "getName(ECGenParameterSpec)", "OID_NAME_MAP: " + OID_NAME_MAP);
            debug.text(Debug.TYPE_FINEST, className, "getName(ECGenParameterSpec)", "NAME_MAP: " + NAME_MAP);
        }
        if (foundName == null) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getName(ECGenParameterSpec)", "No OID found, checking name.");
            }
            if (NAME_MAP.containsKey(parameterSpec.getName())) {
                foundName = parameterSpec.getName();
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "getName(ECGenParameterSpec)", "NAME_MAP contains this key, using this name.");
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getName(ECGenParameterSpec)", foundName);
        }
        return foundName;
    }

    static Boolean hasSize(int keysize) {
        boolean trueOrFalse;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "hasSize", new Integer(keysize));
        }
        boolean bl = trueOrFalse = SIZE_MAP.get(keysize) != null;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "hasSize", trueOrFalse);
        }
        return trueOrFalse;
    }

    static ECParameterSpec getECParameterSpec(int keysize) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getECParameterSpec", new Integer(keysize));
        }
        ECParameterSpec parameterSpec = SIZE_MAP.get(keysize);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getECParameterSpec", parameterSpec);
        }
        return parameterSpec;
    }

    static ECParameterSpec getECParameterSpec(String name) {
        ECParameterSpec spec;
        ECParameterSpec parameterSpec;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getECParameterSpec", name);
        }
        ECParameterSpec eCParameterSpec = parameterSpec = (spec = OID_MAP.get(name)) != null ? spec : NAME_MAP.get(name);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getECParameterSpec", parameterSpec);
        }
        return parameterSpec;
    }

    static ECParameterSpec getECParameterSpec(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "getECParameterSpec", oid);
        }
        if (oid == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getECParameterSpec", "The OID is null, no domain parameters found");
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getECParameterSpec", null);
            }
            return null;
        }
        ECParameterSpec parameterSpec = ECNamedCurve.getECParameterSpec(oid.toString());
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getECParameterSpec", parameterSpec);
        }
        return parameterSpec;
    }

    static ECParameterSpec getECParameterSpec(CurveType type, int keysize) {
        ECParameterSpec spec;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getECParameterSpec", (Object)type, new Integer(keysize));
        }
        switch (type) {
            case NISTPRIME: {
                spec = NISTPRIME_SIZE_MAP.get(keysize);
                break;
            }
            case BRAINPOOL: {
                spec = BRAINPOOL_SIZE_MAP.get(keysize);
                break;
            }
            default: {
                spec = null;
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getECParameterSpec", spec);
        }
        return spec;
    }

    private static BigInteger bi(String s) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "bi", s);
        }
        BigInteger bInteger = new BigInteger(s, 16);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "bi", bInteger);
        }
        return bInteger;
    }

    private static void add(String sname, String soid, CurveType curveType, String sfield, String a, String b, String x, String y, String n, int h, boolean isDefault) {
        ECPoint g;
        BigInteger p;
        ECFieldFp field;
        EllipticCurve curve;
        ECParameterSpec params;
        if (debug != null) {
            Object[] parms = new Object[]{sname, soid, curveType, sfield, a, b, x, y, n, new Integer(h), new Boolean(isDefault)};
            debug.entry(8192L, (Object)className, "add", parms);
        }
        if (OID_MAP.put(soid, params = new ECParameterSpec(curve = new EllipticCurve(field = new ECFieldFp(p = ECNamedCurve.bi(sfield)), ECNamedCurve.bi(a), ECNamedCurve.bi(b)), g = new ECPoint(ECNamedCurve.bi(x), ECNamedCurve.bi(y)), ECNamedCurve.bi(n), h)) != null) {
            RuntimeException re = new RuntimeException("Duplicate OID: " + soid);
            if (debug != null) {
                debug.exception(8192L, className, "add", re);
                debug.exit(8192L, className, "add");
            }
            throw re;
        }
        String[] names = SPLIT_PATTERN.split(sname);
        if (names.length > 0) {
            OID_NAME_MAP.put(soid, names[0].trim());
        }
        for (String name : names) {
            if (debug != null) {
                debug.text(8192L, className, "add", "Processing name: " + name);
            }
            if (NAME_MAP.put(name.trim(), params) != null) {
                RuntimeException re = new RuntimeException("Duplicate name: " + name);
                if (debug != null) {
                    debug.exception(8192L, className, "add", re);
                    debug.exit(8192L, className, "add");
                }
                throw re;
            }
            if (NAME_CURVETYPE_MAP.put(name.trim(), curveType) == null) continue;
            RuntimeException re = new RuntimeException("Duplicate name: " + name);
            if (debug != null) {
                debug.exception(8192L, className, "add", re);
                debug.exit(8192L, className, "add");
            }
            throw re;
        }
        int keysize = field.getFieldSize();
        if (debug != null) {
            debug.text(8192L, className, "add", "key size: " + keysize);
        }
        if (isDefault || SIZE_MAP.get(keysize) == null) {
            SIZE_MAP.put(keysize, params);
        }
        if ((isDefault || SIZE_NAME_MAP.get(keysize) == null) && names.length > 0) {
            SIZE_NAME_MAP.put(keysize, names[0].trim());
        }
        switch (curveType) {
            case NISTPRIME: {
                if (NISTPRIME_SIZE_MAP.put(keysize, params) == null) break;
                RuntimeException re = new RuntimeException("Duplicate key size for NISTPRIME: " + keysize);
                if (debug != null) {
                    debug.exception(8192L, className, "add", re);
                    debug.exit(8192L, className, "add");
                }
                throw re;
            }
            case BRAINPOOL: {
                if (BRAINPOOL_SIZE_MAP.put(keysize, params) == null) break;
                RuntimeException re = new RuntimeException("Duplicate key size for BRAINPOOL: " + keysize);
                if (debug != null) {
                    debug.exception(8192L, className, "add", re);
                    debug.exit(8192L, className, "add");
                }
                throw re;
            }
            default: {
                if (debug == null) break;
                debug.text(8192L, className, "add", "Unrecognized curve type: " + (Object)((Object)curveType));
            }
        }
        if (debug != null) {
            debug.exit(8192L, className, "add");
        }
    }

    static {
        ECNamedCurve.add("secp192r1 [NIST P-192, X9.62 prime192v1]", "1.2.840.10045.3.1.1", CurveType.NISTPRIME, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFC", "64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1", "188DA80EB03090F67CBF20EB43A18800F4FF0AFD82FF1012", "07192B95FFC8DA78631011ED6B24CDD573F977A11E794811", "FFFFFFFFFFFFFFFFFFFFFFFF99DEF836146BC9B1B4D22831", 1, true);
        ECNamedCurve.add("secp224r1 [NIST P-224]", "1.3.132.0.33", CurveType.NISTPRIME, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000001", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFE", "B4050A850C04B3ABF54132565044B0B7D7BFD8BA270B39432355FFB4", "B70E0CBD6BB4BF7F321390B94A03C1D356C21122343280D6115C1D21", "BD376388B5F723FB4C22DFE6CD4375A05A07476444D5819985007E34", "FFFFFFFFFFFFFFFFFFFFFFFFFFFF16A2E0B8F03E13DD29455C5C2A3D", 1, true);
        ECNamedCurve.add("secp256r1 [NIST P-256, X9.62 prime256v1]", "1.2.840.10045.3.1.7", CurveType.NISTPRIME, "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC", "5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B", "6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296", "4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5", "FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551", 1, true);
        ECNamedCurve.add("secp384r1 [NIST P-384]", "1.3.132.0.34", CurveType.NISTPRIME, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC", "B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF", "AA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7", "3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973", 1, true);
        ECNamedCurve.add("secp521r1 [NIST P-521]", "1.3.132.0.35", CurveType.NISTPRIME, "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC", "0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00", "00C6858E06B70404E9CD9E3ECB662395B4429C648139053FB521F828AF606B4D3DBAA14B5E77EFE75928FE1DC127A2FFA8DE3348B3C1856A429BF97E7E31C2E5BD66", "011839296A789A3BC0045C8A5FB42C7D1BD998F54449579B446817AFBD17273E662C97EE72995EF42640C550B9013FAD0761353C7086A272C24088BE94769FD16650", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409", 1, true);
        ECNamedCurve.add("brainpoolP160r1", "1.3.36.3.3.2.8.1.1.1", CurveType.BRAINPOOL, "E95E4A5F737059DC60DFC7AD95B3D8139515620F", "340E7BE2A280EB74E2BE61BADA745D97E8F7C300", "1E589A8595423412134FAA2DBDEC95C8D8675E58", "BED5AF16EA3F6A4F62938C4631EB5AF7BDBCDBC3", "1667CB477A1A8EC338F94741669C976316DA6321", "E95E4A5F737059DC60DF5991D45029409E60FC09", 1, false);
        ECNamedCurve.add("brainpoolP192r1", "1.3.36.3.3.2.8.1.1.3", CurveType.BRAINPOOL, "C302F41D932A36CDA7A3463093D18DB78FCE476DE1A86297", "6A91174076B1E0E19C39C031FE8685C1CAE040E5C69A28EF", "469A28EF7C28CCA3DC721D044F4496BCCA7EF4146FBF25C9", "C0A0647EAAB6A48753B033C56CB0F0900A2F5C4853375FD6", "14B690866ABD5BB88B5F4828C1490002E6773FA2FA299B8F", "C302F41D932A36CDA7A3462F9E9E916B5BE8F1029AC4ACC1", 1, false);
        ECNamedCurve.add("brainpoolP224r1", "1.3.36.3.3.2.8.1.1.5", CurveType.BRAINPOOL, "D7C134AA264366862A18302575D1D787B09F075797DA89F57EC8C0FF", "68A5E62CA9CE6C1C299803A6C1530B514E182AD8B0042A59CAD29F43", "2580F63CCFE44138870713B1A92369E33E2135D266DBB372386C400B", "0D9029AD2C7E5CF4340823B2A87DC68C9E4CE3174C1E6EFDEE12C07D", "58AA56F772C0726F24C6B89E4ECDAC24354B9E99CAA3F6D3761402CD", "D7C134AA264366862A18302575D0FB98D116BC4B6DDEBCA3A5A7939F", 1, false);
        ECNamedCurve.add("brainpoolP256r1", "1.3.36.3.3.2.8.1.1.7", CurveType.BRAINPOOL, "A9FB57DBA1EEA9BC3E660A909D838D726E3BF623D52620282013481D1F6E5377", "7D5A0975FC2C3057EEF67530417AFFE7FB8055C126DC5C6CE94A4B44F330B5D9", "26DC5C6CE94A4B44F330B5D9BBD77CBF958416295CF7E1CE6BCCDC18FF8C07B6", "8BD2AEB9CB7E57CB2C4B482FFC81B7AFB9DE27E1E3BD23C23A4453BD9ACE3262", "547EF835C3DAC4FD97F8461A14611DC9C27745132DED8E545C1D54C72F046997", "A9FB57DBA1EEA9BC3E660A909D838D718C397AA3B561A6F7901E0E82974856A7", 1, false);
        ECNamedCurve.add("brainpoolP320r1", "1.3.36.3.3.2.8.1.1.9", CurveType.BRAINPOOL, "D35E472036BC4FB7E13C785ED201E065F98FCFA6F6F40DEF4F92B9EC7893EC28FCD412B1F1B32E27", "3EE30B568FBAB0F883CCEBD46D3F3BB8A2A73513F5EB79DA66190EB085FFA9F492F375A97D860EB4", "520883949DFDBC42D3AD198640688A6FE13F41349554B49ACC31DCCD884539816F5EB4AC8FB1F1A6", "43BD7E9AFB53D8B85289BCC48EE5BFE6F20137D10A087EB6E7871E2A10A599C710AF8D0D39E20611", "14FDD05545EC1CC8AB4093247F77275E0743FFED117182EAA9C77877AAAC6AC7D35245D1692E8EE1", "D35E472036BC4FB7E13C785ED201E065F98FCFA5B68F12A32D482EC7EE8658E98691555B44C59311", 1, false);
        ECNamedCurve.add("brainpoolP384r1", "1.3.36.3.3.2.8.1.1.11", CurveType.BRAINPOOL, "8CB91E82A3386D280F5D6F7E50E641DF152F7109ED5456B412B1DA197FB71123ACD3A729901D1A71874700133107EC53", "7BC382C63D8C150C3C72080ACE05AFA0C2BEA28E4FB22787139165EFBA91F90F8AA5814A503AD4EB04A8C7DD22CE2826", "04A8C7DD22CE28268B39B55416F0447C2FB77DE107DCD2A62E880EA53EEB62D57CB4390295DBC9943AB78696FA504C11", "1D1C64F068CF45FFA2A63A81B7C13F6B8847A3E77EF14FE3DB7FCAFE0CBD10E8E826E03436D646AAEF87B2E247D4AF1E", "8ABE1D7520F9C2A45CB1EB8E95CFD55262B70B29FEEC5864E19C054FF99129280E4646217791811142820341263C5315", "8CB91E82A3386D280F5D6F7E50E641DF152F7109ED5456B31F166E6CAC0425A7CF3AB6AF6B7FC3103B883202E9046565", 1, false);
        ECNamedCurve.add("brainpoolP512r1", "1.3.36.3.3.2.8.1.1.13", CurveType.BRAINPOOL, "AADD9DB8DBE9C48B3FD4E6AE33C9FC07CB308DB3B3C9D20ED6639CCA703308717D4D9B009BC66842AECDA12AE6A380E62881FF2F2D82C68528AA6056583A48F3", "7830A3318B603B89E2327145AC234CC594CBDD8D3DF91610A83441CAEA9863BC2DED5D5AA8253AA10A2EF1C98B9AC8B57F1117A72BF2C7B9E7C1AC4D77FC94CA", "3DF91610A83441CAEA9863BC2DED5D5AA8253AA10A2EF1C98B9AC8B57F1117A72BF2C7B9E7C1AC4D77FC94CADC083E67984050B75EBAE5DD2809BD638016F723", "81AEE4BDD82ED9645A21322E9C4C6A9385ED9F70B5D916C1B43B62EEF4D0098EFF3B1F78E2D0D48D50D1687B93B97D5F7C6D5047406A5E688B352209BCB9F822", "7DDE385D566332ECC0EABFA9CF7822FDF209F70024A57B1AA000C55B881F8111B2DCDE494A5F485E5BCA4BD88A2763AED1CA2B2FA8F0540678CD1E0F3AD80892", "AADD9DB8DBE9C48B3FD4E6AE33C9FC07CB308DB3B3C9D20ED6639CCA70330870553E5C414CA92619418661197FAC10471DB1D381085DDADDB58796829CA90069", 1, false);
        SPLIT_PATTERN = null;
    }

    static enum CurveType {
        NISTPRIME(0),
        BRAINPOOL(1);

        private final byte value;

        private CurveType(byte value) {
            this.value = value;
        }

        byte byteValue() {
            return this.value;
        }

        static CurveType valueOf(byte value) {
            for (CurveType type : CurveType.values()) {
                if (type.byteValue() != value) continue;
                return type;
            }
            return null;
        }
    }
}

