/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.ECNamedCurve;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private int keysize = 256;
    private ECHWKeyAttributes keyAttributes = null;
    private String keyLabel = null;
    private ECNamedCurve.CurveType curveType = ECNamedCurve.CurveType.NISTPRIME;
    private SecureRandom random = null;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.ECKeyPairGenerator";

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "initialize", params, random);
        }
        if (params instanceof ECHWKeyParameterSpec) {
            ECHWKeyParameterSpec spec = (ECHWKeyParameterSpec)params;
            ECGenParameterSpec parameterSpec = null;
            try {
                parameterSpec = spec.getParameterSpec(ECGenParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Inappropriate parameter specification", e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "initialize", e);
                    debug.exception(Debug.TYPE_PUBLIC, className, "initialize", iape);
                    debug.exit(Debug.TYPE_FINE, className, "initialize");
                }
                throw iape;
            }
            this.curveType = ECNamedCurve.getCurveType(parameterSpec.getName());
            if (this.curveType == null) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("The specified parameter specification is not supported");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "initialize", iape);
                    debug.exit(Debug.TYPE_FINE, className, "initialize");
                }
                throw iape;
            }
            this.keysize = spec.getKeySize();
            this.keyAttributes = spec.getAttributes();
            this.keyLabel = spec.getLabel();
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initialize", "key size = " + this.keysize + ", key label = " + this.keyLabel);
            }
        } else if (params instanceof ECParameterSpec) {
            ECParameterSpec parameterSpec = (ECParameterSpec)params;
            String name = ECNamedCurve.getName(parameterSpec);
            if (name == null) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("The specified parameter specification is not supported");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "initialize", iape);
                    debug.exit(Debug.TYPE_FINE, className, "initialize");
                }
                throw iape;
            }
            this.curveType = ECNamedCurve.getCurveType(name);
            if (this.curveType == null) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("The specified parameter specification is not supported");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "initialize", iape);
                    debug.exit(Debug.TYPE_FINE, className, "initialize");
                }
                throw iape;
            }
            this.keysize = parameterSpec.getCurve().getField().getFieldSize();
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initialize", "key size = " + this.keysize);
            }
        } else if (params instanceof ECGenParameterSpec) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initialize", "ECGenParameterSpec = " + params);
            }
            ECGenParameterSpec parameterSpec = (ECGenParameterSpec)params;
            String name = ECNamedCurve.getName(parameterSpec);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initialize", "ECGenParameterSpec name = " + name);
            }
            this.curveType = ECNamedCurve.getCurveType(name);
            this.keysize = ECNamedCurve.getKeySize(name);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initialize", "key size = " + this.keysize);
            }
            if (this.curveType == null || this.keysize <= 0) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("The specified parameter specification is not supported");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "initialize", iape);
                    debug.exit(Debug.TYPE_FINE, className, "initialize");
                }
                throw iape;
            }
        } else {
            InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Inappropriate parameter specification");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "initialize", iape);
                debug.exit(Debug.TYPE_FINE, className, "initialize");
            }
            throw iape;
        }
        this.random = random;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "initialize");
        }
    }

    @Override
    public void initialize(int keysize, SecureRandom random) throws InvalidParameterException {
        String name;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "initialize", new Integer(keysize), random);
        }
        if ((name = ECNamedCurve.getName(keysize)) == null) {
            InvalidParameterException ipe = new InvalidParameterException("The specified key size is not supported");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "initialize", ipe);
                debug.exit(Debug.TYPE_FINE, className, "initialize");
            }
            throw ipe;
        }
        this.random = random;
        this.curveType = ECNamedCurve.getCurveType(name);
        this.keysize = keysize;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "initialize");
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "generateKeyPair");
        }
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (this.keyAttributes == null) {
            this.keyAttributes = new ECHWKeyAttributes(2, ECHWKeyAttributes.DEFAULT_USAGE);
        }
        KeyPairUtils util = new KeyPairUtils();
        util.initializeEC(this.curveType, this.keysize, this.random, this.keyAttributes, this.keyLabel);
        byte[] skeletonToken = util.generateToken(null);
        byte[] token = util.generateKeysFromSkeletonToken(skeletonToken);
        KeyPair result = util.generateKeyPairFromInternalToken(token);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "generateKeyPair", result);
        }
        return result;
    }
}

