/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes;
import com.ibm.crypto.hdwrCCA.provider.ECNamedCurve;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;

public class ECHWKeyParameterSpec
implements AlgorithmParameterSpec {
    private static final int PKDS_LABEL_MAX_SIZE = 64;
    private int keySize;
    private ECParameterSpec parameterSpec = null;
    private ECGenParameterSpec genParameterSpec = null;
    private String keyLabel = null;
    private ECHWKeyAttributes attributes = null;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.ECHWKeyParameterSpec";

    public ECHWKeyParameterSpec(int strength, byte type) throws IllegalArgumentException {
        this(strength, type, ECHWKeyAttributes.DEFAULT_USAGE);
    }

    public ECHWKeyParameterSpec(int strength, byte type, byte usage) throws IllegalArgumentException {
        this(strength, type, usage, null);
    }

    public ECHWKeyParameterSpec(int strength, byte type, String label) throws IllegalArgumentException {
        this(strength, type, ECHWKeyAttributes.DEFAULT_USAGE, label);
    }

    public ECHWKeyParameterSpec(int strength, byte type, byte usage, String label) throws IllegalArgumentException {
        IllegalArgumentException iae;
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(strength), new Byte(type), new Byte(usage), label};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "ECHWKeyParameterSpec", parms);
        }
        if (!ECNamedCurve.hasSize(strength).booleanValue()) {
            InvalidParameterException ipe = new InvalidParameterException("Key size not supported");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw ipe;
        }
        if (type != 0 && type != 2) {
            iae = new IllegalArgumentException("Invalid key pair type");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw iae;
        }
        if (usage != 3 && usage != 4) {
            iae = new IllegalArgumentException("Invalid key pair usage");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw iae;
        }
        if (label != null && label.length() > 64) {
            iae = new IllegalArgumentException("key label has a maximum length of 64 bytes");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw iae;
        }
        this.keySize = strength;
        this.parameterSpec = ECNamedCurve.getECParameterSpec(strength);
        this.genParameterSpec = new ECGenParameterSpec(ECNamedCurve.getName(strength));
        this.keyLabel = label;
        this.attributes = new ECHWKeyAttributes(type, usage);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
        }
    }

    public <T extends AlgorithmParameterSpec> ECHWKeyParameterSpec(T spec, byte type) throws InvalidParameterSpecException, IllegalArgumentException {
        this(spec, type, ECHWKeyAttributes.DEFAULT_USAGE);
    }

    public <T extends AlgorithmParameterSpec> ECHWKeyParameterSpec(T spec, byte type, byte usage) throws InvalidParameterSpecException, IllegalArgumentException {
        this(spec, type, ECHWKeyAttributes.DEFAULT_USAGE, null);
    }

    public <T extends AlgorithmParameterSpec> ECHWKeyParameterSpec(T spec, byte type, byte usage, String label) throws InvalidParameterSpecException, IllegalArgumentException {
        IllegalArgumentException iae;
        InvalidParameterSpecException ipse;
        if (debug != null) {
            Object[] parms = new Object[]{spec, new Byte(type), new Byte(usage), label};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "ECHWKeyParameterSpec", parms);
        }
        if (spec instanceof ECParameterSpec) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", "spec is an instance of ECParameterSpec");
            }
            this.parameterSpec = (ECParameterSpec)spec;
            String name = ECNamedCurve.getName(this.parameterSpec);
            if (name == null) {
                InvalidParameterSpecException ipse2 = new InvalidParameterSpecException("The specified parameter specification is not supported");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", ipse2);
                    debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
                }
                throw ipse2;
            }
            this.genParameterSpec = new ECGenParameterSpec(name);
        } else if (spec instanceof ECGenParameterSpec) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", "spec is an instance of ECGenParameterSpec");
            }
            this.genParameterSpec = (ECGenParameterSpec)spec;
            this.parameterSpec = ECNamedCurve.getECParameterSpec(this.genParameterSpec.getName());
            if (this.parameterSpec == null) {
                ipse = new InvalidParameterSpecException("The specified parameter specification is not supported");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", ipse);
                    debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
                }
                throw ipse;
            }
        } else {
            ipse = new InvalidParameterSpecException("Inappropriate parameter specification");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", ipse);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw ipse;
        }
        if (type != 0 && type != 2) {
            iae = new IllegalArgumentException("Invalid key pair type");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw iae;
        }
        if (usage != 3 && usage != 4) {
            iae = new IllegalArgumentException("Invalid key pair usage");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw iae;
        }
        if (label != null && label.length() > 64) {
            iae = new IllegalArgumentException("key label has a maximum length of 64 bytes");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw iae;
        }
        this.keySize = this.parameterSpec.getCurve().getField().getFieldSize();
        this.keyLabel = label;
        this.attributes = new ECHWKeyAttributes(type, usage);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
        }
    }

    public ECHWKeyParameterSpec(String name, byte type) throws IllegalArgumentException {
        this(name, type, ECHWKeyAttributes.DEFAULT_USAGE);
    }

    public ECHWKeyParameterSpec(String name, byte type, byte usage) throws IllegalArgumentException {
        this(name, type, usage, null);
    }

    public ECHWKeyParameterSpec(String name, byte type, byte usage, String label) throws IllegalArgumentException {
        IllegalArgumentException iae;
        if (debug != null) {
            Object[] parms = new Object[]{name, new Byte(type), new Byte(usage), label};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "ECHWKeyParameterSpec", parms);
        }
        if (name == null) {
            NullPointerException npe = new NullPointerException("The name must not be null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", npe);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw npe;
        }
        if (type != 0 && type != 2) {
            iae = new IllegalArgumentException("Invalid key pair type");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw iae;
        }
        if (usage != 3 && usage != 4) {
            iae = new IllegalArgumentException("Invalid key pair usage");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw iae;
        }
        if (label != null && label.length() > 64) {
            iae = new IllegalArgumentException("key label has a maximum length of 64 bytes");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw iae;
        }
        this.parameterSpec = ECNamedCurve.getECParameterSpec(name);
        if (this.parameterSpec == null) {
            iae = new IllegalArgumentException("Specified name is not a standard name for Elliptic Curve domain parameters");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw iae;
        }
        this.keySize = this.parameterSpec.getCurve().getField().getFieldSize();
        this.genParameterSpec = new ECGenParameterSpec(name);
        this.keyLabel = label;
        this.attributes = new ECHWKeyAttributes(type, usage);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
        }
    }

    public ECHWKeyParameterSpec(EllipticCurve curve, ECPoint g, BigInteger n, int h, byte type) throws IllegalArgumentException {
        this(curve, g, n, h, type, ECHWKeyAttributes.DEFAULT_USAGE);
    }

    public ECHWKeyParameterSpec(EllipticCurve curve, ECPoint g, BigInteger n, int h, byte type, byte usage) throws IllegalArgumentException {
        this(curve, g, n, h, type, usage, null);
    }

    public ECHWKeyParameterSpec(EllipticCurve curve, ECPoint g, BigInteger n, int h, byte type, byte usage, String label) throws IllegalArgumentException {
        IllegalArgumentException iae;
        if (debug != null) {
            Object[] parms = new Object[]{curve, g, n, new Integer(h), new Byte(type), new Byte(usage), label};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "ECHWKeyParameterSpec", parms);
        }
        if (type != 0 && type != 2) {
            iae = new IllegalArgumentException("Invalid key pair type");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw iae;
        }
        if (usage != 3 && usage != 4) {
            iae = new IllegalArgumentException("Invalid key pair usage");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw iae;
        }
        if (label != null && label.length() > 64) {
            iae = new IllegalArgumentException("key label has a maximum length of 64 bytes");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", iae);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw iae;
        }
        this.parameterSpec = new ECParameterSpec(curve, g, n, h);
        String name = ECNamedCurve.getName(this.parameterSpec);
        if (name == null) {
            IllegalArgumentException iae2 = new IllegalArgumentException("The specified domain parameters are not supported");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", iae2);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
            }
            throw iae2;
        }
        this.genParameterSpec = new ECGenParameterSpec(name);
        this.keySize = this.parameterSpec.getCurve().getField().getFieldSize();
        this.keyLabel = label;
        this.attributes = new ECHWKeyAttributes(type, usage);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
        }
    }

    public int getKeySize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getKeySize");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKeySize", this.keySize);
        }
        return this.keySize;
    }

    public <T extends AlgorithmParameterSpec> T getParameterSpec(Class<T> spec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "ECHWKeyParameterSpec", spec);
        }
        if (spec.isAssignableFrom(ECParameterSpec.class)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "ECHWKeyParameterSpec", spec.cast(this.parameterSpec));
            }
            return (T)((AlgorithmParameterSpec)spec.cast(this.parameterSpec));
        }
        if (spec.isAssignableFrom(ECGenParameterSpec.class)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "ECHWKeyParameterSpec", spec.cast(this.genParameterSpec));
            }
            return (T)((AlgorithmParameterSpec)spec.cast(this.genParameterSpec));
        }
        InvalidParameterSpecException ipse = new InvalidParameterSpecException("Inappropriate parameter specification");
        if (debug != null) {
            debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec", ipse);
            debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyParameterSpec");
        }
        throw ipse;
    }

    public ECHWKeyAttributes getAttributes() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getAttributes");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getAttributes", this.attributes);
        }
        return this.attributes;
    }

    public String getLabel() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getLabel");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabel", this.keyLabel);
        }
        return this.keyLabel;
    }
}

