/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.KeyHWAttributes;
import java.security.InvalidParameterException;

public final class ECHWKeyAttributes
implements KeyHWAttributes {
    private final byte keyType;
    private final byte keyUsage;
    static final byte DEFAULT_TYPE = 2;
    static final byte DEFAULT_USAGE = (byte)(HardwareProfile.isECCDiffieHellmanSupported() ? 4 : 3);
    static final long serialVersionUID = 8519966968172455284L;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes";

    public ECHWKeyAttributes(byte keyType) throws InvalidParameterException {
        this(keyType, DEFAULT_USAGE);
    }

    public ECHWKeyAttributes(byte keyType, byte keyUsage) throws InvalidParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "ECHWKeyAttributes", new Byte(keyType), new Byte(keyUsage));
        }
        if (keyType != 0 && keyType != 2) {
            InvalidParameterException ipe = new InvalidParameterException("Key type must be KeyHWAttributeValues.PKDS or KeyHWAttributeValues.CLEAR for EC keys");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyAttributes", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyAttributes");
            }
            throw ipe;
        }
        if (keyUsage != 3 && keyUsage != 4) {
            InvalidParameterException ipe = new InvalidParameterException("Key usage must be KeyHWAttributeValues.SIGNATURE or KeyHWAttributeValues.KEYMANAGEMNET for EC keys");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "ECHWKeyAttributes", ipe);
                debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyAttributes");
            }
            throw ipe;
        }
        this.keyType = keyType;
        this.keyUsage = keyUsage;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "ECHWKeyAttributes");
        }
    }

    @Override
    public byte getKeyType() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getKeyType");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKeyType", this.keyType);
        }
        return this.keyType;
    }

    @Override
    public byte getKeyUsage() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getKeyUsage");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKeyUsage", this.keyUsage);
        }
        return this.keyUsage;
    }
}

